/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.basedata;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.util.string.StringUtil;
import com.kingdee.eas.tm.td.basedata.AbstractDataSourceInfo;
import com.kingdee.eas.tm.td.basedata.DataSourceEntryCollection;
import com.kingdee.eas.tm.td.basedata.DataSourceEntryFactory;
import com.kingdee.eas.tm.td.basedata.DataSourceEntryInfo;
import com.kingdee.util.UuidException;
import java.io.Serializable;

public class DataSourceInfo
extends AbstractDataSourceInfo
implements Serializable {
    public DataSourceInfo() {
    }

    protected DataSourceInfo(String pkField) {
        super(pkField);
    }

    public DataSourceEntryInfo getMainTable() {
        DataSourceEntryCollection coll = this.getEntry();
        if (coll.size() != 0) {
            for (int i = 0; i < coll.size(); ++i) {
                DataSourceEntryInfo draftDataQueryInfo = coll.get(i);
                if (!draftDataQueryInfo.isIsMainTable()) continue;
                return coll.get(i);
            }
        }
        return null;
    }

    public DataSourceEntryInfo getDataTableByTableAlias(String tableAlias) {
        DataSourceEntryCollection coll = this.getEntry();
        for (int i = 0; i < coll.size(); ++i) {
            if (!tableAlias.equalsIgnoreCase(coll.get(i).getTableAlias())) continue;
            return coll.get(i);
        }
        return null;
    }

    public String getNoDumplicateTableAlias(String tableAlias) {
        String result = tableAlias;
        int i = 1;
        while (this.isTableAliasDumplicate(null, result)) {
            result = result + i;
            ++i;
        }
        return result;
    }

    public boolean isTableNameDumplicate(BOSUuid id, String tableName) throws EASBizException, BOSException, UuidException {
        DataSourceEntryInfo table = null;
        DataSourceEntryCollection coll = this.getEntry();
        for (int i = 0; i < coll.size(); ++i) {
            DataSourceEntryInfo newColl = DataSourceEntryFactory.getRemoteInstance().getDataSourceEntryInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)coll.get(i).getId().toString())));
            if (!newColl.getName().equalsIgnoreCase(tableName)) continue;
            table = newColl;
            break;
        }
        if (table == null) {
            return false;
        }
        return id == null || !table.getId().equals((Object)id);
    }

    public boolean isTableAliasDumplicate(BOSUuid id, String tableAlias) {
        DataSourceEntryInfo table = this.getDataTableByTableAlias(tableAlias);
        if (table == null) {
            return false;
        }
        return id == null || !table.getId().equals((Object)id);
    }

    public FilterInfo getFilterInfo() throws BOSException {
        FilterInfo filter = null;
        if (StringUtil.isEmpty((String)this.getFilterString())) {
            filter = new FilterInfo();
        } else {
            try {
                filter = new FilterInfo(this.getFilterString());
            }
            catch (ParserException e) {
                throw new BOSException();
            }
        }
        return filter;
    }

    public String getFromSQL() {
        StringBuffer result = new StringBuffer("FROM ");
        result.append(this.getJoinTableSQL(this.getMainTable()));
        return result.toString();
    }

    private String getJoinTableSQL(DataSourceEntryInfo table) {
        StringBuffer result = new StringBuffer();
        if (table == null) {
            return result.toString();
        }
        result.append(table.toSQL()).append("\r\n");
        DataSourceEntryCollection coll = table.getChildren(this.getEntry());
        for (int i = 0; i < coll.size(); ++i) {
            result.append(this.getJoinTableSQL(coll.get(i)));
        }
        return result.toString();
    }
}

