/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.basedata.client;

import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.tm.td.basedata.AccountConfigEntryInfo;
import com.kingdee.eas.tm.td.basedata.DataSourceInfo;
import com.kingdee.eas.tm.td.basedata.client.AbstractDataQueryFieldSelectUI;
import com.kingdee.eas.tm.td.basedata.client.GetDataFormula;
import com.kingdee.eas.tm.td.basedata.client.GetDataFormulaUI;
import com.kingdee.eas.tm.td.basedata.util.DraftItemDataSourceTreeUtil;
import com.kingdee.eas.tm.td.basedata.util.PropertyMeta;
import com.kingdee.eas.tm.td.basedata.util.RuleSegementInfo;
import com.kingdee.eas.tm.td.cloud.datamodel.DataFetchEntryInfo;
import com.kingdee.util.LocaleUtils;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Locale;
import java.util.Map;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class DataQueryFieldSelectUI
extends AbstractDataQueryFieldSelectUI {
    private static final Logger logger = CoreUIObject.getLogger(DataQueryFieldSelectUI.class);
    private String propertyName;
    private static final long serialVersionUID = 1L;
    public static Locale zh_en = LocaleUtils.locale_en_US;
    public static Locale zh_cn = LocaleUtils.locale_zh_CN;
    public static Locale zh_hk = LocaleUtils.locale_zh_TW;
    private boolean isCancel;
    private DataSourceInfo dataQuery;
    private CompanyOrgUnitInfo fieldModel;
    private RuleSegementInfo result;
    private AccountConfigEntryInfo configEntry;
    private DataFetchEntryInfo entry;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public DataQueryFieldSelectUI() throws Exception {
        this.treeDataQuery.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                DataQueryFieldSelectUI.this.treeDataQuery_mouseClicked(e);
            }
        });
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.dataQuery = (DataSourceInfo)this.getUIContext().get("DataSource");
        this.fieldModel = (CompanyOrgUnitInfo)this.getUIContext().get("BalanceField");
        this.propertyName = (String)this.getUIContext().get("getPropertyName");
        this.configEntry = (AccountConfigEntryInfo)this.getUIContext().get("configEntry");
        this.entry = (DataFetchEntryInfo)this.getUIContext().get("entry");
        this.result = this.getUIContext().get("RuleSegementInfo") != null ? (RuleSegementInfo)this.getUIContext().get("RuleSegementInfo") : new RuleSegementInfo();
        this.txtValueExpression.setText(this.result.getExpressionAlias());
        this.initDataQueryTree();
        this.initValueTable();
    }

    private void initDataQueryTree() {
        try {
            DefaultKingdeeTreeNode root = DraftItemDataSourceTreeUtil.getDataQueryRoot(this.dataQuery, this.fieldModel, this.propertyName, this.configEntry, this.entry, null);
            if (root == null) {
                this.treeDataQuery.setModel(null);
            } else {
                this.treeDataQuery.setModel((TreeModel)new KingdeeTreeModel((TreeNode)root));
                this.treeDataQuery.expandOnLevel(1);
                this.treeDataQuery.setToggleClickCount(1);
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    protected void initValueTable() {
    }

    private void treeDataQuery_mouseClicked(MouseEvent e) {
        Object obj;
        TreePath tp = this.treeDataQuery.getSelectionPath();
        if (tp == null) {
            return;
        }
        DefaultKingdeeTreeNode treeNode = (DefaultKingdeeTreeNode)tp.getLastPathComponent();
        if (e.getClickCount() == 1 && treeNode != null && (obj = treeNode.getUserObject()) instanceof PropertyMeta) {
            this.result.setProperty(true);
            this.result.setExpression(((PropertyMeta)obj).getFullSQLFieldName(SysContext.getSysContext().getOriginLocale()));
            this.result.setExpressionAlias(((PropertyMeta)obj).getFullAlias());
            this.txtValueExpression.setText(this.result.getExpressionAlias());
        }
    }

    @Override
    public void actionSetFormulan_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext();
        GetDataFormula formulaInfo = new GetDataFormula(this.dataQuery);
        if (this.result.getExpression() != null && !this.result.getExpression().startsWith("return")) {
            formulaInfo.setFormulaExpr(this.result.getExpression());
        }
        uiContext.put("DataQueryFormula", formulaInfo);
        uiContext.put("fieldModel", this.fieldModel);
        uiContext.put("propertyName", this.propertyName);
        IUIWindow uiWindow = null;
        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(GetDataFormulaUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
        GetDataFormulaUI formulaUI = (GetDataFormulaUI)uiWindow.getUIObject();
        if (!formulaUI.isCancel()) {
            formulaInfo = (GetDataFormula)formulaUI.getData();
            this.result.setProperty(false);
            this.result.setExpression(formulaInfo.getFormulaExpr());
            this.result.setExpressionAlias(formulaInfo.getFormualAlias());
            this.txtValueExpression.setText(this.result.getExpressionAlias());
        }
    }

    @Override
    public void actionComfire_actionPerformed(ActionEvent e) throws Exception {
        this.isCancel = false;
        this.disposeUIWindow();
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.isCancel = true;
        this.disposeUIWindow();
    }

    public boolean isCancel() {
        return this.isCancel;
    }

    public Object getData() {
        return this.result;
    }

    public DataSourceInfo getDataQuery() {
        return this.dataQuery;
    }

    public CompanyOrgUnitInfo getFieldModel() {
        return this.fieldModel;
    }

    public AccountConfigEntryInfo getConfigEntry() {
        return this.configEntry;
    }
}

