/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.basedata.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.LanguageInfo;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.PreChangeEvent;
import com.kingdee.bos.ctrl.swing.event.PreChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.sql.util.StringUtil;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.CompareSignEnum;
import com.kingdee.eas.base.commonquery.LogicSignEnum;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.tm.td.basedata.DataSourceEntryInfo;
import com.kingdee.eas.tm.td.basedata.DataSourceInfo;
import com.kingdee.eas.tm.td.basedata.RelationTypeEnum;
import com.kingdee.eas.tm.td.basedata.client.AbstractDataSourceEntryEditUI;
import com.kingdee.eas.tm.td.basedata.util.EntitySelector;
import com.kingdee.eas.tm.td.basedata.util.EntitySelectorType;
import com.kingdee.eas.tm.td.basedata.util.JoinCondition;
import com.kingdee.eas.tm.td.basedata.util.JoinConditionCollection;
import com.kingdee.eas.tm.td.basedata.util.PropertyMeta;
import com.kingdee.eas.tm.td.basedata.util.PropertyMetaUtil;
import com.kingdee.eas.tm.td.basedata.util.SCMMDUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.enums.EnumUtils;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.Locale;
import javax.swing.JComboBox;
import org.apache.log4j.Logger;

public class DataSourceEntryEditUI
extends AbstractDataSourceEntryEditUI {
    private static final Logger logger = CoreUIObject.getLogger(DataSourceEntryEditUI.class);
    private DataSourceInfo dataSourceInfo;
    private DataSourceEntryInfo parentTable;
    private DataSourceEntryInfo editData;
    private EntityObjectInfo childObject;
    private static final int COL_PARENT_IDX = 0;
    private static final int COL_COMPARESIGN_IDX = 1;
    private static final int COL_CHILD_IDX = 2;
    private static final int COL_LOGIC_IDX = 3;
    private static final String COMPARE_SIGN = "=";
    private boolean isConfirm = false;
    private int defaultRows = 10;
    private SelectorListener childSelectorListener;
    private PreChangeListener childPreChangeListener;
    private DataChangeListener childChangeListener;
    private KDComboBox cmbChildProperty;
    private KDComboBox cmbParentProperty;
    private KDComboBox cmbCompareSignProperty;

    protected void childObjectChanged(DataChangeEvent e) {
        if (e.getNewValue() == null) {
            this.childObject = null;
            this.cmbChildProperty.removeAllItems();
            this.txtChildName.setSelectedItemData(null);
            this.txtChildAlias.setText(null);
            this.clearJoinTable();
            return;
        }
        if (e.getNewValue().equals(e.getOldValue())) {
            return;
        }
        this.childObject = (EntityObjectInfo)this.prmtChildObject.getUserObject();
        this.txtChildName.setSelectedItemData((Object)this.childObject.getAlias());
        this.txtChildAlias.setText(this.childObject.getName());
        this.editData.setTableName(this.childObject.getTable().getName());
        this.editData.setName(this.childObject.getAlias());
        this.editData.setBosType(this.childObject.getType().toString());
        this.editData.setTableAlias(this.childObject.getName());
        this.fillComBoxTableFields(this.editData, this.cmbChildProperty);
        this.clearJoinTable();
    }

    private void clearJoinTable() {
        IRow row = null;
        int count = this.tblJoinCondition.getRowCount();
        for (int i = 0; i < count; ++i) {
            row = this.tblJoinCondition.getRow(i);
            row.getCell(2).setValue(null);
            row.getCell(1).setValue(null);
            row.getCell(0).setValue(null);
            row.getCell(3).setValue(null);
        }
    }

    private void transBillTypeResult(PreChangeEvent e) {
        KDPromptBox f7Box = (KDPromptBox)e.getSource();
        if (e.getData() != null) {
            EntityObjectInfo entity = (EntityObjectInfo)e.getData();
            if (entity != null) {
                e.setData((Object)entity.getFullName());
                f7Box.setUserObject((Object)entity);
            } else {
                e.setData(null);
                f7Box.setUserObject(null);
            }
        } else {
            e.setData(null);
            f7Box.setUserObject(null);
        }
    }

    private void initChildObjectF7(SelectorEvent e) {
        KDPromptBox f7Box = (KDPromptBox)e.getSource();
        if (f7Box.getSelector() == null || !(f7Box.getSelector() instanceof EntitySelector)) {
            EntitySelector selector = new EntitySelector(this.getUIWindow(), EASResource.getString((String)"com.kingdee.eas.scm.framework.balance.BALANCEAutoGenerateResource", (String)"132_DataTableEditUI"), EntitySelectorType.FullEntity);
            f7Box.setSelector((KDPromptSelector)selector);
        }
    }

    @Override
    public void loadFields() {
        if (this.parentTable != null) {
            this.txtParentObject.setText(this.parentTable.getDisplayName());
        }
        if (this.editData.getJoinType() != null) {
            this.cmbRelationType.setSelectedItem((Object)this.editData.getJoinType());
        } else {
            this.cmbRelationType.setSelectedItem((Object)RelationTypeEnum.Left_Join);
        }
        this.txtChildName.setSelectedLanguage(new LanguageInfo(LocaleUtils.getDefaultLocale()));
        if (this.editData.getBosType() != null) {
            this.childObject = SCMMDUtil.getEntityByBosType(this.editData.getBosType());
            this.prmtChildObject.setValue((Object)this.childObject.getFullName());
            this.txtChildName.setSelectedItemData((Object)this.editData.getName());
            this.txtChildAlias.setText(this.editData.getTableAlias());
        }
        try {
            this.initTable();
        }
        catch (Exception e) {
            this.handleException(e);
        }
        if (this.editData.isIsMainTable()) {
            this.cmbRelationType.setEnabled(false);
            this.tblJoinCondition.setEnabled(false);
        } else {
            this.cmbRelationType.setEnabled(true);
            this.tblJoinCondition.setEnabled(true);
        }
        if (OprtState.EDIT.equals(this.getOprtState())) {
            this.prmtChildObject.setEnabled(false);
        } else {
            this.prmtChildObject.setEnabled(true);
        }
        this.prmtChildObject.setEditable(false);
    }

    public void onLoad() throws Exception {
        this.dataSourceInfo = (DataSourceInfo)this.getUIContext().get("DataSource");
        this.editData = (DataSourceEntryInfo)this.getUIContext().get("DataSourceEntry");
        this.parentTable = this.editData.getParentTable();
        super.onLoad();
        this.removeListener();
        this.loadFields();
        this.addListener();
    }

    private void removeListener() {
        this.prmtChildObject.removeSelectorListener(this.childSelectorListener);
        this.prmtChildObject.removePreChangeListener(this.childPreChangeListener);
        this.prmtChildObject.removeDataChangeListener(this.childChangeListener);
    }

    protected KDTable getDetailTable() {
        return null;
    }

    private void addListener() {
        if (this.childSelectorListener == null) {
            this.childSelectorListener = new SelectorListener(){

                public void willShow(SelectorEvent e) {
                    DataSourceEntryEditUI.this.initChildObjectF7(e);
                }
            };
        }
        this.prmtChildObject.addSelectorListener(this.childSelectorListener);
        if (this.childPreChangeListener == null) {
            this.childPreChangeListener = new PreChangeListener(){

                public void preChange(PreChangeEvent e) {
                    DataSourceEntryEditUI.this.transBillTypeResult(e);
                }
            };
        }
        this.prmtChildObject.addPreChangeListener(this.childPreChangeListener);
        if (this.childChangeListener == null) {
            this.childChangeListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent e) {
                    try {
                        DataSourceEntryEditUI.this.childObjectChanged(e);
                    }
                    catch (Exception err) {
                        ExceptionHandler.handle((Throwable)err);
                    }
                }
            };
        }
        this.prmtChildObject.addDataChangeListener(this.childChangeListener);
    }

    private void initTable() throws Exception {
        this.tblJoinCondition.checkParsed();
        this.cmbChildProperty = new KDComboBox();
        this.fillComBoxTableFields(this.editData, this.cmbChildProperty);
        this.tblJoinCondition.getColumn(2).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)this.cmbChildProperty));
        this.cmbParentProperty = new KDComboBox();
        this.fillComBoxTableFields(this.parentTable, this.cmbParentProperty);
        this.tblJoinCondition.getColumn(0).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)this.cmbParentProperty));
        this.txtParentObject.setText(this.parentTable.getTableAlias());
        this.cmbCompareSignProperty = new KDComboBox();
        this.fillComBoxCompareSign(this.cmbCompareSignProperty);
        this.tblJoinCondition.getColumn(1).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)this.cmbCompareSignProperty));
        List valueList = EnumUtils.getEnumList((String)LogicSignEnum.class.getName());
        KDComboBox cmbLogicSign = this.getFieldComboBoxField(valueList.toArray());
        this.tblJoinCondition.getColumn(3).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)cmbLogicSign));
        this.fillJoinCondition();
        this.fillLeftRows();
        this.tblJoinCondition.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                DataSourceEntryEditUI.this.editedCellAfter(e);
            }
        });
    }

    private void fillComBoxCompareSign(KDComboBox cmbCompareSign) {
        cmbCompareSign.removeAllItems();
        cmbCompareSign.addItem((Object)"");
        cmbCompareSign.addItem((Object)COMPARE_SIGN);
        cmbCompareSign.addItem((Object)">");
        cmbCompareSign.addItem((Object)">=");
        cmbCompareSign.addItem((Object)"<");
        cmbCompareSign.addItem((Object)"<=");
        cmbCompareSign.addItem((Object)"<>");
        cmbCompareSign.addItem((Object)"LIKE");
    }

    @Override
    public void actionComfire_actionPerformed(ActionEvent e) throws Exception {
        this.storeFields();
        this.isConfirm = true;
        this.getUIWindow().close();
    }

    protected void beforeStoreFields() {
        if (this.childObject == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.scm.framework.balance.BALANCEAutoGenerateResource", (String)"124_DataTableEditUI"));
            this.prmtChildObject.requestFocus();
            SysUtil.abort();
        }
        if (this.cmbRelationType.getSelectedItem() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.scm.framework.balance.BALANCEAutoGenerateResource", (String)"125_DataTableEditUI"));
            this.cmbRelationType.requestFocus();
            SysUtil.abort();
        }
        if (this.txtChildName.getSelectedItemData() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.scm.framework.balance.BALANCEAutoGenerateResource", (String)"126_DataTableEditUI"));
            this.txtChildName.requestFocus();
            SysUtil.abort();
        }
        if (StringUtil.isEmpty((String)this.txtChildAlias.getText())) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.scm.framework.balance.BALANCEAutoGenerateResource", (String)"128_DataTableEditUI"));
            this.txtChildAlias.requestFocus();
            SysUtil.abort();
        } else if (this.dataSourceInfo.isTableAliasDumplicate(this.editData.getId(), this.txtChildAlias.getText())) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.scm.framework.balance.BALANCEAutoGenerateResource", (String)"129_DataTableEditUI"));
            this.txtChildAlias.requestFocus();
            SysUtil.abort();
        }
        if (this.isRelationTableEmpty()) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.scm.framework.balance.BALANCEAutoGenerateResource", (String)"130_DataTableEditUI"));
            SysUtil.abort();
        }
    }

    private boolean isRelationTableEmpty() {
        IRow row = null;
        boolean result = true;
        for (int i = 0; i < this.tblJoinCondition.getRowCount(); ++i) {
            row = this.tblJoinCondition.getRow(i);
            if (row.getCell(2).getValue() == null || StringUtil.isEmpty((String)row.getCell(2).getValue().toString())) continue;
            if (row.getCell(0).getValue() == null || StringUtil.isEmpty((String)row.getCell(0).getValue().toString())) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.scm.framework.balance.BALANCEAutoGenerateResource", (String)"131_DataTableEditUI"));
                SysUtil.abort();
            }
            result = false;
        }
        return result;
    }

    @Override
    public void storeFields() {
        this.beforeStoreFields();
        this.editData.setBosType(this.childObject.getType().toString());
        this.editData.setName(this.txtChildName.getSelectedItemData().toString());
        this.editData.setTableName(this.childObject.getTable().getName());
        this.editData.setTableAlias(this.txtChildAlias.getText());
        this.editData.setJoinType((RelationTypeEnum)((Object)this.cmbRelationType.getSelectedItem()));
        this.storeJoinCondition();
    }

    private void storeJoinCondition() {
        IRow row = null;
        boolean isFirst = true;
        LogicSignEnum logicSign = null;
        StringBuffer joinString = new StringBuffer();
        for (int i = 0; i < this.tblJoinCondition.getRowCount(); ++i) {
            row = this.tblJoinCondition.getRow(i);
            if (row.getCell(2).getValue() == null || StringUtil.isEmpty((String)row.getCell(2).getValue().toString())) continue;
            if (!isFirst) {
                joinString.append(" ").append(logicSign == null ? "AND" : logicSign.getValue()).append(" ");
            }
            PropertyMeta property = (PropertyMeta)row.getCell(2).getValue();
            joinString.append(property.getFullSQLFieldName(SysContext.getSysContext().getOriginLocale()));
            joinString.append(row.getCell(1).getValue());
            property = (PropertyMeta)row.getCell(0).getValue();
            joinString.append(property.getFullSQLFieldName(SysContext.getSysContext().getOriginLocale()));
            if (row.getCell(3).getValue() instanceof LogicSignEnum) {
                logicSign = (LogicSignEnum)row.getCell(3).getValue();
            }
            isFirst = false;
        }
        this.editData.setJoinCondition(joinString.toString());
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.isConfirm = false;
        this.getUIWindow().close();
    }

    private void editedCellAfter(KDTEditEvent e) {
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        Object object = this.tblJoinCondition.getRow(rowIndex).getCell(colIndex).getValue();
        if (object == null || StringUtil.isEmpty((String)object.toString())) {
            if (colIndex == 0) {
                this.tblJoinCondition.getRow(rowIndex).getCell(1).setValue(null);
                this.tblJoinCondition.getRow(rowIndex).getCell(2).setValue(null);
                this.tblJoinCondition.getRow(rowIndex).getCell(3).setValue(null);
            }
            return;
        }
        if (colIndex == 0) {
            this.tblJoinCondition.getRow(rowIndex).getCell(1).setValue((Object)COMPARE_SIGN);
        }
    }

    public boolean isConfirm() {
        return this.isConfirm;
    }

    private void fillLeftRows() {
        int rowCount = this.tblJoinCondition.getRowCount();
        if (rowCount < this.defaultRows) {
            for (int i = 0; i < this.defaultRows - rowCount; ++i) {
                this.addRow();
            }
        }
    }

    private void fillComBoxTableFields(DataSourceEntryInfo dataTable, KDComboBox cmbEntityProperty) {
        if (dataTable == null) {
            return;
        }
        List<PropertyMeta> propertyList = PropertyMetaUtil.getEntityProperty(dataTable);
        cmbEntityProperty.removeAllItems();
        cmbEntityProperty.addItem((Object)"");
        cmbEntityProperty.addItems(propertyList.toArray());
    }

    private KDComboBox getFieldComboBoxField(Object[] valueArray) {
        KDComboBox kdComboBox = new KDComboBox(valueArray);
        kdComboBox.insertItemAt((Object)"", 0);
        return kdComboBox;
    }

    private void fillJoinCondition() throws Exception {
        JoinCondition condition = null;
        JoinConditionCollection coll = this.editData.getJoinConditionCollection();
        List<PropertyMeta> childList = PropertyMetaUtil.getEntityProperty(this.editData);
        List<PropertyMeta> parentList = PropertyMetaUtil.getEntityProperty(this.parentTable);
        for (int i = 0; i < coll.getConditionCount(); ++i) {
            condition = coll.getJoinConditionAt(i);
            IRow row = this.addRow();
            this.setFieldComboBoxField(this.tblJoinCondition, row.getRowIndex(), 2, childList.toArray(), condition.getChildField().getFieldName());
            this.setCompareSignComboBoxField(this.tblJoinCondition, row.getRowIndex(), 1, condition.getCompareSign());
            this.setFieldComboBoxField(this.tblJoinCondition, row.getRowIndex(), 0, parentList.toArray(), condition.getParentField().getFieldName());
            this.setLogicComboBoxField(this.tblJoinCondition, row.getRowIndex(), 3, condition.getLogicSign());
            row.setUserObject((Object)condition);
        }
    }

    private void setLogicComboBoxField(KDTable table, int rowIndex, int colIndex, String fieldValue) {
        List valueList = EnumUtils.getEnumList((String)LogicSignEnum.class.getName());
        KDComboBox comboBox = this.getFieldComboBoxField(valueList.toArray());
        int count = comboBox.getItemCount();
        int selectedIndex = 0;
        LogicSignEnum obj = null;
        for (int i = 1; i < count; ++i) {
            obj = (LogicSignEnum)comboBox.getItemAt(i);
            if (obj == null || !obj.getValue().equalsIgnoreCase(fieldValue)) continue;
            selectedIndex = i;
            break;
        }
        comboBox.setSelectedIndex(selectedIndex);
        comboBox.setSelectedItem((Object)obj);
        table.getRow(rowIndex).getCell(colIndex).setValue(comboBox.getItemAt(selectedIndex));
    }

    private void setCompareSignComboBoxField(KDTable table, int rowIndex, int colIndex, String fieldValue) {
        List valueList = EnumUtils.getEnumList((String)CompareSignEnum.class.getName());
        KDComboBox comboBox = this.cmbCompareSignProperty;
        int count = comboBox.getItemCount();
        int selectedIndex = 0;
        String value = null;
        for (int i = 1; i < count; ++i) {
            value = (String)comboBox.getItemAt(i);
            if (value == null || !value.equalsIgnoreCase(fieldValue)) continue;
            selectedIndex = i;
            break;
        }
        comboBox.setSelectedIndex(selectedIndex);
        table.getRow(rowIndex).getCell(colIndex).setValue(comboBox.getItemAt(selectedIndex));
    }

    private void setFieldComboBoxField(KDTable table, int rowIndex, int colIndex, Object[] valueArray, String fieldValue) {
        KDComboBox comboBox = this.getFieldComboBoxField(valueArray);
        int count = comboBox.getItemCount();
        int selectedIndex = 0;
        PropertyMeta obj = null;
        String fieldName = null;
        for (int i = 1; i < count; ++i) {
            obj = (PropertyMeta)comboBox.getItemAt(i);
            fieldName = obj.getProperty().get("isMultilingual") == null || "false".equals(obj.getProperty().get("isMultilingual")) ? obj.getMappingField().getName() : obj.getMappingField().getName() + "_" + LocaleUtils.getShortCode((Locale)SysContext.getSysContext().getOriginLocale());
            if (!fieldName.equalsIgnoreCase(fieldValue)) continue;
            selectedIndex = i;
            break;
        }
        comboBox.setSelectedIndex(selectedIndex);
        comboBox.setSelectedItem((Object)obj);
        table.getRow(rowIndex).getCell(colIndex).setValue(comboBox.getItemAt(selectedIndex));
    }

    private IRow addRow() {
        int currentRowSize = this.tblJoinCondition.getRowCount();
        return this.tblJoinCondition.addRow(currentRowSize);
    }
}

