/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.basedata.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.util.StringUtil;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tm.td.TDFacadeFactory;
import com.kingdee.eas.tm.td.basedata.DraftItemFactory;
import com.kingdee.eas.tm.td.basedata.DraftItemInfo;
import com.kingdee.eas.tm.td.basedata.DraftItemStatus;
import com.kingdee.eas.tm.td.basedata.IDraftItem;
import com.kingdee.eas.tm.td.basedata.OrgToDraftItemCollection;
import com.kingdee.eas.tm.td.basedata.OrgToDraftItemFactory;
import com.kingdee.eas.tm.td.basedata.OrgToDraftItemInfo;
import com.kingdee.eas.tm.td.basedata.TaxItemTypeInfo;
import com.kingdee.eas.tm.td.basedata.client.AbstractDraftItemEditUI;
import com.kingdee.eas.tm.td.common.uihelper.EditUIHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class DraftItemEditUI
extends AbstractDraftItemEditUI {
    private static final Logger logger = CoreUIObject.getLogger(DraftItemEditUI.class);
    private CtrlUnitInfo baseCtrlUnit = null;
    private CompanyOrgUnitInfo companyInfo;
    private OrgToDraftItemInfo relationInfo = null;
    private String selectedDraftItemId = null;
    private EditUIHelper uiHelper = new EditUIHelper(this);
    private Map btnMap = new HashMap();

    public DraftItemEditUI() throws Exception {
        this.btnMap.put("actionRemove", this.actionRemove);
        this.btnMap.put("actionCancel", this.actionCancel);
        this.btnMap.put("actionCancelCancel", this.actionCancelCancel);
        this.btnMap.put("actionEdit", this.actionEdit);
        this.btnMap.put("actionSave", this.actionSubmit);
        this.btnMap.put("actionCopy", this.actionCopy);
    }

    protected IObjectValue createNewData() {
        DraftItemInfo draftItemGroupInfo = new DraftItemInfo();
        draftItemGroupInfo.setTaxItemType(this.getTaxItemTypeInfo());
        draftItemGroupInfo.setIsAwaken(DraftItemStatus.SAVING);
        draftItemGroupInfo.setCU(this.baseCtrlUnit);
        return draftItemGroupInfo;
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData != null) {
            this.selectedDraftItemId = this.editData.getId().toString();
            if (this.companyInfo == null) {
                this.companyInfo = (CompanyOrgUnitInfo)this.getUIContext().get("companyInfo");
            }
        }
        this.checkPermission("add");
        super.actionCopy_actionPerformed(e);
    }

    @Override
    public void loadFields() {
        super.loadFields();
        try {
            this.loadRelationInfo();
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    private void initBtnStatus(OrgToDraftItemInfo relation) throws BOSException {
        boolean isLight = false;
        if (relation != null && (DraftItemStatus.NOAWAKEN.equals((Object)relation.getState()) || DraftItemStatus.SAVING.equals((Object)relation.getState()))) {
            isLight = true;
        }
        this.uiHelper.initBtnStatus(this.btnMap, isLight);
        if (relation != null && DraftItemStatus.SAVING.equals((Object)relation.getState()) && !this.getOprtState().equals(OprtState.ADDNEW)) {
            this.actionCancelCancel.setEnabled(true);
            this.actionCancel.setEnabled(true);
        }
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionSave_actionPerformed(e);
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
        OrgToDraftItemInfo relation = OrgToDraftItemFactory.getRemoteInstance().getOrgToDraftItemInfo((IObjectPK)new ObjectUuidPK(this.relationInfo.getId()));
        if (!this.getOprtState().equals(OprtState.ADDNEW)) {
            if (relation != null && DraftItemStatus.AWAKEN.equals((Object)relation.getState())) {
                this.setOprtState("VIEW");
            } else {
                this.setOprtState("EDIT");
            }
        }
        this.setDataObject((IObjectValue)this.editData);
        this.loadFields();
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        this.checkPermission("add");
        super.actionAddNew_actionPerformed(e);
    }

    private void checkPermission(String actionType) throws BOSException, EASBizException {
        String orgId = null;
        boolean isOu = false;
        if (this.companyInfo != null && this.companyInfo.getId() != null) {
            orgId = this.companyInfo.getId().toString();
            isOu = true;
        } else {
            orgId = this.baseCtrlUnit.getId().toString();
            isOu = false;
        }
        String permissionItem = this.getPermissionItem(actionType);
        TDFacadeFactory.getRemoteInstance().checkFunctionPermission(orgId, permissionItem);
    }

    protected abstract String getPermissionItem(String var1);

    protected void loadRelationInfo() throws EASBizException, BOSException {
        if (this.editData == null || this.editData.getId() == null) {
            this.cbState.setSelectedItem((Object)DraftItemStatus.SAVING);
            return;
        }
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("draftItem.id", (Object)this.editData.getId().toString(), CompareType.EQUALS));
        if (this.companyInfo != null && this.companyInfo.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)this.companyInfo.getId().toString(), CompareType.EQUALS));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)this.baseCtrlUnit.getId().toString(), CompareType.EQUALS));
        }
        filter.getFilterItems().add(new FilterItemInfo("taxTypeItem.id", (Object)this.getTaxItemTypeInfo().getId().toString(), CompareType.EQUALS));
        ev.setFilter(filter);
        OrgToDraftItemCollection coll = OrgToDraftItemFactory.getRemoteInstance().getOrgToDraftItemCollection(ev);
        if (coll != null && coll.size() > 0) {
            this.relationInfo = coll.get(0);
            this.cbState.setSelectedItem((Object)this.relationInfo.getState());
        }
        this.initBtnStatus(this.relationInfo);
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkPermission("cancelcancel");
        if (this.relationInfo == null) {
            return;
        }
        if (!this.uiHelper.modifySaveOrExit((ItemAction)this.actionSubmit, this.btnSubmit, (ItemAction)this.actionSave, this.btnSave, this.isModifySave())) {
            return;
        }
        DraftItemFactory.getRemoteInstance().active(this.editData.getId().toString(), this.relationInfo.getId().toString());
        this.setDataObject(this.getValue((IObjectPK)new ObjectUuidPK(this.editData.getId().toString())));
        OrgToDraftItemInfo relation = OrgToDraftItemFactory.getRemoteInstance().getOrgToDraftItemInfo((IObjectPK)new ObjectUuidPK(this.relationInfo.getId()));
        if (relation != null && DraftItemStatus.AWAKEN.equals((Object)relation.getState())) {
            this.setOprtState("VIEW");
        } else {
            this.setOprtState("EDIT");
        }
        this.setDataObject((IObjectValue)this.editData);
        this.loadFields();
        this.initOldData((IObjectValue)this.editData);
        this.setSave(true);
        this.setSaved(true);
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkPermission("cancel");
        if (this.relationInfo == null) {
            return;
        }
        DraftItemFactory.getRemoteInstance().inActive(this.editData.getId().toString(), this.relationInfo.getId().toString());
        this.setDataObject(this.getValue((IObjectPK)new ObjectUuidPK(this.editData.getId().toString())));
        this.loadFields();
        this.initOldData((IObjectValue)this.editData);
        this.setSave(true);
        this.setSaved(true);
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        uiContext.put((Object)"companyInfo", (Object)this.companyInfo);
        uiContext.put((Object)"unitInfo", (Object)this.baseCtrlUnit);
    }

    public void onLoad() throws Exception {
        this.companyInfo = (CompanyOrgUnitInfo)this.getUIContext().get("companyInfo");
        OrgUnitInfo unitInfo = (OrgUnitInfo)this.getUIContext().get("unitInfo");
        if (unitInfo == null) {
            this.baseCtrlUnit = SysContext.getSysContext().getCurrentCtrlUnit();
        } else {
            this.baseCtrlUnit = new CtrlUnitInfo();
            this.baseCtrlUnit.setId(BOSUuid.read((String)unitInfo.getId().toString()));
        }
        super.onLoad();
        this.chkMenuItemSubmitAndAddNew.setSelected(false);
        this.cbState.setEnabled(false);
        this.actionCancel.setVisible(true);
        this.actionCancelCancel.setVisible(true);
        this.initBtnStatus(this.relationInfo);
    }

    protected abstract TaxItemTypeInfo getTaxItemTypeInfo();

    protected ICoreBase getBizInterface() throws Exception {
        return DraftItemFactory.getRemoteInstance();
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        String message = null;
        IDraftItem iFactory = (IDraftItem)this.getBizInterface();
        if (StringUtil.isEmpty((String)this.txtNumber.getText())) {
            message = EASResource.getString((String)"com.kingdee.eas.basedata.scm.common.SCMResource.NumberBlank");
            this.txtNumber.requestFocus();
            MsgBox.showInfo((Component)((Object)this), (String)message);
            SysUtil.abort();
        } else {
            this.editData.setNumber(this.txtNumber.getText().trim());
            this.txtNumber.requestFocus();
            iFactory.checkNumberDup((DataBaseInfo)this.editData);
        }
        if (StringUtil.isEmpty((String)this.txtName.getText())) {
            message = EASResource.getString((String)"com.kingdee.eas.basedata.scm.im.inv.BDScmImInvResource.NameNotNull");
            this.txtName.requestFocus();
            MsgBox.showInfo((Component)((Object)this), (String)message);
            SysUtil.abort();
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkPermission("edit");
        this.checkStateEnableEdit();
        super.actionEdit_actionPerformed(e);
        this.initBtnStatus(this.relationInfo);
    }

    protected void checkStateEnableEdit() throws Exception {
        if (this.relationInfo.getState().equals((Object)DraftItemStatus.AWAKEN)) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.tm.td.basedata.DraftItemResource", (String)"state_saveBanEdit"));
            SysUtil.abort();
        }
        if (this.relationInfo != null && this.relationInfo.getCompanyOrgUnit() != null && !this.relationInfo.isIsCompanyAdd()) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.tm.td.basedata.AccountConfigResource", (String)"MSG_EDIT_ERROR"));
            SysUtil.abort();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        if (this.getOprtState().equals(OprtState.ADDNEW) || this.editData == null || this.relationInfo == null) {
            return;
        }
        this.checkPermission("remove");
        String accountID = this.editData.getId().toString();
        String tempState = this.getOprtState();
        if (this.confirmRemove()) {
            try {
                this.setOprtState("REMOVE");
                this.pubFireVOChangeListener(accountID);
                DraftItemFactory.getRemoteInstance().remove(this.editData.getId().toString(), this.relationInfo.getId().toString());
                this.destroyWindow();
                this.setSave(true);
                this.setSaved(true);
            }
            catch (Throwable ex) {
                this.setOprtState(tempState);
                this.handUIException(ex);
                this.abort();
            }
            finally {
                try {
                    this.setOprtState("RELEASEALL");
                    this.pubFireVOChangeListener(accountID);
                    this.initBtnStatus(this.relationInfo);
                }
                catch (Throwable throwable) {}
            }
        }
    }

    protected void doAfterSubmit(IObjectPK pk) throws Exception {
        this.addOrgToDraftItemRelation(pk);
        if (this.getOprtState().equals(OprtState.ADDNEW) && !StringUtils.isEmpty((String)this.selectedDraftItemId)) {
            if (this.editData != null) {
                if (this.companyInfo == null) {
                    this.companyInfo = (CompanyOrgUnitInfo)this.getUIContext().get("companyInfo");
                }
                OrgUnitInfo unitInfo = (OrgUnitInfo)this.getUIContext().get("unitInfo");
                String companyId = this.companyInfo == null ? null : this.companyInfo.getId().toString();
                String unitId = unitInfo == null ? null : unitInfo.getId().toString();
                DraftItemFactory.getRemoteInstance().copyDataSourceAndTakeDataCondition(this.selectedDraftItemId, pk.toString(), companyId, unitId);
            }
            this.selectedDraftItemId = null;
        }
        super.doAfterSubmit(pk);
    }

    private void addOrgToDraftItemRelation(IObjectPK pk) {
        try {
            if (this.companyInfo != null && this.companyInfo.getId() != null) {
                OrgToDraftItemFactory.getRemoteInstance().addOUDraftItem(pk.toString(), this.companyInfo.getId().toString(), this.getTaxItemTypeInfo().getId().toString());
            } else {
                OrgToDraftItemFactory.getRemoteInstance().addCUDraftItem(pk.toString(), this.baseCtrlUnit.getId().toString(), this.getTaxItemTypeInfo().getId().toString());
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("longNumber"));
        sic.add(new SelectorItemInfo("parent.*"));
        return sic;
    }
}

