/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.basedata.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.FrameWorkException;
import com.kingdee.eas.framework.ITreeBase;
import com.kingdee.eas.framework.batchHandler.UtilRequest;
import com.kingdee.eas.framework.client.FrameWorkClientUtils;
import com.kingdee.eas.framework.client.TreePathUtil;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.tm.td.TDFacadeFactory;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.basedata.DSTypeEnum;
import com.kingdee.eas.tm.td.basedata.DraftItemFactory;
import com.kingdee.eas.tm.td.basedata.DraftItemInfo;
import com.kingdee.eas.tm.td.basedata.DraftItemStatus;
import com.kingdee.eas.tm.td.basedata.DraftItemToDataSourceFactory;
import com.kingdee.eas.tm.td.basedata.OrgToDraftItemFactory;
import com.kingdee.eas.tm.td.basedata.OrgToDraftItemInfo;
import com.kingdee.eas.tm.td.basedata.TaxItemTypeInfo;
import com.kingdee.eas.tm.td.basedata.client.AbstractDraftItemTreeListUI;
import com.kingdee.eas.tm.td.basedata.client.DraftItemEditUI;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.tools.datatask.client.DatataskCaller;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public abstract class DraftItemTreeListUI
extends AbstractDraftItemTreeListUI
implements DataChangeListener {
    private static final Logger logger = CoreUIObject.getLogger(DraftItemTreeListUI.class);
    private String cuId = "";
    public static final String TBL_RELATIONID = "relation.id";
    public static final String TBL_STATE = "relation.state";
    public static final String TBL_ID = "id";
    private Map selectRelationIdsMap = new HashMap();

    @Override
    public void loadFields() {
        this.removeListener();
        super.loadFields();
        this.addListener();
    }

    private void addListener() {
        this.prmtChangeUnit.addDataChangeListener((DataChangeListener)this);
    }

    private void removeListener() {
        this.prmtChangeUnit.removeDataChangeListener((DataChangeListener)this);
    }

    public void dataChanged(DataChangeEvent eventObj) {
        if (((KDBizPromptBox)eventObj.getSource()).getValue() != null && this.treeMain.getModel().getRoot() != null) {
            try {
                this.initTree();
                this.tblMainRefresh();
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filterInfo = new FilterInfo();
        HashSet<String> orgSet = new HashSet<String>();
        if (this.prmtChangeUnit.getValue() != null) {
            FullOrgUnitInfo orgUnit = (FullOrgUnitInfo)this.prmtChangeUnit.getValue();
            orgSet.add(orgUnit.getId().toString());
        }
        if (orgSet.size() == 0) {
            orgSet.add("111111111111111111111111111=");
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("unit.id", orgSet, CompareType.INCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo("taxItemType.id", (Object)this.getTaxItemTypeInfo().getId().toString(), CompareType.INCLUDE));
        return filterInfo;
    }

    public void onLoad() throws Exception {
        this.setUIEnable();
        super.onLoad();
        this.addListener();
    }

    private void setUIEnable() {
        this.btnDataSource.setEnabled(true);
        this.btnTakeDataContdition.setEnabled(true);
        this.kDMenuItem1.setEnabled(true);
        this.kDMenuItem2.setEnabled(true);
        this.menuItemImportData.setVisible(true);
        this.menuItemImportData.setEnabled(true);
        this.menuItemExportData.setVisible(true);
        this.menuItemExportData.setEnabled(true);
        this.btnCancel.setEnabled(true);
        this.btnCancelCancel.setEnabled(true);
        this.btnCancel.setVisible(true);
        this.btnCancelCancel.setVisible(true);
        try {
            FullOrgUnitInfo baseUnit = FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK("00000000-0000-0000-0000-000000000000CCE7AED4"));
            this.prmtChangeUnit.setValue((Object)baseUnit);
            this.cuId = baseUnit.getId().toString();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        this.setOrgUnitF7filter();
    }

    private void prepare4CancelOrCancelCancel() {
        this.checkSelected();
        String[] ids = com.kingdee.eas.basedata.framework.util.KDTableUtil.getSelectRowFieldValue((KDTable)this.tblMain, (String)TBL_ID);
        String[] relationIds = com.kingdee.eas.basedata.framework.util.KDTableUtil.getSelectRowFieldValue((KDTable)this.tblMain, (String)TBL_RELATIONID);
        this.selectRelationIdsMap = new HashMap();
        for (int i = 0; i < ids.length; ++i) {
            this.selectRelationIdsMap.put(ids[i], relationIds[i]);
        }
    }

    private void setOrgUnitF7filter() {
        UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
        FullOrgUnitCollection orgCollection = null;
        try {
            orgCollection = this.getAuthOrgByPermItem((IObjectPK)new ObjectUuidPK(userInfo.getId()), OrgType.ControlUnit, this.getPermissionItem("view"));
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        HashSet<String> idSet = new HashSet<String>();
        FullOrgUnitInfo unitInfo = new FullOrgUnitInfo();
        if (orgCollection != null) {
            for (int i = 0; i < orgCollection.size(); ++i) {
                unitInfo = orgCollection.get(i);
                idSet.add(unitInfo.getId().toString());
            }
        } else {
            idSet.add("1111111111111111111");
        }
        EntityViewInfo entity = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo(TBL_ID, idSet, CompareType.INCLUDE));
        entity.setFilter(filter);
        this.prmtChangeUnit.setEntityViewInfo(entity);
    }

    public FullOrgUnitCollection getAuthOrgByPermItem(IObjectPK user, OrgType orgType, String permItem) throws BOSException, EASBizException {
        FullOrgUnitCollection result = null;
        IPermission permission = PermissionFactory.getRemoteInstance();
        result = permission.getAuthorizedOrg(user, orgType, null, permItem);
        return result;
    }

    protected abstract String getPermissionItem(String var1);

    protected abstract TaxItemTypeInfo getTaxItemTypeInfo();

    protected void treeMain_valueChanged(TreeSelectionEvent e) throws Exception {
        this.tblMainRefresh();
    }

    private void tblMainRefresh() {
        FilterInfo filterInfo = new FilterInfo();
        HashSet<String> orgSet = new HashSet<String>();
        if (this.prmtChangeUnit.getValue() != null) {
            FullOrgUnitInfo orgUnit = (FullOrgUnitInfo)this.prmtChangeUnit.getValue();
            this.cuId = orgUnit.getId().toString();
            orgSet.add(this.cuId);
        }
        if (orgSet.size() == 0) {
            orgSet.add("111111111111111111111111111=");
        }
        if (this.getSelectedTreeNode() != null && this.getSelectedTreeNode().getUserObject() != null) {
            if (this.getSelectedTreeNode().getText().equals(EASResource.getString((String)"com.kingdee.eas.tm.td.basedata.DraftItemResource", (String)"rootName"))) {
                filterInfo.getFilterItems().add(new FilterItemInfo("unit.id", orgSet, CompareType.INCLUDE));
            } else if (this.getSelectedTreeNode() != null) {
                DraftItemInfo draftItemGroupInfo = (DraftItemInfo)this.getSelectedTreeNode().getUserObject();
                filterInfo.appendFilterItem(TBL_ID, (Object)draftItemGroupInfo.getId());
            }
        } else {
            filterInfo.getFilterItems().add(new FilterItemInfo("unit.id", orgSet, CompareType.INCLUDE));
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("taxItemType.id", (Object)this.getTaxItemTypeInfo().getId().toString(), CompareType.INCLUDE));
        try {
            EntityViewInfo dialogView;
            if (this.getDialog().getEntityViewInfoResult() != null && (dialogView = this.getEntityViewInfo((EntityViewInfo)this.getDialog().getEntityViewInfoResult().clone())) != null && dialogView.getFilter() != null) {
                filterInfo.mergeFilter(dialogView.getFilter(), "AND");
            }
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        this.mainQuery.setFilter(filterInfo);
        this.mainQuery.setSelector(this.getSelectors());
        this.setTheFirstFillData(true);
        this.tblMain.repaint();
        this.tblMain.removeRows();
    }

    private Set getDraftItemIdsByParam(Set orgSet) {
        try {
            return OrgToDraftItemFactory.getRemoteInstance().getDraftItemIdsByParam(orgSet, this.getTaxItemTypeInfo().getId().toString(), OrgType.ControlUnit);
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        return null;
    }

    protected void initTree() throws Exception {
        if (this.getRootName() != null) {
            KDTreeNode rootNode = new KDTreeNode(this.getRootObject());
            ((DefaultTreeModel)this.treeMain.getModel()).setRoot((TreeNode)rootNode);
        }
        super.initTree();
    }

    protected ArrayList getImportParam() {
        String solutionName;
        DatataskParameter param = new DatataskParameter();
        param.solutionName = solutionName = "eas.tm.10im.draftitemgroup";
        param.alias = "draftitemgroup";
        param.datataskMode = 0;
        Hashtable<String, TaxItemTypeInfo> table = new Hashtable<String, TaxItemTypeInfo>();
        table.put("taxItemTypeInfo", this.getTaxItemTypeInfo());
        param.setContextParam(table);
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    public void actionImportData_actionPerformed(ActionEvent e) throws Exception {
        super.actionImportData_actionPerformed(e);
    }

    public void actionExportData_actionPerformed(ActionEvent e) throws Exception {
        ArrayList para = this.getExportParam();
        if (para == null || para.size() <= 0) {
            throw new FrameWorkException(FrameWorkException.EXPORTDATAPARANULL);
        }
        DatataskCaller task = new DatataskCaller();
        task.setParentComponent((Component)((Object)this));
        task.setMainOrgContext(this.getMainOrgContext());
        task.invoke(para, 1);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        this.checkPermission("add");
        super.actionAddNew_actionPerformed(e);
    }

    private void checkPermission(String actionType) throws BOSException, EASBizException {
        FullOrgUnitInfo unitInfo = (FullOrgUnitInfo)this.prmtChangeUnit.getValue();
        if (unitInfo == null) {
            return;
        }
        String orgId = unitInfo.getId().toString();
        String permissionItem = this.getPermissionItem(actionType);
        TDFacadeFactory.getRemoteInstance().checkFunctionPermission(orgId, permissionItem);
    }

    protected ArrayList getExportParam() {
        DatataskParameter param = new DatataskParameter();
        param.solutionName = "eas.tm.10im.draftitemgroup";
        param.datataskMode = 1;
        param.alias = "draftItemGroup";
        param.varList = new ArrayList();
        Hashtable<String, FilterInfo> hashtable = new Hashtable<String, FilterInfo>();
        try {
            hashtable.put("filter", this.mainQuery.getFilter());
        }
        catch (Exception e) {
            this.handleException(e);
        }
        param.setContextParam(hashtable);
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    protected String getRootName() {
        return EASResource.getString((String)"com.kingdee.eas.tm.td.basedata.DraftItemResource", (String)"rootName");
    }

    protected ITreeBase getTreeInterface() throws Exception {
        return DraftItemFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return DraftItemEditUI.class.getName();
    }

    protected FilterInfo getDefaultFilterForTree() {
        if (this.prmtChangeUnit.getValue() == null) {
            return null;
        }
        FilterInfo filter = new FilterInfo();
        HashSet<String> orgSet = new HashSet<String>();
        Set<String> idSet = new HashSet();
        FullOrgUnitInfo orgUnit = (FullOrgUnitInfo)this.prmtChangeUnit.getValue();
        this.cuId = orgUnit.getId().toString();
        orgSet.add(this.cuId);
        idSet = this.getDraftItemIdsByParam(orgSet);
        if (idSet.size() == 0) {
            idSet.add("111111111111111111111111111=");
        }
        filter.getFilterItems().add(new FilterItemInfo(TBL_ID, idSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("taxItemType.id", (Object)this.getTaxItemTypeInfo().getId().toString(), CompareType.INCLUDE));
        return filter;
    }

    private String getCurrentUnitId() {
        String unitId = "";
        if (this.prmtChangeUnit.getValue() != null) {
            FullOrgUnitInfo orgUnit = (FullOrgUnitInfo)this.prmtChangeUnit.getValue();
            unitId = orgUnit.getId().toString();
        }
        return unitId;
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        FullOrgUnitInfo unitInfo = (FullOrgUnitInfo)this.prmtChangeUnit.getValue();
        uiContext.put((Object)"unitInfo", (Object)unitInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.checkPermission("remove");
        if (this.confirmRemove()) {
            String[] ids = com.kingdee.eas.basedata.framework.util.KDTableUtil.getSelectRowFieldValue((KDTable)this.tblMain, (String)TBL_ID);
            String[] relationIds = com.kingdee.eas.basedata.framework.util.KDTableUtil.getSelectRowFieldValue((KDTable)this.tblMain, (String)TBL_RELATIONID);
            HashMap<String, String[]> params = new HashMap<String, String[]>();
            params.put("billIds", ids);
            params.put("relationIds", relationIds);
            ArrayList idList = this.getSelectedIdValues();
            ArrayList errorList = new ArrayList();
            IMutexServiceControl mutexServiceControl = FrameWorkClientUtils.createMutexServiceControl();
            try {
                Map map = mutexServiceControl.batchRequestObjIDForUpdate((List)idList);
                boolean isReqError = TDUtils.isLocked(map);
                if (isReqError) {
                    MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.tm.td.TaxDraftResource", (String)"LOCK_ERROR"));
                    return;
                }
                errorList = DraftItemFactory.getRemoteInstance().remove(params);
            }
            finally {
                mutexServiceControl.batchReleaseObjIDForUpdate((List)idList);
            }
            String deleteError = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_DeleteError");
            if (errorList.size() > 0) {
                StringBuffer errorDetailMSG = new StringBuffer();
                for (int i = 0; i < errorList.size(); ++i) {
                    errorDetailMSG.append(errorList.get(i)).append("\n");
                }
                MsgBox.showDetailAndOK((Component)((Object)this), (String)deleteError, (String)errorDetailMSG.toString(), (int)8188);
            }
            this.refresh(null);
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.checkPermission("edit");
        this.checkStateEnableEdit();
        super.actionEdit_actionPerformed(e);
    }

    protected void checkStateEnableEdit() throws Exception {
        this.checkSelected();
        IRow row = KDTableUtil.getSelectedRow((KDTable)this.getDetailTable());
        String relationId = (String)row.getCell(TBL_RELATIONID).getValue();
        OrgToDraftItemInfo relationInfo = OrgToDraftItemFactory.getRemoteInstance().getOrgToDraftItemInfo((IObjectPK)new ObjectUuidPK(relationId));
        if (relationInfo.getState().equals((Object)DraftItemStatus.AWAKEN)) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.tm.td.basedata.AccountConfigResource", (String)"ActiveNotEdit"));
            SysUtil.abort();
        }
    }

    protected void refresh(ActionEvent e) throws Exception {
        TreePath oldPath = this.treeMain.getSelectionPath();
        this.initTree();
        TreePath path = TreePathUtil.getNewTreePath((JTree)this.treeMain, (TreeModel)this.treeMain.getModel(), (TreePath)oldPath);
        if (path != null) {
            this.treeMain.setSelectionPath(path);
        } else {
            this.treeMain.setSelectionRow(0);
        }
        this.tblMain.refresh();
    }

    public void checkSelected() {
        if (this.getDetailTable().getRowCount() == 0 || this.getDetailTable().getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
    }

    protected KDTable getDetailTable() {
        return this.tblMain;
    }

    @Override
    public void actionDataSource_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext();
        String draftItemId = this.getSelectedKeyValue();
        this.checkSelected();
        this.checkPermission("datasource");
        Set dataSourceIds = DraftItemToDataSourceFactory.getRemoteInstance().getDataSourceByParam(this.cuId, draftItemId, null);
        if (draftItemId != null && draftItemId.length() > 0) {
            FullOrgUnitInfo orgInfo = (FullOrgUnitInfo)this.prmtChangeUnit.getData();
            if (dataSourceIds != null && dataSourceIds.size() > 0) {
                uiContext.put("dataSourceIds", dataSourceIds);
            }
            uiContext.put("draftItemId", draftItemId);
            uiContext.put("orgUnitId", orgInfo.getId().toString());
            uiContext.put("companyOrgUnitID", null);
            uiContext.put("dsType", DSTypeEnum.DraftItem);
            IUIWindow uiWindow = null;
            uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.tm.td.basedata.client.DataSourceListUI", (Map)uiContext);
            uiWindow.show();
        }
    }

    @Override
    public void actionTakeDataContdition_actionPerformed(ActionEvent e) throws Exception {
        Set dataSourceIds;
        this.checkPermission("getdata");
        UIContext uiContext = new UIContext();
        String draftItemID = this.getSelectedKeyValue();
        if (draftItemID == null) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.tm.td.basedata.DraftItemResource", (String)"select_oneRow"));
            SysUtil.abort();
        }
        if ((dataSourceIds = DraftItemToDataSourceFactory.getRemoteInstance().getDataSourceByParam(this.cuId, draftItemID, null)).size() == 0) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.tm.td.TDResource", (String)"NEED_ADD_DATASOURCE"));
            return;
        }
        uiContext.put("draftItemId", draftItemID);
        uiContext.put("orgUnitId", this.cuId);
        uiContext.put("dataSourceSet", dataSourceIds);
        uiContext.put("dsType", DSTypeEnum.DraftItem);
        IUIWindow uiWindow = null;
        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.tm.td.basedata.client.TakeDataContditionListUI", (Map)uiContext);
        uiWindow.show();
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.checkPermission("cancelcancel");
        this.prepare4CancelOrCancelCancel();
        String cancelMsg = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_CancelCancel");
        if (this.confirmDialog(cancelMsg)) {
            if (UtilRequest.isPrepare((String)"ActionCancelCancel", (CoreUIObject)this)) {
                this.prepareCancelCancel(null).callHandler();
            }
            this.cancelCancel();
            this.refresh(e);
        }
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.checkPermission("cancel");
        this.prepare4CancelOrCancelCancel();
        super.actionCancel_actionPerformed(e);
        this.refresh(e);
    }

    protected String getKeyFieldName() {
        return TBL_ID;
    }

    protected void runCancelCancel(IObjectPK pk) throws Exception {
        String billId = pk.toString();
        DraftItemFactory.getRemoteInstance().active(pk.toString(), this.selectRelationIdsMap.get(billId).toString());
    }

    protected void runCancel(IObjectPK pk) throws Exception {
        String billId = pk.toString();
        DraftItemFactory.getRemoteInstance().inActive(pk.toString(), this.selectRelationIdsMap.get(billId).toString());
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
    }
}

