/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.basedata.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.FrameWorkException;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.basedata.TaxBaseFactory;
import com.kingdee.eas.tm.td.basedata.TaxBaseInfo;
import com.kingdee.eas.tm.td.basedata.TaxInfoState;
import com.kingdee.eas.tm.td.basedata.client.AbstractTaxBaseListUI;
import com.kingdee.eas.tm.td.basedata.client.TaxBaseEditUI;
import com.kingdee.eas.tm.td.common.permsupport.IPermSupport4ListUI;
import com.kingdee.eas.tm.td.common.uihelper.ListUIHelper;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.tools.datatask.client.DatataskCaller;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import javax.swing.AbstractButton;
import org.apache.log4j.Logger;

public class TaxBaseListUI
extends AbstractTaxBaseListUI
implements IPermSupport4ListUI {
    private static final Logger logger = CoreUIObject.getLogger(TaxBaseListUI.class);
    private static final String COL_CREATETIME = "creatTime";
    private static final String COL_UPDATEDATE = "updateTime";
    private ListUIHelper uiHelper = new ListUIHelper(this);

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    public void onLoad() throws Exception {
        this.setMergeColumn();
        super.onLoad();
        String[] dateCols = new String[]{COL_CREATETIME, COL_UPDATEDATE};
        for (int i = 0; i < dateCols.length; ++i) {
            String dateFormatStr = CtrlFormatUtilities.getDateFormatString();
            this.tblMain.getColumn(dateCols[i]).getStyleAttributes().setNumberFormat(dateFormatStr);
        }
    }

    protected FilterInfo getDefaultFilterForQuery() {
        return this.uiHelper.getHasPermissionOrgFilterForQuery();
    }

    protected ArrayList getImportParam() {
        String solutionName;
        DatataskParameter param = new DatataskParameter();
        param.solutionName = solutionName = "taxBase";
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    protected ArrayList getExportParam() {
        DatataskParameter param = new DatataskParameter();
        param.solutionName = "taxBase";
        param.datataskMode = 1;
        param.alias = TDUtils.getString("com.kingdee.eas.tm.td.basedata.TaxBaseResource", "TaxBaseTitle", TDUtils.getLocale());
        param.varList = new ArrayList();
        Hashtable<String, FilterInfo> hashtable = new Hashtable<String, FilterInfo>();
        HashSet selectIds = new HashSet(this.getSelectedIdValues());
        try {
            if (selectIds.size() > 0) {
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", selectIds, CompareType.INCLUDE));
                hashtable.put("filter", filter);
            } else if (this.mainQuery != null) {
                hashtable.put("filter", this.mainQuery.getFilter());
            }
        }
        catch (Exception filter) {
            // empty catch block
        }
        param.setContextParam(hashtable);
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        ObjectUuidPK pk = null;
        if (this.isSupportedBatchActions()) {
            TaxBaseInfo info = null;
            try {
                if (!StringUtils.isEmpty((String)this.getSelectedKeyValue()) && this.getBizInterface().exists((IObjectPK)new ObjectUuidPK(this.getSelectedKeyValue())) && (info = TaxBaseFactory.getRemoteInstance().getTaxBaseInfo((IObjectPK)new ObjectUuidPK(this.getSelectedKeyValue()))) != null && info.getCompany() != null) {
                    pk = new ObjectUuidPK(info.getCompany().getId().toString());
                }
            }
            catch (Exception e) {
                this.handUIException(e);
            }
            if (pk != null) {
                return pk;
            }
        }
        if (this.getMainOrgContext() != null && this.getMainOrgContext().get((Object)this.getMainBizOrgType()) != null) {
            pk = new ObjectUuidPK(((OrgUnitInfo)this.getMainOrgContext().get((Object)this.getMainBizOrgType())).getId().toString());
            return pk;
        }
        return super.getOrgPK(action);
    }

    private boolean isSupportedBatchActions() {
        return true;
    }

    public void actionExportData_actionPerformed(ActionEvent e) throws Exception {
        ArrayList para = this.getExportParam();
        if (para == null || para.size() <= 0) {
            throw new FrameWorkException(FrameWorkException.EXPORTDATAPARANULL);
        }
        DatataskCaller task = new DatataskCaller();
        task.setParentComponent((Component)((Object)this));
        task.setMainOrgContext(this.getMainOrgContext());
        task.invoke(para, 1);
    }

    private void setMergeColumn() {
        String[] mergeColumnKeys = this.getMergeColumnKeys();
        if (mergeColumnKeys != null && mergeColumnKeys.length > 0) {
            this.tblMain.checkParsed();
            this.tblMain.getGroupManager().setGroup(true);
            IColumn col = null;
            for (int i = 0; i < mergeColumnKeys.length; ++i) {
                col = this.tblMain.getColumn(mergeColumnKeys[i]);
                if (col != null) {
                    col.setGroup(true);
                    col.setMergeable(true);
                    continue;
                }
                logger.info((Object)("mergeColumn no found:" + mergeColumnKeys[i]));
            }
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public String[] getMergeColumnKeys() {
        this.tblMain.checkParsed();
        String[] columns = new String[]{"id", "number", "name", "company.name", "taxpayerName", "isMinitype", "taxpayerType", "taxpayerIdetifyNO", "mainGovAgency", "nationTaxContact", "nationTaxTel", "localTaxAgency", "localTaxAgencyContact", "localTaxAgencyTel", "operateScole", "legalRepresentor", "financer.name", "taxOfficer.name", "taxOfficerTel", "comStatus", "enterRegistDate", "registerType", "countryNameAndCode", "industryName", "industryCode", "legalQualification", "isSumRatepayCom", "mainRate", "isThousandEnterprise", "isKeyTaxEnterprise", "registCountry.name", "registProvince.name", "registCity.name", "registAddress", "operateCountry.name", "operateProvince.name", "operateCity.name", "operateAddress", "registCapital", "totalInvest", "state", "costCenter.name", COL_CREATETIME, COL_UPDATEDATE, "currency.name", "creater.name", "updater.name", "mainGovName.name", "mainCompany.name"};
        return columns;
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        if (this.confirmRemove()) {
            this.checkSelected();
            ArrayList result = TaxBaseFactory.getRemoteInstance().batchDelete(new HashSet(this.getSelectedIdValues()));
            String error = "";
            String errorDetail = "";
            if (result != null && !result.isEmpty()) {
                error = EASResource.getString((String)"com.kingdee.eas.tm.td.basedata.TaxBaseResource", (String)"REMOVE_ERROR");
                errorDetail = this.buildErrorMsg(result);
                MsgBox.showDetailAndOK(null, (String)error, (String)errorDetail, (int)1);
            }
            this.refreshList();
        }
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String cancelMsg = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Cancel");
        String cancelError = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_CancelError");
        if (this.confirmDialog(cancelMsg)) {
            ArrayList errorList = TaxBaseFactory.getRemoteInstance().cancel(new HashSet(this.getSelectedIdValues()));
            if (errorList.size() > 0) {
                StringBuffer errorDetailMSG = new StringBuffer();
                for (int i = 0; i < errorList.size(); ++i) {
                    errorDetailMSG.append((String)errorList.get(i)).append("\n");
                }
                MsgBox.showDetailAndOK((Component)((Object)this), (String)cancelError, (String)errorDetailMSG.toString(), (int)8188);
            }
            this.actionRefresh_actionPerformed(e);
        }
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList errorList = TaxBaseFactory.getRemoteInstance().cancelCancel(new HashSet(this.getSelectedIdValues()));
        String cancelCancelError = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_CancelCancelError");
        if (errorList.size() > 0) {
            StringBuffer errorDetailMSG = new StringBuffer();
            for (int i = 0; i < errorList.size(); ++i) {
                errorDetailMSG.append((String)errorList.get(i)).append("\n");
            }
            MsgBox.showDetailAndOK((Component)((Object)this), (String)cancelCancelError, (String)errorDetailMSG.toString(), (int)8188);
        }
        this.actionRefresh_actionPerformed(e);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        TaxBaseInfo info = TaxBaseFactory.getRemoteInstance().getTaxBaseInfo((IObjectPK)new ObjectUuidPK(id));
        if (TaxInfoState.ABLE.equals((Object)info.getState())) {
            MsgBox.showWarning((String)TDUtils.getString("com.kingdee.eas.tm.td.basedata.TaxBaseResource", "Active_NotEdit", TDUtils.getLocale()));
            return;
        }
        super.actionEdit_actionPerformed(e);
    }

    protected String getEditUIName() {
        return TaxBaseEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return TaxBaseFactory.getRemoteInstance();
    }

    @Override
    public String getBizOrgProperty(OrgType orgType) throws BOSException, EASBizException {
        return "company";
    }

    @Override
    public ICoreBase getPermInterface() throws Exception {
        return this.getBizInterface();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        try {
            this.initPermActions();
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void initPermActions() throws BOSException, EASBizException {
        this.uiHelper.bindPermission((AbstractButton)this.btnRemove, (IItemAction)this.actionRemove, this.getServiceContext());
        this.uiHelper.bindPermission((AbstractButton)this.btnCancelCancel, (IItemAction)this.actionCancelCancel, this.getServiceContext());
        this.uiHelper.bindPermission((AbstractButton)this.btnCancel, (IItemAction)this.actionCancel, this.getServiceContext());
        this.uiHelper.bindPermission((AbstractButton)this.menuItemRemove, (IItemAction)this.actionRemove, this.getServiceContext());
        this.uiHelper.bindPermission((AbstractButton)this.menuItemCancelCancel, (IItemAction)this.actionCancelCancel, this.getServiceContext());
        this.uiHelper.bindPermission((AbstractButton)this.menuItemCancel, (IItemAction)this.actionCancel, this.getServiceContext());
    }

    @Override
    public void initPermMainOrgContext(String orgID) throws Exception {
        this.initUIMainOrgContext(orgID);
    }

    public String buildErrorMsg(ArrayList msg) {
        StringBuffer retMsg = new StringBuffer();
        for (int i = 0; i < msg.size(); ++i) {
            retMsg.append(msg.get(i)).append("\r\n");
        }
        return retMsg.toString();
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }
}

