/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.basedata.dataImport.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.basedata.dataImport.impl.AbstractDataImport;
import com.kingdee.eas.tm.td.basedata.dataImport.model.DataImportParams;
import com.kingdee.eas.tm.td.utils.CollectionUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public class DraftItemDataImport
extends AbstractDataImport {
    public DraftItemDataImport(Context ctx, DataImportParams params) {
        super(ctx, params);
    }

    @Override
    protected void delDataSourceConfigRelationRecords() throws BOSException, EASBizException {
        StringBuffer delDraftRelation = new StringBuffer();
        delDraftRelation.append(" delete from  T_TM_DraftItemToDataSource where fid  in (");
        delDraftRelation.append(this.getSelectSql("dsRelation")).append(" )");
        DbUtil.execute((Context)this.ctx, (String)delDraftRelation.toString());
    }

    @Override
    protected void delOrgConfigRelationRecords() throws BOSException, EASBizException {
        StringBuffer delOrgDraftRelation = new StringBuffer();
        delOrgDraftRelation.append(" delete from  T_TM_OrgToDraftItem where fid  in (");
        delOrgDraftRelation.append(this.getSelectSql("itemOrgRelation")).append(" )");
        DbUtil.execute((Context)this.ctx, (String)delOrgDraftRelation.toString());
    }

    @Override
    protected String getSelectSql(String selectType) throws BOSException, EASBizException {
        StringBuffer sb = new StringBuffer();
        if ("takeContdition".equals(selectType)) {
            sb.append(" select t3.fid ");
            sb.append(" from T_TM_DraftItemToDataSource t0 ");
            sb.append(" left join T_TM_DataSource t1 on t1.fid = t0.fdatasourceid ");
            sb.append(" left join T_TM_DataSourceEntry t2 on t1.fid = t2.fparentid ");
            sb.append(" left join T_TM_TakeDataContdition  t3 on t1.fid = t3.FDATASOURCEID ");
            sb.append(" inner join T_TM_DraftItem item on item.fid = t0.FDraftItemID ");
            sb.append(" where t0.FCompanyOrgUnitID = '" + this.params.getCompanyId() + "' ");
            sb.append(" and item.FTaxItemTypeID =  '" + this.params.getTaxTypeID() + "' ");
            sb.append(" and t0.FIsCompanyAdd =0  ");
        } else if ("dsEntry".equals(selectType)) {
            sb.append(" select t2.fid ");
            sb.append(" from T_TM_DraftItemToDataSource t0 ");
            sb.append(" left join T_TM_DataSource t1 on t1.fid = t0.fdatasourceid ");
            sb.append(" left join T_TM_DataSourceEntry t2 on t1.fid = t2.fparentid ");
            sb.append(" inner join T_TM_DraftItem item on item.fid = t0.FDraftItemID ");
            sb.append(" where t0.FCompanyOrgUnitID = '" + this.params.getCompanyId() + "' ");
            sb.append(" and item.FTaxItemTypeID =  '" + this.params.getTaxTypeID() + "' ");
            sb.append(" and t0.FIsCompanyAdd =0  ");
        } else if ("dataSource".equals(selectType)) {
            sb.append(" select t1.fid ");
            sb.append(" from T_TM_DraftItemToDataSource t0 ");
            sb.append(" left join T_TM_DataSource t1 on t1.fid = t0.fdatasourceid ");
            sb.append(" inner join T_TM_DraftItem item on item.fid = t0.FDraftItemID ");
            sb.append(" where t0.FCompanyOrgUnitID = '" + this.params.getCompanyId() + "' ");
            sb.append(" and item.FTaxItemTypeID =  '" + this.params.getTaxTypeID() + "' ");
            sb.append(" and t0.FIsCompanyAdd =0  ");
        } else if ("dsRelation".equals(selectType)) {
            sb.append(" select t0.fid ");
            sb.append(" from T_TM_DraftItemToDataSource t0 ");
            sb.append(" inner join T_TM_DraftItem item on item.fid = t0.FDraftItemID ");
            sb.append(" where t0.FCompanyOrgUnitID = '" + this.params.getCompanyId() + "' ");
            sb.append(" and item.FTaxItemTypeID =  '" + this.params.getTaxTypeID() + "' ");
            sb.append(" and t0.FIsCompanyAdd =0  ");
        } else if ("itemOrgRelation".equals(selectType)) {
            sb.append(" select t0.fid from T_TM_OrgToDraftItem t0");
            sb.append(" inner join T_TM_DraftItem item on item.fid = t0.FDraftItemID");
            sb.append(" where t0.FIsCompanyAdd = 0 and t0.FCompanyOrgUnitID =  '" + this.params.getCompanyId() + "' and t0.FTAXTYPEITEMID =  '" + this.params.getTaxTypeID() + "' ");
        }
        if (this.params.getDraftItems() != null && this.params.getDraftItems().size() > 0) {
            String orgUnitID = null;
            orgUnitID = !"00000000-0000-0000-0000-000000000000CCE7AED4".equals(this.params.getImportCuId()) ? "00000000-0000-0000-0000-000000000000CCE7AED4" : this.company.getCU().getId().toString();
            sb.append(" and (");
            sb.append(" item.fid in (").append(CollectionUtil.convertList2String(this.params.getDraftItems(), ",", true)).append(")");
            sb.append(" or item.fid in (");
            sb.append(" select FDraftItemID from T_TM_OrgToDraftItem where FOrgUnitID ='").append(orgUnitID).append("'");
            sb.append(" and FTAXTYPEITEMID = '").append(this.params.getTaxTypeID()).append("'");
            sb.append(" ))");
        }
        return sb.toString();
    }

    @Override
    protected String getImportCuId() throws BOSException, EASBizException {
        String tempCUID = "00000000-0000-0000-0000-000000000000CCE7AED4";
        StringBuffer draftitemCheck = new StringBuffer();
        draftitemCheck.append(" select  top 1 t1.FOrgUnitID as cuId  from T_TM_OrgToDraftItem t1 ");
        draftitemCheck.append(" inner join  t_tm_draftitem t2 on t1.fdraftitemid  = t2.fid ");
        draftitemCheck.append(" inner join  t_org_company  t3 on t1.FOrgUnitID =  t3.FControlUnitID ");
        draftitemCheck.append(" where t1.fstate = '1' and t3.fid = '" + this.params.getCompanyId() + "' ");
        draftitemCheck.append(" and t2.FTaxItemTypeID = '" + this.params.getTaxTypeID() + "' ");
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)draftitemCheck.toString());
        try {
            if (rs.next()) {
                tempCUID = rs.getString("cuId");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return tempCUID;
    }

    @Override
    protected void insertOrgConfigRelationRecords() throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select count(1) as TOTALCOUNT");
        sql.append(" from T_TM_OrgToDraftItem  t1 inner join t_tm_draftitem t2 on t1.FDRAFTITEMID = t2.fid ");
        sql.append(" where t1.FCompanyOrgUnitID is null and t1.fstate = '1' and  t1.FOrgUnitID = '");
        sql.append(this.importCuId).append("' and t1.FTaxTypeItemID= '" + this.params.getTaxTypeID() + "'");
        if (this.params.getDraftItems() != null && this.params.getDraftItems().size() > 0) {
            sql.append(" and t2.fid in (").append(CollectionUtil.convertList2String(this.params.getDraftItems(), ",", true)).append(")");
        }
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
        try {
            while (rs.next()) {
                this.successCount = rs.getInt("TOTALCOUNT");
                if (this.successCount == 0) {
                    this.result.setDetailMsg(TDUtils.getString("com.kingdee.eas.tm.td.TDResource", "msg_DataImportEmpty", this.ctx.getLocale(), new Object[]{this.company.getName()}));
                    continue;
                }
                this.result.setDetailMsg(TDUtils.getString("com.kingdee.eas.tm.td.TDResource", "msg_DataImportSuccess", this.ctx.getLocale(), new Object[]{this.company.getName(), this.successCount}));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        StringBuffer insertStr = new StringBuffer();
        insertStr.append(" insert into T_TM_OrgToDraftItem ");
        insertStr.append(" (fid,FOrgUnitID,FCompanyOrgUnitID,FDraftItemID,FTaxTypeItemID,FIsCompanyAdd ) ");
        insertStr.append(" select newBosid('75C5FDE7'),null,'" + this.params.getCompanyId() + "',FDraftItemID,FTaxTypeItemID,0");
        insertStr.append(" from T_TM_OrgToDraftItem  t1 inner join t_tm_draftitem t2 on t1.FDRAFTITEMID = t2.fid ");
        insertStr.append(" where t1.FCompanyOrgUnitID is null and t1.fstate = '1' and t1.FOrgUnitID = '");
        insertStr.append(this.importCuId).append("' and t1.FTaxTypeItemID= '" + this.params.getTaxTypeID() + "'");
        if (this.params.getDraftItems() != null && this.params.getDraftItems().size() > 0) {
            insertStr.append(" and t2.fid in (").append(CollectionUtil.convertList2String(this.params.getDraftItems(), ",", true)).append(")");
        }
        DbUtil.execute((Context)this.ctx, (String)insertStr.toString());
    }

    @Override
    protected Map<String, String> getCUDataSourceMap() throws BOSException, EASBizException {
        IRowSet dataSource;
        StringBuffer getIds = new StringBuffer();
        getIds.append(" SELECT t2.fid as dsid,t1.fid as relationID FROM  T_TM_DraftItemToDataSource t1 ");
        getIds.append(" inner join T_TM_DataSource t2 on t1.FDataSourceID = t2.fid ");
        getIds.append(" where FOrgUnitID  = '" + this.importCuId + "' and t1.FDraftItemID in ( ");
        getIds.append(" select  FDraftItemID  from T_TM_OrgToDraftItem where FOrgUnitID = '" + this.importCuId + "' and FTaxTypeItemID = '" + this.params.getTaxTypeID() + "' ");
        getIds.append("  )");
        if (this.params.getDraftItems() != null && this.params.getDraftItems().size() > 0) {
            getIds.append(" and t1.FDraftItemID in (").append(CollectionUtil.convertList2String(this.params.getDraftItems(), ",", true)).append(")");
        }
        if ((dataSource = DbUtil.executeQuery((Context)this.ctx, (String)getIds.toString())).size() == 0) {
            return null;
        }
        HashMap<String, String> dsMap = new HashMap<String, String>();
        try {
            while (dataSource.next()) {
                dsMap.put(dataSource.getString("dsid"), dataSource.getString("relationID"));
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return dsMap;
    }

    @Override
    protected void insertDataSourceConfigRelationRecords() throws BOSException, EASBizException {
        String orgToDsTableName = null;
        try {
            orgToDsTableName = TempTablePool.getInstance((Context)this.ctx).createTempTableName();
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage());
        }
        StringBuffer insertOrgToDSSql = new StringBuffer();
        insertOrgToDSSql.append(" select * into " + orgToDsTableName + " from T_TM_DraftItemToDataSource where fid in (" + this.relationIds + ")");
        DbUtil.execute((Context)this.ctx, (String)insertOrgToDSSql.toString());
        StringBuffer updateSql = new StringBuffer();
        updateSql.append(" update " + orgToDsTableName + " t10  set (FCompanyOrgUnitID,FDataSourceID) = ( ");
        updateSql.append(" SELECT '" + this.params.getCompanyId() + "',t2.fnewId  ");
        updateSql.append(" FROM " + orgToDsTableName + " t1 inner join " + this.dsTempTableName + "  t2 on t1.FDataSourceID = t2.fid ");
        updateSql.append(" where t10.fid = t1.fid) ");
        DbUtil.execute((Context)this.ctx, (String)updateSql.toString());
        DbUtil.execute((Context)this.ctx, (String)this.insertOrgToDataSource(orgToDsTableName));
        TempTablePool.getInstance((Context)this.ctx).releaseTable(orgToDsTableName);
    }

    private String insertOrgToDataSource(String tempTableName) {
        StringBuffer insertSql = new StringBuffer();
        insertSql.append(" insert into T_TM_DraftItemToDataSource");
        insertSql.append(" (fid,FDraftItemID,FDataSourceID,FOrgUnitID,FCompanyOrgUnitID,FIsCompanyAdd  )");
        insertSql.append(" select newbosid('6502B022'),FDraftItemID,FDataSourceID,null,FCompanyOrgUnitID,0  from ").append(tempTableName);
        return insertSql.toString();
    }

    @Override
    protected void checkNumberOrNameDup(String type) throws BOSException, EASBizException {
    }
}

