/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.DataObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.td.SortTypeEnum;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.basedata.AccountConfigEntryCollection;
import com.kingdee.eas.tm.td.basedata.AccountConfigEntryInfo;
import com.kingdee.eas.tm.td.basedata.AccountConfigFactory;
import com.kingdee.eas.tm.td.basedata.AccountConfigInfo;
import com.kingdee.eas.tm.td.basedata.DataTypeEnum;
import com.kingdee.eas.tm.td.client.AbstractAccountFieldSelectUI;
import com.kingdee.eas.tm.td.client.AccountFormulaUIHelper;
import com.kingdee.eas.tm.td.client.RowIdxComparer;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import org.apache.log4j.Logger;

public class AccountFieldSelectUI
extends AbstractAccountFieldSelectUI {
    private static final Logger logger = CoreUIObject.getLogger(AccountFieldSelectUI.class);
    private ArrayList rptArr = null;
    private ArrayList rptArrSelected = null;
    private AccountConfigInfo configInfo = null;
    private int rowsize = 0;
    private boolean isCanceled = true;
    private Map data = null;
    private boolean isSumFormula = false;
    private boolean isColumnMatch = false;
    private boolean isSumField = false;
    private boolean enabledMultiSelection = true;
    private boolean isOnlySelected = false;
    private KDTEditAdapter fieldSelectTableChange = null;
    private ItemListener isGroupListener = null;
    private ItemListener isSumListener = null;
    private ItemListener dataTypeChangeListener = null;

    public void setRptArr(ArrayList arr) {
        this.rptArr = arr;
    }

    public ArrayList getRptArr() {
        if (this.rptArr == null) {
            this.rptArr = new ArrayList();
        }
        return this.rptArr;
    }

    public void setRptArrSelected(ArrayList arr) {
        this.rptArrSelected = arr;
    }

    public ArrayList getRptArrSelected() {
        if (this.rptArrSelected == null) {
            this.rptArrSelected = new ArrayList();
        }
        return this.rptArrSelected;
    }

    public void onLoad() throws Exception {
        this.fieldGrid.checkParsed();
        this.fieldSelectedGrid.checkParsed();
        super.onLoad();
        this.initParam();
        this.initFields();
        this.initControl();
        this.loadFields();
    }

    @Override
    public void loadFields() {
        this.removeListener();
        super.loadFields();
        this.initListeners();
    }

    private void removeListener() {
        if (this.fieldSelectTableChange != null) {
            this.fieldSelectedGrid.removeKDTEditListener((KDTEditListener)this.fieldSelectTableChange);
        }
        if (this.dataTypeChangeListener != null) {
            this.cbxDataType.removeItemListener(this.dataTypeChangeListener);
        }
    }

    private void initListeners() {
        if (this.fieldSelectTableChange == null) {
            this.fieldSelectTableChange = new KDTEditAdapter(){

                public void editStopped(KDTEditEvent e) {
                    try {
                        AccountFieldSelectUI.this.fieldSelectTable_editStopped(e);
                    }
                    catch (Exception ex) {
                        AccountFieldSelectUI.this.handUIException(ex);
                    }
                }
            };
        }
        this.fieldSelectedGrid.addKDTEditListener((KDTEditListener)this.fieldSelectTableChange);
        if (this.dataTypeChangeListener == null) {
            this.dataTypeChangeListener = new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    AccountFieldSelectUI.this.dataTypeChanged(e);
                }
            };
        }
        this.cbxDataType.addItemListener(this.dataTypeChangeListener);
    }

    private void dataTypeChanged(ItemEvent e) {
        try {
            if (e.getStateChange() == 1) {
                this.initFields();
            }
        }
        catch (BOSException e1) {
            this.handleException((Exception)((Object)e1));
        }
    }

    protected void fieldSelectTable_editStopped(KDTEditEvent e) throws Exception {
    }

    private void initIsGroupControl() {
        KDCheckBox check = new KDCheckBox();
        this.isGroupListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                AccountFieldSelectUI.this.isGroupChanged(e.getStateChange() == 1);
            }
        };
        check.addItemListener(this.isGroupListener);
        this.fieldSelectedGrid.getColumn("isGroup").setEditor((ICellEditor)new KDTDefaultCellEditor((JCheckBox)check));
    }

    private void initIsSumControl() {
        KDCheckBox check = new KDCheckBox();
        this.isSumListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                AccountFieldSelectUI.this.isSumChanged(e.getStateChange() == 1);
            }
        };
        check.addItemListener(this.isSumListener);
        this.fieldSelectedGrid.getColumn("isSum").setEditor((ICellEditor)new KDTDefaultCellEditor((JCheckBox)check));
    }

    private void isGroupChanged(boolean selected) {
        int rowIndex = this.fieldSelectedGrid.getEditManager().getEditRowIndex();
        IRow row = this.fieldSelectedGrid.getRow(rowIndex);
        AccountFormulaUIHelper.tableCheckBoxValueChange(row, "isGroup", selected, this.isSumFormula);
    }

    private void isSumChanged(boolean selected) {
        int rowIndex = this.fieldSelectedGrid.getEditManager().getEditRowIndex();
        IRow row = this.fieldSelectedGrid.getRow(rowIndex);
        AccountFormulaUIHelper.tableCheckBoxValueChange(row, "isSum", selected, this.isSumFormula);
    }

    private void initParam() throws EASBizException, BOSException {
        this.configInfo = (AccountConfigInfo)this.getUIContext().get("configInfo");
        this.isSumFormula = (Boolean)this.getUIContext().get("isSumFormula");
        this.isColumnMatch = (Boolean)this.getUIContext().get("isColumnMatch");
        if (this.getUIContext().containsKey("enabledMultiSelection")) {
            this.enabledMultiSelection = (Boolean)this.getUIContext().get("enabledMultiSelection");
        }
        if (this.getUIContext().containsKey("isOnlySelected")) {
            this.isOnlySelected = (Boolean)this.getUIContext().get("isOnlySelected");
        }
        if (this.getUIContext().containsKey("isSumField")) {
            this.isSumField = (Boolean)this.getUIContext().get("isSumField");
        }
        this.setRptArrSelected((ArrayList)this.getUIContext().get("entryList"));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("entry.*");
        this.configInfo = AccountConfigFactory.getRemoteInstance().getAccountConfigInfo((IObjectPK)new ObjectUuidPK(this.configInfo.getId().toString()), sic);
    }

    private void initFields() throws BOSException {
        int i;
        this.getRptArr().clear();
        AccountConfigEntryCollection rptFieldsCL = this.configInfo.getEntry();
        AccountConfigEntryCollection rptFieldsCL2 = (AccountConfigEntryCollection)((Object)rptFieldsCL.clone());
        AccountConfigEntryInfo entryInfo = null;
        for (int i2 = 0; i2 < rptFieldsCL2.size(); ++i2) {
            entryInfo = rptFieldsCL2.get(i2);
            AccountFormulaUIHelper.entrySetFieldNull(entryInfo);
        }
        int iCount = this.getRptArrSelected().size();
        if (iCount > 0) {
            for (i = 0; i < iCount; ++i) {
                entryInfo = (AccountConfigEntryInfo)this.getRptArrSelected().get(i);
                if (!rptFieldsCL2.containsObject((IObjectValue)entryInfo)) continue;
                rptFieldsCL2.remove(entryInfo);
            }
            this.addArrayListToTable(this.getRptArrSelected(), this.fieldSelectedGrid);
        }
        for (i = 0; i < rptFieldsCL.size(); ++i) {
            entryInfo = rptFieldsCL.get(i);
            if (this.volidDataType(entryInfo)) continue;
            rptFieldsCL2.remove(entryInfo);
        }
        this.addCollectionToArrayList(this.getRptArr(), (IObjectCollection)rptFieldsCL2);
        Collections.sort(this.getRptArr());
        this.addArrayListToTable(this.getRptArr(), this.fieldGrid);
    }

    private boolean volidDataType(AccountConfigEntryInfo entryInfo) {
        if (this.cbxDataType.getSelectedItem() != null && !entryInfo.getDataType().equals((Object)((DataTypeEnum)((Object)this.cbxDataType.getSelectedItem())))) {
            return false;
        }
        return !this.isSumField || DataTypeEnum.Qty.equals((Object)entryInfo.getDataType()) || DataTypeEnum.Price.equals((Object)entryInfo.getDataType()) || DataTypeEnum.Amount.equals((Object)entryInfo.getDataType());
    }

    private void initControl() {
        this.fieldSelectedGrid.getColumn("isGroup").getStyleAttributes().setHided(!this.isSumFormula);
        this.fieldSelectedGrid.getColumn("isSum").getStyleAttributes().setHided(!this.isSumFormula);
        this.fieldSelectedGrid.getColumn("matchField").getStyleAttributes().setHided(!this.isColumnMatch);
        this.fieldSelectedGrid.getColumn("sortType").getStyleAttributes().setHided(this.isColumnMatch);
        KDComboBox enumEditor = new KDComboBox();
        enumEditor.addItem((Object)SortTypeEnum.NORMAL);
        enumEditor.addItem((Object)SortTypeEnum.ASC);
        enumEditor.addItem((Object)SortTypeEnum.DESC);
        this.fieldSelectedGrid.getColumn("sortType").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)enumEditor));
        this.initIsGroupControl();
        this.initIsSumControl();
        this.initDataTypeControl();
        if (this.isOnlySelected) {
            this.fieldSelectedGrid.getColumn("isGroup").getStyleAttributes().setHided(true);
            this.fieldSelectedGrid.getColumn("isSum").getStyleAttributes().setHided(true);
            this.fieldSelectedGrid.getColumn("matchField").getStyleAttributes().setHided(true);
            this.fieldSelectedGrid.getColumn("sortType").getStyleAttributes().setHided(true);
            this.fieldSelectedGrid.getColumn("isVisible").getStyleAttributes().setHided(true);
        }
    }

    private void initDataTypeControl() {
        this.cbxDataType.removeAllItems();
        this.cbxDataType.addItem((Object)new DataObject());
        List list = DataTypeEnum.getEnumList();
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            this.cbxDataType.addItem(list.get(i));
        }
    }

    private void addArrayListToTable(ArrayList rptArr, KDTable table) {
        table.checkParsed();
        table.removeRows();
        table.getStyleAttributes().setLocked(true);
        int count = rptArr.size();
        AccountConfigEntryInfo entryInfo = null;
        IRow r = null;
        for (int i = 0; i < count; ++i) {
            entryInfo = (AccountConfigEntryInfo)rptArr.get(i);
            r = table.addRow();
            if (table.getName() == this.fieldSelectedGrid.getName()) {
                AccountFormulaUIHelper.updateLineData(r, entryInfo, this.isSumFormula, this.isColumnMatch);
                continue;
            }
            r.getCell("name").setValue((Object)entryInfo.getAlias());
            r.getCell("dataType").setValue((Object)entryInfo.getDataType().getAlias());
            r.getCell("ID").setValue((Object)entryInfo.getId());
            r.getCell("OBJECT").setValue((Object)entryInfo);
        }
    }

    public ArrayList addCollectionToArrayList(ArrayList arr, IObjectCollection collection) {
        if (collection == null || collection.size() == 0) {
            return null;
        }
        int i = arr.size();
        Object obj2 = null;
        for (Object obj2 : collection) {
            if (obj2 != null) {
                arr.add(i, obj2);
                if (arr == this.rptArr) {
                    AccountFormulaUIHelper.entrySetFieldNull((AccountConfigEntryInfo)obj2);
                }
            }
            ++i;
        }
        return arr;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnAdd.setIcon(EASResource.getIcon((String)"imgTbtn_move_right"));
        this.btnReduce.setIcon(EASResource.getIcon((String)"imgTbtn_move_left"));
        this.btnAddAll.setIcon(EASResource.getIcon((String)"imgTbtn_moveall_right"));
        this.btnReduceAll.setIcon(EASResource.getIcon((String)"imgTbtn_moveall_left"));
        this.btnMoveUp.setIcon(EASResource.getIcon((String)"imgTbtn_movetop"));
        this.btnMoveDown.setIcon(EASResource.getIcon((String)"imgTbtn_movedown"));
        this.btnMoveTop.setIcon(EASResource.getIcon((String)"imgTbtn_movetop1"));
        this.btnMoveBottom.setIcon(EASResource.getIcon((String)"imgTbtn_movebottom"));
    }

    @Override
    public void actionAdd_actionPerformed(ActionEvent e) throws Exception {
        if (this.getRptArr().size() == 0) {
            return;
        }
        super.actionAdd_actionPerformed(e);
        AccountConfigEntryCollection rptFieldcol = this.getSelectedCollectionFromTable(this.fieldGrid);
        this.addCollectionToArrayList(this.getRptArrSelected(), (IObjectCollection)rptFieldcol);
        this.addArrayListToTable(this.getRptArrSelected(), this.fieldSelectedGrid);
        Collections.sort(this.getRptArr());
        this.addArrayListToTable(this.getRptArr(), this.fieldGrid);
    }

    private AccountConfigEntryCollection getSelectedCollectionFromTable(KDTable table) {
        AccountConfigEntryCollection rptFieldcol = null;
        int size = table.getSelectManager().size();
        for (int i = 0; i < size; ++i) {
            KDTSelectBlock sb = table.getSelectManager().get(i);
            int n = sb.getBottom();
            for (int j = sb.getTop(); j <= n; ++j) {
                AccountConfigEntryInfo rptInfo;
                if (rptFieldcol == null) {
                    rptFieldcol = new AccountConfigEntryCollection();
                }
                if (table.getName().equals(this.fieldSelectedGrid.getName())) {
                    rptInfo = AccountFormulaUIHelper.buildEntryInfo(table.getRow(j));
                    if (this.cbxDataType.getSelectedItem() != null && this.cbxDataType.getSelectedItem() instanceof DataTypeEnum && !rptInfo.getDataType().equals(this.cbxDataType.getSelectedItem())) {
                        this.getRptArrtemp(table).remove(rptInfo);
                        continue;
                    }
                } else {
                    rptInfo = (AccountConfigEntryInfo)table.getRow(j).getCell("OBJECT").getValue();
                }
                rptFieldcol.add(rptInfo);
                this.getRptArrtemp(table).remove(rptInfo);
            }
        }
        return rptFieldcol;
    }

    private ArrayList getRptArrtemp(KDTable table) {
        ArrayList rptArr = null;
        if (table.equals(this.fieldGrid)) {
            rptArr = this.getRptArr();
        } else if (table.equals(this.fieldSelectedGrid)) {
            rptArr = this.getRptArrSelected();
        }
        return rptArr;
    }

    @Override
    public void actionReduce_actionPerformed(ActionEvent e) throws Exception {
        super.actionReduce_actionPerformed(e);
        AccountConfigEntryCollection rptFieldcol = this.getSelectedCollectionFromTable(this.fieldSelectedGrid);
        this.addCollectionToArrayList(this.getRptArr(), (IObjectCollection)rptFieldcol);
        this.addArrayListToTable(this.getRptArrSelected(), this.fieldSelectedGrid);
        Collections.sort(this.getRptArr());
        this.addArrayListToTable(this.getRptArr(), this.fieldGrid);
    }

    @Override
    public void actionMoveUp_actionPerformed(ActionEvent e) throws Exception {
        super.actionMoveUp_actionPerformed(e);
        this.moveUp();
        IObjectCollection rptFieldcol = this.getCollectionFromTable(this.fieldSelectedGrid);
        this.addCollectionToArrayList(this.getRptArrSelected(), rptFieldcol);
    }

    private IObjectCollection getCollectionFromTable(KDTable table) {
        AccountConfigEntryCollection rptFieldcol = null;
        int size = table.getRowCount();
        for (int i = 0; i < size; ++i) {
            if (rptFieldcol == null) {
                rptFieldcol = new AccountConfigEntryCollection();
            }
            AccountConfigEntryInfo rptInfo = (AccountConfigEntryInfo)table.getRow(i).getCell("OBJECT").getValue();
            if (table.getName().equals(this.fieldSelectedGrid.getName()) && this.cbxDataType.getSelectedItem() != null && this.cbxDataType.getSelectedItem() instanceof DataTypeEnum && !rptInfo.getDataType().equals(this.cbxDataType.getSelectedItem())) {
                this.getRptArrtemp(table).remove(rptInfo);
                continue;
            }
            rptFieldcol.add(rptInfo);
            this.getRptArrtemp(table).remove(rptInfo);
        }
        return rptFieldcol;
    }

    @Override
    public void actionMoveDown_actionPerformed(ActionEvent e) throws Exception {
        super.actionMoveDown_actionPerformed(e);
        this.moveDown(null);
        IObjectCollection rptItemcol = this.getCollectionFromTable(this.fieldSelectedGrid);
        this.addCollectionToArrayList(this.getRptArrSelected(), rptItemcol);
    }

    @Override
    public void actionAddAll_actionPerformed(ActionEvent e) throws Exception {
        if (this.getRptArr().size() == 0) {
            return;
        }
        super.actionAddAll_actionPerformed(e);
        AccountFieldSelectUI.addArrayListToArrayList(this.getRptArrSelected(), this.getRptArr());
        this.getRptArr().clear();
        Collections.sort(this.getRptArrSelected());
        this.addArrayListToTable(this.getRptArrSelected(), this.fieldSelectedGrid);
        this.addArrayListToTable(this.getRptArr(), this.fieldGrid);
    }

    @Override
    public void actionReduceAll_actionPerformed(ActionEvent e) throws Exception {
        int iCount;
        super.actionReduceAll_actionPerformed(e);
        if (this.cbxDataType.getSelectedItem() != null && this.cbxDataType.getSelectedItem() instanceof DataTypeEnum && (iCount = this.getRptArrSelected().size()) > 0) {
            for (int i = 0; i < this.getRptArrSelected().size(); ++i) {
                AccountConfigEntryInfo entryInfo = (AccountConfigEntryInfo)this.getRptArrSelected().get(i);
                if (entryInfo.getDataType().equals(this.cbxDataType.getSelectedItem())) continue;
                this.getRptArrSelected().remove(entryInfo);
            }
        }
        AccountFieldSelectUI.addArrayListToArrayList(this.getRptArr(), this.getRptArrSelected());
        this.getRptArrSelected().clear();
        this.addArrayListToTable(this.getRptArrSelected(), this.fieldSelectedGrid);
        Collections.sort(this.getRptArr());
        this.addArrayListToTable(this.getRptArr(), this.fieldGrid);
    }

    public static ArrayList addArrayListToArrayList(ArrayList arrTo, ArrayList arrFrom) {
        if (arrFrom == null || arrFrom.size() == 0) {
            return null;
        }
        Object obj = null;
        int i = arrTo.size();
        int n = arrFrom.size();
        for (int j = 0; j < n; ++j) {
            obj = arrFrom.get(j);
            if (obj != null) {
                arrTo.add(i, obj);
            }
            ++i;
        }
        return arrTo;
    }

    @Override
    public void actionMoveTop_actionPerformed(ActionEvent e) throws Exception {
        super.actionMoveTop_actionPerformed(e);
        while (this.moveUp()) {
        }
        IObjectCollection rptItemcol = this.getCollectionFromTable(this.fieldSelectedGrid);
        this.addCollectionToArrayList(this.getRptArrSelected(), rptItemcol);
    }

    @Override
    public void actionMoveBottom_actionPerformed(ActionEvent e) throws Exception {
        super.actionMoveBottom_actionPerformed(e);
        while (this.moveDown("bottom")) {
        }
        this.rowsize = 0;
        IObjectCollection rptFieldcol = this.getCollectionFromTable(this.fieldSelectedGrid);
        this.addCollectionToArrayList(this.getRptArrSelected(), rptFieldcol);
    }

    protected boolean moveUp() {
        IRow[] rows = this.getTableSelection(this.fieldSelectedGrid);
        Arrays.sort(rows, new RowIdxComparer());
        if (rows.length > 0) {
            if (rows[0].getRowIndex() == 0) {
                return false;
            }
        } else {
            return false;
        }
        this.fieldSelectedGrid.getSelectManager().removeAll();
        boolean moved = false;
        for (int i = 0; i < rows.length; ++i) {
            IRow row = rows[i];
            int r = rows[i].getRowIndex();
            if (r == 0) break;
            moved = true;
            this.fieldSelectedGrid.removeRow(r);
            this.fieldSelectedGrid.addRow(r - 1, row);
            KDTSelectBlock sel = new KDTSelectBlock();
            sel.setTable(this.fieldSelectedGrid);
            sel.setTop(r - 1);
            sel.setBottom(r - 1);
            sel.setMode(2);
            this.fieldSelectedGrid.getSelectManager().add(sel);
        }
        if (moved) {
            this.fieldSelectedGrid.setRefresh(true);
        }
        return true;
    }

    protected boolean moveDown(String bottom) {
        IRow row;
        int r;
        int rowcount = this.fieldSelectedGrid.getRowCount();
        IRow[] rows = this.getTableSelection(this.fieldSelectedGrid);
        Arrays.sort(rows, new RowIdxComparer());
        if (rows.length > 0) {
            if ("bottom".equals(bottom)) {
                if (this.rowsize == 0) {
                    this.rowsize = rows.length;
                } else if (this.rowsize != rows.length) {
                    return false;
                }
            }
            if (rows[rows.length - 1].getRowIndex() == rowcount - 1) {
                return false;
            }
        } else {
            return false;
        }
        this.fieldSelectedGrid.getSelectManager().removeAll();
        boolean moved = false;
        for (int i = rows.length - 1; i >= 0 && (r = (row = rows[i]).getRowIndex()) != rowcount - 1; --i) {
            moved = true;
            this.fieldSelectedGrid.removeRow(r);
            this.fieldSelectedGrid.addRow(r + 1, row);
            KDTSelectBlock sel = new KDTSelectBlock();
            sel.setTable(this.fieldSelectedGrid);
            sel.setTop(r + 1);
            sel.setBottom(r + 1);
            sel.setMode(2);
            this.fieldSelectedGrid.getSelectManager().add(sel);
        }
        if (moved) {
            this.fieldSelectedGrid.setRefresh(true);
        }
        return true;
    }

    protected IRow[] getTableSelection(KDTable tbl) {
        ArrayList blocks = tbl.getSelectManager().getBlocks();
        ArrayList<IRow> rows = new ArrayList<IRow>();
        for (int i = 0; i < blocks.size(); ++i) {
            KDTSelectBlock block = (KDTSelectBlock)blocks.get(i);
            if (block.getMode() == 8) {
                for (int j = 0; j < tbl.getRowCount(); ++j) {
                    rows.add(tbl.getRow(j));
                }
                break;
            }
            int smallLine = block.getBeginRow() < block.getEndRow() ? block.getBeginRow() : block.getEndRow();
            int bigLine = block.getBeginRow() > block.getEndRow() ? block.getBeginRow() : block.getEndRow();
            for (int row = smallLine; row <= bigLine; ++row) {
                rows.add(tbl.getRow(row));
            }
        }
        return rows.toArray(new IRow[rows.size()]);
    }

    private void checkRequiredFields() {
        if (this.getRptArrSelected().size() == 0) {
            MsgBox.showInfo((String)"\u8bf7\u9009\u62e9\u5b57\u6bb5!");
            SysUtil.abort();
        }
        if (!this.hasVisibleFields()) {
            MsgBox.showInfo((String)"\u663e\u793a\u5217\u4e0d\u80fd\u4e3a\u7a7a!");
            SysUtil.abort();
        }
        if (!this.enabledMultiSelection && this.getRptArrSelected().size() > 1) {
            MsgBox.showInfo((String)TDUtils.getString("com.kingdee.eas.tm.td.structure.TaxStructureResource", "SelectOne", TDUtils.getLocale()));
            SysUtil.abort();
        }
    }

    public void storeSelectedFields() {
        ArrayList<AccountConfigEntryInfo> entryList = new ArrayList<AccountConfigEntryInfo>();
        for (int i = 0; i < this.fieldSelectedGrid.getRowCount(); ++i) {
            entryList.add(AccountFormulaUIHelper.buildEntryInfo(this.fieldSelectedGrid.getRow(i)));
        }
        this.setRptArrSelected(entryList);
    }

    private boolean hasVisibleFields() {
        AccountConfigEntryInfo entryInfo = null;
        for (int i = 0; i < this.getRptArrSelected().size(); ++i) {
            entryInfo = (AccountConfigEntryInfo)this.getRptArrSelected().get(i);
            if (!entryInfo.getIsVisible()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void actionOk_actionPerformed(ActionEvent e) throws Exception {
        this.storeSelectedFields();
        this.checkRequiredFields();
        this.isCanceled = false;
        this.getUIWindow().close();
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.isCanceled = true;
        this.getUIWindow().close();
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    public Map getData() {
        this.data = new HashMap();
        this.data.put("selected", this.getRptArrSelected());
        return this.data;
    }
}

