/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.client;

import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.bot.BOTMappingCollection;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.DefineSysEnum;
import com.kingdee.bos.metadata.bot.IBOTMapping;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.botp.BOTPException;
import com.kingdee.eas.base.botp.BotpHelper;
import com.kingdee.eas.base.botp.client.BOTMappingSelectUI;
import com.kingdee.eas.base.btp.client.BTPBillListImpl;
import com.kingdee.eas.base.dap.AbstractDAPVoucherStrategy;
import com.kingdee.eas.base.dap.DAPTransImpl;
import com.kingdee.eas.base.dap.DAPTransformResult;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ICoreBillBase;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.client.CoreBillEditUI;
import com.kingdee.eas.framework.client.CoreBillListUI;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.tm.td.TaxDraftConfirmBillFactory;
import com.kingdee.eas.tm.td.TaxDraftConfirmBillInfo;
import com.kingdee.util.LowTimer;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class TaxDraftListUIHelper {
    private static final Logger logger = CoreUIObject.getLogger((String)"com.kingdee.eas.tm.td.utils.DAPUIHelper");
    private TDDAPTransImpl dapTrans = null;
    private BTPBillListImpl billList = null;
    private CoreBillListUI listUI = null;
    private ListUI owner = null;

    public TaxDraftListUIHelper(ListUI owner) {
        try {
            this.owner = owner;
            this.listUI = new TDCoreBillListUI();
            this.dapTrans = new TDDAPTransImpl(this.listUI);
            this.billList = new BTPBillListImpl(this.listUI);
        }
        catch (Exception e) {
            logger.info((Object)e.getMessage());
        }
    }

    public void genVoucher(CoreBillBaseCollection sourceBillCollection) throws Exception {
        HashMap<String, CtrlUnitInfo> ctx = new HashMap<String, CtrlUnitInfo>();
        logger.error((Object)("[TaxDraftListUIHelper]sourceBillCollection:" + sourceBillCollection));
        TaxDraftConfirmBillInfo info = (TaxDraftConfirmBillInfo)sourceBillCollection.get(0);
        logger.error((Object)("[TaxDraftListUIHelper]info:" + info));
        ctx.put("TRANSMITCU", info.getCompanyOrgUnit().getCU());
        this.dapTrans.trans(sourceBillCollection, ctx);
    }

    public void delVoucher(ArrayList idList) throws Exception {
        this.dapTrans.delTrans(idList);
    }

    public TDDAPTransImpl getDapTrans() {
        return this.dapTrans;
    }

    public void setDapTrans(TDDAPTransImpl dapTrans) {
        this.dapTrans = dapTrans;
    }

    public BTPBillListImpl getBillList() {
        return this.billList;
    }

    public void setBillList(BTPBillListImpl billList) {
        this.billList = billList;
    }

    public CoreBillListUI getListUI() {
        return this.listUI;
    }

    public void setListUI(CoreBillListUI listUI) {
        this.listUI = listUI;
    }

    public ListUI getOwner() {
        return this.owner;
    }

    public void setOwner(ListUI owner) {
        this.owner = owner;
    }

    class TDDAPTransImpl
    extends DAPTransImpl {
        private IUIWindow mappingSelecteWindow;
        private LowTimer ts;
        private BOTMappingInfo selectedBotMappingInfo;
        private boolean isCancel;

        public TDDAPTransImpl(CoreBillListUI billList) {
            super(billList);
            this.mappingSelecteWindow = null;
            this.ts = new LowTimer();
            this.selectedBotMappingInfo = null;
            this.isCancel = false;
        }

        public TDDAPTransImpl(CoreBillEditUI billEdit) {
            super(billEdit);
            this.mappingSelecteWindow = null;
            this.ts = new LowTimer();
            this.selectedBotMappingInfo = null;
            this.isCancel = false;
        }

        public BOTMappingInfo getSelectedBotMappingInfo() {
            return this.selectedBotMappingInfo;
        }

        public void setSelectedBotMappingInfo(BOTMappingInfo selectedBotMappingInfo) {
            this.selectedBotMappingInfo = selectedBotMappingInfo;
        }

        public void trans(CoreBillBaseCollection sourceBillCollection) throws Exception {
            super.trans(sourceBillCollection);
        }

        public boolean isCancel() {
            return this.isCancel;
        }

        public void setCancel(boolean isCancel) {
            this.isCancel = isCancel;
        }

        public void voucherFinish() {
            this.setCancel(false);
            this.setSelectedBotMappingInfo(null);
        }

        protected Map beforeDAPTrans(CoreBillBaseCollection sourceBillCollection, Map ctx) throws Exception {
            HashMap<String, Object> params = new HashMap<String, Object>();
            IBOTMapping botMapping = BOTMappingFactory.getRemoteInstance();
            BOTMappingCollection botMappingCollection = null;
            CtrlUnitInfo transmitCU = null;
            if (ctx != null) {
                transmitCU = (CtrlUnitInfo)ctx.get("TRANSMITCU");
            } else {
                ctx = new HashMap<String, CtrlUnitInfo>();
            }
            if (this.billEdit != null) {
                transmitCU = this.billEdit.getCUForBOTP();
                ctx.put("TRANSMITCU", transmitCU);
            }
            if (transmitCU == null || !(transmitCU instanceof CtrlUnitInfo)) {
                if (this.billList != null) {
                    transmitCU = this.billList.getMainOrgInfo();
                } else if (this.billEdit != null) {
                    transmitCU = this.billEdit.getMainOrgInfo();
                }
                if (transmitCU != null) {
                    transmitCU = ((OrgUnitInfo)transmitCU).getCU();
                    ctx.put("TRANSMITCU", transmitCU);
                }
            }
            String sourceBillType = sourceBillCollection.getObject(0).getBOSType().toString();
            IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
            EntityObjectInfo entity = loader.getEntity(sourceBillCollection.getObject(0).getBOSType());
            int count = sourceBillCollection.size();
            String[] idList = new String[count];
            for (int i = 0; i < count; ++i) {
                idList[i] = sourceBillCollection.get(i).getId().toString();
            }
            String[] entrysName = new String[]{this.getBillMainEntryName(entity)};
            List entriesKey = this.getSelectEntryIDs(sourceBillCollection, entrysName[0]);
            SelectorItemCollection botpSelectors = null;
            RequestContext request = new RequestContext();
            request.setMethodName("beforeDAPTrans");
            request.put("DAPTransImpl_beforeDAPTrans_bostype", (Object)sourceBillType);
            request.put("DAPTransImpl_beforeDAPTrans_VOUCHERTYPE", (Object)"2652E01E");
            request.put("DAPTransImpl_beforeDAPTrans_transmitCU", ctx);
            request.put("DAPTransImpl_beforeDAPTrans_idList", (Object)idList);
            request.put("DAPTransImpl_beforeDAPTrans_entryNames", (Object)entrysName);
            request.put("DAPTransImpl_beforeDAPTrans_entriesKey", (Object)entriesKey);
            request.put("DAPTransImpl_beforeDAPTrans_botpSelectors", botpSelectors);
            this.prepareRPC(request).callHandler();
            botMappingCollection = botMapping.getMappingCollectionForSelectUseRuleFilter(sourceBillType, "2652E01E", DefineSysEnum.DAP, ctx, idList, entrysName, entriesKey, botpSelectors);
            IObjectPK[] sourceBillPkList = new IObjectPK[sourceBillCollection.size()];
            Iterator iter = sourceBillCollection.iterator();
            int index = 0;
            while (iter.hasNext()) {
                CoreBillBaseInfo sourceBillInfo = (CoreBillBaseInfo)iter.next();
                sourceBillPkList[index] = new ObjectUuidPK(sourceBillInfo.getId());
                ++index;
            }
            params.put("DAPTransImpl_param_srcBillIds", sourceBillPkList);
            BOTMappingCollection botMappingInfos = this.getSelectedDAPMappingInfo(botMappingCollection, sourceBillPkList);
            params.put("DAPTransImpl_param_mappings", botMappingInfos);
            ArrayList<SelectorItemCollection> botSelectorsList = new ArrayList<SelectorItemCollection>();
            if (null != botMappingInfos) {
                for (int i = 0; i < botMappingInfos.size(); ++i) {
                    SelectorItemCollection botSelectors = BotpHelper.getBOTPSelectors((BOTMappingInfo)botMappingInfos.get(i));
                    botSelectorsList.add(botSelectors);
                }
            }
            params.put("DAPTransImpl_param_selectors", botSelectorsList);
            logger.info((Object)("***DAPTransform, beforeDAPTrans=" + this.ts.msValue() + "ms"));
            return params;
        }

        private BOTMappingCollection getSelectedDAPMappingInfo(BOTMappingCollection botMappingCollection, IObjectPK[] sourceBillPkList) throws UIException, BOTPException {
            if (this.isCancel) {
                return null;
            }
            if (botMappingCollection.size() == 0) {
                throw new BOTPException(BOTPException.MAPPINGNUMZERO);
            }
            BOTMappingCollection botMappingInfos = null;
            if (botMappingCollection.size() > 1 && (this.billList != null && this.billList.isNeedShowBOTPRule() || this.billEdit != null && this.billEdit.isNeedShowBOTPRule())) {
                HashMap<String, Boolean> uiContext = new HashMap<String, Boolean>();
                uiContext.put("isMultiDAPTrans", false);
                if (this.billList != null) {
                    uiContext.put("Owner", (Boolean)this.billList);
                    if (this.billList.isSupportMultiDAP() && 1 == sourceBillPkList.length) {
                        uiContext.put("isMultiDAPTrans", true);
                    }
                } else {
                    uiContext.put("Owner", (Boolean)this.billEdit);
                    if (this.billEdit.isSupportMultiDAP() && 1 == sourceBillPkList.length) {
                        uiContext.put("isMultiDAPTrans", true);
                    }
                }
                uiContext.put("BOTMappings", (Boolean)botMappingCollection);
                IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
                this.mappingSelecteWindow = uiFactory.create("com.kingdee.eas.base.botp.client.BOTMappingSelectUI", uiContext, null);
                this.mappingSelecteWindow.show();
                if (((BOTMappingSelectUI)this.mappingSelecteWindow.getUIObject()).isCanceled() || ((BOTMappingSelectUI)this.mappingSelecteWindow.getUIObject()).getSelectBotMappingInfos() == null) {
                    this.isCancel = true;
                } else {
                    botMappingInfos = ((BOTMappingSelectUI)this.mappingSelecteWindow.getUIObject()).getSelectBotMappingInfos();
                }
            } else {
                botMappingInfos = botMappingCollection;
            }
            return botMappingInfos;
        }

        protected DAPTransformResult doDAPTrans(ICoreBillBase srcBillBase, Map params, String srcBosType) throws Exception {
            return super.doDAPTrans(srcBillBase, params, srcBosType);
        }

        protected void afterDAPTrans(String sourceBillType, BOTMappingInfo botMappingInfo, String[] idArray, DAPTransformResult transResult, boolean showMsg) throws Exception {
            AbstractObjectCollection voucherCols = null;
            BOTRelationCollection relationCollection = null;
            if (transResult != null && transResult.getVoucherCollection() != null) {
                voucherCols = (AbstractObjectCollection)transResult.getVoucherCollection();
                relationCollection = transResult.getRelationCollection();
            } else {
                relationCollection = this.getDAPRelationCollection(idArray);
                String strIdLists = StringUtils.arrayToString((Object[])idArray, (String)",");
                if (relationCollection.size() == 0) {
                    logger.error((Object)"afterDAPTrans ----------------------relationCollection.size() ==0");
                    logger.error((Object)("afterDAPTrans ----------------------" + strIdLists));
                    return;
                }
                voucherCols = AbstractDAPVoucherStrategy.getInstanceof((String)"fi").getVoucherCollection(relationCollection);
            }
            if (voucherCols == null || voucherCols.size() <= 0) {
                return;
            }
            if (this.billList != null) {
                this.billList.afterDAPTrans(botMappingInfo, relationCollection);
            } else if (this.billEdit != null) {
                this.billEdit.afterDAPTrans(botMappingInfo, relationCollection);
            }
        }
    }

    class TDCoreBillListUI
    extends CoreBillListUI {
        protected ICoreBase getBizInterface() throws Exception {
            return TaxDraftConfirmBillFactory.getRemoteInstance();
        }

        public boolean isNeedShowBOTPRule() {
            return true;
        }
    }
}

