/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.core.ICellDisplayProvider;
import com.kingdee.bos.ctrl.excel.core.IExtRender;
import com.kingdee.bos.ctrl.excel.core.KDSpread;
import com.kingdee.bos.ctrl.excel.impl.ActionManager;
import com.kingdee.bos.ctrl.excel.impl.ToolBarManager;
import com.kingdee.bos.ctrl.excel.impl.action.SpreadAction;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.event.BookChangeEvent;
import com.kingdee.bos.ctrl.excel.model.struct.validate.ValidationList;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.kscript.ParserException;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.uiframe.client.UIFactoryHelper;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.newrpt.DesignerResource;
import com.kingdee.eas.fi.newrpt.client.designer.IBookProvider;
import com.kingdee.eas.fi.newrpt.client.designer.IItemFormulaProvider;
import com.kingdee.eas.fi.newrpt.client.designer.IMenuStrategy;
import com.kingdee.eas.fi.newrpt.client.designer.SpreadManager;
import com.kingdee.eas.fi.newrpt.client.designer.TimeMark;
import com.kingdee.eas.fi.newrpt.client.designer.render.IRenderProvider;
import com.kingdee.eas.fi.newrpt.client.designer.render.SumRangeRender;
import com.kingdee.eas.fi.newrpt.client.progress.IProgressMonitor;
import com.kingdee.eas.fi.newrpt.client.progress.IRunnableWithProgress;
import com.kingdee.eas.fi.newrpt.client.progress.ProgressDialogHelper;
import com.kingdee.eas.fi.newrpt.client.progress.ProgressDialogNew;
import com.kingdee.eas.fi.newrpt.designer.IReportVariableProvider;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.fi.newrpt.report.VariablesHelper;
import com.kingdee.eas.fi.rpt.RptSheetParamInfo;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.fi.rpt.excelformula.ExcelFormulaPaserHelper;
import com.kingdee.eas.fi.rpt.excelformula.expr.BinaryOperationExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.BoolExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.Expression;
import com.kingdee.eas.fi.rpt.excelformula.expr.FunctionExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.IntExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.NumberExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.StringExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.UnaryOperationExpr;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBillBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.tm.td.DraftBillBuildCenter;
import com.kingdee.eas.tm.td.DraftStatusEnum;
import com.kingdee.eas.tm.td.RecordTypeEnum;
import com.kingdee.eas.tm.td.TDException;
import com.kingdee.eas.tm.td.TDFacadeFactory;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.TaxBaseBillInfo;
import com.kingdee.eas.tm.td.TaxDraftRecordFactory;
import com.kingdee.eas.tm.td.TaxDraftRecordInfo;
import com.kingdee.eas.tm.td.account.engine.model.AccountCalculatorParams;
import com.kingdee.eas.tm.td.account.engine.model.AccountCalculatorResult;
import com.kingdee.eas.tm.td.account.formula.AccountFormulaCalculateService;
import com.kingdee.eas.tm.td.basedata.AccountConfigEntryCollection;
import com.kingdee.eas.tm.td.basedata.AccountConfigEntryInfo;
import com.kingdee.eas.tm.td.basedata.AccountConfigInfo;
import com.kingdee.eas.tm.td.basedata.RptBillRangeEntryCollection;
import com.kingdee.eas.tm.td.basedata.RptBillRangeEntryInfo;
import com.kingdee.eas.tm.td.client.AbstractTaxDraftRptUI;
import com.kingdee.eas.tm.td.client.AccountFormulaUI;
import com.kingdee.eas.tm.td.client.TaxDraftReportMenu;
import com.kingdee.eas.tm.td.cloud.datamodel.check.ReportCheck;
import com.kingdee.eas.tm.td.cloud.datamodel.client.ItemFormulaFillEditUI;
import com.kingdee.eas.tm.td.cloud.datamodel.utils.CheckUtils;
import com.kingdee.eas.tm.td.common.TaxMsgBox;
import com.kingdee.eas.tm.td.est.RealEstateGroupInfo;
import com.kingdee.eas.tm.td.formula.relate.client.TaxFindLedger;
import com.kingdee.eas.tm.td.structure.client.ItemFormulaWizardUI;
import com.kingdee.eas.tm.td.structure.client.TaxReportItemFormulaEditUI;
import com.kingdee.eas.tm.td.structure.utils.RptTaxItemFormulaProvider;
import com.kingdee.eas.tm.td.utils.AccountTakeDataUtil;
import com.kingdee.eas.tm.td.utils.LogUtils;
import com.kingdee.eas.tm.td.utils.TaxDraftProvider;
import com.kingdee.eas.tm.td.utils.TaxDraftRptPropertyAdapter;
import com.kingdee.eas.tm.td.utils.TaxDraftVariableProvider;
import com.kingdee.eas.tm.td.utils.render.DefaultRenderProvider;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public abstract class TaxDraftRptUI
extends AbstractTaxDraftRptUI {
    private static final Logger logger = CoreUIObject.getLogger(TaxDraftRptUI.class);
    private static final String rsClass = "com.kingdee.eas.tm.td.TDResource";
    private TaxDraftRecordInfo editData = null;

    public TaxDraftRptUI() throws Exception {
        this.setMenuStrategy(this.getDraftMenuStrategy());
        this.setBookProvider(this.getDraftBookProvider());
        this.setVariableProvider(this.getDraftVariableProvider());
        this.setPropertyAdapter(this.getDraftPropertyAdapter());
        this.menuItemBatchFill.setVisible(false);
        this.menuItemImportG3.setVisible(false);
        this.menuItemExportG3.setVisible(false);
    }

    protected void initToolbar() {
        ToolBarManager toolBarManager = this.getSpreadManager().getSpreadContainer().getToolBarManager();
        this.actionSubmit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_submit"));
        toolBarManager.addFirstGroupItem((Action)((Object)this.actionSubmit), "common");
        this.actionSave.putValue("SmallIcon", (Object)EASResource.getIcon((String)"imgTbtn_save"));
        toolBarManager.addFirstGroupItem((Action)this.actionSave, "common");
        this.actionEdit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_edit"));
        toolBarManager.addFirstGroupItem((Action)((Object)this.actionEdit), "common");
        this.actionAddAccountFormula.putValue("AcceleratorKey", KeyStroke.getKeyStroke("F6"));
        this.actionCalculateSelectedSheet.putValue("SmallIcon", (Object)EASResource.getIcon((String)"imgTbtn_compute"));
        this.actionCalculate.putValue("SmallIcon", (Object)EASResource.getIcon((String)"imgTbtn_autocount"));
        this.actionReportCheck.putValue("SmallIcon", (Object)EASResource.getIcon((String)"imgTbtn_check"));
        ActionManager actions = this.getSpreadManager().getSpreadContainer().getActionManager();
        SpreadAction action = actions.getAction("SetCellDisplayMode");
        action.putValue("SmallIcon", (Object)EASResource.getIcon((String)"imgTbtn_showformula"));
        this.actionReportRound.putValue("SmallIcon", (Object)EASResource.getIcon((String)"imgTbtn_balancecheck"));
        this.actionSheetManager.putValue("SmallIcon", (Object)EASResource.getIcon((String)"imgTbtn_reportparameter"));
        Component[] comps = this.toolBar.getToolBarComponents();
        for (int i = 0; i < comps.length; ++i) {
            toolBarManager.addLastGroupItem(comps[i], "common");
        }
        this.toolBar = toolBarManager.getToolBar("common");
        this.toolBar.setIsControlByParent(false);
        this.toolBar.setTextIconDisStyle((short)2);
        this.toolBar.setPopupMenuShowable(true);
        this.getSpreadManager().setUserExtRender((IExtRender)SumRangeRender.getInstance());
    }

    public void onLoad() throws Exception {
        Object uiClassParam = this.getUIContext().get("UIClassParam");
        Object isSubmitObject = this.getUIContext().get("isSubmit");
        boolean isSubmit = false;
        if (isSubmitObject != null) {
            isSubmit = (Boolean)this.getUIContext().get("isSubmit");
        }
        if (uiClassParam != null) {
            String[] params = uiClassParam.toString().split("\\$");
            String ID = params[0];
            this.getUIContext().put("ID", ID);
        }
        super.onLoad();
        SpreadManager.registerRenderProvider((IRenderProvider)new DefaultRenderProvider());
        this.editData = (TaxDraftRecordInfo)this.getReportAdapter().getReportProperty("editData");
        if (this.editData.getId() != null && !TaxDraftRecordFactory.getRemoteInstance().exists((IObjectPK)new ObjectUuidPK(this.editData.getId().toString()))) {
            throw new EASBizException(EASBizException.CHECKEXIST);
        }
        this.initDraftConfirmData();
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            RecordTypeEnum recordType = this.editData.getRecordType();
            if (recordType.equals((Object)RecordTypeEnum.Account)) {
                this.accountTakeData();
            }
            this.addDraftConfirmSheet(false, true);
            if (isSubmit) {
                if (this.getBookProvider().getEditValue() != null && this.getBookProvider().getEditValue().get("id") != null && this.getUIContext().get("submitRecordID") != null) {
                    String onloadRecordID;
                    String submitRecordID = (String)this.getUIContext().get("submitRecordID");
                    if (!submitRecordID.equals(onloadRecordID = this.getBookProvider().getEditValue().get("id").toString())) {
                        this.actionSubmit_actionPerformed(null);
                    }
                } else {
                    this.actionSubmit_actionPerformed(null);
                }
            } else {
                this.actionSave_actionPerformed(null);
            }
        }
        this.initSheetSelected();
        this.btnEdit.setVisible(false);
        this.btnSubmit.setVisible(false);
        if (this.editData.getRecordType().equals((Object)RecordTypeEnum.Account)) {
            this.menuAccount.setVisible(true);
        } else {
            this.menuAccount.setVisible(false);
        }
        this.actionAddAccountFormula.setEnabled(true);
        this.actionModifyAccountFormula.setEnabled(true);
        this.initActions();
    }

    protected void initActions() {
        this.menuItemClearItemFormula.setCustomAction((Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TaxDraftRptUI.this.getBook().getActiveSelectionRange().clear(false, false, false, false, new String[]{"TAXITEM"});
            }
        });
        this.menuItemRightClearItemFormula.setCustomAction(this.menuItemClearItemFormula.getAction());
        this.itemTaxItemFormula.setCustomAction(this.menuItemTaxItemFormula.getAction());
        this.itemTaxItemFormula.setText("\u9879\u76ee\u516c\u5f0f...");
    }

    protected void initWorkButton() {
        if (this.getOprtState().equals(OprtState.VIEW)) {
            this.actionSubmit.setEnabled(false);
            this.actionSave.setEnabled(false);
            this.actionEdit.setEnabled(true);
            this.actionImport.setEnabled(false);
        } else {
            this.actionSubmit.setEnabled(true);
            this.actionSave.setEnabled(true);
            this.actionEdit.setEnabled(false);
            this.actionImport.setEnabled(true);
        }
    }

    private void initSheetSelected() {
        for (int i = 0; i < this.getBook().getSheetCount(); ++i) {
            this.getBook().getSheet(i).setSelected(false);
        }
        if (this.getBook().getActiveSheet() != null) {
            this.getBook().getActiveSheet().setSelected(true);
        }
    }

    private void initDraftConfirmData() {
        RptBillRangeEntryCollection entrys = DraftBillBuildCenter.getBillRangeEntry(this.editData);
        if (entrys == null) {
            return;
        }
        for (int i = 0; i < entrys.size(); ++i) {
            String bosType = entrys.get(i).getBillBosType();
            DraftBillBuildCenter.initDraftBillInfos(null, bosType);
        }
    }

    @Override
    public void actionAccountGetSQL_actionPerformed(ActionEvent e) throws Exception {
        AccountConfigInfo accountConfigInfo = this.editData.getRelateAccount();
        if (accountConfigInfo == null) {
            return;
        }
        UIContext uiContext = new UIContext();
        uiContext.put("recordInfo", this.editData);
        uiContext.put("accountId", accountConfigInfo.getId().toString());
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.tm.td.client.AccountSQLView", (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    protected abstract String getPermissionItem(String var1);

    @Override
    public void actionAccountTakeData_actionPerformed(ActionEvent e) throws Exception {
        ProgressDialogNew processDialog = ProgressDialogHelper.createProgressDialogNew((CoreUI)this, (boolean)true);
        processDialog.setBackgroundRunButtonEnabled(false);
        IRunnableWithProgress iRunnableWithProgress = new IRunnableWithProgress(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(IProgressMonitor monitor) {
                TimeMark mark = TaxDraftRptUI.this.getTimeMark();
                if (mark != null) {
                    mark.Start();
                }
                try {
                    monitor.beginTask(TDUtils.getString(TaxDraftRptUI.rsClass, "GetData_Start", TDUtils.getLocale()), -1);
                    monitor.setTaskName(TDUtils.getString(TaxDraftRptUI.rsClass, "GetData_Doing", TDUtils.getLocale()));
                    monitor.subTaskBegin(DesignerResource.getString((String)"prepareData"));
                    try {
                        TaxDraftRptUI.this.accountTakeData();
                    }
                    catch (Exception e) {
                        TaxDraftRptUI.this.handleException(e);
                    }
                    TaxDraftRptUI.this.initSheetSelectedWithValidate();
                    TaxDraftRptUI.this.getSpreadManager().getSpreadContainer().clearQueue();
                }
                finally {
                    monitor.subTaskBegin(TDUtils.getString(TaxDraftRptUI.rsClass, "GetData_Finish", TDUtils.getLocale()));
                    monitor.done();
                    if (mark != null) {
                        mark.Stop();
                    }
                }
            }
        };
        try {
            processDialog.run(false, true, iRunnableWithProgress, processDialog);
        }
        catch (Exception e1) {
            logger.error((Object)"Report GetData Progress Error", (Throwable)e1);
        }
    }

    protected void initSheetSelectedWithValidate() {
        for (int i = 0; i < this.getBook().getSheetCount(); ++i) {
            this.getBook().getSheet(i).setSelected(false);
            ValidationList list = this.getBook().getSheet(i).getValidations();
            int len = list.size();
            for (int j = 0; j < len; ++j) {
                list.getValidation(j).getMessagedValidate().setCellRangeList(true);
            }
        }
        this.getBook().getActiveSheet().setSelected(true);
    }

    private void accountTakeData() throws Exception {
        for (int i = 0; i < this.getBook().getSheetCount(); ++i) {
            this.getBook().getSheet(i).setSelected(false);
        }
        AccountConfigInfo accountConfigInfo = this.editData.getRelateAccount();
        if (accountConfigInfo == null) {
            return;
        }
        AccountCalculatorResult result = this.getAccountData(accountConfigInfo.getId().toString());
        if (result != null && StringUtils.isEmpty((String)result.getExceptionMessage())) {
            AccountTakeDataUtil.addAccountDataSheet(null, this.editData, this.getBook(), result);
            if (accountConfigInfo.isIsTotal()) {
                AccountTakeDataUtil.addAccountDataTotalSheet(null, this.editData, this.getBook(), result);
            }
            if (result.getSumRs() != null) {
                AccountTakeDataUtil.addAccountDataSumSheet(null, this.editData, this.getBook(), result);
            }
        } else if (result != null && !StringUtils.isEmpty((String)result.getExceptionMessage())) {
            Sheet rptSheet = new Sheet(this.getBook(), "Sheet1");
            this.getBook().addSheet(rptSheet);
            rptSheet.setSelected(false);
            this.getBook().setActiveSheet(rptSheet);
            this.actionSave_actionPerformed(null);
            MsgBox.showDetailAndOK((Component)((Object)this), (String)result.getExceptionMessage(), (String)result.getExceptionMessageDeatil(), (int)0);
            SysUtil.abort();
        }
    }

    public void onShow() {
        super.onShow();
        this.getSpreadManager().setItemFormulaShowModel(0);
        this.getSpreadManager().setItemFormulaProvider((IItemFormulaProvider)new RptTaxItemFormulaProvider());
        this.getSpreadManager().setItemFormulaEnable(false);
    }

    @Override
    public void actionInsertDraft_actionPerformed(ActionEvent e) throws Exception {
        this.addDraftConfirmSheet(true, false);
        this.initSheetSelected();
    }

    public String getUITitle() {
        if (this.editData == null) {
            return TDUtils.getString(rsClass, "TAX_DRAFT", TDUtils.getLocale());
        }
        RecordTypeEnum recordType = this.editData.getRecordType();
        RealEstateGroupInfo realEstateGroupInfo = this.editData.getBuildingTaxesGroup();
        String realEstateGroupName = "";
        if (realEstateGroupInfo != null) {
            realEstateGroupName = TDUtils.getString("com.kingdee.eas.tm.td.est.ESTResource", "RealEstateGroupLabel", TDUtils.getLocale()) + "\uff1a";
            realEstateGroupName = realEstateGroupName + realEstateGroupInfo.getName();
        }
        String reportTitle = "";
        if (this.editData.getTaxType() != null && "ZCyrvv6oAnPgU0ETqMCc49uK96Y=".equals(this.editData.getTaxType().getId().toString())) {
            String title = TDUtils.getString("com.kingdee.eas.tm.td.est.ESTResource", "RealEstateLand", TDUtils.getLocale());
            reportTitle = TDUtils.getString("com.kingdee.eas.tm.td.TDCommonResource", "ReportTitle", TDUtils.getLocale(), new Object[]{title + recordType.getAlias(), this.editData.getName(), this.editData.getCompanyOrgUnit().getName() + "  " + realEstateGroupName, this.editData.getRptPeriod().getNumber() + ""});
        } else {
            reportTitle = TDUtils.getString("com.kingdee.eas.tm.td.TDCommonResource", "ReportTitle", TDUtils.getLocale(), new Object[]{this.editData.getTaxType().getName() + recordType.getAlias(), this.editData.getName(), this.editData.getCompanyOrgUnit().getName() + "  " + realEstateGroupName, this.editData.getRptPeriod().getNumber() + ""});
        }
        return reportTitle;
    }

    private AccountCalculatorResult getAccountData(String accountId) {
        AccountCalculatorResult calculatorResult = null;
        AccountCalculatorParams params = new AccountCalculatorParams();
        params.setAccountID(accountId);
        params.setCompanyID(this.editData.getCompanyOrgUnit().getId().toString());
        params.setStartDate(this.editData.getStartDate());
        params.setEndDate(this.editData.getEndDate());
        if (this.editData.getRptPeriod() != null) {
            params.setPeriodID(this.editData.getRptPeriod().getId().toString());
        }
        params.setYear(this.editData.getYear());
        params.setPeriod(this.editData.getPeriod());
        if (this.editData.getRptPeriodFrom() != null) {
            params.put("periodFromID", this.editData.getRptPeriodFrom().getId().toString());
        }
        if (this.editData.getRptPeriodTo() != null) {
            params.put("periodToID", this.editData.getRptPeriodTo().getId().toString());
        }
        if (this.editData.getOrgTree() != null) {
            params.put("orgTreeID", this.editData.getOrgTree().getId().toString());
        }
        if (this.editData.getBuildingTaxesGroup() != null) {
            params.setGroupID(this.editData.getBuildingTaxesGroup().getId().toString());
        }
        AccountConfigEntryCollection accountConfigEntry = this.editData.getRelateAccount().getEntry();
        ArrayList<String> groupFields = new ArrayList<String>();
        ArrayList<String> sumFields = new ArrayList<String>();
        for (int i = 0; i < accountConfigEntry.size(); ++i) {
            AccountConfigEntryInfo entryInfo = accountConfigEntry.get(i);
            if (entryInfo.isIsGroup()) {
                groupFields.add(entryInfo.getName());
            }
            if (!entryInfo.isIsSum()) continue;
            sumFields.add(entryInfo.getName());
        }
        params.put("groupFields", groupFields);
        params.put("sumFields", sumFields);
        try {
            calculatorResult = TDFacadeFactory.getRemoteInstance().getAccountData(params);
        }
        catch (Exception e) {
            calculatorResult = new AccountCalculatorResult();
            String exceptionMessage = EASResource.getString((String)"com.kingdee.eas.tm.td.TaxDraftResource", (String)"AccountTakeDataFailure");
            String exceptionMessageDetail = EASResource.getString((String)"com.kingdee.eas.tm.td.TaxDraftResource", (String)"AccountTakeDataFailureDetail") + "\n" + e.getMessage();
            calculatorResult.setExceptionMessage(exceptionMessage);
            calculatorResult.setExceptionMessageDeatil(exceptionMessageDetail);
        }
        return calculatorResult;
    }

    private void addDraftConfirmSheet(boolean isActive, boolean isAddNew) {
        RptBillRangeEntryCollection billRangeEntrys = DraftBillBuildCenter.getBillRangeEntry(this.editData);
        if (billRangeEntrys == null) {
            if (!isAddNew) {
                MsgBox.showInfo((String)TDUtils.getString(rsClass, "INSERT_ERROR_NOBILLS", TDUtils.getLocale()));
            }
            return;
        }
        SpreadManager spreadManager = this.getSpreadManager();
        for (int k = 0; k < billRangeEntrys.size(); ++k) {
            RptBillRangeEntryInfo entry = billRangeEntrys.get(k);
            String bosType = entry.getBillBosType();
            String billName = entry.getBillName();
            Sheet exists = this.getBook().getSheet(billName);
            if (exists != null) continue;
            Sheet rptSheet = new Sheet(this.getBook(), billName);
            rptSheet.setUserObject("bosType", (Object)bosType);
            this.getBook().addSheet(rptSheet);
            rptSheet.setSelected(false);
            if (isActive) {
                this.getBook().setActiveSheet(rptSheet);
            }
            rptSheet.getRange(0, 0, rptSheet.getMaxRowIndex(), rptSheet.getMaxColIndex()).clear(true, true, false, true, new String[0]);
            int top = rptSheet.getActiveRow();
            int left = rptSheet.getActiveCol();
            DraftBillBuildCenter.initDraftBillInfos(null, bosType);
            List<DraftBillBuildCenter> fieldList = DraftBillBuildCenter.getFieldsList(bosType);
            int index = 0;
            for (int i = 0; i < fieldList.size(); ++i) {
                DraftBillBuildCenter info = fieldList.get(i);
                int valueRangeTop = top;
                if (info.getFieldName().equals("companyOrgUnit") && bosType.equals("ED4D060A")) continue;
                rptSheet.getRange(valueRangeTop, left + index).setValue(new Variant((Object)info.getFieldDisplayName()));
                rptSheet.getRange(valueRangeTop, left + index).setUserObject("fieldKey", (Object)info.getFieldName());
                if (info.getProperty() instanceof LinkPropertyInfo) {
                    StyleAttributes sa = Styles.getEmptySA();
                    sa.setNumberFormat("@");
                    rptSheet.getColRange(left + index, left + index).setStyle(sa, sa);
                }
                this.autoSetColWidth(spreadManager, rptSheet, valueRangeTop, left + index);
                ++index;
            }
            Range range = rptSheet.getRange(top, left);
            range.setUserObject("fieldsCount", (Object)fieldList.size());
        }
    }

    @Override
    public void actionSaveDraftBill_actionPerformed(ActionEvent e) throws Exception {
        this.checkPermission(this.editData.getCompanyOrgUnit().getId().toString(), this.getPermissionItem("confirmsave"));
        Object rptID = this.getReportAdapter().getReportProperty("Report.ID");
        String logDetailStr = this.editData.getTaxType().getName() + " " + this.editData.getRecordType().getAlias() + " " + this.editData.getNumber();
        IObjectPK logPk = LogUtils.beginLog(null, "saveConfirmBill", BOSObjectType.create((String)"2A607F02"), (IObjectPK)new ObjectUuidPK(this.editData.getId().toString()), logDetailStr, "taxdraftitem_comfire_save", "");
        DraftStatusEnum draftStatus = (DraftStatusEnum)((Object)this.getReportAdapter().getReportProperty("draftStatus"));
        if (draftStatus.getValue() == 3) {
            MsgBox.showInfo((String)TDUtils.getString(rsClass, "NOT_AUDIT", TDUtils.getLocale()));
            return;
        }
        RptBillRangeEntryCollection entrys = DraftBillBuildCenter.getBillRangeEntry(this.editData);
        if (entrys == null) {
            MsgBox.showInfo((String)TDUtils.getString(rsClass, "SAVE_ERROR_NOBILLS", TDUtils.getLocale()));
            return;
        }
        boolean isError = false;
        StringBuffer errorDetail = new StringBuffer();
        for (int k = 0; k < entrys.size(); ++k) {
            RptBillRangeEntryInfo entry = entrys.get(k);
            String billName = entry.getBillName();
            String billBosType = entry.getBillBosType();
            Sheet activeSheet = this.getBook().getSheet(billName);
            if (activeSheet == null) {
                errorDetail.append(TDUtils.getString(rsClass, "NOT_EXISTS_SHEET", TDUtils.getLocale(), new Object[]{billName})).append("\r\n");
                isError = true;
                continue;
            }
            int rowCount = activeSheet.getRows().getMaxIntMark() + 1;
            int colCount = activeSheet.getCols().getMaxIntMark() + 1;
            Point point = new Point(0, 0);
            int fieldsCount = 0;
            block3: for (int i = 0; i < rowCount; ++i) {
                for (int j = 0; j < colCount; ++j) {
                    Object userObject = activeSheet.getRange(i, j).getUserObject("fieldsCount");
                    if (userObject == null) continue;
                    point = new Point(j, i);
                    fieldsCount = (Integer)userObject;
                    break block3;
                }
            }
            CoreBaseCollection taxBills = new CoreBaseCollection();
            int rowIndex = point.y + 1;
            int colIndex = point.x;
            String fieldKey = null;
            Object fieldValue = null;
            DraftBillBuildCenter fieldsInfo = null;
            EntityObjectInfo entityInfo = DraftBillBuildCenter.getDrafteBillEntity(null, billBosType);
            for (int i = rowIndex; i < rowCount; ++i) {
                isError = false;
                TaxBaseBillInfo info = DraftBillBuildCenter.getTaxBillInfo(entityInfo);
                info.setRptId(rptID.toString());
                info.setTaxItemType(this.editData.getTaxType());
                info.setReport(this.editData);
                for (int j = colIndex; j < colIndex + fieldsCount; ++j) {
                    if (activeSheet.getRange(point.y, j).getUserObject("fieldKey") == null) continue;
                    fieldKey = activeSheet.getRange(point.y, j).getUserObject("fieldKey").toString();
                    fieldValue = null;
                    Object value = activeSheet.getRange(i, j).getValue().getValue();
                    fieldsInfo = (DraftBillBuildCenter)DraftBillBuildCenter.getFieldsMap(billBosType).get(fieldKey);
                    if (fieldsInfo == null) continue;
                    try {
                        if (value instanceof String) {
                            fieldValue = value.toString();
                        } else if (value instanceof GregorianCalendar) {
                            GregorianCalendar time = (GregorianCalendar)value;
                            fieldValue = time.getTime();
                        } else if (value instanceof Date) {
                            Date date = (Date)value;
                            fieldValue = date;
                        } else if (value instanceof BigDecimal) {
                            fieldValue = new BigDecimal(value.toString());
                        }
                        if ("companyOrgUnit".equals(fieldKey) && (fieldValue == null || fieldValue.toString().isEmpty())) {
                            isError = true;
                            break;
                        }
                        DraftBillBuildCenter.buildDraftBillInfo(fieldKey, fieldValue, (IObjectValue)info, fieldsInfo);
                        continue;
                    }
                    catch (Exception ex) {
                        isError = true;
                        errorDetail.append(DraftBillBuildCenter.buildErrorResult(i, fieldKey, fieldValue, fieldsInfo)).append("\r\n");
                    }
                }
                if (isError) continue;
                taxBills.add((CoreBaseInfo)info);
            }
            if (taxBills.size() <= 0) continue;
            this.saveTaxBills(billBosType, entityInfo, taxBills, errorDetail);
        }
        if (errorDetail.length() > 0) {
            String error = TDUtils.getString(rsClass, "draftSaveError", TDUtils.getLocale());
            MsgBox.showDetailAndOK((Component)((Object)this), (String)error, (String)errorDetail.toString(), (int)0);
            this.abort();
        } else {
            MsgBox.showInfo((String)TDUtils.getString(rsClass, "SAVE_SUCESS", TDUtils.getLocale()));
            LogUtils.afterLog(null, logPk);
        }
    }

    private boolean saveTaxBills(String bosType, EntityObjectInfo entityInfo, CoreBaseCollection taxBills, StringBuffer errorDetail) {
        try {
            String bizInterface = entityInfo.getBusinessInterface();
            ICoreBillBase iBillBase = (ICoreBillBase)BOSObjectFactory.createRemoteBOSObject((BOSObjectType)new BOSObjectType(bosType), Class.forName(bizInterface));
            iBillBase.save(taxBills);
        }
        catch (Exception e) {
            errorDetail.append(e.getMessage()).append("\r\n");
        }
        return true;
    }

    private void checkPermission(String orgId, String permissionItem) throws EASBizException, BOSException {
        TDFacadeFactory.getRemoteInstance().checkFunctionPermission(orgId, permissionItem);
    }

    @Override
    public void actionDelDraftBill_actionPerformed(ActionEvent e) throws Exception {
        Object rptID = this.getReportAdapter().getReportProperty("Report.ID");
        if (rptID == null) {
            return;
        }
        String logDetailStr = this.editData.getTaxType().getName() + " " + this.editData.getRecordType().getAlias() + " " + this.editData.getNumber();
        IObjectPK logPk = LogUtils.beginLog(null, "deleteConfirmBill", BOSObjectType.create((String)"2A607F02"), (IObjectPK)new ObjectUuidPK(this.editData.getId().toString()), logDetailStr, "taxdraftitem_comfire_delete", "");
        this.checkPermission(this.editData.getCompanyOrgUnit().getId().toString(), this.getPermissionItem("confirmdelete"));
        ObjectUuidPK pk = new ObjectUuidPK(rptID.toString());
        TaxDraftRecordInfo info = TaxDraftRecordFactory.getRemoteInstance().getTaxDraftRecordInfo((IObjectPK)pk);
        if (info.getDraftStatus().equals((Object)DraftStatusEnum.AUDIT)) {
            MsgBox.showInfo((String)TDUtils.getString(rsClass, "DEL_ERROR_ISAUDIT", TDUtils.getLocale()));
            SysUtil.abort();
        }
        FilterInfo filter = new FilterInfo();
        filter.appendFilterItem("rptId", (Object)rptID.toString());
        RptBillRangeEntryCollection entrys = DraftBillBuildCenter.getBillRangeEntry(this.editData);
        if (entrys == null) {
            MsgBox.showInfo((String)TDUtils.getString(rsClass, "DEL_ERROR_NOBILLS", TDUtils.getLocale()));
            return;
        }
        for (int i = 0; i < entrys.size(); ++i) {
            RptBillRangeEntryInfo entry = entrys.get(i);
            String billBosType = entry.getBillBosType();
            EntityObjectInfo entityInfo = DraftBillBuildCenter.getDrafteBillEntity(null, billBosType);
            String bizInterface = entityInfo.getBusinessInterface();
            ICoreBillBase iBillBase = (ICoreBillBase)BOSObjectFactory.createRemoteBOSObject((BOSObjectType)new BOSObjectType(billBosType), Class.forName(bizInterface));
            iBillBase.delete(filter);
        }
        MsgBox.showInfo((String)TDUtils.getString(rsClass, "DEL_SUCESS", TDUtils.getLocale()));
        LogUtils.afterLog(null, logPk);
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkPermission(this.editData.getCompanyOrgUnit().getId().toString(), this.getPermissionItem("edit"));
        DraftStatusEnum billStatus = this.editData.getDraftStatus();
        if (billStatus.equals((Object)DraftStatusEnum.AUDIT)) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.tm.td.TaxDraftResource", (String)"NOT_EDIT"));
            return;
        }
        String tempOprState = this.getOprtState();
        this.setOprtState("EDIT");
        try {
            this.setDataObject((IObjectValue)this.editData);
        }
        catch (Exception ex) {
            this.setOprtState(tempOprState);
            throw ex;
        }
        this.initWorkButton();
        if (this.editData.getDraftStatus() == DraftStatusEnum.SUBMIT) {
            this.actionSave.setEnabled(false);
        }
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        ReportCheck reportCheck;
        String[] htmls;
        this.checkPermission(this.editData.getCompanyOrgUnit().getId().toString(), this.getPermissionItem("submit"));
        this.verify(e);
        this.beforeSave();
        this.getBookProvider().restoreBook(this.getBook());
        Map promptMap = new HashMap();
        Map enableSubmitMap = new HashMap();
        Set checkIds = new HashSet();
        boolean isNeedAsk = false;
        String askMsg = null;
        String askDetailMsg = null;
        HashMap<String, CoreBaseInfo> values = new HashMap<String, CoreBaseInfo>();
        values.put(this.editData.getId().toString(), (CoreBaseInfo)this.getBookProvider().getEditValue());
        HashMap<String, Object> params = new HashMap<String, Object>();
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(this.editData.getId().toString());
        params.put("ids", ids);
        params.put("values", values);
        params.put("recordType", (Object)this.editData.getRecordType());
        Map ret = TaxDraftRecordFactory.getRemoteInstance().beforeSubmit(params);
        promptMap = (Map)ret.get("promptMap");
        checkIds = (Set)ret.get("checkIds");
        enableSubmitMap = (Map)ret.get("enableSubmitMap");
        promptMap = (Map)ret.get("promptMap");
        isNeedAsk = (Boolean)ret.get("isNeedAsk");
        askMsg = (String)ret.get("askMsg");
        askDetailMsg = (String)ret.get("askDetailMsg");
        if (isNeedAsk) {
            int result = TaxMsgBox.showReportConfirm4a(askMsg, askDetailMsg, null);
            if (result == 99) {
                htmls = null;
                if (ret != null && ret.get("checkResultMap") != null) {
                    reportCheck = new ReportCheck();
                    htmls = reportCheck.exportCheckResult(ret);
                }
                params = new HashMap();
                params.put("htmls", htmls);
                CheckUtils.showEditorPanel(params);
                SysUtil.abort();
            } else if (result != 0) {
                SysUtil.abort();
            }
        }
        try {
            if (!enableSubmitMap.containsKey(this.editData.getId().toString())) {
                throw new TDException(TDException.ERROR_MSG, new Object[]{promptMap.get(this.editData.getId().toString())});
            }
            boolean isSubmit2Cacl = TDUtils.getBooleanParam(null, this.editData.getCompanyOrgUnit().getId().toString(), "VATD004");
            if (isSubmit2Cacl) {
                this.actionCalculate_actionPerformed(e);
            }
            try {
                this.getSpreadManager().getSpreadContainer().getStateManager().stopAll();
            }
            catch (Exception e1) {
                System.out.println();
            }
            IObjectPK pk = this.getBookProvider().getBizInterface().submit((CoreBaseInfo)this.getBookProvider().getEditValue());
            this.getBookProvider().setEditValue(this.getBookProvider().queryEditData(pk));
            this.editData = (TaxDraftRecordInfo)this.getBookProvider().getEditValue();
            this.setBook(this.editData.getBook());
            this.getBookProvider().getEditValue().setBOSUuid(this.getBookProvider().getEditValue().getPKField(), BOSUuid.read((String)pk.toString()));
            if (!this.getUIContext().containsKey("SumRptProcessUI_isSumGrade")) {
                this.showSuccessMsg(EASResource.getString((String)"com.kingdee.eas.tm.td.TaxDraftResource", (String)"submitSuccess"));
                if (isSubmit2Cacl) {
                    this.getSpreadManager().getSpreadContainer().repaint();
                    this.getSpreadManager().getSpreadContainer().getSpread().repaint();
                }
            }
            this.getSpreadManager().getModifyManager().discardAllEdits();
            this.getSpreadManager().getSpreadContainer().getToolBarManager().changed(new BookChangeEvent(this.getBook().getActiveSheet(), "Sheet_Hide"));
            this.actionSave.setEnabled(false);
        }
        catch (EASBizException e1) {
            htmls = null;
            if (ret != null && ret.get("checkResultMap") != null) {
                reportCheck = new ReportCheck();
                htmls = reportCheck.exportCheckResult(ret);
            }
            if (htmls == null) {
                MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.tm.td.TaxDraftResource", (String)"submitFailure"), (String)e1.getMessage(), (int)1);
                SysUtil.abort();
            } else {
                int result = TaxMsgBox.showReportDetailAndOK((Component)((Object)this), EASResource.getString((String)"com.kingdee.eas.tm.td.TaxDraftResource", (String)"submitFailure"), e1.getMessage(), 8188, null);
                if (result == 99) {
                    params = new HashMap();
                    params.put("htmls", htmls);
                    CheckUtils.showEditorPanel(params);
                    SysUtil.abort();
                } else if (result != 0) {
                    SysUtil.abort();
                }
            }
            SysUtil.abort();
        }
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        this.verify(e);
        this.beforeSave();
        this.getBookProvider().restoreBook(this.getBook());
        try {
            try {
                this.getSpreadManager().getSpreadContainer().getStateManager().stopAll();
            }
            catch (Exception e1) {
                System.out.println();
            }
            IObjectPK pk = this.getBookProvider().getBizInterface().save((CoreBaseInfo)this.getBookProvider().getEditValue());
            this.getBookProvider().setEditValue(this.getBookProvider().queryEditData(pk));
            this.editData = (TaxDraftRecordInfo)this.getBookProvider().getEditValue();
            this.getBookProvider().getEditValue().setBOSUuid(this.getBookProvider().getEditValue().getPKField(), BOSUuid.read((String)pk.toString()));
            if (!this.getUIContext().containsKey("SumRptProcessUI_isSumGrade")) {
                this.showSuccessMsg(DesignerResource.getString((String)"saveOK"));
            }
            this.getSpreadManager().getModifyManager().discardAllEdits();
            this.getSpreadManager().getSpreadContainer().getToolBarManager().changed(new BookChangeEvent(this.getBook().getActiveSheet(), "Sheet_Hide"));
        }
        catch (EASBizException e1) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)DesignerResource.getString((String)"saveFail").replaceAll("\uff0c", ""), (String)e1.getMessage(), (int)0);
            SysUtil.abort();
        }
    }

    private void autoSetColWidth(SpreadManager spreadManager, Sheet sheet, int row, int col) {
        int w;
        if (spreadManager == null) {
            return;
        }
        KDSpread spread = spreadManager.getSpreadContainer().getSpread();
        Graphics2D g2d = (Graphics2D)spread.getGraphics();
        if (g2d == null) {
            return;
        }
        Cell cell = sheet.getCell(row, col, false);
        int width = sheet.getColRange(col, col).getColumnWidth();
        FontMetrics fm = g2d.getFontMetrics((Font)cell.getStyle().getKDFont());
        ICellDisplayProvider cvp = spread.getCellDisplayProvider();
        Object value = cvp.getBaseValue(cell, spread.getBook().getActiveSheet().getSheetOption().getCellDisplayMode());
        if (value instanceof String && ((w = fm.stringWidth((String)value)) > width || width - w < 12)) {
            width = w + 12;
        }
        if (width > 0) {
            sheet.getColRange(col, col).setColumnWidth(width + 8);
        }
    }

    public IMenuStrategy getDraftMenuStrategy() {
        return new TaxDraftReportMenu();
    }

    public IBookProvider getDraftBookProvider() {
        return new TaxDraftProvider();
    }

    public IReportVariableProvider getDraftVariableProvider() {
        return new TaxDraftVariableProvider();
    }

    private IReportPropertyAdapter getDraftPropertyAdapter() {
        return new TaxDraftRptPropertyAdapter();
    }

    public void actionFormulaFill_actionPerformed(ActionEvent e) throws Exception {
    }

    @Override
    public void actionItemBatchFill_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"rptTable", (Object)this.getBook().getActiveSheet());
        IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        IUIWindow window = uiFactory.create(ItemFormulaFillEditUI.class.getName(), (Map)uiContext, null, this.getOprtState());
        window.show();
        this.repaint();
    }

    protected void beforeCalculate() {
        boolean oldstate = this.getBook().isAutoCalculate();
        this.getBook().setCalculate(false);
        AccountFormulaCalculateService calculateService = new AccountFormulaCalculateService(null);
        Book book = this.getBook();
        TaxDraftRecordInfo reportInfo = this.editData;
        for (int i = 0; i < this.getBook().getSheetCount(); ++i) {
            if (!book.getSheet(i).isEnableCalculation()) continue;
            try {
                calculateService.calculateSheet(reportInfo, book.getSheet(i));
                continue;
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
        this.getSpreadManager().getSpreadContainer().repaint();
        this.getBook().setCalculate(oldstate);
    }

    @Override
    public void actionAddAccountFormula_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"rptSheet", (Object)this.getBook().getActiveSheet());
        uiContext.put((Object)"spreadManager", (Object)this.getSpreadManager());
        uiContext.put((Object)"editData", (Object)this.getBookProvider().getEditValue());
        IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        IUIWindow window = uiFactory.create(AccountFormulaUI.class.getName(), (Map)uiContext, null, this.getOprtState());
        window.show();
    }

    @Override
    public void actionTaxItemFormula_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"rptSheet", (Object)this.getBook().getActiveSheet());
        uiContext.put((Object)"spreadManager", (Object)this.getSpreadManager());
        uiContext.put((Object)"editData", (Object)this.getBookProvider().getEditValue());
        IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        IUIWindow window = uiFactory.create(ItemFormulaWizardUI.class.getName(), (Map)uiContext, null, this.getOprtState());
        window.show();
    }

    @Override
    public void actionTaxReportItemFormulaFill_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"rptSheet", (Object)this.getBook().getActiveSheet());
        uiContext.put((Object)"spreadManager", (Object)this.getSpreadManager());
        uiContext.put((Object)"editData", (Object)this.getBookProvider().getEditValue());
        IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        IUIWindow window = uiFactory.create(TaxReportItemFormulaEditUI.class.getName(), (Map)uiContext, null, this.getOprtState());
        window.show();
    }

    @Override
    public void actionRelateCell_actionPerformed(ActionEvent e) throws Exception {
        List expresions = this.getCurrCellexpresion();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"expressions", (Object)expresions);
        uiContext.put((Object)"report", (Object)this.getBookProvider().getEditValue());
        uiContext.put((Object)"superParent", this.getUIContext().get("superParent"));
        uiContext.put((Object)"rptSheetParam", (Object)this.getSheetParamInfo());
        uiContext.put((Object)"type", (Object)"3");
        Frame ownerWindow = UIFactoryHelper.getMainFrame((Map)this.getUIContext());
        if (ownerWindow != null) {
            uiContext.put((Object)"OwnerWindow", (Object)UIFactoryHelper.getMainFrame((Map)this.getUIContext()));
        }
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(TaxFindLedger.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        if (expresions != null && expresions.size() > 1) {
            uiWindow.show();
        }
    }

    private RptSheetParamInfo getSheetParamInfo() {
        return VariablesHelper.variables2SheetParams((ReportVariables)this.getVariables(), (String)this.getBook().getActiveSheet().getSheetName(), (boolean)true, null);
    }

    protected List getCurrCellexpresion() {
        Range cell = this.getBook().getActiveCellRange();
        Sheet currTable = this.getBook().getActiveSheet();
        ReportVariables reportVariables = this.getVariables();
        String expression = cell.getFormula();
        if (expression == null || expression.trim().length() == 0) {
            MsgBox.showInfo((String)RptUtil.getResourceSince51((String)"CellNotExistsFormula"));
            SysUtil.abort();
        }
        try {
            Expression expr = ExcelFormulaPaserHelper.parse((String)expression);
            TaxDraftRptUI.calculateFunctionParameter(expr, this.getBook().getActiveSheet());
            StringBuffer buffer = new StringBuffer();
            expr.output(buffer);
            expression = expression.trim().startsWith("=") ? "=" + buffer.toString() : buffer.toString();
        }
        catch (Exception expr) {
            // empty catch block
        }
        List formulaList = null;
        try {
            formulaList = TableToolkit.parseExcelFormula((String)expression, (boolean)true);
        }
        catch (ParserException e) {
            MsgBox.showInfo((String)RptUtil.getResourceSince51((String)"FormulaError"));
            SysUtil.abort();
        }
        if (formulaList == null || formulaList.size() == 0) {
            MsgBox.showInfo((String)RptUtil.getResourceSince51((String)"PleaseChooseFormula2"));
            SysUtil.abort();
        }
        return formulaList;
    }

    private static void calculateFunctionParameter(Expression expr, Sheet sheet) throws Exception {
        if (expr instanceof FunctionExpr) {
            List ps = ((FunctionExpr)expr).parameters;
            ArrayList<Object> ps2 = new ArrayList<Object>(ps.size());
            for (int i = 0; i < ps.size(); ++i) {
                Expression pa = (Expression)ps.get(i);
                if (pa instanceof StringExpr || pa instanceof NumberExpr || pa instanceof BoolExpr || pa instanceof IntExpr) {
                    ps2.add(pa);
                    continue;
                }
                String param = pa.toString();
                sheet.getBook().resumeUnknownMethod();
                Variant variant = sheet.calcFormula("=" + param);
                if (variant.isNumber()) {
                    ps2.add(new NumberExpr(variant.toBigDecimal()));
                    continue;
                }
                if (variant.isString()) {
                    ps2.add(new StringExpr(variant.toString()));
                    continue;
                }
                if (variant.isNumeric()) {
                    ps2.add(new NumberExpr(variant.toBigDecimal()));
                    continue;
                }
                if (variant.isNull() || variant.isEmpty()) {
                    ps2.add(new StringExpr(""));
                    continue;
                }
                ps2.add(new StringExpr(variant.toString()));
            }
            ((FunctionExpr)expr).parameters = ps2;
        } else if (expr instanceof BinaryOperationExpr) {
            BinaryOperationExpr bin = (BinaryOperationExpr)expr;
            TaxDraftRptUI.calculateFunctionParameter(bin.left, sheet);
            TaxDraftRptUI.calculateFunctionParameter(bin.right, sheet);
        } else if (expr instanceof UnaryOperationExpr) {
            TaxDraftRptUI.calculateFunctionParameter(((UnaryOperationExpr)expr).operand, sheet);
        }
    }

    public boolean isRefreshParent() {
        return true;
    }
}

