/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.ActivityInstInfo;
import com.kingdee.bos.workflow.AssignmentInfo;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.biz.trans.WfSendingMsgBundle;
import com.kingdee.bos.workflow.define.ActivityDef;
import com.kingdee.bos.workflow.define.extended.ApproveActivityDef;
import com.kingdee.bos.workflow.monitor.client.BasicWorkFlowMonitorPanel;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.base.multiapprove.client.DesignateNextActivityPerformerUI;
import com.kingdee.eas.base.multiapprove.client.MultiApproveUtil;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.uiframe.client.UIModelDialogFactory;
import com.kingdee.eas.basedata.common.perf.CreateJobFacadeFactory;
import com.kingdee.eas.basedata.common.perf.JobConfig;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.newrpt.RptNewUIUtil;
import com.kingdee.eas.fi.newrpt.client.rptnewui.rptprop.OrgNodeUserDefineInfo;
import com.kingdee.eas.fi.rpt.IReport;
import com.kingdee.eas.fi.rpt.ReportFactory;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ITreeBase;
import com.kingdee.eas.framework.client.FrameWorkClientUtils;
import com.kingdee.eas.framework.client.ITableLocate;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.framework.client.workflow.WfClientUtils;
import com.kingdee.eas.framework.client.workflow.WorkflowSendMsgUI;
import com.kingdee.eas.framework.query.QuickFilteringSupportItems;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.tm.td.ITaxDraftCalculateFacade;
import com.kingdee.eas.tm.td.TDFacadeFactory;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.TaxDraftCalculateFacadeFactory;
import com.kingdee.eas.tm.td.TaxOtherReportCollection;
import com.kingdee.eas.tm.td.TaxOtherReportFactory;
import com.kingdee.eas.tm.td.TaxOtherReportInfo;
import com.kingdee.eas.tm.td.TaxReportStatusEnum;
import com.kingdee.eas.tm.td.basedata.TaxReportTypeInfo;
import com.kingdee.eas.tm.td.client.AbstractTaxOtherReportListUI;
import com.kingdee.eas.tm.td.client.TaxDraftListUIHelper;
import com.kingdee.eas.tm.td.client.TaxOtherReportEditUI;
import com.kingdee.eas.tm.td.client.TaxOtherReportRptUI;
import com.kingdee.eas.tm.td.client.TaxOtherReportUIHelper;
import com.kingdee.eas.tm.td.cloud.TDCloudFacadeFactory;
import com.kingdee.eas.tm.td.cloud.utils.TDCloudUtil;
import com.kingdee.eas.tm.td.utils.LogUtils;
import com.kingdee.eas.tm.td.utils.OrgTreeBuilder;
import com.kingdee.eas.tm.td.utils.TDSelectorFactory;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

public class TaxOtherReportListUI
extends AbstractTaxOtherReportListUI {
    private static final Logger logger = CoreUIObject.getLogger(TaxOtherReportListUI.class);
    private OrgTreeBuilder builder = null;
    Map<String, OrgNodeUserDefineInfo> _OrgNodeMap = null;
    private ITableLocate locate = null;
    private TaxDraftListUIHelper uiHelper = null;
    private DataChangeListener reportTypeChangeListener = null;
    private QuickFilteringSupportItems qfsi = new QuickFilteringSupportItems(true, true);

    public TaxOtherReportListUI() throws Exception {
        this.uiHelper = new TaxDraftListUIHelper((ListUI)this);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initControl();
        this.setDefaultValue();
    }

    protected void initListener() {
        super.initListener();
        this.reportTypeChangeListener = new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                if (TDCloudUtil.isEqual(e.getNewValue(), e.getOldValue())) {
                    return;
                }
                try {
                    TaxOtherReportListUI.this.reportType_dataChanged(e);
                }
                catch (Exception e1) {
                    TaxOtherReportListUI.this.handleException(e1);
                }
            }
        };
        this.prmtReportType.addDataChangeListener(this.reportTypeChangeListener);
    }

    protected void reportType_dataChanged(DataChangeEvent e) throws Exception {
        this.prmtReportType.removeDataChangeListener(this.reportTypeChangeListener);
        this.treeMain_valueChanged(null);
        this.prmtReportType.addDataChangeListener(this.reportTypeChangeListener);
    }

    private void initControl() {
        this.treeView.setShowControlPanel(true);
        this.treeView.setShowButton(true);
        this.btnWorkFlowG.addAssistMenuItem((JMenuItem)TDUtils.cloneMenuItem(this.menuItemViewDoProccess));
        this.btnWorkFlowG.addAssistMenuItem((JMenuItem)TDUtils.cloneMenuItem(this.menuItemMultiapprove));
        this.btnWorkFlowG.addAssistMenuItem((JMenuItem)TDUtils.cloneMenuItem(this.menuItemWorkFlowList));
        this.btnWorkFlowG.addAssistMenuItem((JMenuItem)TDUtils.cloneMenuItem(this.menuItemNextPerson));
        this.btnWorkFlowG.addAssistMenuItem((JMenuItem)TDUtils.cloneMenuItem(this.menuItemAuditResult));
        this.btnExportReport.addAssistMenuItem((Action)((Object)this.actionImportReport));
        this.chkIncludeChild.setVisible(false);
        this.btnMoveTree.setVisible(false);
        this.menuItemGroupAddNew.setVisible(false);
        this.menuItemGroupEdit.setVisible(false);
        this.menuItemGroupMoveTree.setVisible(false);
        this.menuItemGroupRemove.setVisible(false);
        this.menuItemGroupView.setVisible(false);
        this.menuItemMoveTree.setVisible(false);
    }

    protected void initGroupButton() {
    }

    private void setDefaultValue() throws Exception {
        this.builder.selectedOrgNodeByGivenCompany(null);
        this.treeMain_valueChanged(null);
    }

    protected QuickFilteringSupportItems getQuickFilteringSupport() {
        return this.qfsi;
    }

    protected void initTree() throws Exception {
        this.treeView.setShowControlPanel(false);
        KDTreeNode treeNodeRoot = new KDTreeNode((Object)OrgType.Company);
        treeNodeRoot.removeAllChildren();
        this.treeMain.setModel((TreeModel)new KingdeeTreeModel((TreeNode)treeNodeRoot));
        this._OrgNodeMap = RptNewUIUtil.getAuthorizedOrg((IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString()), (String[])new String[]{"td_taxotherreport_view"}, (OrgType)this.getOrgType());
        this.builder = new OrgTreeBuilder(this.treeMain, treeNodeRoot, this._OrgNodeMap);
        this.builder.initOrgTree();
        this.builder.buildOrgTree();
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        if (this.locate != null) {
            this.locate.stopLocate();
        }
        this.locate = this.getTableLocate();
        this.treeMain_valueChanged(null);
        if (this.locate != null) {
            this.locate.locate();
        }
    }

    protected void treeMain_valueChanged(TreeSelectionEvent e) throws Exception {
        try {
            this.mainQuery = new EntityViewInfo();
            this.mainQuery.setFilter(new FilterInfo());
            this.mainQuery.getFilter().mergeFilter(this.getDefaultFilterForQuery(), "AND");
            this.mainQuery.getFilter().mergeFilter(this.getSelectedNodeFilterForQuery(), "AND");
            this.mainQuery.getFilter().mergeFilter(this.getDialogViewFilterForQuery(), "AND");
            this.mainQuery.getFilter().mergeFilter(this.getBodyFilterForQuery(), "AND");
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
        this.tblMain.repaint();
        this.tblMain.removeRows();
    }

    protected FilterInfo getBodyFilterForQuery() {
        FilterInfo filterInfo = new FilterInfo();
        if (this.prmtReportType.getValue() != null) {
            TaxReportTypeInfo reportType = (TaxReportTypeInfo)this.prmtReportType.getValue();
            filterInfo.appendFilterItem("reportType.id", (Object)reportType.getId().toString());
        }
        return filterInfo;
    }

    protected FilterInfo getSelectedNodeFilterForQuery() {
        FilterInfo filterInfo = new FilterInfo();
        if (this.getSelectedNodeKeyValue() != null) {
            filterInfo.appendFilterItem("companyOrgUnit.id", (Object)this.getSelectedNodeKeyValue());
        }
        return filterInfo;
    }

    protected FilterInfo getDialogViewFilterForQuery() throws BOSException {
        FilterInfo filterInfo = new FilterInfo();
        if (this.getDialog().getEntityViewInfoResult() != null) {
            filterInfo = this.getDialog().getCommonFilter();
        }
        return filterInfo;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        HashSet<String> orgSet = new HashSet<String>();
        OrgNodeUserDefineInfo orgNode2 = null;
        if (this._OrgNodeMap == null) {
            return null;
        }
        for (OrgNodeUserDefineInfo orgNode2 : this._OrgNodeMap.values()) {
            orgSet.add(orgNode2.getOrgPK());
        }
        if (orgSet.size() == 0) {
            orgSet.add("1111111111111111111");
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", orgSet, CompareType.INCLUDE));
        return filter;
    }

    protected KDTable getDetailTable() {
        return this.tblMain;
    }

    protected OrgType getOrgType() {
        return OrgType.Company;
    }

    protected String getEditUIName() {
        return TaxOtherReportRptUI.class.getName();
    }

    protected String getSelectedNodeKeyValue() {
        KDTreeNode treeNode = this.getSelectedTreeNode();
        String orgId = "";
        if (treeNode != null && !treeNode.getUserObject().toString().equals(OrgType.Company.getAlias())) {
            OrgNodeUserDefineInfo orgInfo = (OrgNodeUserDefineInfo)treeNode.getUserObject();
            orgId = orgInfo.getOrgPK();
            return orgId;
        }
        return null;
    }

    protected IObjectPK getSelectedTreeKeyValue() {
        return null;
    }

    protected String getGroupEditUIName() {
        return null;
    }

    protected String getQueryFieldName() {
        return "companyOrgUnit.id";
    }

    protected ITreeBase getTreeInterface() throws Exception {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return TaxOtherReportFactory.getRemoteInstance();
    }

    protected String getEditHeadUIName() {
        return TaxOtherReportEditUI.class.getName();
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        if (this.getSelectedTreeNode() == null || this.getSelectedTreeNode().getUserObject().equals(OrgType.Company)) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.tm.td.TaxDraftResource", (String)"addNewNoRoot"));
            return;
        }
        OrgNodeUserDefineInfo defineInfo = (OrgNodeUserDefineInfo)this.getSelectedTreeNode().getUserObject();
        String companyId = defineInfo.getOrgPK();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("accountPeriodType.*"));
        CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId), sic);
        uiContext.put((Object)"company", (Object)company);
        IUIWindow w = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(this.getEditHeadUIName(), (Map)uiContext, null, OprtState.ADDNEW);
        w.show();
        this.actionRefresh_actionPerformed(e);
    }

    @Override
    public void actionEditHead_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String billID = this.getSelectedKeyValue();
        TaxOtherReportInfo info = TaxOtherReportFactory.getRemoteInstance().getTaxOtherReportInfo((IObjectPK)new ObjectUuidPK(billID), this.getSelectors());
        String orgId = info.getCompanyOrgUnit().getId().toString();
        TDFacadeFactory.getRemoteInstance().checkFunctionPermission(orgId, "td_taxotherreport_update");
        if (info.getState().getValue() == TaxReportStatusEnum.AUDIT.getValue()) {
            MsgBox.showWarning((String)TDUtils.getString("com.kingdee.eas.tm.td.TaxOtherReportResource", "AUDIT_NOTEDIT", null));
            SysUtil.abort();
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)billID);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(this.getEditHeadUIName(), (Map)uiContext, null, OprtState.EDIT);
        uiWindow.show();
        this.actionRefresh_actionPerformed(e);
    }

    @Override
    public void actionSumbit_actionPerformed(ActionEvent e) throws Exception {
        this.batchOperation("submit");
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        this.batchOperation("audit");
    }

    @Override
    public void actionUnAudit_actionPerformed(ActionEvent e) throws Exception {
        this.batchOperation("unAudit");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void batchOperation(String method) throws Exception {
        int failedLock;
        this.checkSelected();
        ArrayList list = this.getSelectedIdValues();
        Map numMap = this.getSelectedIdNumber();
        String[] idArray = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            idArray[i] = (String)list.get(i);
        }
        if (SCMClientUtils.checkAllBizObjInWfProcess((String[])idArray)) {
            this.actionMultiapprove_actionPerformed(null);
            this.actionRefresh_actionPerformed(null);
            return;
        }
        if (list.isEmpty()) {
            return;
        }
        IMutexServiceControl mutexServiceControl = FrameWorkClientUtils.createMutexServiceControl();
        int total = list.size();
        int failed = 0;
        String msg = null;
        ArrayList<String> errorMsg = new ArrayList<String>();
        try {
            Map result;
            Map map = mutexServiceControl.batchRequestObjIDForUpdate((List)list);
            Set idSet = map.keySet();
            ArrayList<String> lockIdList = new ArrayList<String>();
            failedLock = 0;
            for (Object id : idSet) {
                if (!((Boolean)map.get(id)).booleanValue()) {
                    errorMsg.add(numMap.get(id) + ":" + EASResource.getString((String)"com.kingdee.eas.scm.common.ActionResource.ERROR_MUTEX"));
                    ++failedLock;
                    continue;
                }
                lockIdList.add((String)id);
            }
            if (lockIdList.size() > 0 && !"0".equals((result = TDCloudFacadeFactory.getRemoteInstance().batchOperation("B4FE5E14", method, lockIdList.toArray(new String[lockIdList.size()]))).get("ERROR_COUNT"))) {
                for (Object cause : result.keySet()) {
                    if ("ERROR_COUNT".equals(cause.toString())) {
                        failed = Integer.parseInt(result.get(cause).toString());
                        continue;
                    }
                    errorMsg.add(numMap.get(cause.toString()) + ":" + result.get(cause).toString() + "\r\n");
                }
            }
        }
        finally {
            mutexServiceControl.batchReleaseObjIDForUpdate((List)list);
        }
        if ((failed += failedLock) > 0) {
            msg = TDUtils.getString("com.kingdee.eas.tm.td.TaxOtherReportResource", "BATCHRESULT", null, new Object[]{total, total - failed, failed});
            MsgBox.showDetailAndOK((Component)((Object)this), (String)msg, (String)TDUtils.buildErrorMsg(errorMsg), (int)1);
        }
        this.actionRefresh_actionPerformed(null);
    }

    @Override
    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String billID = this.getSelectedKeyValue();
        TaxOtherReportInfo info = TaxOtherReportFactory.getRemoteInstance().getTaxOtherReportInfo((IObjectPK)new ObjectUuidPK(billID), TDSelectorFactory.getTaxOtherReportSelectors());
        this.setFieldsNull((AbstractObjectValue)info);
        UIContext uiContext = new UIContext();
        uiContext.put((Object)"InitDataObject", (Object)info);
        IUIWindow w = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(this.getEditHeadUIName(), (Map)uiContext, null, OprtState.COPYADDNEW);
        w.show();
        this.actionRefresh_actionPerformed(e);
    }

    protected void setFieldsNull(AbstractObjectValue newData) {
        TaxOtherReportUIHelper.setFieldNull((TaxOtherReportInfo)newData);
    }

    protected void afterTableFillData(KDTDataRequestEvent e) {
        super.afterTableFillData(e);
        int firstIndex = e.getFirstRow();
        int lastIndex = e.getLastRow();
        for (int r = firstIndex; r <= lastIndex; ++r) {
            if (this.tblMain.getCell(r, "rptPeriodFrom.number").getValue() != null && this.tblMain.getCell(r, "rptPeriodFrom.number").getValue().toString().equals("0")) {
                this.tblMain.getCell(r, "rptPeriodFrom.number").setValue(null);
            }
            if (this.tblMain.getCell(r, "rptPeriodTo.number").getValue() == null || !this.tblMain.getCell(r, "rptPeriodTo.number").getValue().toString().equals("0")) continue;
            this.tblMain.getCell(r, "rptPeriodTo.number").setValue(null);
        }
    }

    @Override
    public void actionBatchCalc_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList ids = this.getAllSelecteIDListValues();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(ids), CompareType.INCLUDE));
        view.setFilter(filter);
        TaxOtherReportCollection coll = TaxOtherReportFactory.getRemoteInstance().getTaxOtherReportCollection(view);
        int errorCount = 0;
        StringBuffer errorDetail = new StringBuffer();
        final TaxOtherReportCollection reportColl = new TaxOtherReportCollection();
        TaxOtherReportInfo reportInfo = null;
        JobConfig jobCfg = null;
        String reportId = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            reportInfo = coll.get(i);
            reportId = reportInfo.getId().toString();
            jobCfg = TaxOtherReportListUI.createJobCfg("", reportId);
            if (TaxReportStatusEnum.AUDIT.equals((Object)reportInfo.getState())) {
                errorDetail.append(EASResource.getString((String)"com.kingdee.eas.tm.td.TaxDraftResource", (String)"ReportBatchCalHasAudit", (Object[])new Object[]{reportInfo.getNumber(), reportInfo.getName()})).append("\n");
                ++errorCount;
                continue;
            }
            if (CreateJobFacadeFactory.getRemoteInstance().checkDuplicateTask(jobCfg.getTaskType())) {
                errorDetail.append(RptUtil.getReportResource((String)"QueueControlRupSubmitDetail").replaceAll("\\{0\\}", reportInfo.getNumber()).replaceAll("\\{1\\}", reportInfo.getName()) + "\n");
                ++errorCount;
                continue;
            }
            reportColl.add(coll.get(i));
        }
        if (errorCount == 0) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.tm.td.TaxDraftResource", (String)"ReportBatchCalSuccess"));
        } else if (errorCount == ids.size()) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.tm.td.TaxDraftResource", (String)"ReportBatchCalFailure"), (String)errorDetail.toString(), (int)0);
        } else {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.tm.td.TaxDraftResource", (String)"ReportBatchCalPartSuccess", (Object[])new Object[]{ids.size() - errorCount, errorCount}), (String)errorDetail.toString(), (int)1);
        }
        if (reportColl == null || reportColl.size() == 0) {
            return;
        }
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    logger.info((Object)"report batch calc start");
                    ITaxDraftCalculateFacade iBatchCalc = TaxDraftCalculateFacadeFactory.getRemoteInstance();
                    List returnList = iBatchCalc.batchCalc(reportColl);
                    logger.info((Object)"report batch calc end");
                }
                catch (Exception e1) {
                    logger.error((Object)e1.getMessage(), (Throwable)e1);
                }
            }
        });
        t.setName("report batch calc");
        t.start();
    }

    @Override
    public void actionGenVoucher_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList ids = this.getSelectedIdValues();
        Map retMap = TaxOtherReportFactory.getRemoteInstance().checkBeforeVoucher(new HashSet(ids));
        List billIds = (List)retMap.get("billIds");
        StringBuffer errorMsg = (StringBuffer)retMap.get("errorMsg");
        Map reportMap = (Map)retMap.get("reportMap");
        Map confirmBillMap = (Map)retMap.get("confirmbillMap");
        if (!confirmBillMap.isEmpty()) {
            TaxOtherReportInfo reportInfo = null;
            CoreBillBaseCollection draftBillColl = null;
            List billList = null;
            Iterator it = confirmBillMap.keySet().iterator();
            while (it.hasNext()) {
                reportInfo = (TaxOtherReportInfo)reportMap.get(it.next());
                billList = (List)confirmBillMap.get(it.next());
                draftBillColl = new CoreBillBaseCollection();
                int size = billList.size();
                for (int i = 0; i < size; ++i) {
                    draftBillColl.add((CoreBillBaseInfo)billList.get(i));
                }
                String logDetailStr = reportInfo.getNumber();
                IObjectPK logPk = LogUtils.beginLog(null, "saveConfirmBill", BOSObjectType.create((String)"2A607F02"), (IObjectPK)new ObjectUuidPK(reportInfo.getId().toString()), logDetailStr, "td_taxotherreport_comfire_certificate", "");
                try {
                    this.uiHelper.genVoucher(draftBillColl);
                }
                catch (Exception ex) {
                    errorMsg.append(ex.getMessage());
                    billIds.remove(reportInfo.getId().toString());
                    continue;
                }
                LogUtils.afterLog(null, logPk);
            }
        }
        if (errorMsg.length() > 0) {
            String msg = TDUtils.getString("com.kingdee.eas.tm.td.TaxOtherReportResource", "BATCHRESULT", null, new Object[]{ids.size(), billIds.size(), ids.size() - billIds.size()});
            MsgBox.showDetailAndOK((Component)((Object)this), (String)msg, (String)errorMsg.toString(), (int)1);
        }
        this.uiHelper.getDapTrans().voucherFinish();
    }

    @Override
    public void actionDelVoucher_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String message = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Delete");
        if (this.confirmRemoveDialog(message)) {
            this.delVoucher();
        }
    }

    protected void delVoucher() throws Exception {
        ArrayList ids = this.getSelectedIdValues();
        Map retMap = TaxOtherReportFactory.getRemoteInstance().delVoucher(new HashSet(ids));
        List billIds = (List)retMap.get("billIds");
        StringBuffer errorMsg = (StringBuffer)retMap.get("errorMsg");
        if (errorMsg.length() > 0) {
            String msg = TDUtils.getString("com.kingdee.eas.tm.td.TaxOtherReportResource", "BATCHRESULT", null, new Object[]{ids.size(), billIds.size(), ids.size() - billIds.size()});
            MsgBox.showDetailAndOK((Component)((Object)this), (String)msg, (String)errorMsg.toString(), (int)1);
        }
        this.actionRefresh_actionPerformed(null);
    }

    @Override
    public void actionBatchSave_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList ids = this.getSelectedIdValues();
        ArrayList billIds = new ArrayList();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(ids), CompareType.INCLUDE));
        view.setFilter(filter);
        TaxOtherReportCollection coll = TaxOtherReportFactory.getRemoteInstance().getTaxOtherReportCollection(view);
        ITaxDraftCalculateFacade iBatchCalc = TaxDraftCalculateFacadeFactory.getRemoteInstance();
        Map retMap = iBatchCalc.batchSave(coll);
        MsgBox.showWarning((String)TDUtils.getString("com.kingdee.eas.tm.td.TDCommonResource", "BatchSaveSubmitSuccess", TDUtils.getLocale()));
    }

    protected boolean confirmRemoveDialog(String message) {
        return MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)message));
    }

    public static JobConfig createJobCfg(String jobTitle, String jobTaskType) {
        JobConfig jobCfg = new JobConfig();
        jobCfg.setNumber("TD_CALC_0001");
        jobCfg.setTitle(jobTitle);
        jobCfg.setTaskType(jobTaskType);
        jobCfg.setNeedCheckTaskType(false);
        jobCfg.setMutex("rptcalculate");
        return jobCfg;
    }

    @Override
    public void actionExportReport_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList ids = this.getSelectedIdValues();
        if (ids == null || ids.size() == 0) {
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ids", (Object)ids);
        uiContext.put((Object)"reportType", (Object)1);
        String uiClass = "com.kingdee.eas.tm.td.client.TaxDraftExportUI";
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(uiClass, (Map)uiContext, null, OprtState.EDIT);
        uiWindow.show();
    }

    @Override
    public void actionImportReport_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"reportType", (Object)1);
        String uiClass = "com.kingdee.eas.tm.td.client.TaxDraftImportUI";
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(uiClass, (Map)uiContext, null, OprtState.EDIT);
        uiWindow.show();
    }

    @Override
    public void actionViewDoProccess_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        IEnactmentService service2 = EnactmentServiceFactory.createRemoteEnactService();
        ProcessInstInfo instInfo = null;
        ProcessInstInfo[] procInsts = service2.getProcessInstanceByHoldedObjectId(this.getSelectedKeyValue());
        int n = procInsts.length;
        for (int i = 0; i < n; ++i) {
            if (!"open.running".equals(procInsts[i].getState()) && !"open.not_running.suspended".equals(procInsts[i].getState())) continue;
            instInfo = procInsts[i];
        }
        if (instInfo == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_WFHasNotInstance"));
        } else {
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"id", (Object)instInfo.getProcInstId());
            String className = BasicWorkFlowMonitorPanel.class.getName();
            IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(className, (Map)uiContext);
            uiWindow.show();
        }
    }

    @Override
    public void actionMultiapprove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String userID = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        ArrayList idList = this.getSelectedIdValues();
        String[] boID = new String[idList.size()];
        if (boID == null || boID.length == 0) {
            return;
        }
        for (int i = 0; i < idList.size(); ++i) {
            boID[i] = (String)idList.get(i);
        }
        IReport ireport = ReportFactory.getRemoteInstance();
        MultiApproveUtil.multiapproveBills((CoreUIObject)this, (String)userID, (String[])boID);
        this.actionRefresh_actionPerformed(e);
    }

    @Override
    public void actionWorkFlowG_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        IEnactmentService service2 = EnactmentServiceFactory.createRemoteEnactService();
        ProcessInstInfo instInfo = null;
        ProcessInstInfo[] procInsts = service2.getProcessInstanceByHoldedObjectId(this.getSelectedKeyValue());
        int n = procInsts.length;
        for (int i = 0; i < n; ++i) {
            if (!"open.running".equals(procInsts[i].getState()) && !"open.not_running.suspended".equals(procInsts[i].getState())) continue;
            instInfo = procInsts[i];
        }
        if (instInfo == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_WFHasNotInstance"));
        } else {
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"id", (Object)instInfo.getProcInstId());
            String className = BasicWorkFlowMonitorPanel.class.getName();
            IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(className, (Map)uiContext);
            uiWindow.show();
        }
    }

    @Override
    public void actionWorkflowList_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String selectId = this.getSelectedKeyValue();
        IEnactmentService service = EnactmentServiceFactory.createRemoteEnactService();
        ArrayList<ProcessInstInfo> openProcInsts = new ArrayList<ProcessInstInfo>();
        ProcessInstInfo[] procInsts = service.getProcessInstanceByHoldedObjectId(selectId);
        if (procInsts == null || procInsts.length == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_WFHasNotInstance"));
        } else {
            for (int i = 0; i < procInsts.length; ++i) {
                ProcessInstInfo processInstInfo = procInsts[i];
                if (!"open".equalsIgnoreCase(processInstInfo.getState().substring(0, 4))) continue;
                openProcInsts.add(processInstInfo);
            }
            if (openProcInsts.size() == 0 || openProcInsts == null) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_WFHasNotInstance"));
            } else {
                ProcessInstInfo procInstInfo = (ProcessInstInfo)openProcInsts.get(0);
                WfClientUtils.invokeWfInstActivityTable((ProcessInstInfo)procInstInfo, (IUIObject)this);
            }
        }
    }

    @Override
    public void actionNextPerson_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String boID = this.getSelectedKeyValue();
        if (boID == null) {
            return;
        }
        DesignateNextActivityPerformerUI.designateNextActivityPerformerByBillId((CoreUIObject)this, (String)boID);
    }

    @Override
    public void actionAuditResult_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        if (id == null || id.trim().length() < 1) {
            return;
        }
        MultiApproveUtil.showApproveHis((BOSUuid)BOSUuid.read((String)id), (String)UIModelDialogFactory.class.getName(), (Object)((Object)this));
    }

    @Override
    public void actionSendingMessage_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        IEnactmentService enactmentService = EnactmentServiceFactory.createRemoteEnactService();
        String selectId = this.getSelectedKeyValue();
        ProcessInstInfo[] procInsts = enactmentService.getProcessInstanceByHoldedObjectId(selectId);
        if (procInsts == null || procInsts.length <= 0 || procInsts[0] == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_WFHasNotInstance"));
            return;
        }
        Set wfMsgList = this.getWfSendingMsgBundle(procInsts[0].getProcInstId());
        if (wfMsgList == null || wfMsgList.size() <= 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_WFHasNotInstance"));
            return;
        }
        HashMap<String, Object> ctx = new HashMap<String, Object>();
        ctx.put("Owner", (Object)this);
        ctx.put("wfMsgList", wfMsgList);
        IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        IUIWindow messageDialog = uiFactory.create(WorkflowSendMsgUI.class.getName(), ctx);
        messageDialog.show();
    }

    protected Set getWfSendingMsgBundle(String procInstId) throws BOSException {
        HashSet<WfSendingMsgBundle> result = new HashSet<WfSendingMsgBundle>();
        HashSet<String> states = new HashSet<String>();
        IEnactmentService enactmentService = EnactmentServiceFactory.createRemoteEnactService();
        states.add("open.running");
        states.add("open.not_running.not_started");
        List actInstInfos = enactmentService.getRelatedActInstsByProcInstID(procInstId, states);
        for (ActivityInstInfo activityInstInfo : actInstInfos) {
            StringBuffer receviers = new StringBuffer("");
            StringBuffer content = new StringBuffer("");
            String name = activityInstInfo.getActDefName(this.currentLocale);
            boolean isApproved = false;
            String processInstId = activityInstInfo.getProcDefId();
            String actvityInstId = activityInstInfo.getActInstId();
            ActivityDef actDef = enactmentService.getActDefByActInstInfo(activityInstInfo);
            if (actDef instanceof ApproveActivityDef) {
                isApproved = true;
            }
            AssignmentInfo[] assignInfoArray = enactmentService.getAssignmentByActInstId(activityInstInfo.getActInstId());
            int length = assignInfoArray.length;
            for (int j = 0; j < length; ++j) {
                String userName = assignInfoArray[j].getUserName(this.currentLocale);
                String workContent = assignInfoArray[j].getBody(this.currentLocale);
                if (userName == null || receviers.indexOf(userName) != -1) continue;
                if (receviers.toString().trim().length() != 0) {
                    receviers.append(",");
                    content.append(",");
                }
                receviers.append(userName);
                if (workContent == null || content.indexOf(workContent) != -1) continue;
                content.append(workContent);
            }
            if (",".equals(content.toString())) {
                content = new StringBuffer("");
            }
            WfSendingMsgBundle MsgBundle = new WfSendingMsgBundle(name, receviers.toString(), content.toString(), isApproved, processInstId, actvityInstId);
            result.add(MsgBundle);
        }
        return result;
    }
}

