/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.client.util;

import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTColumns;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDNumberTextField;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ctrl.swing.KDTextArea;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.util.enums.EnumUtils;
import java.awt.Color;
import java.awt.Component;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTextField;

public class TDClientUtils {
    public static final Color NECCESSCOLOR = new Color(252, 251, 223);
    public static final Color NULLCOLOR = new Color(255, 255, 255, 0);
    public static final String NUMFORMAT = "###,##0.##########";
    public static final String STRDATEFORMAT = "%{yyyy-MM-dd}t";
    public static final String NUMBERRANDER = "$number$";
    public static final String NAMERANDER = "$name$";
    public static int PRECISION_2 = 2;
    public static int PRECISION_4 = 4;
    public static int PRECISION_8 = 8;
    public static int PRECISION_20 = 20;
    public static String strTimeFormat = CtrlFormatUtilities.getDateTimeFormatString();
    public static String strDateFormat = CtrlFormatUtilities.getDateFormatString();

    public static boolean isRowBlank(KDTable detailTable, int row, String[] cols) throws Exception {
        if (detailTable == null || cols == null) {
            return true;
        }
        for (int i = 0; i < cols.length; ++i) {
            if (detailTable.getCell(row, cols[i]) == null || detailTable.getCell(row, cols[i]).getValue() == null) continue;
            return false;
        }
        return true;
    }

    public static void clearComponentValue(Component[] components) {
        for (Component c : components) {
            TDClientUtils.clearComponentValue(c);
        }
    }

    public static void clearComponentValue(Component component) {
        if (component instanceof KDTextField) {
            ((KDTextField)component).setText(null);
        } else if (component instanceof KDNumberTextField) {
            ((KDNumberTextField)component).setText(null);
        } else if (component instanceof KDDatePicker) {
            KDDatePicker date = (KDDatePicker)component;
            date.setValue(null);
        } else if (component instanceof KDFormattedTextField) {
            ((KDFormattedTextField)component).setText(null);
        } else if (component instanceof KDComboBox) {
            ((KDComboBox)component).setSelectedItem(null);
        } else if (component instanceof KDBizPromptBox) {
            ((KDBizPromptBox)component).setValue(null);
        } else if (component instanceof KDCheckBox) {
            ((KDCheckBox)component).setSelected(false);
        } else if (component instanceof KDSpinner) {
            ((KDSpinner)component).setValue(null);
        } else if (component instanceof KDTextArea) {
            ((KDTextArea)component).setText(null);
        } else if (component instanceof KDLabelContainer) {
            TDClientUtils.clearComponentValue(((KDLabelContainer)component).getBoundEditor());
        }
    }

    public static Map<Integer, String> getRequiredColName(KDTable table) {
        KDTColumns columns = table.getColumns();
        KDTRow head = table.getHead().getRow(0);
        HashMap<Integer, String> reqMap = new HashMap<Integer, String>();
        for (int i = 0; i < columns.size(); ++i) {
            if (!columns.getColumn(i).isRequired()) continue;
            reqMap.put(i, (String)head.getCell(i).getValue());
        }
        return reqMap;
    }

    public static void textFieldTrim(Component[] comps) {
        for (int i = 0; i < comps.length; ++i) {
            KDTextField txt;
            JComponent boundEditor;
            if (!(comps[i] instanceof KDLabelContainer) || !((boundEditor = ((KDLabelContainer)comps[i]).getBoundEditor()) instanceof KDTextField) || (txt = (KDTextField)boundEditor).getText() == null) continue;
            txt.setText(txt.getText().trim());
        }
    }

    public static KDBizPromptBox getF7Box(String queryInfoStr) {
        KDBizPromptBox f7Box = new KDBizPromptBox();
        f7Box.setQueryInfo(queryInfoStr);
        f7Box.setEditFormat(NUMBERRANDER);
        f7Box.setDisplayFormat(NAMERANDER);
        f7Box.setCommitFormat(NUMBERRANDER);
        return f7Box;
    }

    public static void setBigDecimalEditor(KDTable table, String column, int precision) {
        KDFormattedTextField formattedField = new KDFormattedTextField();
        formattedField.setDataType(1);
        formattedField.setPrecision(precision);
        formattedField.setNegatived(false);
        formattedField.setSupportedEmpty(true);
        formattedField.setRemoveingZeroInEdit(true);
        formattedField.setRemoveingZeroInDispaly(true);
        formattedField.setHorizontalAlignment(4);
        table.getColumn(column).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)formattedField));
        table.getColumn(column).getStyleAttributes().setNumberFormat(NUMFORMAT);
        table.getColumn(column).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
    }

    public static void setRateEditor(KDTable table, String column, int precision) {
        KDFormattedTextField formattedField = new KDFormattedTextField();
        formattedField.setDataType(1);
        formattedField.setPrecision(precision);
        formattedField.setNegatived(false);
        formattedField.setRemoveingZeroInEdit(true);
        formattedField.setRemoveingZeroInDispaly(true);
        formattedField.setHorizontalAlignment(4);
        formattedField.setMaximumValue((Comparable)BigDecimal.ONE);
        formattedField.setMinimumValue((Comparable)BigDecimal.ZERO);
        table.getColumn(column).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)formattedField));
        table.getColumn(column).getStyleAttributes().setNumberFormat(NUMFORMAT);
        table.getColumn(column).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
    }

    public static void setRateEditor2(KDTable table, String column, int precision) {
        KDFormattedTextField formattedField = new KDFormattedTextField();
        formattedField.setDataType(1);
        formattedField.setPrecision(precision);
        formattedField.setNegatived(false);
        formattedField.setRemoveingZeroInEdit(true);
        formattedField.setRemoveingZeroInDispaly(true);
        formattedField.setHorizontalAlignment(4);
        formattedField.setMaximumValue((Comparable)BigDecimal.valueOf(100L));
        formattedField.setMinimumValue((Comparable)BigDecimal.ZERO);
        formattedField.setSupportedEmpty(true);
        table.getColumn(column).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)formattedField));
        table.getColumn(column).getStyleAttributes().setNumberFormat(NUMFORMAT);
        table.getColumn(column).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
    }

    public static void setDateEditor(KDTable table, String columeName) {
        KDDatePicker kdDatePicker = new KDDatePicker();
        kdDatePicker.setSupportedEmpty(false);
        KDTDefaultCellEditor dateEditor = new KDTDefaultCellEditor(kdDatePicker);
        table.getColumn(columeName).setEditor((ICellEditor)dateEditor);
        table.getColumn(columeName).getStyleAttributes().setNumberFormat(STRDATEFORMAT);
    }

    public static void setEnumEditor(KDTable table, String columeName, String enumClazz) {
        KDComboBox enumEditor = new KDComboBox();
        enumEditor.addItems(EnumUtils.getEnumList((String)enumClazz).toArray());
        table.getColumn(columeName).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)enumEditor));
    }

    public static IBasicRender getRander(String bizString) {
        ObjectValueRender avr = new ObjectValueRender();
        avr.setFormat((IDataFormat)new BizDataFormat(bizString));
        return avr;
    }

    public static IBasicRender getNameRander() {
        ObjectValueRender avr = new ObjectValueRender();
        avr.setFormat((IDataFormat)new BizDataFormat(NAMERANDER));
        return avr;
    }

    public static void setCellLocked(IRow row, String columnKey, Boolean locked) {
        if (locked.booleanValue()) {
            row.getCell(columnKey).getStyleAttributes().setLocked(true);
            row.getCell(columnKey).getStyleAttributes().setBackground(NULLCOLOR);
        } else {
            row.getCell(columnKey).getStyleAttributes().setLocked(false);
            row.getCell(columnKey).getStyleAttributes().setBackground(NECCESSCOLOR);
        }
    }

    public static BigDecimal getBigDecimalValue(String valueStr) {
        BigDecimal value = new BigDecimal(0);
        if (valueStr != null && valueStr.length() > 0) {
            value = new BigDecimal(valueStr);
        }
        return value;
    }

    public static String transmitNumber(String number) {
        if (number == null || number.length() == 0) {
            return "";
        }
        return number.replace(",", "");
    }

    public static boolean objectEquals(Object obj1, Object obj2) {
        if (obj1 == null && obj2 == null) {
            return true;
        }
        if (obj1 == null || obj2 == null) {
            return false;
        }
        if (obj1 instanceof BigDecimal && obj2 instanceof BigDecimal) {
            return ((BigDecimal)obj1).compareTo((BigDecimal)obj2) == 0;
        }
        if (obj1 instanceof CoreBaseInfo && obj2 instanceof CoreBaseInfo) {
            return ((CoreBaseInfo)obj1).getId().toString().equals(((CoreBaseInfo)obj2).getId().toString());
        }
        return obj1.equals(obj2);
    }

    public static boolean isEmptyRow(IRow row, String[] keyColumns) {
        if (keyColumns == null) {
            return true;
        }
        int j = keyColumns.length;
        for (int i = 0; i < j; ++i) {
            if (row.getCell(keyColumns[i]).getValue() == null) continue;
            return false;
        }
        return true;
    }

    public static void removeNullRow(KDTable table, String[] colNames) {
        int rowCount = table.getRowCount();
        int colCount = table.getColumnCount();
        if (colNames == null) {
            for (int i = 0; i < rowCount; ++i) {
                boolean isNullRow = true;
                IRow row = table.getRow(i);
                for (int colIndex = 0; isNullRow && colIndex < colCount; ++colIndex) {
                    isNullRow = row.getCell(colIndex).getValue() == null;
                }
                if (!isNullRow) continue;
                table.removeRow(i);
                --i;
                --rowCount;
            }
        } else {
            int colCounts = colNames.length;
            for (int i = 0; i < rowCount; ++i) {
                boolean isNullRow = false;
                IRow row = table.getRow(i);
                for (int colIndex = 0; !isNullRow && colIndex < colCounts; ++colIndex) {
                    isNullRow = row.getCell(colNames[colIndex]).getValue() == null;
                }
                if (!isNullRow) continue;
                if (rowCount == 1) {
                    return;
                }
                table.removeRow(i);
                --i;
                --rowCount;
            }
        }
    }
}

