/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.cloud.client;

import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.basedata.TaxItemTypeInfo;
import com.kingdee.eas.tm.td.cloud.BackupDataTypeInfo;
import com.kingdee.eas.tm.td.cloud.BackupItemEntryCollection;
import com.kingdee.eas.tm.td.cloud.BackupItemEntryInfo;
import com.kingdee.eas.tm.td.cloud.BackupItemFactory;
import com.kingdee.eas.tm.td.cloud.BackupItemInfo;
import com.kingdee.eas.tm.td.cloud.EnableStateEnum;
import com.kingdee.eas.tm.td.cloud.client.AbstractBackupItemEditUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class BackupItemEditUI
extends AbstractBackupItemEditUI {
    private static final Logger logger = CoreUIObject.getLogger(BackupItemEditUI.class);
    private static final String TDRESOURCE = "com.kingdee.eas.tm.td.cloud.TDCloudResource";
    private static final String TB_Name = "name";
    private DataChangeListener prmtTaxItemTypeListener = null;
    private DataChangeListener prmtBackupDataTypeListener = null;

    public void onLoad() throws Exception {
        this.kdtEntrys.checkParsed();
        if (this.getOprtState() == null) {
            this.setOprtState("ADDNEW");
        }
        super.onLoad();
    }

    protected void addControlListener() {
        if (this.prmtTaxItemTypeListener == null) {
            this.prmtTaxItemTypeListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent e) {
                    try {
                        BackupItemEditUI.this.prmtTaxItemType_dataChanged(e);
                    }
                    catch (Exception exc) {
                        BackupItemEditUI.this.handUIException(exc);
                    }
                }
            };
        }
        this.prmtTaxItemType.addDataChangeListener(this.prmtTaxItemTypeListener);
        if (this.prmtBackupDataTypeListener == null) {
            this.prmtBackupDataTypeListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent e) {
                    try {
                        BackupItemEditUI.this.prmtBackupDataType_dataChanged(e);
                    }
                    catch (Exception exc) {
                        BackupItemEditUI.this.handUIException(exc);
                    }
                }
            };
        }
        this.prmtBackupDataType.addDataChangeListener(this.prmtBackupDataTypeListener);
    }

    protected void deleteControlListener() {
        if (this.prmtTaxItemTypeListener != null) {
            this.prmtTaxItemType.removeDataChangeListener(this.prmtTaxItemTypeListener);
        }
        if (this.prmtBackupDataTypeListener != null) {
            this.prmtBackupDataType.removeDataChangeListener(this.prmtBackupDataTypeListener);
        }
    }

    protected void prmtTaxItemType_dataChanged(DataChangeEvent e) throws Exception {
        this.initBackupItemF7();
        this.prmtBackupDataType.setValue(null);
    }

    protected void prmtBackupDataType_dataChanged(DataChangeEvent e) throws Exception {
        Object backupDataType = this.prmtBackupDataType.getValue();
        if (backupDataType != null && backupDataType instanceof BackupDataTypeInfo) {
            BackupDataTypeInfo backupDataTypeInfo = (BackupDataTypeInfo)backupDataType;
            if ("tax_check002".equals(backupDataTypeInfo.getNumber())) {
                this.txtHasPreferentialTime.setEditable(false);
                this.txtHasPreferentialTime.setText(null);
            } else {
                this.txtHasPreferentialTime.setEditable(true);
            }
        } else {
            this.txtHasPreferentialTime.setEditable(true);
        }
    }

    private void initBackupItemF7() {
        Object taxItemType = this.prmtTaxItemType.getValue();
        EntityViewInfo entityViewInfo = this.prmtBackupDataType.getEntityViewInfo();
        if (entityViewInfo == null) {
            entityViewInfo = new EntityViewInfo();
        }
        FilterInfo filter = new FilterInfo();
        if (taxItemType != null && taxItemType instanceof TaxItemTypeInfo) {
            TaxItemTypeInfo taxItemTypeInfo = (TaxItemTypeInfo)taxItemType;
            filter.getFilterItems().add(new FilterItemInfo("taxItemType.id", (Object)taxItemTypeInfo.getId().toString(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("taxItemType.id", null, CompareType.IS));
            filter.setMaskString("#0 or #1");
        } else {
            filter.clone();
        }
        entityViewInfo.setFilter(filter);
        this.prmtBackupDataType.setEntityViewInfo(entityViewInfo);
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BackupItemFactory.getRemoteInstance();
    }

    @Override
    public void loadFields() {
        this.deleteControlListener();
        super.loadFields();
        this.addControlListener();
        this.initDataStatus();
    }

    protected void setFieldsNull(AbstractObjectValue newData) {
        BackupItemInfo editData = (BackupItemInfo)newData;
        editData.setNumber(null);
        editData.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
    }

    private void inputCheck() {
        StringBuffer sb = new StringBuffer();
        if (this.txtNumber.getText().isEmpty()) {
            sb.append("\u3001" + this.txtNumber.getBoundLabelText());
        }
        if (this.txtName.getText().isEmpty()) {
            sb.append("\u3001" + this.txtName.getBoundLabelText());
        }
        if (this.prmtBackupDataType.getValue() == null) {
            sb.append("\u3001" + this.contBackupDataType.getBoundLabelText());
        }
        if (sb.length() > 0) {
            sb.append(TDUtils.getString("com.kingdee.eas.tm.td.basedata.TaxBaseResource", "Data_NotNull", TDUtils.getLocale())).append("\r\n");
            MsgBox.showWarning((String)sb.substring(1));
            SysUtil.abort();
        }
        try {
            if (this.txtDescription.getText().getBytes("utf8").length > 1024) {
                sb.append("\u3001" + this.txtDescription.getBoundLabelText());
            }
            if (this.txtPolicySummarize.getText().getBytes("utf8").length > 1024) {
                sb.append("\u3001" + this.txtPolicySummarize.getBoundLabelText());
            }
            if (this.txtPolicyGist.getText().getBytes("utf8").length > 1024) {
                sb.append("\u3001" + this.txtPolicyGist.getBoundLabelText());
            }
            if (this.txtHasPreferentialTime.getText().getBytes("utf8").length > 512) {
                sb.append("\u3001" + this.txtHasPreferentialTime.getBoundLabelText());
            }
            if (this.txtApplyCondition.getText().getBytes("utf8").length > 512) {
                sb.append("\u3001" + this.txtApplyCondition.getBoundLabelText());
            }
            if (this.txtRemark.getText().getBytes("utf8").length > 1024) {
                sb.append("\u3001" + this.txtRemark.getBoundLabelText());
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        if (sb.length() > 0) {
            sb.append(EASResource.getString((String)TDRESOURCE, (String)"OVER_LENGTH"));
            MsgBox.showWarning((String)sb.substring(1));
            SysUtil.abort();
        }
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        TDUtils.removeNullRow(this.kdtEntrys, new String[]{TB_Name}, false);
        this.inputCheck();
        super.actionSave_actionPerformed(e);
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        TDUtils.removeNullRow(this.kdtEntrys, new String[]{TB_Name}, false);
        this.inputCheck();
        super.actionSubmit_actionPerformed(e);
    }

    protected void initDataStatus() {
        super.initDataStatus();
        if (OprtState.VIEW.equals(this.getOprtState())) {
            this.txtNumber.setEditable(false);
        }
        if (this.editData == null) {
            return;
        }
        if (this.editData.getId() != null && EnableStateEnum.ENABLE.equals((Object)this.editData.getState())) {
            this.setOprtState("VIEW");
        }
        if (this.editData.getId() == null) {
            this.btnCancel.setEnabled(false);
            this.btnCancelCancel.setEnabled(false);
            this.menuItemCancelCancel.setEnabled(false);
            this.menuItemCancel.setEnabled(false);
            this.btnAddRow.setEnabled(true);
            this.btnInsertRow.setEnabled(true);
            this.btnDelRow.setEnabled(true);
            return;
        }
        if (this.editData.getState().equals((Object)EnableStateEnum.ENABLE)) {
            this.btnRemove.setEnabled(false);
            this.btnCancel.setEnabled(true);
            this.btnCancelCancel.setEnabled(false);
            this.menuItemCancel.setEnabled(true);
            this.menuItemCancelCancel.setEnabled(false);
            this.btnEdit.setEnabled(false);
            this.btnAddRow.setEnabled(false);
            this.btnInsertRow.setEnabled(false);
            this.btnDelRow.setEnabled(false);
        } else {
            this.btnRemove.setEnabled(true);
            this.btnCancel.setEnabled(false);
            this.btnCancelCancel.setEnabled(true);
            this.menuItemCancel.setEnabled(false);
            this.menuItemCancelCancel.setEnabled(true);
            this.btnEdit.setEnabled(true);
            if ("EDIT".equals(this.getOprtState())) {
                this.btnAddRow.setEnabled(true);
                this.btnInsertRow.setEnabled(true);
                this.btnDelRow.setEnabled(true);
            } else if ("VIEW".equals(this.getOprtState())) {
                this.btnAddRow.setEnabled(false);
                this.btnInsertRow.setEnabled(false);
                this.btnDelRow.setEnabled(false);
            }
        }
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkStateEnableEdit();
        super.actionEdit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkStateEnableRemove();
        super.actionRemove_actionPerformed(e);
    }

    protected void checkStateEnableEdit() throws Exception {
        if (this.editData.getState().getValue() == 0) {
            MsgBox.showInfo((String)"\u542f\u7528\u72b6\u6001\u4e0d\u80fd\u7f16\u8f91\uff01");
            SysUtil.abort();
        }
    }

    protected void checkStateEnableRemove() throws Exception {
        if (this.editData.getState().getValue() == 0) {
            MsgBox.showInfo((String)"\u542f\u7528\u72b6\u6001\u4e0d\u80fd\u5220\u9664\uff01");
            SysUtil.abort();
        }
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        String billId = this.editData.getId().toString();
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(billId);
        ArrayList errors = BackupItemFactory.getRemoteInstance().cancelCancel(new HashSet(ids));
        if (errors.size() > 0) {
            MsgBox.showWarning((Component)((Object)this), (String)((String)errors.get(0)));
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Startup_OK"));
            this.setOprtState("VIEW");
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)billId));
            this.refresh((IObjectPK)pk);
        }
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        String billId = this.editData.getId().toString();
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(billId);
        ArrayList errors = BackupItemFactory.getRemoteInstance().cancel(new HashSet(ids));
        if (errors.size() > 0) {
            MsgBox.showWarning((Component)((Object)this), (String)((String)errors.get(0)));
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Forbid _OK"));
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)billId));
            this.refresh((IObjectPK)pk);
        }
    }

    private void refresh(IObjectPK pk) throws Exception {
        this.setDataObject(this.getValue(pk));
        this.loadFields();
        this.initOldData((IObjectValue)this.editData);
    }

    protected IObjectValue createNewData() {
        BackupItemInfo info = new BackupItemInfo();
        info.getEntrys().addCollection(this.createNewDetailData(this.kdtEntrys));
        info.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        info.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
        return info;
    }

    protected BackupItemEntryCollection createNewDetailData(KDTable table) {
        BackupItemEntryCollection coll = new BackupItemEntryCollection();
        BackupItemEntryInfo info = new BackupItemEntryInfo();
        coll.add(info);
        return coll;
    }

    @Override
    public void actionAddRow_actionPerformed(ActionEvent e) throws Exception {
        this.kdtEntrys.addRow();
        if (this.kdtEntrys.getRowCount() > 0) {
            this.btnDelRow.setEnabled(true);
        }
    }

    @Override
    public void actionInsertRow_actionPerformed(ActionEvent e) throws Exception {
        if (this.kdtEntrys.getSelectManager().size() > 0) {
            int top = this.kdtEntrys.getSelectManager().get().getTop();
            this.kdtEntrys.addRow(top);
        } else {
            this.kdtEntrys.addRow();
        }
        if (this.kdtEntrys.getRowCount() > 0) {
            this.btnDelRow.setEnabled(true);
        }
    }

    @Override
    public void actionDelRow_actionPerformed(ActionEvent e) throws Exception {
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.kdtEntrys);
        if (selectRows == null || selectRows.length == 0) {
            return;
        }
        for (int i = 0; i < selectRows.length; ++i) {
            this.kdtEntrys.removeRow(selectRows[i]);
        }
        if (this.kdtEntrys.getRowCount() == 0) {
            this.btnDelRow.setEnabled(false);
        }
    }

    protected KDTable getDetailTable() {
        return this.kdtEntrys;
    }
}

