/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.cloud.datamodel.check.handler;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.service.job.core.IJobHandler;
import com.kingdee.bos.service.job.core.Job;
import com.kingdee.eas.base.message.BMCMessageFactory;
import com.kingdee.eas.base.message.BMCMessageInfo;
import com.kingdee.eas.base.message.MsgBizType;
import com.kingdee.eas.base.message.MsgPriority;
import com.kingdee.eas.base.message.MsgStatus;
import com.kingdee.eas.base.message.MsgType;
import com.kingdee.eas.basedata.common.perf.JobParam;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.basedata.TaxItemTypeInfo;
import com.kingdee.eas.tm.td.cloud.GroupInfo;
import com.kingdee.eas.tm.td.cloud.datamodel.CheckIndexInfo;
import com.kingdee.eas.tm.td.cloud.datamodel.CheckTypeEnum;
import com.kingdee.eas.tm.td.cloud.datamodel.check.CheckServiceFactory;
import com.kingdee.eas.util.app.ContextUtil;
import java.util.Map;

public class IndexCalculateHandler
implements IJobHandler {
    public Object execute(Job job) throws Exception {
        Context ctx = job.getContext();
        JobParam jobParam = (JobParam)job.getParameters();
        Map params = (Map)jobParam.getBizParam();
        String title = TDUtils.getString("com.kingdee.eas.tm.td.cloud.TDCloudResource", "IndexCalculate", null);
        String msgBody = this.getMsgBody(params);
        try {
            CheckServiceFactory.getCheckService().check(ctx, params, CheckTypeEnum.TAXINDEX);
            this.sendMsg(ctx, title, msgBody + TDUtils.getString("com.kingdee.eas.tm.td.cloud.TDCloudResource", "IndexCalculateSuccess", null));
        }
        catch (Exception e) {
            this.sendMsg(ctx, title, msgBody + TDUtils.getString("com.kingdee.eas.tm.td.cloud.TDCloudResource", "IndexCalculateFailure", null) + "\n" + e.getMessage());
            throw e;
        }
        return new Boolean(true);
    }

    protected String getMsgBody(Map params) {
        Object[] indexes;
        String groupTitle = TDUtils.getString("com.kingdee.eas.tm.td.cloud.TDCloudResource", "Group", null);
        String companyTitle = TDUtils.getString("com.kingdee.eas.tm.td.cloud.TDCloudResource", "Company", null);
        String periodTitle = TDUtils.getString("com.kingdee.eas.tm.td.cloud.TDCloudResource", "Period", null);
        String taxItemTypeTitle = TDUtils.getString("com.kingdee.eas.tm.td.cloud.TDCloudResource", "TaxItemType", null);
        String indexTitle = TDUtils.getString("com.kingdee.eas.tm.td.cloud.TDCloudResource", "Index", null);
        StringBuffer msg = new StringBuffer();
        GroupInfo group = (GroupInfo)params.get("group");
        msg.append(groupTitle + "\uff1a").append(group.getName()).append("\uff0c");
        Object[] companys = (Object[])params.get("companys");
        if (companys != null && companys.length > 0) {
            msg.append(companyTitle + "\uff1a");
            CompanyOrgUnitInfo company = null;
            for (int i = 0; i < companys.length; ++i) {
                company = (CompanyOrgUnitInfo)companys[i];
                msg.append(company.getName()).append("\uff0c");
            }
        }
        msg.append(periodTitle + "\uff1a");
        int yearFrom = (Integer)params.get("spYearFrom");
        int monthFrom = (Integer)params.get("spMonthFrom");
        msg.append(yearFrom).append("-").append(monthFrom < 10 ? "0" + monthFrom : Integer.valueOf(monthFrom)).append("~");
        int yearTo = (Integer)params.get("spYearTo");
        int monthTo = (Integer)params.get("spMonthTo");
        msg.append(yearTo).append("-").append(monthTo < 10 ? "0" + monthTo : Integer.valueOf(monthTo)).append("\uff0c");
        TaxItemTypeInfo taxType = (TaxItemTypeInfo)params.get("taxType");
        if (taxType != null) {
            msg.append(taxItemTypeTitle + "\uff1a");
            msg.append(taxType.getName()).append("\uff0c");
        }
        if ((indexes = (Object[])params.get("indexes")) != null && indexes.length > 0) {
            msg.append(indexTitle + "\uff1a");
            CheckIndexInfo index = null;
            for (int i = 0; i < indexes.length; ++i) {
                index = (CheckIndexInfo)indexes[i];
                msg.append(index.getName()).append("\uff0c");
            }
        }
        return msg.toString();
    }

    protected void sendMsg(Context ctx, String title, String msgBody) throws EASBizException, BOSException {
        BMCMessageInfo msgInfo = new BMCMessageInfo();
        msgInfo.setType(MsgType.NOTICE);
        msgInfo.setBizType(MsgBizType.ONLINE);
        msgInfo.setStatus(MsgStatus.UNREADED);
        msgInfo.setPriority(MsgPriority.MIDDLE);
        msgInfo.setTitle(title);
        msgInfo.setBody(msgBody);
        msgInfo.setReceiver(ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString());
        BMCMessageFactory.getLocalInstance((Context)ctx).addnew((CoreBaseInfo)msgInfo);
    }
}

