/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.cloud.datamodel.check.processor;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.expr.IErrorProvider;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.fi.newrpt.formula.ReportCalculateContext;
import com.kingdee.eas.fi.newrpt.formula.define.FormulaDefinition;
import com.kingdee.eas.fi.rpt.util.BookProperties;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.TaxDraftRecordInfo;
import com.kingdee.eas.tm.td.basedata.AccountConfigInfo;
import com.kingdee.eas.tm.td.cloud.datamodel.CheckAccountEntryCollection;
import com.kingdee.eas.tm.td.cloud.datamodel.CheckAccountEntryInfo;
import com.kingdee.eas.tm.td.cloud.datamodel.CheckAccountInfo;
import com.kingdee.eas.tm.td.cloud.datamodel.check.info.CheckAccountDetailResultVo;
import com.kingdee.eas.tm.td.cloud.utils.CheckFormulaUtil;
import com.kingdee.eas.tm.td.utils.TaxDraftRptPropertyAdapter;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class CheckAccountDetailProcessor {
    private Context ctx = null;
    private TaxDraftRecordInfo reportInfo = null;
    private CheckAccountInfo checkInfo = null;
    private Book book = null;
    private static final String rsClass = "com.kingdee.eas.tm.td.TDResource";
    private Sheet periodSheet = null;
    private Object[][] periodData = null;
    private Sheet periodTotalSheet = null;
    private Object[][] periodTotalData = null;
    private List<CheckAccountDetailResultVo> errorList = new ArrayList<CheckAccountDetailResultVo>();
    private List<CheckAccountDetailResultVo> detailList = new ArrayList<CheckAccountDetailResultVo>();
    private String periodLabel = null;
    private String periodTotalLabel = null;

    public List<CheckAccountDetailResultVo> getErrorList() {
        return this.errorList;
    }

    public List<CheckAccountDetailResultVo> getDetailList() {
        return this.detailList;
    }

    public CheckAccountDetailProcessor(Context ctx, TaxDraftRecordInfo reportInfo, CheckAccountInfo checkInfo) {
        this.ctx = ctx;
        this.reportInfo = reportInfo;
        this.checkInfo = checkInfo;
    }

    public void execute() throws Exception {
        this.beforeExecute();
        this.doExecute();
        this.afterExecute();
    }

    protected void beforeExecute() throws Exception {
        this.book = this.initBook(this.ctx, this.reportInfo);
        this.periodLabel = TDUtils.getString(rsClass, "AccountPeriod", this.ctx.getLocale());
        this.periodTotalLabel = TDUtils.getString(rsClass, "AccountPeriodTotal", this.ctx.getLocale());
        this.periodSheet = this.book.getSheet(this.periodLabel);
        CheckAccountDetailResultVo detailResultVo = null;
        if (this.periodSheet == null) {
            detailResultVo = new CheckAccountDetailResultVo(null, this.periodLabel, false);
            detailResultVo.setErrorMsg("\u672c\u671f\u65b0\u589e\u53f0\u8d26\u9875\u7b7e\u4e0d\u5b58\u5728");
            this.errorList.add(detailResultVo);
        } else {
            this.periodData = this.getSheetData(this.periodSheet, this.checkInfo.getAccount());
        }
        if (this.checkInfo.isIsCheckTotal()) {
            this.periodTotalSheet = this.book.getSheet(this.periodTotalLabel);
            if (this.periodTotalSheet == null) {
                detailResultVo = new CheckAccountDetailResultVo(null, this.periodTotalLabel, true);
                detailResultVo.setErrorMsg("\u7d2f\u8ba1\u66f4\u65b0\u53f0\u8d26\u9875\u7b7e\u4e0d\u5b58\u5728");
                this.errorList.add(detailResultVo);
            } else {
                this.periodTotalData = this.getSheetData(this.periodTotalSheet, this.checkInfo.getAccount());
            }
        }
    }

    protected void doExecute() throws Exception {
        this.checkData(false);
        if (this.checkInfo.isIsCheckTotal()) {
            this.checkData(true);
        }
    }

    protected void afterExecute() throws Exception {
    }

    private void checkData(boolean isPeriodTotal) throws Exception {
        String label;
        CheckAccountDetailResultVo detailResultVo = null;
        Object[][] data = isPeriodTotal ? this.periodTotalData : this.periodData;
        String string = label = isPeriodTotal ? this.periodTotalLabel : this.periodLabel;
        if (data == null || data.length == 0) {
            return;
        }
        CheckAccountEntryCollection entryColl = this.checkInfo.getEntry();
        Object checkFormula = null;
        CheckAccountEntryInfo entryInfo = null;
        int size = entryColl.size();
        for (int i = 0; i < size; ++i) {
            entryInfo = entryColl.get(i);
            if (this.isManualPass(this.ctx, entryInfo, isPeriodTotal)) continue;
            detailResultVo = new CheckAccountDetailResultVo(entryInfo, label, isPeriodTotal);
            Object[] rowData = null;
            for (int j = 0; j < data.length; ++j) {
                rowData = data[j];
                if (!this.checkDataFormula(j, rowData, entryInfo.getCheckFormula(), entryInfo.getCheckFormulaMask())) continue;
                detailResultVo.addErrorRowIndex(j + this.checkInfo.getAccount().getFillRow() + 1);
            }
            if (!detailResultVo.isPass()) {
                this.errorList.add(detailResultVo);
            }
            this.getDetailList().add(detailResultVo);
        }
    }

    private boolean isManualPass(Context ctx, CheckAccountEntryInfo entryInfo, boolean isPeriodTotal) throws BOSException {
        StringBuffer sb = new StringBuffer();
        sb.append(" SELECT 1 from T_TD_CheckAccountResult ");
        sb.append(" WHERE FCheckAcctID=? and FCheckAcctEntryID=? and FReportID=? and FSheetName=? and Fstate = ?");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{this.checkInfo.getId().toString(), entryInfo.getId().toString(), this.reportInfo.getId().toString(), isPeriodTotal ? this.periodTotalLabel : this.periodLabel, 3});
        try {
            if (rs.next()) {
                return true;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return false;
    }

    private Object[][] getSheetData(Sheet sheet, AccountConfigInfo config) {
        int rowFrom = config.getFillRow() > 0 ? config.getFillRow() - 1 : config.getFillRow();
        int rowTo = sheet.getRows().getMaxIntMark();
        int colFrom = config.getFillColumn() > 0 ? config.getFillColumn() - 1 : config.getFillColumn();
        int colTo = colFrom + config.getEntry().size();
        if (rowTo - rowFrom == 0) {
            return null;
        }
        Object[][] data = new Object[rowTo - rowFrom][colTo - colFrom];
        Object[] rowData = null;
        int columnSize = config.getEntry().size();
        for (int i = rowFrom + 1; i <= rowTo; ++i) {
            rowData = new Object[columnSize];
            for (int j = colFrom; j < colTo; ++j) {
                rowData[j - colFrom] = sheet.getRange(i, j).getValue().getValue();
            }
            data[i - (rowFrom + 1)] = rowData;
        }
        return data;
    }

    private boolean checkDataFormula(int rowIndex, Object[] rowData, String formula, String formulaMask) throws ParserException, EASBizException, BOSException {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("rowIndex", rowIndex);
        param.put("rowData", rowData);
        param.put("configInfo", this.checkInfo.getAccount());
        param.put("filterInfo", this.getFilterInfo(formula, formulaMask));
        return CheckFormulaUtil.computeIfClause(this.ctx, formula, param, null);
    }

    public FilterInfo getFilterInfo(String formula, String formulaMask) throws BOSException, EASBizException {
        FilterInfo filterInfo = new FilterInfo();
        if (!StringUtils.isEmpty((String)formula)) {
            try {
                filterInfo = new FilterInfo(formula);
            }
            catch (ParserException e) {
                throw new BOSException((Throwable)e);
            }
            if (!StringUtils.isEmpty((String)formulaMask)) {
                filterInfo.setMaskString(formulaMask);
            }
        }
        return filterInfo;
    }

    private Book initBook(Context ctx, TaxDraftRecordInfo reportInfo) throws Exception {
        Book book = null;
        book = reportInfo.getData() != null ? reportInfo.getBook() : Book.Manager.getNewBook((String)"Sheet1", (int)3);
        book.setCalculate(false);
        BookProperties p = BookProperties.loadFromBook((Book)book);
        TaxDraftRptPropertyAdapter adapter = new TaxDraftRptPropertyAdapter();
        adapter.initReportProperties((IObjectValue)reportInfo, ctx);
        FormulaDefinition.registerFormulaToBook((Book)book, (ICalculateContextProvider)new ReportCalculateContext(ctx, (IReportPropertyAdapter)adapter, p.getVariables(), (IErrorProvider)p.getErrorProvider(), null));
        return book;
    }
}

