/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.cloud.datamodel.check.processor;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.newrpt.formula.FormulaRuntimeFactory;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.fi.newrpt.formula.ReportCalculateContext;
import com.kingdee.eas.fi.rpt.excelformula.expr.BinaryOperationExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.Expression;
import com.kingdee.eas.fi.rpt.excelformula.expr.FunctionExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.UnaryOperationExpr;
import com.kingdee.eas.tm.td.basedata.TaxItemTypeInfo;
import com.kingdee.eas.tm.td.cloud.GroupCollection;
import com.kingdee.eas.tm.td.cloud.GroupFactory;
import com.kingdee.eas.tm.td.cloud.GroupInfo;
import com.kingdee.eas.tm.td.cloud.OrgGroupCollection;
import com.kingdee.eas.tm.td.cloud.OrgGroupFactory;
import com.kingdee.eas.tm.td.cloud.datamodel.CheckIndexCollection;
import com.kingdee.eas.tm.td.cloud.datamodel.CheckIndexFactory;
import com.kingdee.eas.tm.td.cloud.datamodel.CheckIndexInfo;
import com.kingdee.eas.tm.td.cloud.datamodel.CheckIndexRangeEntryCollection;
import com.kingdee.eas.tm.td.cloud.datamodel.CheckIndexRangeEntryInfo;
import com.kingdee.eas.tm.td.cloud.datamodel.CheckTypeEnum;
import com.kingdee.eas.tm.td.cloud.datamodel.CheckViewCollection;
import com.kingdee.eas.tm.td.cloud.datamodel.CheckViewFactory;
import com.kingdee.eas.tm.td.cloud.datamodel.CheckViewInfo;
import com.kingdee.eas.tm.td.cloud.datamodel.DiffTypeEnum;
import com.kingdee.eas.tm.td.cloud.datamodel.OperateSymbolEnum;
import com.kingdee.eas.tm.td.cloud.datamodel.RiskLevelEnum;
import com.kingdee.eas.tm.td.cloud.datamodel.check.info.CheckResultVo;
import com.kingdee.eas.tm.td.cloud.datamodel.check.info.CheckVo;
import com.kingdee.eas.tm.td.cloud.datamodel.check.info.YearMonthVo;
import com.kingdee.eas.tm.td.cloud.datamodel.check.processor.AbstractCheckProcessor;
import com.kingdee.eas.tm.td.cloud.datamodel.utils.DataModelUtil;
import com.kingdee.eas.tm.td.formula.fillFormula.FillFormulaFactory;
import com.kingdee.eas.tm.td.formula.fillFormula.IFillFormula;
import com.kingdee.eas.tm.td.utils.TaxDraftRptPropertyAdapter;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class CheckIndexProcessor
extends AbstractCheckProcessor {
    @Override
    public Map check(Context ctx, Map params, CheckTypeEnum checkType) throws EASBizException, BOSException {
        Map ret = this.buildCheck(ctx, params);
        List checkList = (List)ret.get("checkList");
        if (checkList == null) {
            return null;
        }
        CheckVo checkVo = null;
        HashMap<String, CheckResultVo> checkResultMap = new HashMap<String, CheckResultVo>();
        CheckResultVo resultVo = null;
        FormulaRuntimeFactory.FormulaRuntimeEnv formulaRuntimeEnv = null;
        boolean hasCheck = false;
        int size = checkList.size();
        for (int i = 0; i < size; ++i) {
            hasCheck = true;
            checkVo = (CheckVo)checkList.get(i);
            resultVo = new CheckResultVo(checkVo);
            checkVo.paserFormula(ctx);
            checkResultMap.put(checkVo.getId(), resultVo);
            if (formulaRuntimeEnv == null) {
                formulaRuntimeEnv = this.getCalculateFormulaRuntimeEnv(ctx);
            }
            this.fillFormulaParameter(ctx, checkVo);
            Sheet calculateSheet = formulaRuntimeEnv.getCalculateSheet();
            int row = calculateSheet.getMaxRowIndex() + 1;
            this.fillFormulaIntoCalculateBook(ctx, calculateSheet, row, checkVo);
        }
        if (hasCheck) {
            formulaRuntimeEnv.getCalculateBook().calc();
            Sheet sheet = formulaRuntimeEnv.getCalculateSheet();
            for (int row = 0; row <= sheet.getMaxRowIndex(); ++row) {
                this.compareCalculateValue(checkResultMap, sheet, row);
            }
            this.writeCheckResultRecord(ctx, checkResultMap, checkType);
        }
        return checkResultMap;
    }

    public void fillFormulaParameter(Context ctx, CheckVo checkVo) {
        Map ret = this.processFormulaExpression(ctx, checkVo.getlExpression(), checkVo);
        Expression lExpression = (Expression)ret.get("expression");
        String lExpressionDesc = (String)ret.get("expressionDesc");
        ret = this.processFormulaExpression(ctx, checkVo.getrExpression(), checkVo);
        Expression rExpression = (Expression)ret.get("expression");
        String rExpressionDesc = (String)ret.get("expressionDesc");
        checkVo.setlExpression(lExpression);
        checkVo.setrExpression(rExpression);
        checkVo.setlValueDesc(lExpressionDesc);
        checkVo.setrValueDesc(rExpressionDesc);
    }

    @Override
    public void fillFormulaIntoCalculateBook(Context ctx, Sheet calculateSheet, int row, CheckVo checkVo) throws EASBizException, BOSException {
        super.fillFormulaIntoCalculateBook(ctx, calculateSheet, row, checkVo);
        if (checkVo.getlExpression() != null) {
            String lformula = checkVo.getlExpression().toString();
            calculateSheet.getRange(row, 1).setFormula("=" + lformula);
        }
        if (checkVo.getrExpression() != null) {
            String rformula = checkVo.getrExpression().toString();
            calculateSheet.getRange(row, 2).setFormula("=" + rformula);
        }
    }

    protected Map processFormulaExpression(Context ctx, Expression expression, CheckVo checkVo) {
        Expression expr;
        String expressionDesc = null;
        if (expression instanceof FunctionExpr) {
            FunctionExpr functionExpr = (FunctionExpr)expression;
            IFillFormula fillFormula = FillFormulaFactory.getFillFormula(functionExpr.funcionName);
            expression = fillFormula.fillFormulaParameter(ctx, (FunctionExpr)expression, checkVo);
            expressionDesc = fillFormula.getFormulaDescription(ctx, (FunctionExpr)expression);
        } else if (expression instanceof BinaryOperationExpr) {
            ((BinaryOperationExpr)expression).left = expr = (Expression)this.processFormulaExpression(ctx, ((BinaryOperationExpr)expression).left, checkVo).get("expression");
            ((BinaryOperationExpr)expression).right = expr = (Expression)this.processFormulaExpression(ctx, ((BinaryOperationExpr)expression).right, checkVo).get("expression");
        } else if (expression instanceof UnaryOperationExpr) {
            ((UnaryOperationExpr)expression).operand = expr = (Expression)this.processFormulaExpression(ctx, ((UnaryOperationExpr)expression).operand, checkVo).get("expression");
        }
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ret.put("expression", expression);
        ret.put("expressionDesc", expressionDesc);
        return ret;
    }

    private ICalculateContextProvider getCalculateContextProvider(Context ctx) throws BOSException {
        ReportCalculateContext calcContext = new ReportCalculateContext(ctx);
        TaxDraftRptPropertyAdapter adapter = new TaxDraftRptPropertyAdapter();
        calcContext.setReportAdapter((IReportPropertyAdapter)adapter);
        return calcContext;
    }

    private FormulaRuntimeFactory.FormulaRuntimeEnv getCalculateFormulaRuntimeEnv(Context ctx) throws EASBizException, BOSException {
        FormulaRuntimeFactory.FormulaRuntimeEnv formulaRuntimeEnv = null;
        try {
            ICalculateContextProvider calculateContextProvider = this.getCalculateContextProvider(ctx);
            formulaRuntimeEnv = FormulaRuntimeFactory.getInstance().getFormulaRuntime(calculateContextProvider);
        }
        catch (Exception ex) {
            throw new BOSException("init formula runtime error", (Throwable)ex);
        }
        return formulaRuntimeEnv;
    }

    @Override
    public CheckTypeEnum getCheckType() {
        return CheckTypeEnum.TAXINDEX;
    }

    public Map buildCheck(Context ctx, Map params) throws EASBizException, BOSException {
        int yearFrom = (Integer)params.get("spYearFrom");
        int monthFrom = (Integer)params.get("spMonthFrom");
        int yearTo = (Integer)params.get("spYearTo");
        int monthTo = (Integer)params.get("spMonthTo");
        Object[] companys = (Object[])params.get("companys");
        GroupInfo group = (GroupInfo)params.get("group");
        TaxItemTypeInfo taxType = (TaxItemTypeInfo)params.get("taxType");
        Object[] indexes = (Object[])params.get("indexes");
        HashMap ret = new HashMap();
        CompanyOrgUnitCollection companyColl = this.getCompanys(ctx, companys, group);
        CheckIndexCollection indexColl = this.getIndexes(ctx, taxType, indexes);
        List<YearMonthVo> rangePeriod = DataModelUtil.getRangePeriod(yearFrom, monthFrom, yearTo, monthTo);
        Map checkViewMap = this.getCheckViewMap(ctx, indexColl);
        if (companyColl.size() == 0 || indexColl.size() == 0) {
            return ret;
        }
        CompanyOrgUnitInfo companyInfo2 = null;
        ArrayList<CheckVo> checkList = new ArrayList<CheckVo>();
        CheckIndexInfo indexInfo = null;
        for (CompanyOrgUnitInfo companyInfo2 : companyColl) {
            for (YearMonthVo periodYear : rangePeriod) {
                int size = indexColl.size();
                for (int i = 0; i < size; ++i) {
                    indexInfo = indexColl.get(i);
                    String key = companyInfo2.getId().toString() + "-" + indexInfo.getId().toString();
                    if (!checkViewMap.containsKey(key)) continue;
                    CheckVo vo = new CheckVo();
                    vo.setCheckInfo(indexInfo);
                    vo.setCompany(companyInfo2);
                    vo.setTaxType(indexInfo.getTaxType());
                    vo.setYear(periodYear.getYear());
                    vo.setMonth(periodYear.getMonth());
                    checkList.add(vo);
                }
            }
        }
        ret.put("checkList", checkList);
        return ret;
    }

    private Map getCheckViewMap(Context ctx, CheckIndexCollection indexes) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("checkType", (Object)"2", CompareType.EQUALS));
        if (indexes != null && indexes.size() > 0) {
            HashSet<String> indexIds = new HashSet<String>();
            CheckIndexInfo indexInfo = null;
            int size = indexes.size();
            for (int i = 0; i < size; ++i) {
                indexInfo = indexes.get(i);
                indexIds.add(indexInfo.getId().toString());
            }
            filter.getFilterItems().add(new FilterItemInfo("index.id", indexIds, CompareType.INCLUDE));
        }
        filter.getFilterItems().add(new FilterItemInfo("index.state", (Object)0, CompareType.EQUALS));
        view.setFilter(filter);
        CheckViewCollection viewColl = CheckViewFactory.getLocalInstance(ctx).getCheckViewCollection(view);
        HashMap<String, Boolean> ret = new HashMap<String, Boolean>();
        CheckViewInfo viewInfo = null;
        int size = viewColl.size();
        for (int i = 0; i < size; ++i) {
            viewInfo = viewColl.get(i);
            ret.put(viewInfo.getCompany().getId().toString() + "-" + viewInfo.getIndex().getId().toString(), true);
        }
        return ret;
    }

    private CheckIndexCollection getIndexes(Context ctx, TaxItemTypeInfo taxType, Object[] indexes) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (indexes != null && indexes.length > 0) {
            HashSet<String> indexIds = new HashSet<String>();
            CheckIndexInfo indexInfo = null;
            int size = indexes.length;
            for (int i = 0; i < size; ++i) {
                indexInfo = (CheckIndexInfo)indexes[i];
                indexIds.add(indexInfo.getId().toString());
            }
            filter.getFilterItems().add(new FilterItemInfo("id", indexIds, CompareType.INCLUDE));
        }
        if (taxType != null) {
            filter.getFilterItems().add(new FilterItemInfo("taxType.id", (Object)taxType.getId().toString(), CompareType.EQUALS));
        }
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)0, CompareType.EQUALS));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("rangeEntry.*"));
        sic.add(new SelectorItemInfo("taxType.*"));
        view.setSelector(sic);
        CheckIndexCollection indexColl = CheckIndexFactory.getLocalInstance(ctx).getCheckIndexCollection(view);
        return indexColl;
    }

    private CompanyOrgUnitCollection getCompanys(Context ctx, Object[] companys, GroupInfo group) throws BOSException {
        int i;
        int size;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (companys != null && companys.length > 0) {
            HashSet<String> companyIds = new HashSet<String>();
            CompanyOrgUnitInfo companyInfo = null;
            size = companys.length;
            for (i = 0; i < size; ++i) {
                companyInfo = (CompanyOrgUnitInfo)companys[i];
                companyIds.add(companyInfo.getId().toString());
            }
            filter.getFilterItems().add(new FilterItemInfo("company.id", companyIds, CompareType.INCLUDE));
        } else {
            GroupCollection groupColl = GroupFactory.getLocalInstance(ctx).getGroupCollection(" where longNumber like '" + group.getLongNumber() + "%'");
            HashSet<String> groupIncludeChildrenIds = new HashSet<String>();
            size = groupColl.size();
            for (i = 0; i < size; ++i) {
                groupIncludeChildrenIds.add(groupColl.get(i).getId().toString());
            }
            filter.getFilterItems().add(new FilterItemInfo("group.id", groupIncludeChildrenIds, CompareType.INCLUDE));
        }
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("group.id"));
        sic.add(new SelectorItemInfo("group.longNumber"));
        sic.add(new SelectorItemInfo("group.level"));
        view.setSelector(sic);
        OrgGroupCollection orgGroupColl = OrgGroupFactory.getLocalInstance(ctx).getOrgGroupCollection(view);
        CompanyOrgUnitCollection orgColl = new CompanyOrgUnitCollection();
        int size2 = orgGroupColl.size();
        for (int i2 = 0; i2 < size2; ++i2) {
            orgColl.add(orgGroupColl.get(i2).getCompany());
        }
        return orgColl;
    }

    public void compareCalculateValue(Map checkResultMap, Sheet calculateSheet, int row) throws EASBizException, BOSException {
        CheckVo check = (CheckVo)calculateSheet.getRange(row, 6).getValue().getValue();
        String id = check.getId().toString();
        CheckIndexInfo checkInfo = (CheckIndexInfo)check.getCheckInfo();
        Variant objLValue = calculateSheet.getRange(row, 1).getValue();
        Object lValue = this.getCalculateValue(check, objLValue, checkInfo.getLFormula(), true);
        check.setlValue(lValue);
        Variant objRValue = calculateSheet.getRange(row, 2).getValue();
        Object rValue = this.getCalculateValue(check, objRValue, checkInfo.getRFormula(), false);
        check.setrValue(rValue);
        CheckIndexRangeEntryCollection entry = checkInfo.getRangeEntry();
        OperateSymbolEnum operateSymbol = checkInfo.getOperateSymbol();
        CheckResultVo checkResult = (CheckResultVo)checkResultMap.get(id);
        if (!check.isAvailable()) {
            check.setCheckResultCode(2);
            checkResult.getErrorCheckList().add(check);
            checkResult.setFailCheckResultCode();
            return;
        }
        BigDecimal bdLeftValue = (BigDecimal)lValue;
        BigDecimal bdRightValue = (BigDecimal)rValue;
        check.setRange(bdRightValue.subtract(bdLeftValue).abs());
        CheckIndexRangeEntryInfo entryInfo = null;
        CheckIndexRangeEntryInfo normalEntryInfo = null;
        int size = entry.size();
        for (int i = 0; i < size; ++i) {
            entryInfo = entry.get(i);
            if (!RiskLevelEnum.Level0.equals((Object)entryInfo.getRiskLevel())) continue;
            normalEntryInfo = entryInfo;
            break;
        }
        BigDecimal rangeFrom = null;
        BigDecimal rangeTo = null;
        BigDecimal range = null;
        int size2 = entry.size();
        for (int i = 0; i < size2; ++i) {
            entryInfo = entry.get(i);
            range = entryInfo.getRange();
            if (range != null && DiffTypeEnum.STANDARDPERENT.equals((Object)checkInfo.getRangeType())) {
                range = range.divide(new BigDecimal(100), 5, 4);
            }
            rangeTo = range;
            if (OperateSymbolEnum.EQUAL.equals((Object)operateSymbol)) {
                if (this.isComparePass(lValue, rValue, rangeFrom, rangeTo)) {
                    check.setRiskLevel(entryInfo.getRiskLevel());
                    if (RiskLevelEnum.Level0.equals((Object)entryInfo.getRiskLevel())) {
                        check.setCheckResultCode(1);
                        checkResult.setPassCheckResultCode();
                        break;
                    }
                    check.setCheckResultCode(2);
                    checkResult.setFailCheckResultCode();
                    break;
                }
            } else {
                if (normalEntryInfo != null) {
                    range = normalEntryInfo.getRange();
                }
                if (range != null && DiffTypeEnum.STANDARDPERENT.equals((Object)checkInfo.getRangeType())) {
                    range = range.divide(new BigDecimal(100), 5, 4);
                }
                if (RiskLevelEnum.Level0.equals((Object)entryInfo.getRiskLevel())) {
                    if (this.isComparePass(lValue, rValue, operateSymbol, range)) {
                        check.setRiskLevel(entryInfo.getRiskLevel());
                        check.setCheckResultCode(1);
                        checkResult.setPassCheckResultCode();
                    }
                } else if (!this.isComparePass(lValue, rValue, operateSymbol, range)) {
                    check.setRiskLevel(entryInfo.getRiskLevel());
                    check.setCheckResultCode(2);
                    checkResult.setFailCheckResultCode();
                }
            }
            rangeFrom = range;
        }
    }

    protected boolean isComparePass(Object left, Object right, BigDecimal rangeFrom, BigDecimal rangeTo) {
        if (rangeFrom != null && rangeTo != null) {
            return this.isIndexComparePass(left, right, OperateSymbolEnum.MORE, rangeFrom) && this.isIndexComparePass(left, right, OperateSymbolEnum.LESSANDEQUAL, rangeTo);
        }
        if (rangeFrom != null) {
            return this.isIndexComparePass(left, right, OperateSymbolEnum.MORE, rangeFrom);
        }
        if (rangeTo != null) {
            return this.isIndexComparePass(left, right, OperateSymbolEnum.LESSANDEQUAL, rangeTo);
        }
        return false;
    }

    public void writeCheckResultRecord(Context ctx, Map checkResultMap, CheckTypeEnum checkType) throws EASBizException, BOSException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pstmt = conn.prepareStatement(this.getCheckResultInsertSQL());
            CheckResultVo checkResult = null;
            CheckVo check = null;
            String riskLevel = null;
            int state = -1;
            ArrayList<Object[]> updateParamsList = new ArrayList<Object[]>();
            for (Map.Entry entry : checkResultMap.entrySet()) {
                checkResult = (CheckResultVo)entry.getValue();
                check = checkResult.getCheck();
                if (check.getRiskLevel() != null) {
                    riskLevel = check.getRiskLevel().getValue();
                }
                if (check.getlValue() == null) {
                    riskLevel = null;
                }
                if (3 == (state = this.isExists(ctx, check))) continue;
                if (state > 0) {
                    Object[] updateParams = new Object[]{check.getlValue(), check.getrValue(), check.getRange(), riskLevel, check.getCheckResultState().getValue(), check.getDescription(), timestamp, check.getlValueDesc(), check.getrValueDesc(), check.getCompany().getId().toString(), check.getTaxType().getId().toString(), this.getCheckType().getValue(), check.getCheckInfo().getId().toString(), check.getYear(), check.getMonth()};
                    updateParamsList.add(updateParams);
                    continue;
                }
                pstmt.setString(1, BOSUuid.create((String)"086D8622").toString());
                pstmt.setString(2, check.getCompany().getId().toString());
                pstmt.setString(3, check.getTaxType().getId().toString());
                pstmt.setString(4, null);
                pstmt.setString(5, this.getCheckType().getValue());
                pstmt.setString(6, null);
                pstmt.setObject(7, check.getCheckInfo().getId().toString());
                pstmt.setInt(8, check.getCheckResultState().getValue());
                pstmt.setString(9, riskLevel);
                pstmt.setBigDecimal(10, (BigDecimal)check.getlValue());
                pstmt.setBigDecimal(11, (BigDecimal)check.getrValue());
                pstmt.setBigDecimal(12, check.getRange());
                pstmt.setString(13, null);
                pstmt.setString(14, null);
                pstmt.setInt(15, check.getYear());
                pstmt.setInt(16, check.getMonth());
                pstmt.setTimestamp(17, timestamp);
                pstmt.setString(18, check.getDescription());
                pstmt.setString(19, check.getCheckInfo().getDescription());
                pstmt.setInt(20, check.getCheckInfo().getRangeType().getValue());
                pstmt.setString(21, check.getlValueDesc());
                pstmt.setString(22, check.getrValueDesc());
                pstmt.addBatch();
            }
            pstmt.executeBatch();
            if (updateParamsList.size() > 0) {
                StringBuffer sql = new StringBuffer();
                sql.append(" update T_TD_CheckResult set FLValue=?,FRValue=?,FRange=?,FRiskLevel=?,FState=?,FDescription=?,FCreateTime=?,");
                sql.append(" FLValueDesc=?,FRValueDesc=? ");
                sql.append(" WHERE FCompanyID=? and FTaxTypeID=? and FCheckType=? and FIndexID=? and FYear =? and FMonth=?");
                DbUtil.executeBatch((Context)ctx, (String)sql.toString(), updateParamsList);
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException(e.getMessage());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    private int isExists(Context ctx, CheckVo check) throws BOSException, SQLException {
        int state = -1;
        StringBuffer sb = new StringBuffer();
        sb.append(" SELECT FState from T_TD_CheckResult ");
        sb.append(" WHERE FCompanyID=? and FTaxTypeID=? and FCheckType=? and FIndexID=? and FYear =? and FMonth=?");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new Object[]{check.getCompany().getId().toString(), check.getTaxType().getId().toString(), this.getCheckType().getValue(), check.getCheckInfo().getId().toString(), check.getYear(), check.getMonth()});
        if (rs.next()) {
            state = rs.getInt("FState");
        }
        return state;
    }
}

