/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.cloud.datamodel.client;

import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.cloud.EnableStateEnum;
import com.kingdee.eas.tm.td.cloud.MaterialType;
import com.kingdee.eas.tm.td.cloud.TaxArchiveType;
import com.kingdee.eas.tm.td.cloud.companyType;
import com.kingdee.eas.tm.td.cloud.datamodel.ArchiveUrlFactory;
import com.kingdee.eas.tm.td.cloud.datamodel.ArchiveUrlInfo;
import com.kingdee.eas.tm.td.cloud.datamodel.client.AbstractArchiveUrlEditUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class ArchiveUrlEditUI
extends AbstractArchiveUrlEditUI {
    private static final Logger logger = CoreUIObject.getLogger(ArchiveUrlEditUI.class);
    private static final String TDRESOURCE = "com.kingdee.eas.tm.td.cloud.TDCloudResource";

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initEnumItem();
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.initBtnStatus();
    }

    @Override
    public void comboArchiveType_itemStateChanged(ItemEvent e) {
        if (e.getItem().equals(this.comboArchiveType.getSelectedItem())) {
            return;
        }
        this.comboCompanyType.setSelectedItem((Object)"");
        this.comboMaterialType.setSelectedItem((Object)"");
        this.initEnumItem();
    }

    private void initEnumItem() {
        Object companytype = this.comboCompanyType.getSelectedItem();
        Object materialtype = this.comboMaterialType.getSelectedItem();
        if (this.comboCompanyType.getSelectedItem() != null || this.comboMaterialType.getSelectedItem() != null) {
            // empty if block
        }
        this.comboCompanyType.removeAllItems();
        this.comboMaterialType.removeAllItems();
        if (TaxArchiveType.BASEINFO.equals(this.comboArchiveType.getSelectedItem())) {
            this.comboMaterialType.addItem((Object)"");
            this.comboMaterialType.addItem((Object)MaterialType.buslicense);
            this.comboMaterialType.addItem((Object)MaterialType.taxgrade);
            this.comboMaterialType.addItem((Object)MaterialType.orgcode);
            this.comboMaterialType.addItem((Object)MaterialType.registration);
            this.comboMaterialType.addItem((Object)MaterialType.socialinsurance);
        } else if (TaxArchiveType.BANKACCOUNT.equals(this.comboArchiveType.getSelectedItem())) {
            this.comboMaterialType.addItem((Object)"");
            this.comboMaterialType.addItem((Object)MaterialType.accprintscreenprove);
        } else if (TaxArchiveType.QUALIFICATION.equals(this.comboArchiveType.getSelectedItem())) {
            this.comboMaterialType.addItem((Object)"");
            this.comboMaterialType.addItem((Object)MaterialType.certificate);
            this.comboMaterialType.addItem((Object)MaterialType.applicatematerial);
            this.comboMaterialType.addItem((Object)MaterialType.qualificateupdatematerial);
            this.comboCompanyType.addItem((Object)"");
            this.comboCompanyType.addItem((Object)companyType.JS);
            this.comboCompanyType.addItem((Object)companyType.KJ);
            this.comboCompanyType.addItem((Object)companyType.GX);
        }
        this.comboCompanyType.setSelectedItem(companytype);
        this.comboMaterialType.setSelectedItem(materialtype);
    }

    private void initBtnStatus() {
        if (this.editData.getId() == null) {
            this.btnCancel.setEnabled(false);
            this.btnCancelCancel.setEnabled(false);
            this.menuItemCancelCancel.setEnabled(false);
            this.menuItemCancel.setEnabled(false);
            return;
        }
        if (this.editData.getState().equals((Object)EnableStateEnum.ENABLE)) {
            this.btnRemove.setEnabled(false);
            this.btnCancel.setEnabled(true);
            this.btnCancelCancel.setEnabled(false);
            this.menuItemCancel.setEnabled(true);
            this.menuItemCancelCancel.setEnabled(false);
            this.btnEdit.setEnabled(false);
        } else {
            this.btnRemove.setEnabled(true);
            this.btnCancel.setEnabled(false);
            this.btnCancelCancel.setEnabled(true);
            this.menuItemCancel.setEnabled(false);
            this.menuItemCancelCancel.setEnabled(true);
            this.btnEdit.setEnabled(true);
        }
    }

    private void refresh(IObjectPK pk) throws Exception {
        this.setDataObject(this.getValue(pk));
        this.loadFields();
        this.initOldData((IObjectValue)this.editData);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemove_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        this.initBtnStatus();
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.inputCheck();
        super.actionSave_actionPerformed(e);
        super.actionSubmit_actionPerformed(e);
        this.setOprtState("VIEW");
        if (this.editData != null && this.editData.getId() != null) {
            String billId = this.editData.getId().toString();
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)billId));
            this.refresh((IObjectPK)pk);
        }
    }

    private void inputCheck() {
        StringBuffer sb = new StringBuffer();
        if (this.txtNumber.getText().isEmpty()) {
            sb.append("\u3001" + this.txtNumber.getBoundLabelText());
        }
        if (this.txtName.getText().isEmpty()) {
            sb.append("\u3001" + this.contName.getBoundLabelText());
        }
        if (this.comboArchiveType.getSelectedItem() == null) {
            sb.append("\u3001" + this.comboArchiveType.getBoundLabelText());
        }
        if (sb.length() > 0) {
            sb.append(TDUtils.getString("com.kingdee.eas.tm.td.basedata.TaxBaseResource", "Data_NotNull", TDUtils.getLocale())).append("\r\n");
            MsgBox.showWarning((String)sb.substring(1));
            SysUtil.abort();
        }
        try {
            if (this.remark.getText().length() > 1024) {
                sb.append(EASResource.getString((String)TDRESOURCE, (String)"REMARK"));
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        if (sb.length() > 0) {
            sb.append(EASResource.getString((String)TDRESOURCE, (String)"OVER_LENGTH"));
            MsgBox.showWarning((String)sb.substring(1));
            SysUtil.abort();
        }
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        String billId = this.editData.getId().toString();
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(billId);
        ArrayList errors = ArchiveUrlFactory.getRemoteInstance().cancelCancel(new HashSet(ids));
        if (errors.size() > 0) {
            MsgBox.showWarning((Component)((Object)this), (String)((String)errors.get(0)));
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Startup_OK"));
            this.setOprtState("VIEW");
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)billId));
            this.refresh((IObjectPK)pk);
        }
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        String billId = this.editData.getId().toString();
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(billId);
        ArrayList errors = ArchiveUrlFactory.getRemoteInstance().cancel(new HashSet(ids));
        if (errors.size() > 0) {
            MsgBox.showWarning((Component)((Object)this), (String)((String)errors.get(0)));
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Forbid _OK"));
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)billId));
            this.refresh((IObjectPK)pk);
        }
    }

    protected void setFieldsNull(AbstractObjectValue newData) {
        ArchiveUrlInfo editData = (ArchiveUrlInfo)newData;
        editData.setNumber(null);
        editData.setState(EnableStateEnum.ENABLE);
    }

    protected ICoreBase getBizInterface() throws Exception {
        return ArchiveUrlFactory.getRemoteInstance();
    }

    protected IObjectValue createNewData() {
        ArchiveUrlInfo info = new ArchiveUrlInfo();
        info.setState(EnableStateEnum.ENABLE);
        Date date = new Date();
        info.setCreateTime(new Timestamp(date.getTime()));
        info.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
        info.setArchiveType(TaxArchiveType.BASEINFO);
        info.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        return info;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.ControlUnit;
    }
}

