/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.cloud.datamodel.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.Util;
import com.kingdee.eas.basedata.common.perf.client.JobMonitorManager;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.basedata.TaxItemTypeInfo;
import com.kingdee.eas.tm.td.cloud.GroupCollection;
import com.kingdee.eas.tm.td.cloud.GroupFactory;
import com.kingdee.eas.tm.td.cloud.GroupInfo;
import com.kingdee.eas.tm.td.cloud.OrgGroupCollection;
import com.kingdee.eas.tm.td.cloud.OrgGroupFactory;
import com.kingdee.eas.tm.td.cloud.OrgGroupInfo;
import com.kingdee.eas.tm.td.cloud.datamodel.IndexCalculateFacadeFactory;
import com.kingdee.eas.tm.td.cloud.datamodel.client.AbstractCheckIndexCalculateUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class CheckIndexCalculateUI
extends AbstractCheckIndexCalculateUI {
    private static final Logger logger = CoreUIObject.getLogger(CheckIndexCalculateUI.class);
    private DataChangeListener prmtGroupListener = null;
    private DataChangeListener prmtTaxTypeListenr = null;

    @Override
    public void loadFields() {
        this.removeListener();
        super.loadFields();
        this.initListeners();
        this.initIndexFilter();
    }

    private void removeListener() {
        if (this.prmtGroupListener != null) {
            this.prmtGroup.removeDataChangeListener(this.prmtGroupListener);
        }
        if (this.prmtTaxTypeListenr != null) {
            this.prmtTaxType.removeDataChangeListener(this.prmtTaxTypeListenr);
        }
    }

    private void initListeners() {
        if (this.prmtGroupListener == null) {
            this.prmtGroupListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent eventObj) {
                    try {
                        CheckIndexCalculateUI.this.prmtCompanyOrg.setValue(null);
                        CheckIndexCalculateUI.this.initCompanyFilter();
                    }
                    catch (BOSException e) {
                        CheckIndexCalculateUI.this.handUIException(e);
                    }
                }
            };
        }
        this.prmtGroup.addDataChangeListener(this.prmtGroupListener);
        if (this.prmtTaxTypeListenr == null) {
            this.prmtTaxTypeListenr = new DataChangeListener(){

                public void dataChanged(DataChangeEvent eventObj) {
                    try {
                        CheckIndexCalculateUI.this.prmtCheckIndex.setValue(null);
                        CheckIndexCalculateUI.this.initIndexFilter();
                    }
                    catch (Exception e) {
                        CheckIndexCalculateUI.this.handUIException(e);
                    }
                }
            };
        }
        this.prmtTaxType.addDataChangeListener(this.prmtTaxTypeListenr);
    }

    private void initCompanyFilter() throws BOSException {
        if (this.prmtGroup.getValue() == null) {
            return;
        }
        GroupInfo group = (GroupInfo)this.prmtGroup.getValue();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        GroupCollection groupColl = GroupFactory.getRemoteInstance().getGroupCollection(" where longNumber like '" + group.getLongNumber() + "%'");
        HashSet<String> groupIncludeChildrenIds = new HashSet<String>();
        int size = groupColl.size();
        for (int i = 0; i < size; ++i) {
            groupIncludeChildrenIds.add(groupColl.get(i).getId().toString());
        }
        filter.getFilterItems().add(new FilterItemInfo("group.id", groupIncludeChildrenIds, CompareType.INCLUDE));
        view.setFilter(filter);
        OrgGroupCollection coll = OrgGroupFactory.getRemoteInstance().getOrgGroupCollection(view);
        OrgGroupInfo orgGroupInfo = null;
        HashSet<String> orgIds = new HashSet<String>();
        for (int i = 0; i < coll.size(); ++i) {
            orgGroupInfo = coll.get(i);
            orgIds.add(orgGroupInfo.getCompany().getId().toString());
        }
        view = new EntityViewInfo();
        filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", orgIds, CompareType.INCLUDE));
        view.setFilter(filter);
        this.prmtCompanyOrg.setEntityViewInfo(view);
    }

    protected void initIndexFilter() {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (this.prmtTaxType.getValue() != null) {
            TaxItemTypeInfo taxType = (TaxItemTypeInfo)this.prmtTaxType.getValue();
            filter.getFilterItems().add(new FilterItemInfo("taxType.id", (Object)taxType.getId().toString(), CompareType.EQUALS));
        }
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)0, CompareType.EQUALS));
        view.setFilter(filter);
        this.prmtCheckIndex.setEntityViewInfo(view);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.prmtCompanyOrg.setEnabledMultiSelection(true);
        this.prmtCheckIndex.setEnabledMultiSelection(true);
        this.loadFields();
        this.setDefaultValue();
    }

    protected void setDefaultValue() {
        Calendar cale = Calendar.getInstance();
        int year = cale.get(1);
        int month = cale.get(2) + 1;
        this.spinBeginYear.setValue((Object)year);
        this.spinEndYear.setValue((Object)year);
        this.spinBeginPeriod.setValue((Object)month);
        this.spinEndPeriod.setValue((Object)month);
        this.prmtGroup.setValue(null);
        this.prmtCompanyOrg.setValue(null);
        this.prmtTaxType.setValue(null);
        this.prmtCheckIndex.setValue(null);
    }

    public void clear() {
        this.setDefaultValue();
    }

    private Object[] getValues(KDBizPromptBox box) {
        Object[] values = null;
        IObjectValue value = null;
        if (box.getValue() instanceof IObjectValue) {
            value = (IObjectValue)box.getValue();
            if (value != null) {
                values = new Object[]{value};
            }
        } else {
            ArrayList<Object> arrList = new ArrayList<Object>();
            Object[] arrs = (Object[])box.getValue();
            if (arrs == null) {
                return null;
            }
            int size = arrs.length;
            for (int i = 0; i < size; ++i) {
                if (arrs[i] == null) continue;
                arrList.add(arrs[i]);
            }
            if (arrList.size() > 0) {
                values = arrList.toArray();
            }
        }
        return values;
    }

    @Override
    public void actionCalculate_actionPerformed(ActionEvent e) throws Exception {
        this.checkRequireFields();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("spYearFrom", this.spinBeginYear.getValue());
        params.put("spMonthFrom", this.spinBeginPeriod.getValue());
        params.put("spYearTo", this.spinEndYear.getValue());
        params.put("spMonthTo", this.spinEndPeriod.getValue());
        params.put("companys", this.getValues(this.prmtCompanyOrg));
        params.put("group", this.prmtGroup.getValue());
        params.put("taxType", this.prmtTaxType.getValue());
        params.put("indexes", this.getValues(this.prmtCheckIndex));
        Map jobMap = IndexCalculateFacadeFactory.getRemoteInstance().calculateIndex(params);
        String jobInstExtId = (String)jobMap.get("jobInstExtId");
        if (jobInstExtId != null) {
            JobMonitorManager.getInstance().addMonitorInfo(jobInstExtId, (String)jobMap.get("title"));
        }
        Util.getWindow((Component)this.getCommonQueryPanel()).dispose();
        MsgBox.showInfo((String)TDUtils.getString("com.kingdee.eas.tm.td.est.ESTResource", "Msg_AddJob", this.getLocale()));
    }

    private void checkRequireFields() {
        if (this.prmtGroup.getValue() == null) {
            MsgBox.showInfo((String)"\u5206\u7ec4\u4e0d\u80fd\u4e3a\u7a7a");
            SysUtil.abort();
        }
    }

    public RptParams getCustomCondition() {
        RptParams pp = new RptParams();
        pp.setObject("spYearFrom", this.spinBeginYear.getValue());
        pp.setObject("spMonthFrom", this.spinBeginPeriod.getValue());
        pp.setObject("spYearTo", this.spinEndYear.getValue());
        pp.setObject("spMonthTo", this.spinEndPeriod.getValue());
        pp.setObject("companys", this.prmtCompanyOrg.getValue());
        pp.setObject("group", this.prmtGroup.getValue());
        pp.setObject("taxType", this.prmtTaxType.getValue());
        pp.setObject("indexes", this.prmtCheckIndex.getValue());
        return pp;
    }

    public void setCustomCondition(RptParams params) {
        if (params.getObject("spYearFrom") != null) {
            this.spinBeginYear.setValue(params.getObject("spYearFrom"));
        }
        if (params.getObject("spMonthFrom") != null) {
            this.spinBeginPeriod.setValue(params.getObject("spMonthFrom"));
        }
        if (params.getObject("spYearTo") != null) {
            this.spinEndYear.setValue(params.getObject("spYearTo"));
        }
        if (params.getObject("spMonthTo") != null) {
            this.spinEndPeriod.setValue(params.getObject("spMonthTo"));
        }
        this.prmtGroup.setValue(params.getObject("group"));
        this.prmtCompanyOrg.setValue(params.getObject("companys"));
        this.prmtTaxType.setValue(params.getObject("taxType"));
        this.prmtCheckIndex.setValue(params.getObject("indexes"));
    }

    public void onInit(RptParams arg0) throws Exception {
    }
}

