/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.cloud.datamodel.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tm.td.cloud.datamodel.CheckBaseInfo;
import com.kingdee.eas.tm.td.cloud.datamodel.CheckIndexFactory;
import com.kingdee.eas.tm.td.cloud.datamodel.CheckIndexInfo;
import com.kingdee.eas.tm.td.cloud.datamodel.CheckItemFactory;
import com.kingdee.eas.tm.td.cloud.datamodel.CheckItemInfo;
import com.kingdee.eas.tm.td.cloud.datamodel.CheckTypeEnum;
import com.kingdee.eas.tm.td.cloud.datamodel.CheckViewFactory;
import com.kingdee.eas.tm.td.cloud.datamodel.client.AbstractCheckViewListUI;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;
import java.util.Map;
import org.apache.log4j.Logger;

public class CheckViewListUI
extends AbstractCheckViewListUI {
    private static final Logger logger = CoreUIObject.getLogger(CheckViewListUI.class);
    public static final String TBL_COMPANYNUMBER = "company.number";
    public static final String TBL_COMPANYNAME = "company.name";
    public static final String TBL_CODE = "company.code";
    public static final String[] companyView = new String[]{"company.number", "company.name", "company.code"};
    public static final String TBL_INDEXNUMBER = "index.number";
    public static final String TBL_INDEXNAME = "index.name";
    public static final String TBL_INDEXTAXTYPE = "taxType.name";
    public static final String TBL_INDEXTYPE = "indexType.name";
    public static final String TBL_INDEXSTATE = "index.state";
    public static final String[] indexView = new String[]{"index.number", "index.name", "taxType.name", "indexType.name", "index.state"};
    public static final String TBL_ITEMNUMBER = "item.number";
    public static final String TBL_ITEMNAME = "item.name";
    public static final String TBL_ITEMTAXTYPE = "taxType1.name";
    public static final String TBL_ITEMSTATE = "item.state";
    public static final String[] itemView = new String[]{"item.number", "item.name", "taxType1.name", "item.state"};
    private CheckTypeEnum checkType = null;
    private int viewType = -1;
    private DataChangeListener prmtCompanyListener = null;
    private DataChangeListener prmtItemListener = null;
    private DataChangeListener prmtIndexListener = null;
    private FilterInfo filterInfo = null;

    @Override
    public void loadFields() {
        this.removeListener();
        super.loadFields();
        this.initListeners();
    }

    private void removeListener() {
        if (this.prmtCompanyListener != null) {
            this.prmtCompany.removeDataChangeListener(this.prmtCompanyListener);
        }
        if (this.prmtItemListener != null) {
            this.prmtItem.removeDataChangeListener(this.prmtItemListener);
        }
        if (this.prmtIndexListener != null) {
            this.prmtIndex.removeDataChangeListener(this.prmtIndexListener);
        }
    }

    private void initListeners() {
        if (this.prmtCompanyListener == null) {
            this.prmtCompanyListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent e) {
                    try {
                        CheckViewListUI.this.companyChange(e);
                    }
                    catch (Exception ex) {
                        CheckViewListUI.this.handUIException(ex);
                    }
                }
            };
        }
        this.prmtCompany.addDataChangeListener(this.prmtCompanyListener);
        if (this.prmtItemListener == null) {
            this.prmtItemListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent e) {
                    try {
                        CheckViewListUI.this.itemChange(e);
                    }
                    catch (Exception ex) {
                        CheckViewListUI.this.handUIException(ex);
                    }
                }
            };
        }
        this.prmtItem.addDataChangeListener(this.prmtItemListener);
        if (this.prmtIndexListener == null) {
            this.prmtIndexListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent e) {
                    try {
                        CheckViewListUI.this.indexChange(e);
                    }
                    catch (Exception ex) {
                        CheckViewListUI.this.handUIException(ex);
                    }
                }
            };
        }
        this.prmtIndex.addDataChangeListener(this.prmtIndexListener);
    }

    protected void companyChange(DataChangeEvent e) throws Exception {
        if (e.getNewValue().equals(e.getOldValue()) || e.getNewValue() == null) {
            return;
        }
        CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)e.getNewValue();
        this.initFilterInfo(companyInfo.getId().toString(), null);
        this.execQuery();
    }

    protected void itemChange(DataChangeEvent e) throws Exception {
        if (e.getNewValue().equals(e.getOldValue()) || e.getNewValue() == null) {
            return;
        }
        CheckItemInfo itemInfo = (CheckItemInfo)e.getNewValue();
        this.initFilterInfo(null, itemInfo.getId().toString());
        this.execQuery();
    }

    protected void indexChange(DataChangeEvent e) throws Exception {
        if (e.getNewValue().equals(e.getOldValue()) || e.getNewValue() == null) {
            return;
        }
        CheckIndexInfo indexInfo = (CheckIndexInfo)e.getNewValue();
        this.initFilterInfo(null, indexInfo.getId().toString());
        this.execQuery();
    }

    public void onLoad() throws Exception {
        super.onLoad();
    }

    protected void initBtnStatus() {
        this.actionAddNew.setVisible(false);
        this.actionAttachment.setVisible(false);
        this.actionRemove.setVisible(false);
        this.actionLocate.setVisible(false);
        this.actionEdit.setVisible(false);
        this.actionView.setVisible(false);
        this.actionQuery.setVisible(false);
        this.menuEdit.setVisible(false);
    }

    public void afterLoad(Map uiContext) throws EASBizException, BOSException {
        Map uictx = uiContext;
        if (uictx == null) {
            uictx = this.getUIContext();
        }
        this.checkType = (CheckTypeEnum)((Object)uictx.get("checkType"));
        this.viewType = (Integer)uictx.get("viewType");
        this.loadFields();
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)uictx.get("company");
        String billId = (String)uictx.get("billId");
        if (!StringUtils.isEmpty((String)billId)) {
            CheckBaseInfo check = null;
            if (CheckTypeEnum.TAXDECLARE.equals((Object)this.checkType)) {
                check = CheckItemFactory.getRemoteInstance().getCheckItemInfo((IObjectPK)new ObjectUuidPK(billId));
                this.prmtItem.setValue((Object)check);
            } else if (CheckTypeEnum.TAXINDEX.equals((Object)this.checkType)) {
                check = CheckIndexFactory.getRemoteInstance().getCheckIndexInfo((IObjectPK)new ObjectUuidPK(billId));
                this.prmtIndex.setValue((Object)check);
            }
        }
        this.initBtnStatus();
        this.setVisibleByViewType();
        this.initFilterInfo(company.getId().toString(), billId);
        this.execQuery();
    }

    private void initFilterInfo(String companyID, String billId) {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("checkType", (Object)this.checkType.getValue(), CompareType.EQUALS));
        if (this.viewType == 0) {
            if (CheckTypeEnum.TAXDECLARE.equals((Object)this.checkType)) {
                filterInfo.getFilterItems().add(new FilterItemInfo("item.id", (Object)billId, CompareType.EQUALS));
            } else {
                filterInfo.getFilterItems().add(new FilterItemInfo("index.id", (Object)billId, CompareType.EQUALS));
            }
        } else if (this.viewType == 1) {
            filterInfo.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyID, CompareType.EQUALS));
        }
        this.filterInfo = filterInfo;
    }

    private void setVisibleByViewType() {
        if (CheckTypeEnum.TAXDECLARE.equals((Object)this.checkType)) {
            this.setUITitle("\u4e8b\u9879\u68c0\u67e5\u591a\u7ef4\u5ea6\u67e5\u8be2");
        } else if (CheckTypeEnum.TAXINDEX.equals((Object)this.checkType)) {
            this.setUITitle("\u6307\u6807\u68c0\u67e5\u591a\u7ef4\u5ea6\u67e5\u8be2");
        }
        if (this.viewType == 0) {
            this.companyContainer.setVisible(false);
            this.setTableColumnVisible(companyView, false);
            if (CheckTypeEnum.TAXDECLARE.equals((Object)this.checkType)) {
                this.indexContainer.setVisible(false);
                this.itemContainer.setVisible(true);
            } else if (CheckTypeEnum.TAXINDEX.equals((Object)this.checkType)) {
                this.itemContainer.setVisible(false);
                this.indexContainer.setVisible(true);
            }
            this.setTableColumnVisible(indexView, true);
            this.setTableColumnVisible(itemView, true);
        } else if (this.viewType == 1) {
            this.companyContainer.setVisible(true);
            this.indexContainer.setVisible(false);
            this.itemContainer.setVisible(false);
            this.setTableColumnVisible(companyView, true);
            if (CheckTypeEnum.TAXDECLARE.equals((Object)this.checkType)) {
                this.setTableColumnVisible(indexView, true);
                this.setTableColumnVisible(itemView, false);
            } else if (CheckTypeEnum.TAXINDEX.equals((Object)this.checkType)) {
                this.setTableColumnVisible(indexView, false);
                this.setTableColumnVisible(itemView, true);
            }
        }
    }

    private void setTableColumnVisible(String[] columns, boolean isHided) {
        int length = columns.length;
        for (int i = 0; i < length; ++i) {
            this.tblMain.getColumn(columns[i]).getStyleAttributes().setHided(isHided);
        }
    }

    private FilterInfo getFilterInfo() {
        return this.filterInfo;
    }

    protected void execQuery() {
        this.mainQuery.setFilter(this.getFilterInfo());
        super.execQuery();
        this.setVisibleByViewType();
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return CheckViewFactory.getRemoteInstance();
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }
}

