/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.cloud.datamodel.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTFocusChangeAction;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDScrollBar;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MDContextFactory;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.access.MetaDataAccessFactory;
import com.kingdee.bos.metadata.access.entity.EntitySelect;
import com.kingdee.bos.metadata.access.entity.SimpleEntity;
import com.kingdee.bos.metadata.data.SQLType;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.resource.BizEnumInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.BooleanEnum;
import com.kingdee.eas.base.commonquery.CompareSignBooleanEnum;
import com.kingdee.eas.base.commonquery.CompareSignDateEnum;
import com.kingdee.eas.base.commonquery.CompareSignEnum;
import com.kingdee.eas.base.commonquery.CompareSignEnumEnum;
import com.kingdee.eas.base.commonquery.CompareSignIntEnum;
import com.kingdee.eas.base.commonquery.CompareSignStringEnum;
import com.kingdee.eas.base.commonquery.LeftBracketSignEnum;
import com.kingdee.eas.base.commonquery.LogicSignEnum;
import com.kingdee.eas.base.commonquery.QueryColumnInfo;
import com.kingdee.eas.base.commonquery.QueryUtils;
import com.kingdee.eas.base.commonquery.RightBracketSignEnum;
import com.kingdee.eas.base.commonquery.SorterSignEnum;
import com.kingdee.eas.base.commonquery.client.CommonFilterUtil;
import com.kingdee.eas.base.commonquery.client.CommonQueryUI;
import com.kingdee.eas.base.commonquery.client.DataObject;
import com.kingdee.eas.base.commonquery.client.ICommonQureyPanelExtendForBos;
import com.kingdee.eas.base.commonquery.client.RowObject;
import com.kingdee.eas.base.commonquery.client.Util;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.td.basedata.AccountConfigEntryCollection;
import com.kingdee.eas.tm.td.basedata.AccountConfigEntryInfo;
import com.kingdee.eas.tm.td.basedata.AccountConfigFactory;
import com.kingdee.eas.tm.td.basedata.AccountConfigInfo;
import com.kingdee.eas.tm.td.basedata.DataTypeEnum;
import com.kingdee.eas.tm.td.cloud.datamodel.client.AbstractFormulaWizardUI;
import com.kingdee.eas.tm.td.cloud.utils.CheckFormulaUtil;
import com.kingdee.eas.tm.td.utils.NullUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import com.kingdee.util.enums.DoubleEnum;
import com.kingdee.util.enums.DynamicEnum;
import com.kingdee.util.enums.Enum;
import com.kingdee.util.enums.EnumUtils;
import com.kingdee.util.enums.FloatEnum;
import com.kingdee.util.enums.IntEnum;
import com.kingdee.util.enums.LongEnum;
import com.kingdee.util.enums.StringEnum;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JComboBox;
import javax.swing.JScrollBar;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class FormulaWizardUI
extends AbstractFormulaWizardUI {
    private FilterInfo filterInfo;
    private FilterInfo defalutFilterInfo;
    private String panelName;
    private static final String commonFilterRes = "com.kingdee.eas.base.commonquery.client.CommonFilterPanel";
    private int width;
    private int height;
    private int defaultRows = 10;
    private ICommonQureyPanelExtendForBos extend;
    private boolean showFieldCompare;
    private int[] FILTER_COLUMN_WIDTHs;
    private AccountConfigInfo configInfo;
    protected static final String DEFAULT_F7_QUERY = "defaultF7Query";
    protected static final String DEFAULT_F7_UI = "defaultF7UI";
    protected Logger logger = Logger.getLogger(FormulaWizardUI.class);
    private int SMALL_BUTTON_WIDTH = 22;
    private int SMALL_BUTTON_HEIGHT = 19;
    private int SPACE = 3;
    private int SMALL_SPACE = 1;
    private Object data = null;
    private boolean isCanceled = true;
    protected static final String[] FILTER_COLUMN_CODEs = new String[]{"leftBracketSign", "condition", "compareSign", "compareValue", "rightBracketSign", "loginSign"};
    protected static final Color LOCKED_COLOR = new Color(244, 253, 193);
    protected static final int FILTER_LFET_BRACKET_SIGN = 0;
    protected static final int FILTER_CONDITION = 1;
    protected static final int FILTER_COMPARE_SIGN = 2;
    protected static final int FILTER_COMPARE_VALUE = 3;
    protected static final int FILTER_RIGHT_BRACKET_SIGN = 4;
    protected static final int FILTER_LOGIC_SIGN = 5;
    private boolean isMsgBoxShow = false;
    private boolean errorFieldFlag = true;
    private Map fieldMaxLength = null;
    private static int defaultFieldMaxLenth = 80;

    public void onLoad() throws Exception {
        this.kDTable.checkParsed();
        super.onLoad();
        this.panelName = (String)this.getUIContext().get("panelName");
        this.configInfo = (AccountConfigInfo)this.getUIContext().get("configInfo");
        this.filterInfo = (FilterInfo)this.getUIContext().get("filterInfo");
        this.loadConfigInfo(this.configInfo.getId().toString());
        this.initTable();
        this.initButton();
        this.setUITitle(this.panelName);
    }

    private void loadConfigInfo(String billId) throws EASBizException, BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("entry.*");
        this.configInfo = AccountConfigFactory.getRemoteInstance().getAccountConfigInfo((IObjectPK)new ObjectUuidPK(billId), sic);
    }

    public void initButton() {
        this.actionOk.setEnabled(true);
        this.actionCancel.setEnabled(true);
        this.btnAddLine.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnRemoveLine.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.btnClear.setIcon(EASResource.getIcon((String)"imgTbtn_clear"));
        this.btnAddLine.setEnabled(true);
        this.btnRemoveLine.setEnabled(true);
        this.btnClear.setEnabled(true);
    }

    private String getWaterMark() {
        return EASResource.getString((String)commonFilterRes, (String)"watermark");
    }

    private void addTableListener() {
        this.kDTable.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStarting(KDTEditEvent e) {
                try {
                    FormulaWizardUI.this.kDTable_editStarting(e);
                }
                catch (Exception e1) {
                    ExceptionHandler.handle((Throwable)e1);
                }
            }

            public void editStarted(KDTEditEvent e) {
                int rowIndex = e.getRowIndex();
                int colIndex = e.getColIndex();
                if (rowIndex == 0 && colIndex == 1 && FormulaWizardUI.this.getWaterMark().equals(FormulaWizardUI.this.kDTable.getRow(rowIndex).getCell(colIndex).getValue())) {
                    FormulaWizardUI.this.kDTable.getRow(rowIndex).getCell(colIndex).setValue((Object)"");
                }
            }

            public void editStopped(KDTEditEvent e) {
                try {
                    FormulaWizardUI.this.kDTable_editStopped(e);
                }
                catch (Exception e1) {
                    ExceptionHandler.handle((Throwable)e1);
                }
            }
        });
        this.kDTable.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                try {
                    FormulaWizardUI.this.onMouseClicked(e);
                }
                catch (Exception e1) {
                    ExceptionHandler.handle((Throwable)e1);
                }
            }
        });
    }

    private void initTable() throws BOSException {
        this.fillFilterTableBody();
        this.kDTable.getLayoutManager().setVerticalScrollBar((JScrollBar)new KDScrollBar(1));
        this.kDTable.getLayoutManager().setHorizonScrollBar((JScrollBar)new KDScrollBar(0));
        this.fillLeftRows();
        this.addTableListener();
        this.kDTable.getActionMap().put("FocusChangeCol", (Action)new KDTFocusChangeAction(this.kDTable, 0, false));
    }

    private void fillLeftRows() throws BOSException {
        int rowCount = this.kDTable.getRowCount();
        if (rowCount < this.defaultRows) {
            for (int i = 0; i < this.defaultRows - rowCount; ++i) {
                IRow row = this.kDTable.addRow();
                this.initTableEditor(row.getRowIndex());
            }
        }
    }

    private void beforeFillFilterTable() throws BOSException {
        this.checkFilters(this.filterInfo);
    }

    private void setCommonLockedRowStyle(IRow row) {
        row.getStyleAttributes().setLocked(true);
        row.getStyleAttributes().setBackground(LOCKED_COLOR);
    }

    private void setLastLockedRowStyle(IRow row) {
        row.getStyleAttributes().setLocked(true);
        row.getStyleAttributes().setBackground(LOCKED_COLOR);
        row.getCell(5).getStyleAttributes().setLocked(false);
        row.getCell(5).getStyleAttributes().setBackground(Color.WHITE);
    }

    protected void fillFilterTableBody() throws BOSException {
        this.kDTable.removeRows();
        if (this.filterInfo != null) {
            int filterSize = this.filterInfo.getFilterItems().size();
            if (filterSize > 0) {
                this.beforeFillFilterTable();
                ArrayList rowInfos = Util.getRowInfos((FilterInfo)this.filterInfo);
                for (int i = 0; i < filterSize; ++i) {
                    RowObject rowObject = (RowObject)rowInfos.get(i);
                    FilterItemInfo filterItemInfo = this.filterInfo.getFilterItems().get(i);
                    IRow row = this.kDTable.addRow(i);
                    rowObject.setLeftBracket(rowObject.getLeftBracket());
                    rowObject.setCondition(filterItemInfo.getPropertyName());
                    if (!filterItemInfo.isCompareValueIsProperty()) {
                        if (filterItemInfo.getCompareValue() != null) {
                            this.updateLikeRowObject(rowObject, filterItemInfo.getCompareValue(), filterItemInfo.getCompareType());
                        } else if (filterItemInfo.getCompareValue() == null && filterItemInfo.getCompareType().equals((Object)CompareType.NOTEQUALS) || filterItemInfo.getCompareType().equals((Object)CompareType.EQUALS)) {
                            String compare = filterItemInfo.getCompareType().getName();
                            if (compare.equalsIgnoreCase("=")) {
                                compare = "IS";
                            }
                            if (compare.equalsIgnoreCase("<>")) {
                                compare = "IS NOT";
                            }
                            rowObject.setCompare(compare);
                            rowObject.setCompareValue(null);
                        }
                    }
                    rowObject.setRightBracket(rowObject.getRightBracket());
                    rowObject.setLogic(rowObject.getLogic());
                    this.loadFilter(i, rowObject);
                }
            } else {
                this.addRow();
            }
        }
    }

    private void checkFilters(FilterInfo checkFilterInfo) throws BOSException {
        int filterSize = checkFilterInfo.getFilterItems().size();
        DataObject[] dataObjects = this.getQueryConditionArray();
        int dataObjectsLength = dataObjects == null ? 0 : dataObjects.length;
        for (int i = 0; i < filterSize; ++i) {
            String currentField = "";
            FilterItemInfo itemInfo = checkFilterInfo.getFilterItems().get(i);
            if (itemInfo.isFuncCol()) {
                List list = itemInfo.getFieldList();
                if (list.size() > 0) {
                    currentField = (String)list.get(0);
                }
            } else {
                currentField = itemInfo.getPropertyName();
            }
            for (int j = 0; j < dataObjectsLength; ++j) {
                String queryFieldName = dataObjects[j].getValue();
                if (!this.compareFiledName(queryFieldName, currentField)) continue;
                this.errorFieldFlag = false;
                break;
            }
            if (!this.errorFieldFlag) continue;
            this.logger.error((Object)("field name is:" + currentField));
            MsgBox.showInfo((Component)((Object)this), (String)(EASResource.getString((String)commonFilterRes, (String)"versionupgradehint") + "\n" + EASResource.getString((String)commonFilterRes, (String)"versionup2") + "\n" + EASResource.getString((String)commonFilterRes, (String)"versionup3")));
            this.errorFieldFlag = false;
        }
    }

    private boolean compareFiledName(String queryFieldName, String currentField) {
        if (queryFieldName.equalsIgnoreCase(currentField)) {
            return true;
        }
        if (("upper(" + queryFieldName + ")").equalsIgnoreCase(currentField)) {
            return true;
        }
        return ("(" + queryFieldName + ")").equalsIgnoreCase(currentField);
    }

    private void increaseRow(KDTEditEvent e) throws BOSException {
        Object object;
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        if (colIndex == 5 && rowIndex == this.kDTable.getRowCount() - 1 && (object = this.kDTable.getRow(rowIndex).getCell(5).getValue()) != null && object.toString() != null && !this.isBlankRow(rowIndex) && !this.checkCurrentHasBlankCol(rowIndex)) {
            this.addRow();
        }
    }

    protected void kDTable_editStopped(KDTEditEvent e) throws Exception {
        this.increaseRow(e);
        this.editedCellAfter(e);
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        Object object = this.kDTable.getRow(rowIndex).getCell(colIndex).getValue();
        if (rowIndex == 0 && colIndex == 1) {
            if (object instanceof String && StringUtils.isEmpty((String)((String)object))) {
                this.kDTable.getRow(rowIndex).getCell(colIndex).setValue((Object)this.getWaterMark());
                this.kDTable.getRow(rowIndex).getCell(colIndex).getStyleAttributes().setFontColor(Color.lightGray);
            } else {
                this.kDTable.getRow(rowIndex).getCell(colIndex).getStyleAttributes().setFontColor(Color.BLACK);
            }
        }
    }

    private void kDTable_editStarting(KDTEditEvent e) throws Exception {
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        switch (colIndex) {
            case 0: {
                return;
            }
            case 1: {
                return;
            }
            case 2: {
                return;
            }
            case 3: {
                return;
            }
            case 4: {
                return;
            }
            case 5: {
                return;
            }
        }
    }

    private void editedCondtionCellAfter(KDTEditEvent e) throws Exception {
        int rowIndex = e.getRowIndex();
        if (this.kDTable.getRow(rowIndex).getCell(1) == null) {
            this.kDTable.getRow(rowIndex).getCell(2).getStyleAttributes().setLocked(true);
            this.kDTable.getRow(rowIndex).getCell(3).getStyleAttributes().setLocked(true);
        } else if (this.kDTable.getRow(rowIndex).getCell(1).isChange()) {
            if (e.getOldValue() != null) {
                if (!e.getOldValue().equals(e.getValue())) {
                    ICell iCell = this.kDTable.getRow(rowIndex).getCell(3);
                    if (iCell.getEditor() != null) {
                        iCell.setEditor(null);
                    }
                    iCell.getStyleAttributes().setNumberFormat("");
                    this.processCompareSignCell(e);
                    this.kDTable.getRow(rowIndex).getCell(2).getStyleAttributes().setLocked(false);
                    this.kDTable.getRow(rowIndex).getCell(3).getStyleAttributes().setLocked(false);
                    this.reSetCompareValue(rowIndex);
                }
            } else {
                this.processCompareSignCell(e);
                this.kDTable.getRow(rowIndex).getCell(2).getStyleAttributes().setLocked(false);
                this.kDTable.getRow(rowIndex).getCell(3).getStyleAttributes().setLocked(false);
            }
        }
    }

    private void reSetCompareValue(int rowIndex) {
        ICell iCell = this.kDTable.getRow(rowIndex).getCell(3);
        iCell.setValue(null);
    }

    private void editedCompareValueCellAfter(KDTEditEvent e) throws Exception {
        String compareCompare;
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        DataObject dataObject = new DataObject();
        String conditonValue = Util.getValue((Object)this.kDTable.getRow(rowIndex).getCell(1).getValue()).toString();
        if (this.kDTable.getRow(rowIndex).getCell(2).getValue() != null && CommonFilterUtil.isFieldJudge((String)(compareCompare = this.kDTable.getRow(rowIndex).getCell(2).getValue().toString()))) {
            this.kDTable.getRow(rowIndex).getCell(colIndex).setValue(this.kDTable.getRow(rowIndex).getCell(3).getValue());
            return;
        }
        DataObject dataType = this.getRefMetaData(conditonValue);
        if (dataType == null) {
            return;
        }
        if (CommonFilterUtil.isIntType((String)dataType.getName())) {
            CompareSignEnum signEnum;
            String numberValue = null;
            Object f7Data = null;
            String entityName = dataType.getValue();
            if (entityName != null) {
                KDBizPromptBox f7PromptBox = (KDBizPromptBox)this.kDTable.getRow(rowIndex).getCell(3).getEditor().getComponent();
                numberValue = f7PromptBox.getText();
                f7Data = f7PromptBox.getData();
            } else {
                numberValue = Util.getValue((Object)this.kDTable.getRow(rowIndex).getCell(3).getValue()).toString();
            }
            boolean checkNumber = true;
            String strCompare = Util.getValue((Object)this.kDTable.getRow(rowIndex).getCell(2).getValue()).toString();
            if (strCompare != null && !strCompare.equalsIgnoreCase("") && FormulaWizardUI.isIncludeCompare(signEnum = CompareSignEnum.getEnum((String)strCompare))) {
                checkNumber = false;
            }
            if (checkNumber && this.checkIsNumber(numberValue, dataType.getName())) {
                this.kDTable.getRow(rowIndex).getCell(3).setValue(null);
                this.isMsgBoxShow = true;
                MsgBox.showWarning((String)EASResource.getString((String)commonFilterRes, (String)"compareValueWarning"));
                this.isMsgBoxShow = false;
            } else if (f7Data != null) {
                KDBizPromptBox f7PromptBox = (KDBizPromptBox)this.kDTable.getRow(rowIndex).getCell(3).getEditor().getComponent();
                if (f7Data instanceof IObjectValue) {
                    IObjectValue bizObject = (IObjectValue)f7Data;
                    bizObject = FormulaWizardUI.getBizData(bizObject);
                    f7PromptBox.setData((Object)bizObject);
                    ObjectValueRender avr = new ObjectValueRender();
                    avr.setFormat((IDataFormat)new BizDataFormat(f7PromptBox.getDisplayFormatter().toString()));
                    this.kDTable.getRow(rowIndex).getCell(3).setRenderer((IBasicRender)avr);
                    this.kDTable.getRow(rowIndex).getCell(colIndex).setValue((Object)bizObject);
                } else if (f7Data instanceof Object[]) {
                    if (f7PromptBox.getEditFormatter().toString().equals("$id$") || f7PromptBox.getEditFormatter().toString().equals("$number$")) {
                        f7PromptBox.setData(f7Data);
                        ObjectValueRender avr = new ObjectValueRender();
                        avr.setFormat((IDataFormat)new BizDataFormat(f7PromptBox.getDisplayFormatter().toString()));
                        this.kDTable.getRow(rowIndex).getCell(3).setRenderer((IBasicRender)avr);
                        this.kDTable.getRow(rowIndex).getCell(colIndex).setValue(f7Data);
                    } else {
                        String bizStr = f7PromptBox.getEditFormatter().valueToString(f7Data);
                        f7PromptBox.setData((Object)bizStr);
                        ObjectValueRender avr = new ObjectValueRender();
                        avr.setFormat((IDataFormat)new BizDataFormat(f7PromptBox.getDisplayFormatter().toString()));
                        this.kDTable.getRow(rowIndex).getCell(3).setRenderer((IBasicRender)avr);
                        this.kDTable.getRow(rowIndex).getCell(colIndex).setValue(f7Data);
                    }
                }
            } else {
                dataObject.setValue(numberValue);
                dataObject.setName(numberValue);
                this.kDTable.getRow(rowIndex).getCell(colIndex).setValue((Object)dataObject);
            }
        } else if (CommonFilterUtil.isF7Type((String)dataType.getName())) {
            ICellEditor editer = this.kDTable.getRow(rowIndex).getCell(3).getEditor();
            if (editer == null) {
                return;
            }
            KDBizPromptBox promptBox = (KDBizPromptBox)this.kDTable.getRow(rowIndex).getCell(3).getEditor().getComponent();
            Object objData = promptBox.getData();
            if (objData == null) {
                return;
            }
            if (objData instanceof IObjectValue) {
                IObjectValue bizObject = (IObjectValue)objData;
                bizObject = FormulaWizardUI.getBizData(bizObject);
                promptBox.setData((Object)bizObject);
                ObjectValueRender avr = new ObjectValueRender();
                avr.setFormat((IDataFormat)new BizDataFormat(promptBox.getDisplayFormatter().toString()));
                this.kDTable.getRow(rowIndex).getCell(3).setRenderer((IBasicRender)avr);
                this.kDTable.getRow(rowIndex).getCell(colIndex).setValue((Object)bizObject);
            } else if (objData instanceof Object[]) {
                if (promptBox.getEditFormatter().toString().equals("$id$") || promptBox.getEditFormatter().toString().equals("$number$")) {
                    promptBox.setData(objData);
                    ObjectValueRender avr = new ObjectValueRender();
                    avr.setFormat((IDataFormat)new BizDataFormat(promptBox.getDisplayFormatter().toString()));
                    this.kDTable.getRow(rowIndex).getCell(3).setRenderer((IBasicRender)avr);
                    this.kDTable.getRow(rowIndex).getCell(colIndex).setValue(objData);
                } else {
                    String bizStr = promptBox.getEditFormatter().valueToString(objData);
                    promptBox.setData((Object)bizStr);
                    ObjectValueRender avr = new ObjectValueRender();
                    avr.setFormat((IDataFormat)new BizDataFormat(promptBox.getDisplayFormatter().toString()));
                    this.kDTable.getRow(rowIndex).getCell(3).setRenderer((IBasicRender)avr);
                    this.kDTable.getRow(rowIndex).getCell(colIndex).setValue(objData);
                }
            }
        } else if (CommonFilterUtil.isDateType((String)dataType.getName()) && this.kDTable.getRow(rowIndex).getCell(2).getValue() != null && QueryUtils.isDateFunctionCompareSign((String)Util.getValue((Object)this.kDTable.getRow(rowIndex).getCell(2).getValue()).toString())) {
            String numberValue = Util.getValue((Object)this.kDTable.getRow(rowIndex).getCell(3).getValue()).toString();
            if (this.checkIsNumber(numberValue, DataType.INTEGER.getName())) {
                this.kDTable.getRow(rowIndex).getCell(3).setValue(null);
                this.isMsgBoxShow = true;
                MsgBox.showWarning((String)EASResource.getString((String)commonFilterRes, (String)"compareValueWarning"));
                this.isMsgBoxShow = false;
            } else {
                dataObject.setValue(numberValue);
                dataObject.setName(numberValue);
                this.kDTable.getRow(rowIndex).getCell(colIndex).setValue((Object)dataObject);
            }
        }
    }

    protected static IObjectValue getBizData(IObjectValue data) throws BOSException {
        SimpleEntity entity = FormulaWizardUI.getSimpleEntity(MDContextFactory.getRemoteInstance().entityMapping.getProperty(data.getBOSType()).getFullName());
        String pk = data.get(entity.getLogicalKeyProperties()[0]).toString();
        return FormulaWizardUI.getRemoteValue(pk);
    }

    protected static IObjectValue getRemoteValue(String pkValue) throws BOSException {
        BOSUuid id = BOSUuid.read((String)pkValue);
        IObjectValue objectValue = null;
        objectValue = DynamicObjectFactory.getRemoteInstance().getValue(id.getType(), (IObjectPK)new ObjectUuidPK(id));
        return objectValue;
    }

    protected static SimpleEntity getSimpleEntity(String fullName) throws BOSException {
        EntitySelect select = new EntitySelect(fullName);
        select.extendPropertySelect().select(new String[]{DEFAULT_F7_QUERY, DEFAULT_F7_UI});
        select.selectLogicalKeyProperties();
        return MetaDataAccessFactory.getRemoteInstance().select(select);
    }

    protected static boolean isIncludeCompare(CompareSignEnum compareSignEnum) {
        if (compareSignEnum != null) {
            if (compareSignEnum.equals((Object)CompareSignEnum.INCLUDESIGN)) {
                return true;
            }
            if (compareSignEnum.equals((Object)CompareSignEnum.NOTINCLUDESIGN)) {
                return true;
            }
        }
        return false;
    }

    private void editedCellAfter(KDTEditEvent e) throws Exception {
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        Object object = this.kDTable.getRow(rowIndex).getCell(colIndex).getValue();
        boolean isNullValue = false;
        if (object == null) {
            isNullValue = true;
        } else if (object instanceof DataObject && ((DataObject)object).getValue() == null) {
            isNullValue = true;
        }
        if (isNullValue) {
            if (colIndex == 1) {
                this.resetCell(this.kDTable.getRow(rowIndex).getCell(2));
                this.resetCell(this.kDTable.getRow(rowIndex).getCell(3));
            }
            return;
        }
        switch (colIndex) {
            case 0: {
                return;
            }
            case 1: {
                this.editedCondtionCellAfter(e);
                return;
            }
            case 2: {
                this.processCompareValueCell(e);
                return;
            }
            case 3: {
                this.editedCompareValueCellAfter(e);
                return;
            }
            case 4: {
                return;
            }
            case 5: {
                return;
            }
        }
    }

    private void loadLeftBracket(int rowIndex, RowObject rowObject) {
        FormulaWizardUI.setEnumComboBoxField(this.kDTable, rowIndex, 0, LeftBracketSignEnum.class.getName(), rowObject.getLeftBracket());
    }

    protected static KDComboBox setEnumComboBoxField(KDTable table, int rowIndex, int colIndex, String enumClassName, String fieldValue) {
        List list = FormulaWizardUI.getEnumList(enumClassName);
        Object[] array = list.toArray();
        Object[] temp = FormulaWizardUI.addObjectToArray(array, "");
        KDComboBox comboBox = FormulaWizardUI.setComboBoxField(table, rowIndex, colIndex, temp);
        comboBox.setMaximumRowCount(10);
        int count = comboBox.getItemCount();
        int selectedIndex = 0;
        for (int i = 0; i < count; ++i) {
            Object obj = comboBox.getItemAt(i);
            Object value = null;
            if (obj == null || !(obj instanceof Enum) || (value = FormulaWizardUI.getEnumValue((Enum)obj)) == null || !value.toString().equalsIgnoreCase(fieldValue)) continue;
            selectedIndex = i;
            break;
        }
        comboBox.setSelectedIndex(selectedIndex);
        comboBox.setSelectedItem(temp[selectedIndex]);
        table.getRow(rowIndex).getCell(colIndex).setValue(comboBox.getItemAt(selectedIndex));
        if (2 == colIndex && !SorterSignEnum.class.getName().equals(enumClassName)) {
            comboBox.setCanSearch(true);
        }
        return comboBox;
    }

    protected static KDComboBox setComboBoxField(KDTable kdTable, int rowIndex, int colIndex, Object[] objs) {
        KDComboBox kdComboBox = new KDComboBox(objs);
        kdComboBox.setMaximumRowCount(10);
        KDTDefaultCellEditor kdtDefaultCellEditor = new KDTDefaultCellEditor((JComboBox)kdComboBox);
        kdTable.getRow(rowIndex).getCell(colIndex).setEditor((ICellEditor)kdtDefaultCellEditor);
        if (1 == colIndex) {
            kdComboBox.setCanSearch(true);
        }
        return kdComboBox;
    }

    protected static Object[] addObjectToArray(Object[] objects, Object insertObject) {
        Object[] DEFAULT_OBJECTs = new Object[]{insertObject};
        if (objects == null) {
            return DEFAULT_OBJECTs;
        }
        int length = objects.length;
        if (length == 0) {
            return DEFAULT_OBJECTs;
        }
        Object[] results = new Object[length + 1];
        results[0] = DEFAULT_OBJECTs[0];
        for (int i = 1; i <= length; ++i) {
            results[i] = objects[i - 1];
        }
        return results;
    }

    protected static List getEnumList(String enumpk) {
        MetaDataPK entityPK = MetaDataPK.create((String)enumpk);
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        BizEnumInfo bizEnum = loader.getEnum((IMetaDataPK)entityPK);
        List list = null;
        list = bizEnum.isDynamic() ? DynamicEnum.getEnumList((String)enumpk) : EnumUtils.getEnumList((String)enumpk);
        if (enumpk.equals("com.kingdee.eas.base.commonquery.CompareSignDateEnum")) {
            ArrayList enumList = new ArrayList();
            for (int i = 0; i < list.size(); ++i) {
                if (list.get(i) == CompareSignDateEnum.IN_X_DAYS_AFTER || list.get(i) == CompareSignDateEnum.IN_X_DAYS_EQUAL || list.get(i) == CompareSignDateEnum.IN_X_DAYS_BEFORE || list.get(i) == CompareSignDateEnum.X_DAYS_AGO_AFTER || list.get(i) == CompareSignDateEnum.X_DAYS_AGO_EQUAL || list.get(i) == CompareSignDateEnum.X_DAYS_AGO_BEFORE) continue;
                enumList.add(list.get(i));
            }
            return enumList;
        }
        return list;
    }

    static Object getEnumValue(Enum enumValue) {
        Object value = null;
        if (enumValue instanceof BooleanEnum) {
            value = new Integer(((IntEnum)enumValue).getValue());
        } else if (enumValue instanceof IntEnum) {
            value = new Integer(((IntEnum)enumValue).getValue());
        } else if (enumValue instanceof FloatEnum) {
            value = String.valueOf(((FloatEnum)enumValue).getValue());
        } else if (enumValue instanceof DoubleEnum) {
            value = String.valueOf(((DoubleEnum)enumValue).getValue());
        } else if (enumValue instanceof LongEnum) {
            value = String.valueOf(((LongEnum)enumValue).getValue());
        } else if (enumValue instanceof StringEnum) {
            value = ((StringEnum)enumValue).getValue();
        } else if (enumValue instanceof DynamicEnum) {
            value = ((DynamicEnum)enumValue).getValue();
        }
        return value;
    }

    private void loadCondition(int rowIndex, RowObject rowObject) throws BOSException {
        Object[] objects = this.getQueryConditionArray();
        DataObject temp = new DataObject();
        temp.setName("");
        objects = FormulaWizardUI.addObjectToArray(objects, temp);
        int dataObjectsLength = objects.length;
        int selectedIndex = 0;
        for (int j = 1; j < dataObjectsLength; ++j) {
            DataObject dataObject = (DataObject)objects[j];
            String fieldName = dataObject.getValue();
            String selectedFieldName = rowObject.getCondition();
            if (!selectedFieldName.equalsIgnoreCase(fieldName) && !selectedFieldName.equalsIgnoreCase("upper(" + fieldName + ")")) continue;
            selectedIndex = j;
            break;
        }
        KDComboBox comboBox = FormulaWizardUI.setComboBoxField(this.kDTable, rowIndex, 1, objects);
        comboBox.setSelectedIndex(selectedIndex);
        comboBox.setSelectedItem(objects[selectedIndex]);
        this.kDTable.getRow(rowIndex).getCell(1).setValue(comboBox.getItemAt(selectedIndex));
    }

    private void loadCompareSign(int rowIndex, RowObject rowObject) throws BOSException {
        KDComboBox comboBox;
        String condition = Util.getValue((Object)this.kDTable.getRow(rowIndex).getCell(1).getValue()).toString();
        DataObject dataInfo = this.getRefMetaData(condition);
        if (dataInfo != null) {
            String dataType = dataInfo.getName();
            if (CommonFilterUtil.isEnumType((String)dataType)) {
                comboBox = FormulaWizardUI.setEnumComboBoxField(this.kDTable, rowIndex, 2, CompareSignEnumEnum.class.getName(), rowObject.getCompare());
            } else if (dataType.equalsIgnoreCase(DataType.BOOLEAN.getName())) {
                comboBox = FormulaWizardUI.setEnumComboBoxField(this.kDTable, rowIndex, 2, CompareSignBooleanEnum.class.getName(), rowObject.getCompare());
            } else if (CommonFilterUtil.isDateType((String)dataType)) {
                if (rowObject.getCompareValue() != null && CommonFilterUtil.isDateCompareSign((String)rowObject.getCompareValue().toString())) {
                    comboBox = FormulaWizardUI.setEnumComboBoxField(this.kDTable, rowIndex, 2, CompareSignDateEnum.class.getName(), rowObject.getCompareValue().toString());
                } else if (rowObject.getCompareValue() != null && QueryUtils.isDateFunctionCompareSign((String)rowObject.getCompareValue().toString())) {
                    String compareValue = rowObject.getCompareValue().toString().split("\\$")[0];
                    comboBox = FormulaWizardUI.setEnumComboBoxField(this.kDTable, rowIndex, 2, CompareSignDateEnum.class.getName(), compareValue);
                } else {
                    comboBox = FormulaWizardUI.setEnumComboBoxField(this.kDTable, rowIndex, 2, CompareSignDateEnum.class.getName(), rowObject.getCompare());
                }
            } else {
                comboBox = CommonFilterUtil.isIntType((String)dataType) ? FormulaWizardUI.setEnumComboBoxField(this.kDTable, rowIndex, 2, CompareSignIntEnum.class.getName(), rowObject.getCompare()) : FormulaWizardUI.setEnumComboBoxField(this.kDTable, rowIndex, 2, CompareSignStringEnum.class.getName(), rowObject.getCompare());
            }
        } else {
            comboBox = FormulaWizardUI.setEnumComboBoxField(this.kDTable, rowIndex, 2, CompareSignStringEnum.class.getName(), rowObject.getCompare());
        }
        this.processFieldcompare(comboBox);
        this.processClob(comboBox, condition);
    }

    private boolean processClob(KDComboBox comboBox, String prop) {
        if (this.fieldMaxLength == null) {
            return false;
        }
        QueryColumnInfo cInfo = (QueryColumnInfo)this.fieldMaxLength.get(prop);
        if (cInfo != null && cInfo.getColumnType() != null && (cInfo.getColumnType().equals((Object)SQLType.CLOB) || cInfo.getColumnType().equals((Object)SQLType.NCLOB))) {
            if (comboBox != null) {
                comboBox.removeAllItems();
                comboBox.addItem((Object)CompareSignStringEnum.LIKESIGN);
                comboBox.addItem((Object)CompareSignStringEnum.LEFTLIKESIGN);
                comboBox.addItem((Object)CompareSignStringEnum.RIGHTLIKESIGN);
                comboBox.addItem((Object)CompareSignStringEnum.NOTLIKESIGN);
                comboBox.addItem((Object)CompareSignStringEnum.NOTLEFTLIKESIGN);
            }
            return true;
        }
        return false;
    }

    private void processFieldcompare(KDComboBox comboBox) {
        if (comboBox != null && !this.isShowFieldCompare()) {
            this.removeFieldCompare(comboBox);
        }
    }

    public static DataObject[] getCompareValueList(AccountConfigInfo configInfo, String type) throws Exception {
        ArrayList target = new ArrayList();
        return target.toArray(new DataObject[0]);
    }

    private void loadCompareValue(int rowIndex, RowObject rowObject) throws BOSException {
        String condition = Util.getValue((Object)this.kDTable.getRow(rowIndex).getCell(1).getValue()).toString();
        String compare = Util.getValue((Object)this.kDTable.getRow(rowIndex).getCell(2).getValue()).toString();
        DataObject dataInfo = this.getRefMetaData(condition);
        String likeCompareValue = null;
        likeCompareValue = Util.getValue((Object)rowObject.getCompareValue()).toString();
        if (dataInfo != null) {
            if (CommonFilterUtil.isDateCompareSign((String)compare) || compare.equals("IS") || compare.equals("IS NOT")) {
                this.kDTable.getRow(rowIndex).getCell(3).setValue(null);
                this.kDTable.getRow(rowIndex).getCell(3).getStyleAttributes().setLocked(true);
            } else if (CommonFilterUtil.isEnumType((String)dataInfo.getName())) {
                FormulaWizardUI.setEnumComboBoxField(this.kDTable, rowIndex, 3, dataInfo.getValue(), likeCompareValue);
            } else if (dataInfo.getName().equalsIgnoreCase(DataType.BOOLEAN.getName())) {
                FormulaWizardUI.setEnumComboBoxField(this.kDTable, rowIndex, 3, dataInfo.getValue(), Util.getValue((Object)rowObject.getCompareValue()).toString());
            } else if (CommonFilterUtil.isDateType((String)dataInfo.getName())) {
                if (rowObject.getCompareValue() == null) {
                    this.kDTable.getRow(rowIndex).getCell(3).setValue(null);
                } else if (CommonFilterUtil.isDateCompareSign((String)rowObject.getCompareValue().toString())) {
                    this.kDTable.getRow(rowIndex).getCell(3).setValue(null);
                } else if (QueryUtils.isDateFunctionCompareSign((String)rowObject.getCompareValue().toString())) {
                    String compareValue = rowObject.getCompareValue().toString();
                    this.kDTable.getRow(rowIndex).getCell(3).setValue((Object)compareValue.split("\\$")[1]);
                } else {
                    Date dateValue = QueryUtils.getDate((Date)((Date)rowObject.getCompareValue()), (String)dataInfo.getName(), (CompareSignDateEnum)CompareSignDateEnum.getEnum((String)compare));
                    FormulaWizardUI.setDateCtrlField(this.kDTable, rowIndex, 3, dateValue);
                    this.kDTable.getRow(rowIndex).getCell(3).setValue((Object)dateValue);
                    String format = FormulaWizardUI.getTimeFormatForTable(dataInfo.getName());
                    this.kDTable.getRow(rowIndex).getCell(3).getStyleAttributes().setNumberFormat(format);
                }
            } else if (CommonFilterUtil.isIntType((String)dataInfo.getName())) {
                this.kDTable.getRow(rowIndex).getCell(3).setValue(rowObject.getCompareValue());
            } else {
                DataObject queryDataObject = new DataObject();
                queryDataObject.setName(likeCompareValue);
                queryDataObject.setValue(likeCompareValue);
                this.kDTable.getRow(rowIndex).getCell(3).setValue((Object)queryDataObject);
            }
        } else {
            DataObject queryDataObject = new DataObject();
            queryDataObject.setName(likeCompareValue);
            queryDataObject.setValue(likeCompareValue);
            if (rowObject.getCompareValue() == null || compare.equals("IS") || compare.equals("IS NOT")) {
                this.kDTable.getRow(rowIndex).getCell(3).setValue(null);
            } else {
                this.kDTable.getRow(rowIndex).getCell(3).setValue((Object)queryDataObject);
            }
        }
    }

    protected static String getTimeFormatForTable(String dateType) {
        String format = "%{" + FormulaWizardUI.getTimeFormat(dateType) + "}t";
        return format;
    }

    protected static String getTimeFormat(String dateType) {
        return QueryUtils.getTimeFormat((String)dateType);
    }

    protected static void setDateCtrlField(KDTable kdTable, int rowIndex, int colIndex, Date initDate) {
        KDDatePicker datePicker = new KDDatePicker();
        if (initDate instanceof Timestamp) {
            datePicker.setTimeEnabled(true);
        } else if (initDate instanceof Time) {
            datePicker.setTimeEnabled(true);
        }
        datePicker.setValue((Object)initDate);
        KDTDefaultCellEditor kdtDefaultCellEditor = new KDTDefaultCellEditor(datePicker);
        kdTable.getRow(rowIndex).getCell(colIndex).setEditor((ICellEditor)kdtDefaultCellEditor);
    }

    private void loadRightBracket(int rowIndex, RowObject rowObject) {
        FormulaWizardUI.setEnumComboBoxField(this.kDTable, rowIndex, 4, RightBracketSignEnum.class.getName(), rowObject.getRightBracket());
    }

    private void loadLogicSign(int rowIndex, RowObject rowObject) {
        FormulaWizardUI.setEnumComboBoxField(this.kDTable, rowIndex, 5, LogicSignEnum.class.getName(), rowObject.getLogic());
    }

    protected void loadFilter(int rowIndex, RowObject rowObject) throws BOSException {
        int length = FILTER_COLUMN_CODEs.length;
        block8: for (int i = 0; i < length; ++i) {
            switch (i) {
                case 0: {
                    this.loadLeftBracket(rowIndex, rowObject);
                    continue block8;
                }
                case 1: {
                    this.loadCondition(rowIndex, rowObject);
                    continue block8;
                }
                case 2: {
                    this.loadCompareSign(rowIndex, rowObject);
                    continue block8;
                }
                case 3: {
                    this.loadCompareValue(rowIndex, rowObject);
                    continue block8;
                }
                case 4: {
                    this.loadRightBracket(rowIndex, rowObject);
                    continue block8;
                }
                case 5: {
                    this.loadLogicSign(rowIndex, rowObject);
                    continue block8;
                }
            }
        }
    }

    private boolean checkIsNumber(String value, String dataType) {
        boolean flag = false;
        try {
            if (dataType.equalsIgnoreCase(DataType.SHORT.getName())) {
                new Short(value);
            } else if (dataType.equalsIgnoreCase(DataType.INTEGER.getName())) {
                new Integer(value);
            } else if (dataType.equalsIgnoreCase(DataType.LONG.getName())) {
                new Long(value);
            } else if (dataType.equalsIgnoreCase(DataType.FLOAT.getName())) {
                new Float(value);
            } else if (dataType.equalsIgnoreCase(DataType.DOUBLE.getName())) {
                new Double(value);
            } else if (dataType.equalsIgnoreCase(DataType.DECIMAL.getName())) {
                NumberFormat nf = CtrlFormatUtilities.getDecimalFormat();
                String formatValue = "";
                try {
                    formatValue = nf.parse(value).toString();
                    new BigDecimal(formatValue);
                }
                catch (ParseException e) {
                    flag = true;
                    this.logger.error((Object)e);
                }
            }
        }
        catch (NumberFormatException e) {
            flag = true;
        }
        return flag;
    }

    private void processCompareSignCell(KDTEditEvent e) throws Exception {
        int rowIndex = e.getRowIndex();
        if (this.kDTable.getRow(rowIndex).getCell(1).getValue() != null && !"".equals(this.kDTable.getRow(rowIndex).getCell(1).getValue())) {
            DataObject dataObject;
            String value = null;
            if (this.kDTable.getRow(rowIndex).getCell(1) != null && this.kDTable.getRow(rowIndex).getCell(1).getValue() instanceof DataObject) {
                value = ((DataObject)this.kDTable.getRow(rowIndex).getCell(1).getValue()).getValue();
            }
            if ((dataObject = this.getRefMetaData(value)) == null) {
                return;
            }
            String dataType = dataObject.getName();
            KDComboBox comboBox = null;
            if (!dataType.equalsIgnoreCase(DataType.STRING.getName())) {
                comboBox = dataType.equalsIgnoreCase(DataType.BOOLEAN.getName()) ? FormulaWizardUI.setComboBoxField(this.kDTable, rowIndex, 2, FormulaWizardUI.addObjectToArray(CompareSignBooleanEnum.getEnumList().toArray(), null)) : (dataType.equalsIgnoreCase(DataType.ENUM.getName()) ? FormulaWizardUI.setComboBoxField(this.kDTable, rowIndex, 2, FormulaWizardUI.addObjectToArray(CompareSignEnumEnum.getEnumList().toArray(), null)) : (dataType != null && (dataType.equals(DataType.DATE.getName()) || dataType.equals(DataType.TIMESTAMP.getName()) || dataType.equals(DataType.TIME.getName())) ? FormulaWizardUI.setComboBoxField(this.kDTable, rowIndex, 2, FormulaWizardUI.addObjectToArray(FormulaWizardUI.getEnumList("com.kingdee.eas.base.commonquery.CompareSignDateEnum").toArray(), null)) : (dataType != null && (dataType.equalsIgnoreCase(DataType.SHORT.getName()) || dataType.equalsIgnoreCase(DataType.INTEGER.getName()) || dataType.equalsIgnoreCase(DataType.LONG.getName()) || dataType.equalsIgnoreCase(DataType.FLOAT.getName()) || dataType.equalsIgnoreCase(DataType.DOUBLE.getName()) || dataType.equalsIgnoreCase(DataType.DECIMAL.getName())) ? FormulaWizardUI.setComboBoxField(this.kDTable, rowIndex, 2, FormulaWizardUI.addObjectToArray(CompareSignIntEnum.getEnumList().toArray(), null)) : FormulaWizardUI.setComboBoxField(this.kDTable, rowIndex, 2, FormulaWizardUI.addObjectToArray(CompareSignEnumEnum.getEnumList().toArray(), null)))));
            } else if (this.kDTable.getRow(rowIndex).getCell(2).getEditor() != null) {
                comboBox = FormulaWizardUI.setComboBoxField(this.kDTable, rowIndex, 2, FormulaWizardUI.addObjectToArray(CompareSignStringEnum.getEnumList().toArray(), null));
            }
            String condition = Util.getValue((Object)this.kDTable.getRow(rowIndex).getCell(1).getValue()).toString();
            this.getFieldMaxLength(condition);
            this.processFieldcompare(comboBox);
            boolean isclob = this.processClob(comboBox, condition);
            if (this.kDTable.getRow(rowIndex).getCell(2).getValue() == null || this.kDTable.getRow(rowIndex).getCell(1).isChange()) {
                if (!isclob) {
                    this.kDTable.getRow(rowIndex).getCell(2).setValue((Object)CompareSignStringEnum.EQUALSSIGN);
                } else {
                    this.kDTable.getRow(rowIndex).getCell(2).setValue((Object)CompareSignStringEnum.LIKESIGN);
                }
                this.processCompareValueCell(e);
            }
        }
    }

    private int getFieldMaxLength(String fieldName) throws Exception {
        return 1024;
    }

    private void processCompareValueCell(KDTEditEvent e) throws Exception {
        int rowIndex = e.getRowIndex();
        IRow row = this.kDTable.getRow(rowIndex);
        ICell iCell = row.getCell(3);
        ICell iConditionCell = row.getCell(1);
        ICell iSignCell = row.getCell(2);
        Object signValue = iSignCell.getValue();
        String filterCompareSign = Util.getValue((Object)signValue).toString();
        if (StringUtils.isEmpty((String)StringUtils.cnulls((Object)iConditionCell.getValue())) || this.getWaterMark().equals(String.valueOf(iConditionCell.getValue()))) {
            return;
        }
        DataObject condition = (DataObject)iConditionCell.getValue();
        String fieldName = condition.getValue();
        if (!ToolUtils.equalObject((Object)e.getValue(), (Object)e.getOldValue())) {
            this.processCompareValueCell(iCell, filterCompareSign, rowIndex, fieldName);
        }
    }

    private void processCompareValueCell(ICell compareValueCell, String filterCompareSign, int rowIndex, String fieldName) throws Exception {
        if (CommonFilterUtil.isFieldJudge((String)filterCompareSign)) {
            compareValueCell.getStyleAttributes().setLocked(false);
            compareValueCell.setValue(null);
            Object[] conditions = null;
            conditions = FormulaWizardUI.getCompareValueList(fieldName);
            FormulaWizardUI.setComboBoxField(this.kDTable, rowIndex, 3, FormulaWizardUI.addObjectToArray(conditions, null));
            return;
        }
        if (CommonFilterUtil.isNullJudge((String)filterCompareSign)) {
            compareValueCell.setValue(null);
            compareValueCell.getStyleAttributes().setLocked(true);
            return;
        }
        compareValueCell.getStyleAttributes().setLocked(false);
        DataObject dataObject = this.getRefMetaData(fieldName);
        if (dataObject != null) {
            this.setDataObjectCompareValue(dataObject, rowIndex, filterCompareSign, compareValueCell);
        } else {
            this.resetTextFieldCell(compareValueCell);
        }
    }

    public static DataObject[] getCompareValueList(String condition) throws Exception {
        ArrayList target = new ArrayList();
        return target.toArray(new DataObject[0]);
    }

    private void setDataObjectCompareValue(DataObject dataObject, int rowIndex, String filter_compare_sign, ICell iCell) throws BOSException {
        String value = ((DataObject)this.kDTable.getRow(rowIndex).getCell(1).getValue()).getValue();
        String type = dataObject.getName();
        if (CommonFilterUtil.isEnumType((String)type)) {
            String enumClassName = dataObject.getValue();
            Object[] em = FormulaWizardUI.getEnumList(enumClassName).toArray();
            FormulaWizardUI.setComboBoxField(this.kDTable, rowIndex, 3, FormulaWizardUI.addObjectToArray(em, null));
        } else if (CommonFilterUtil.isBooleanType((String)type)) {
            String enumClassName = dataObject.getValue();
            Object[] em = FormulaWizardUI.getEnumList(enumClassName).toArray();
            FormulaWizardUI.setComboBoxField(this.kDTable, rowIndex, 3, FormulaWizardUI.addObjectToArray(em, null));
            iCell.setValue(null);
        } else if (CommonFilterUtil.isDateType((String)type)) {
            if (CommonFilterUtil.isDateCompareSign((String)filter_compare_sign) || filter_compare_sign.equals("IS") || filter_compare_sign.equals("IS NOT")) {
                iCell.getStyleAttributes().setLocked(true);
                iCell.setValue(null);
            } else if (QueryUtils.isDateFunctionCompareSign((String)filter_compare_sign)) {
                this.resetTextFieldCell(iCell);
                iCell.setValue(null);
            } else {
                String format = FormulaWizardUI.getTimeFormatForTable(type);
                FormulaWizardUI.setDateCtrlField(this.kDTable, rowIndex, 3, FormulaWizardUI.getDate(new Date(), type, CompareSignDateEnum.getEnum((String)filter_compare_sign)));
                iCell.getStyleAttributes().setNumberFormat(format);
                iCell.getStyleAttributes().setLocked(false);
                iCell.setValue(null);
            }
        } else if (CommonFilterUtil.isIntType((String)type)) {
            this.resetTextFieldCell(iCell);
        }
    }

    protected static Date getDate(Date date, String type, CompareSignDateEnum sign) {
        return QueryUtils.getDate((Date)date, (String)type, (CompareSignDateEnum)sign);
    }

    private void resetCell(ICell iCell) {
        iCell.setEditor(null);
        iCell.setValue(null);
        if (iCell.getStyleAttributes() != null) {
            iCell.getStyleAttributes().setNumberFormat("");
        }
    }

    private void resetTextFieldCell(ICell iCell) {
        KDTextField field = new KDTextField();
        KDTDefaultCellEditor kdtDefaultCellEditor = new KDTDefaultCellEditor((JTextField)field);
        iCell.setEditor((ICellEditor)kdtDefaultCellEditor);
        if (iCell.getStyleAttributes() != null) {
            iCell.getStyleAttributes().setNumberFormat("");
        }
    }

    protected void addRowButton_actionPerformed(ActionEvent e) {
        try {
            this.addRow();
        }
        catch (BOSException e1) {
            ExceptionHandler.handle((Throwable)e1);
        }
    }

    protected void delRowButton_actionPerformed(ActionEvent e) {
        int selectedRowIndex = this.kDTable.getSelectManager().getActiveRowIndex();
        if (selectedRowIndex == -1) {
            MsgBox.showWarning((String)EASResource.getString((String)commonFilterRes, (String)"delWarning"));
        } else {
            this.delRow();
        }
    }

    protected void clearButton_actionPerformed(ActionEvent e) {
        this.clear();
    }

    protected boolean isBlankRow(int rowIndex) {
        int columnSize = FILTER_COLUMN_CODEs.length;
        for (int i = 0; i < columnSize; ++i) {
            Object value = this.kDTable.getRow(rowIndex).getCell(i).getValue();
            if (rowIndex == 0 && i == 1 && value instanceof String && this.getWaterMark().equals(value)) {
                value = "";
            }
            if (Util.getValue((Object)value).toString().trim().equalsIgnoreCase("")) continue;
            return false;
        }
        return true;
    }

    private boolean checkCurrentHasTooLongCol(int rowIndex) {
        if (this.fieldMaxLength == null) {
            return false;
        }
        IRow iRow = this.kDTable.getRow(rowIndex);
        Object compareValue = null;
        String condition = Util.getValue((Object)iRow.getCell(1).getValue()).toString();
        String compare = Util.getValue((Object)iRow.getCell(2).getValue()).toString().toLowerCase();
        if (!this.fieldMaxLength.containsKey(condition) || !(this.fieldMaxLength.get(condition) instanceof QueryColumnInfo)) {
            return false;
        }
        QueryColumnInfo columnInfo = (QueryColumnInfo)this.fieldMaxLength.get(condition);
        SQLType sqlType = columnInfo.getColumnType();
        if (!(sqlType.equals((Object)SQLType.CHAR) || sqlType.equals((Object)SQLType.NCHAR) || sqlType.equals((Object)SQLType.VARCHAR) || sqlType.equals((Object)SQLType.NVARCHAR))) {
            return false;
        }
        if (!Util.isF7CompareValue((IRow)iRow) && !CommonFilterUtil.isFieldJudge((String)compare) && (compareValue = Util.getValue((Object)iRow.getCell(3).getValue())) instanceof String) {
            Vector vec = FormulaWizardUI.processStringValue((String)compareValue);
            if (vec.size() > 500) {
                return true;
            }
            Object o = null;
            if (this.fieldMaxLength != null) {
                o = this.fieldMaxLength.get(condition);
            }
            if (o != null && o instanceof QueryColumnInfo) {
                int maxlength = ((QueryColumnInfo)o).getColumnLength();
                maxlength = maxlength > 0 ? maxlength : defaultFieldMaxLenth;
                for (int i = 0; i < vec.size(); ++i) {
                    String tmp = (String)vec.get(i);
                    if (tmp == null || tmp.length() <= maxlength) continue;
                    return true;
                }
            }
        }
        return false;
    }

    protected static Vector processStringValue(String str) {
        Vector<String> vect = new Vector<String>();
        if (str.indexOf(",") > 0) {
            StringTokenizer tokenizer = new StringTokenizer(str, ",");
            while (tokenizer.hasMoreTokens()) {
                String temp = tokenizer.nextToken().trim();
                vect.add(temp);
            }
        } else if (str.indexOf(";") > 0) {
            StringTokenizer tokenizer = new StringTokenizer(str, ";");
            while (tokenizer.hasMoreTokens()) {
                String temp = tokenizer.nextToken().trim();
                vect.add(temp);
            }
        } else {
            vect.add(str);
        }
        return vect;
    }

    private boolean checkCurrentHasBlankCol(int rowIndex) {
        boolean flag = false;
        int columnSize = FILTER_COLUMN_CODEs.length;
        for (int i = 0; i < columnSize; ++i) {
            Object filterValue;
            if (i == 0 || i == 4) continue;
            if (i == 5) {
                if (this.isLastUsefulRow(rowIndex)) {
                    return !this.isExistLogicSign(rowIndex);
                }
                filterValue = this.kDTable.getRow(rowIndex).getCell(i).getValue();
                if (filterValue == null || filterValue.toString().trim().length() == 0) {
                    this.kDTable.getRow(rowIndex).getCell(i).setValue((Object)LogicSignEnum.AND);
                }
            }
            if ((filterValue = this.kDTable.getRow(rowIndex).getCell(i).getValue()) == null) {
                String compareSign = Util.getValue((Object)this.kDTable.getRow(rowIndex).getCell(2).getValue()).toString();
                if (CommonFilterUtil.isDateCompareSign((String)compareSign) || compareSign.equalsIgnoreCase("IS") || compareSign.equalsIgnoreCase("IS NOT")) {
                    if (this.kDTable.getRow(rowIndex).getCell(1).getValue() != null && this.kDTable.getRow(rowIndex).getCell(3).getValue() == null) continue;
                    return true;
                }
                return !this.isMsgBoxShow;
            }
            if (filterValue.toString() != null && !filterValue.toString().trim().equalsIgnoreCase("")) continue;
            return true;
        }
        return flag;
    }

    private boolean isLastUsefulRow(int rowIndex) {
        int rowCount = this.kDTable.getRowCount();
        for (int i = rowIndex + 1; i < rowCount; ++i) {
            if (this.isBlankRow(i)) continue;
            return false;
        }
        return true;
    }

    private void addRow() throws BOSException {
        int currentRowSize = this.kDTable.getRowCount();
        this.kDTable.addRow(currentRowSize);
        this.initTableEditor(currentRowSize);
    }

    private void delRow() {
        int selectedRowIndex = this.kDTable.getSelectManager().getActiveRowIndex();
        this.kDTable.removeRow(selectedRowIndex);
    }

    private void setLeftBracketCell(int rowIndex) {
        if (this.kDTable.getRow(rowIndex).getCell(0).getEditor() == null) {
            FormulaWizardUI.setComboBoxField(this.kDTable, rowIndex, 0, FormulaWizardUI.addObjectToArray(LeftBracketSignEnum.getEnumList().toArray(), null));
        }
    }

    private void setConditionCell(int rowIndex) throws BOSException {
        if (this.kDTable.getRow(rowIndex).getCell(1).getEditor() == null) {
            Object[] conditions = null;
            conditions = this.getQueryConditionArray();
            KDComboBox kdComboBox = FormulaWizardUI.setComboBoxField(this.kDTable, rowIndex, 1, FormulaWizardUI.addObjectToArray(conditions, null));
            kdComboBox.setCanSearch(true);
        }
    }

    public void reInitCondition() throws BOSException {
        for (int i = 0; i < this.kDTable.getRowCount(); ++i) {
            Object[] conditions = null;
            conditions = this.getQueryConditionArray();
            FormulaWizardUI.setComboBoxField(this.kDTable, i, 1, FormulaWizardUI.addObjectToArray(conditions, null));
        }
    }

    private DataObject[] getQueryConditionArray() throws BOSException {
        AccountConfigEntryCollection entryColl = this.configInfo.getEntry();
        DataObject[] arr = new DataObject[entryColl.size()];
        AccountConfigEntryInfo entryInfo = null;
        DataObject dataObject = null;
        int size = entryColl.size();
        for (int i = 0; i < size; ++i) {
            entryInfo = entryColl.get(i);
            dataObject = new DataObject();
            dataObject.setName(entryInfo.getAlias());
            dataObject.setValue(entryInfo.getName());
            arr[i] = dataObject;
        }
        return arr;
    }

    private DataObject getRefMetaData(String condition) {
        AccountConfigEntryCollection entryColl = this.configInfo.getEntry();
        AccountConfigEntryInfo entryInfo = null;
        DataObject dataObject = new DataObject();
        int size = entryColl.size();
        for (int i = 0; i < size; ++i) {
            entryInfo = entryColl.get(i);
            if (!condition.equalsIgnoreCase(entryInfo.getName()) && !condition.equalsIgnoreCase("upper(" + entryInfo.getName() + ")")) continue;
            dataObject.setName(this.getDataType(entryInfo.getDataType()));
            if (entryInfo.getDataType().equals((Object)DataTypeEnum.Boolean)) {
                dataObject.setValue("com.kingdee.eas.base.commonquery.BooleanEnum");
            } else {
                dataObject.setValue(entryInfo.getBaseDataBOSType());
            }
            return dataObject;
        }
        return null;
    }

    private String getDataType(DataTypeEnum dataType) {
        String type = null;
        if (DataTypeEnum.String.equals((Object)dataType)) {
            type = DataType.STRING.toString();
        } else if (DataTypeEnum.Integer.equals((Object)dataType)) {
            type = DataType.INTEGER.toString();
        } else if (DataTypeEnum.Date.equals((Object)dataType)) {
            type = DataType.DATE.toString();
        } else if (DataTypeEnum.Boolean.equals((Object)dataType)) {
            type = DataType.BOOLEAN.toString();
        } else if (DataTypeEnum.Enum.equals((Object)dataType)) {
            type = DataType.ENUM.toString();
        } else if (DataTypeEnum.Qty.equals((Object)dataType)) {
            type = DataType.DECIMAL.toString();
        } else if (DataTypeEnum.Amount.equals((Object)dataType)) {
            type = DataType.DECIMAL.toString();
        } else if (DataTypeEnum.Price.equals((Object)dataType)) {
            type = DataType.DECIMAL.toString();
        } else if (DataTypeEnum.BOSUuid.equals((Object)dataType)) {
            type = DataType.STRING.toString();
        } else if (DataTypeEnum.Timestamp.equals((Object)dataType)) {
            type = DataType.TIMESTAMP.toString();
        }
        return type;
    }

    private void setCompareCell(int rowIndex) throws BOSException {
        String condition;
        KDComboBox comboBox = null;
        if (this.kDTable.getRow(rowIndex).getCell(1).getEditor() != null && this.kDTable.getRow(rowIndex).getCell(2).getEditor() == null) {
            condition = Util.getValue((Object)this.kDTable.getRow(rowIndex).getCell(1).getValue()).toString();
            DataObject dataInfo = null;
            dataInfo = this.getRefMetaData(condition);
            comboBox = dataInfo != null ? (CommonFilterUtil.isEnumType((String)dataInfo.getName()) ? FormulaWizardUI.setEnumComboBoxField(this.kDTable, rowIndex, 2, CompareSignEnumEnum.class.getName(), null) : (CommonFilterUtil.isBooleanType((String)dataInfo.getName()) ? FormulaWizardUI.setEnumComboBoxField(this.kDTable, rowIndex, 2, CompareSignBooleanEnum.class.getName(), null) : (CommonFilterUtil.isDateType((String)dataInfo.getName()) ? FormulaWizardUI.setEnumComboBoxField(this.kDTable, rowIndex, 2, CompareSignDateEnum.class.getName(), null) : (CommonFilterUtil.isIntType((String)dataInfo.getName()) ? FormulaWizardUI.setEnumComboBoxField(this.kDTable, rowIndex, 2, CompareSignIntEnum.class.getName(), null) : FormulaWizardUI.setEnumComboBoxField(this.kDTable, rowIndex, 2, CompareSignStringEnum.class.getName(), null))))) : FormulaWizardUI.setEnumComboBoxField(this.kDTable, rowIndex, 2, CompareSignStringEnum.class.getName(), null);
        }
        if (comboBox != null) {
            comboBox.setCanSearch(true);
        }
        condition = Util.getValue((Object)this.kDTable.getRow(rowIndex).getCell(1).getValue()).toString();
        this.processFieldcompare(comboBox);
        this.processClob(comboBox, condition);
    }

    private void setCompareValueCell(int rowIndex) throws Exception {
        ICell currentCell = this.kDTable.getRow(rowIndex).getCell(3);
        if (currentCell.getEditor() != null) {
            String compareSign;
            Component editor = currentCell.getEditor().getComponent();
            if (editor instanceof KDDatePicker && (compareSign = Util.getValue((Object)this.kDTable.getRow(rowIndex).getCell(2).getValue()).toString()) != null && currentCell.getValue() == null && !CommonFilterUtil.isDateCompareSign((String)compareSign) && !compareSign.equalsIgnoreCase("IS") && !compareSign.equalsIgnoreCase("IS NOT")) {
                currentCell.setValue((Object)new Date());
            }
            if (editor instanceof KDPromptBox) {
                KDBizPromptBox f7Editor = (KDBizPromptBox)editor;
                String strCompare = Util.getValue((Object)this.kDTable.getRow(rowIndex).getCell(2).getValue()).toString();
                if (!strCompare.equalsIgnoreCase("=")) {
                    f7Editor.setEnabledMultiSelection(true);
                }
            }
        }
    }

    private void setRightBracketCell(int rowIndex) {
        if (this.kDTable.getRow(rowIndex).getCell(4).getEditor() == null) {
            FormulaWizardUI.setComboBoxField(this.kDTable, rowIndex, 4, FormulaWizardUI.addObjectToArray(RightBracketSignEnum.getEnumList().toArray(), null));
        }
    }

    private void setLogicCell(int rowIndex) {
        if (this.kDTable.getRow(rowIndex).getCell(5).getEditor() == null) {
            FormulaWizardUI.setComboBoxField(this.kDTable, rowIndex, 5, FormulaWizardUI.addObjectToArray(LogicSignEnum.getEnumList().toArray(), null));
        }
    }

    private void onMouseClicked(KDTMouseEvent e) throws Exception {
        int rowIndex = e.getRowIndex();
        int columnIndex = e.getColIndex();
        if (rowIndex >= 0 && e.getType() == 1) {
            switch (columnIndex) {
                case 2: {
                    this.setCompareCell(rowIndex);
                    break;
                }
                case 3: {
                    this.setCompareValueCell(rowIndex);
                    break;
                }
            }
        }
    }

    private void initTableEditor(int rowIndex) throws BOSException {
        this.setLeftBracketCell(rowIndex);
        this.setConditionCell(rowIndex);
        this.setRightBracketCell(rowIndex);
        this.setLogicCell(rowIndex);
    }

    private boolean checkInvaildFilter() {
        int rowCount = this.kDTable.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            if (this.isBlankRow(i)) continue;
            if (this.checkCurrentHasBlankCol(i)) {
                return true;
            }
            if (!this.checkCurrentHasTooLongCol(i)) continue;
            return true;
        }
        return false;
    }

    protected String getExistBlankColumnWarning() {
        String customerFilterWarning = null;
        if (this.checkInvaildFilter()) {
            customerFilterWarning = EASResource.getString((String)commonFilterRes, (String)"blankRowWarning");
        }
        return customerFilterWarning;
    }

    protected boolean isExistLogicSign(int rowIndex) {
        Object object = this.kDTable.getRow(rowIndex).getCell(5).getValue();
        return object == null || object.toString() == null || object.toString().equalsIgnoreCase("");
    }

    protected String getBracketNotMatchingWarning() {
        String bracketNotMatchingWarning = null;
        int rowCount = this.kDTable.getRowCount();
        int balance = 0;
        for (int i = 0; i < rowCount; ++i) {
            RightBracketSignEnum rightBracketSignEnum;
            int j;
            String bracketValue;
            LeftBracketSignEnum leftBracketSignEnum;
            int brackAmount = 0;
            Object object = this.kDTable.getRow(i).getCell(0).getValue();
            if (object != null && object.toString() != null && !object.toString().equalsIgnoreCase("") && (leftBracketSignEnum = (LeftBracketSignEnum)object) != null && (bracketValue = leftBracketSignEnum.getValue()) != null) {
                brackAmount = bracketValue.length();
                for (j = 0; j < brackAmount; ++j) {
                    ++balance;
                }
            }
            if ((object = this.kDTable.getRow(i).getCell(4).getValue()) == null || object.toString() == null || object.toString().equalsIgnoreCase("") || (rightBracketSignEnum = (RightBracketSignEnum)object) == null || (bracketValue = rightBracketSignEnum.getValue()) == null) continue;
            brackAmount = bracketValue.length();
            for (j = 0; j < brackAmount; ++j) {
                --balance;
            }
        }
        if (balance != 0) {
            bracketNotMatchingWarning = EASResource.getString((String)commonFilterRes, (String)"bracketWarning");
        }
        return bracketNotMatchingWarning;
    }

    public String getFilterInfoAlias() {
        StringBuffer sb = new StringBuffer();
        int rowCount = this.kDTable.getRowCount();
        if (rowCount > 0) {
            for (int i = 0; i < rowCount; ++i) {
                if (this.isBlankRow(i)) continue;
                IRow iRow = this.kDTable.getRow(i);
                AccountConfigEntryCollection coll = this.configInfo.getEntry();
                coll.sort("seq");
                DataObject dataObject = (DataObject)iRow.getCell(1).getValue();
                int index = CheckFormulaUtil.getPropertyIndex(coll, dataObject.getValue());
                if (index < 0) continue;
                AccountConfigEntryInfo entryInfo = coll.get(index);
                String leftBracket = FormulaWizardUI.getValueAlias(iRow.getCell(0).getValue(), entryInfo).toString();
                String condition = FormulaWizardUI.getValueAlias(iRow.getCell(1).getValue(), entryInfo).toString();
                String compare = FormulaWizardUI.getValueAlias(iRow.getCell(2).getValue(), entryInfo).toString().toLowerCase();
                Object compareValue = FormulaWizardUI.getValueAlias(iRow.getCell(3).getValue(), entryInfo);
                String rightBracket = FormulaWizardUI.getValueAlias(iRow.getCell(4).getValue(), entryInfo).toString();
                String logic = FormulaWizardUI.getValueAlias(iRow.getCell(5).getValue(), entryInfo).toString();
                sb.append(leftBracket);
                sb.append(condition).append(" ");
                sb.append(compare).append(" ");
                sb.append(compareValue == null ? "" : NullUtils.isNull2Empty(compareValue));
                sb.append(rightBracket).append(" ");
                sb.append(logic).append(" ");
            }
        }
        return sb.toString();
    }

    public static Object getValueAlias(Object object, AccountConfigEntryInfo entryInfo) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat timeStampFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String value = "";
        if (object != null) {
            if (object instanceof Enum) {
                value = ((Enum)object).getAlias();
            } else if (object instanceof Date) {
                if (entryInfo.getDataType().equals((Object)DataTypeEnum.Date)) {
                    value = dateFormat.format(object);
                } else if (entryInfo.getDataType().equals((Object)DataTypeEnum.Timestamp)) {
                    value = timeStampFormat.format(object);
                }
            } else {
                value = object instanceof Timestamp ? timeStampFormat.format(object) : (object instanceof DataObject ? ((DataObject)object).getName() : object.toString());
            }
        }
        if (value == null) {
            return "";
        }
        if (value instanceof String) {
            value = value == null ? "" : value.trim();
        }
        return value;
    }

    private void setCurrentFilterInfo() throws BOSException {
        int rowCount = this.kDTable.getRowCount();
        FilterInfo newFilterInfo = new FilterInfo();
        if (rowCount > 0) {
            StringBuffer sbFormula = new StringBuffer();
            for (int i = 0; i < rowCount; ++i) {
                FilterItemInfo filterItemInfo;
                if (this.isBlankRow(i)) continue;
                IRow iRow = this.kDTable.getRow(i);
                String leftBracket = Util.getValue((Object)iRow.getCell(0).getValue()).toString();
                String condition = Util.getValue((Object)iRow.getCell(1).getValue()).toString();
                String compare = Util.getValue((Object)iRow.getCell(2).getValue()).toString().toLowerCase();
                String rightBracket = Util.getValue((Object)iRow.getCell(4).getValue()).toString();
                String logic = Util.getValue((Object)iRow.getCell(5).getValue()).toString();
                Object compareValue = null;
                ICell compareValueCell = iRow.getCell(3);
                if (compareValueCell.getEditor() != null && compareValueCell.getEditor().getComponent() != null) {
                    Component obj = iRow.getCell(3).getEditor().getComponent();
                    if (!(obj instanceof KDBizPromptBox) && (compareValue = Util.getValue((Object)iRow.getCell(3).getValue())) instanceof Date) {
                        String dateType = this.getRefMetaData(condition).getName();
                        compareValue = FormulaWizardUI.getDate((Date)compareValue, dateType, CompareSignDateEnum.getEnum((String)compare));
                    }
                } else {
                    compareValue = Util.getValue((Object)iRow.getCell(3).getValue());
                    if (compareValue instanceof Date) {
                        String dateType = this.getRefMetaData(condition).getName();
                        compareValue = FormulaWizardUI.getDate((Date)compareValue, dateType, CompareSignDateEnum.getEnum((String)compare));
                    }
                }
                Object compareSign = iRow.getCell(2).getValue();
                if (CommonFilterUtil.isIncludeSign((Object)compareSign)) {
                    FilterItemInfo includeFilter = new FilterItemInfo(condition, (Object)FormulaWizardUI.processIncludeValue(NullUtils.isNull2Empty(compareValue)), CompareType.getEnum((String)compare));
                    newFilterInfo.getFilterItems().add(includeFilter);
                    sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                    continue;
                }
                if (CommonFilterUtil.isDateCompareSign((String)compare)) {
                    filterItemInfo = new FilterItemInfo(condition, (Object)compare, CompareType.EQUALS);
                    newFilterInfo.getFilterItems().add(filterItemInfo);
                    sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                    continue;
                }
                if (QueryUtils.isDateFunctionCompareSign((String)compare)) {
                    filterItemInfo = new FilterItemInfo(condition, (Object)(compare + "$" + compareValue), CompareType.EQUALS);
                    newFilterInfo.getFilterItems().add(filterItemInfo);
                    sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                    continue;
                }
                if (compare.equalsIgnoreCase("IS") || compare.equalsIgnoreCase("IS")) {
                    filterItemInfo = new FilterItemInfo(condition, (Object)"EMPTY", CompareType.IS);
                    newFilterInfo.getFilterItems().add(filterItemInfo);
                    sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                    continue;
                }
                if (compare.equalsIgnoreCase("IS NOT") || compare.equalsIgnoreCase("IS NOT")) {
                    filterItemInfo = new FilterItemInfo(condition, (Object)"EMPTY", CompareType.ISNOT);
                    newFilterInfo.getFilterItems().add(filterItemInfo);
                    sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                    continue;
                }
                if (CommonFilterUtil.isFieldJudge((String)compare)) {
                    FilterItemInfo filterItemInfo4 = CommonFilterUtil.getFieldFilter((String)compare, (String)condition, (Object)compareValue);
                    newFilterInfo.getFilterItems().add(filterItemInfo4);
                    sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                    continue;
                }
                if (CommonFilterUtil.isLikeSign((Object)compareSign)) {
                    if (compareSign == CompareSignStringEnum.LEFTLIKESIGN) {
                        compare = compare.substring(compare.length() - 4, compare.length());
                    } else if (compareSign == CompareSignStringEnum.RIGHTLIKESIGN) {
                        compare = compare.substring(compare.length() - 4, compare.length());
                    } else if (compareSign == CompareSignStringEnum.NOTLEFTLIKESIGN) {
                        compare = "not like";
                    }
                    compareValue = CommonFilterUtil.getLikeCompareValue((Object)compareValue, (Object)compareSign);
                }
                DataObject dataInfo = this.getRefMetaData(condition);
                FilterItemInfo filterItemInfo2 = null;
                if (dataInfo != null) {
                    String dataType = this.getRefMetaData(condition).getName();
                    if (CommonFilterUtil.isIntType((String)dataType)) {
                        Number tmpCompareValue = null;
                        if (NullUtils.isNull2Empty(compareValue).indexOf(".") >= 0 || DataType.DECIMAL.getName().equals(dataType)) {
                            NumberFormat nf = CtrlFormatUtilities.getDecimalFormat();
                            try {
                                tmpCompareValue = nf.parse(NullUtils.isNull2Empty(compareValue));
                            }
                            catch (ParseException e) {
                                this.logger.error((Object)e);
                            }
                        } else {
                            tmpCompareValue = new Integer(NullUtils.isNull2Empty(compareValue));
                        }
                        filterItemInfo2 = new FilterItemInfo(condition, (Object)tmpCompareValue, CompareType.getEnum((String)compare));
                        newFilterInfo.getFilterItems().add(filterItemInfo2);
                        sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                        continue;
                    }
                    if (CommonFilterUtil.isF7Type((String)dataType)) {
                        filterItemInfo2 = new FilterItemInfo(condition, compareValue, CompareType.getEnum((String)compare));
                        newFilterInfo.getFilterItems().add(filterItemInfo2);
                        sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                        continue;
                    }
                    filterItemInfo2 = new FilterItemInfo(condition, compareValue, CompareType.getEnum((String)compare));
                    newFilterInfo.getFilterItems().add(filterItemInfo2);
                    sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                    continue;
                }
                filterItemInfo2 = new FilterItemInfo(condition, compareValue, CompareType.getEnum((String)compare));
                newFilterInfo.getFilterItems().add(filterItemInfo2);
                sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
            }
            String strFormula = sbFormula.toString();
            if (strFormula != null && !strFormula.trim().equalsIgnoreCase("")) {
                newFilterInfo.setMaskString(strFormula.substring(0, strFormula.length() - 1));
            }
        }
        this.filterInfo = newFilterInfo;
    }

    protected static Set processIncludeValue(String str) {
        HashSet<String> value = new HashSet<String>();
        if (str.indexOf(";") > 0) {
            StringTokenizer tokenizer = new StringTokenizer(str, ";");
            while (tokenizer.hasMoreTokens()) {
                String temp = tokenizer.nextToken();
                value.add(temp);
            }
        } else {
            value.add(str);
        }
        return value;
    }

    public FilterInfo getFilterInfo() {
        try {
            this.setCurrentFilterInfo();
        }
        catch (BOSException bOSException) {
            // empty catch block
        }
        return this.filterInfo;
    }

    public void setFilterInfo(FilterInfo filterInfo) {
        this.filterInfo = filterInfo;
    }

    public void setPanelName(String panelName) {
        this.panelName = panelName;
    }

    public String getPanelName() {
        return this.panelName;
    }

    public KDTable getkDTable() {
        return this.kDTable;
    }

    public boolean verify() {
        if (this.isMsgBoxShow) {
            return false;
        }
        String existBlankColumnWarning = this.getExistBlankColumnWarning();
        if (existBlankColumnWarning != null) {
            MsgBox.showWarning((Component)((Object)this), (String)existBlankColumnWarning);
            return false;
        }
        String bracketNotMatchingWarning = this.getBracketNotMatchingWarning();
        if (bracketNotMatchingWarning != null) {
            MsgBox.showWarning((Component)((Object)this), (String)bracketNotMatchingWarning);
            return false;
        }
        return true;
    }

    public void clear() {
        if (this.defalutFilterInfo != null) {
            this.filterInfo = this.defalutFilterInfo;
            try {
                this.fillFilterTableBody();
            }
            catch (BOSException e) {
                ExceptionHandler.handle((Throwable)e);
            }
        } else {
            this.clearTable();
            try {
                this.fillLeftRows();
            }
            catch (BOSException e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
    }

    protected void clearTable() {
        int rowCount;
        int lockedRowSize = 0;
        for (int i = rowCount = this.kDTable.getRowCount(); i >= lockedRowSize; --i) {
            this.kDTable.removeRow(i);
        }
    }

    private void removeFieldCompare(KDComboBox comboBox) {
        for (int i = 0; i < comboBox.getItemCount(); ++i) {
            Object obj = comboBox.getItemAt(i);
            Object enumVlaue = null;
            if (obj == null || !(obj instanceof Enum) || (enumVlaue = FormulaWizardUI.getEnumValue((Enum)obj)) == null || !CommonFilterUtil.isFieldJudge((String)enumVlaue.toString())) continue;
            comboBox.removeItem(obj);
            --i;
        }
    }

    public boolean isShowFieldCompare() {
        return this.showFieldCompare;
    }

    public void setShowFieldCompare(boolean showFieldCompare) {
        this.showFieldCompare = showFieldCompare;
    }

    private CommonQueryUI getCommonQueryUI() {
        return (CommonQueryUI)Util.getComponent((Component)((Object)this), (String)CommonQueryUI.class.getName());
    }

    public void insertNewRow(DataObject dataObject) {
        int insertRowIndex = this.getInsertRowIndex();
        try {
            this.addRow(insertRowIndex);
        }
        catch (BOSException e1) {
            this.logger.error((Object)"", (Throwable)e1);
            ExceptionHandler.handle((Throwable)e1);
        }
        IRow row = this.kDTable.getRow(insertRowIndex);
        ICell compareValueCell = row.getCell(3);
        this.setRowCondition(row, dataObject);
        RowObject rowObject = new RowObject();
        rowObject.setCompare("=");
        try {
            this.loadCompareSign(row.getRowIndex(), rowObject);
            this.processCompareValueCell(compareValueCell, "=", insertRowIndex, dataObject.getValue());
        }
        catch (Exception e) {
            this.logger.error((Object)"", (Throwable)e);
            ExceptionHandler.handle((Throwable)e);
        }
        this.kDTable.getSelectManager().select(insertRowIndex, 3);
    }

    private void setRowCondition(IRow row, DataObject dataObject) {
        String number;
        ICell conditionCell = row.getCell(1);
        Component conditionComponent = conditionCell.getEditor().getComponent();
        String string = number = dataObject == null ? "" : dataObject.getValue();
        if (conditionComponent instanceof KDComboBox) {
            KDComboBox conditionEditor = (KDComboBox)conditionComponent;
            int count = conditionEditor.getItemCount();
            for (int i = 0; i < count; ++i) {
                String tempNumber;
                DataObject tempDataObject = (DataObject)conditionEditor.getItemAt(i);
                String string2 = tempNumber = tempDataObject == null ? "" : tempDataObject.getValue();
                if (!StringUtils.equals((String)number, (String)tempNumber)) continue;
                conditionEditor.setSelectedIndex(i);
            }
        }
        conditionCell.setValue((Object)dataObject);
    }

    private int getInsertRowIndex() {
        ArrayList blocks = this.kDTable.getSelectManager().getBlocks();
        if (blocks.size() == 1) {
            KDTSelectBlock block = (KDTSelectBlock)blocks.get(0);
            int selectedRowIndex = block.getBeginRow();
            if (this.kDTable.getCell(selectedRowIndex, 1).getValue() == null) {
                return block.getBeginRow();
            }
            return block.getBeginRow() + 1;
        }
        return this.getFirstBrankRowIndex();
    }

    private int getFirstBrankRowIndex() {
        int size = this.kDTable.getRowCount();
        for (int i = 0; i < size; ++i) {
            if (this.kDTable.getRow(i).getCell(1).getValue() != null) continue;
            return i;
        }
        return this.kDTable.getRowCount();
    }

    private void addRow(int index) throws BOSException {
        this.kDTable.addRow(index);
        this.initTableEditor(index);
    }

    @Override
    public void actionOk_actionPerformed(ActionEvent e) throws Exception {
        this.isCanceled = false;
        HashMap<String, Object> ret = new HashMap<String, Object>();
        if (!this.verify()) {
            return;
        }
        ret.put("filterInfo", this.getFilterInfo());
        ret.put("filterInfoDesc", this.getFilterInfoAlias());
        this.data = ret;
        this.getUIWindow().close();
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.isCanceled = true;
        super.actionCancel_actionPerformed(e);
        this.getUIWindow().close();
    }

    @Override
    public void actionAddLine_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddLine_actionPerformed(e);
        this.addRow();
    }

    @Override
    public void actionClear_actionPerformed(ActionEvent e) throws Exception {
        super.actionClear_actionPerformed(e);
        this.clearTable();
    }

    @Override
    public void actionRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemoveLine_actionPerformed(e);
        boolean tmpSelected = false;
        Object selectedKeyValue = null;
        KDTSelectBlock selectBlock = this.kDTable.getSelectManager().get();
        if (selectBlock != null) {
            int rowIndex = selectBlock.getTop();
            this.kDTable.removeRow(rowIndex);
            tmpSelected = true;
        }
        if (!tmpSelected) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
        }
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    public Object getData() {
        return this.data;
    }

    public void updateLikeRowObject(RowObject rowObject, Object compValue, CompareType type) {
        String compareValue = compValue.toString();
        Vector vec = FormulaWizardUI.processStringValue(compareValue);
        String token = compareValue.indexOf(",") >= 0 ? "," : (compareValue.indexOf(";") >= 0 ? ";" : null);
        for (int i = 0; i < vec.size(); ++i) {
            String oldComparevalue;
            compareValue = (String)vec.get(i);
            String string = oldComparevalue = rowObject.getCompareValue() == null ? null : rowObject.getCompareValue().toString();
            if (compareValue.indexOf("%") == -1 || rowObject != null && rowObject.getCompare() != null && rowObject.getCompare().toLowerCase().indexOf("like") <= 0) {
                rowObject.setCompareValue(compValue);
                rowObject.setCompare(type.getName());
                continue;
            }
            int ii = compareValue.indexOf("%");
            int jj = compareValue.length();
            if (String.valueOf(ii).equals(String.valueOf(0))) {
                int kk = compareValue.indexOf("%", jj - 1);
                if (kk == -1) {
                    rowObject.setCompareValue((Object)compareValue.substring(1, jj));
                    rowObject.setCompare("RIGHT LIKE");
                } else {
                    rowObject.setCompareValue((Object)compareValue.substring(1, jj - 1));
                    if (type.getName().equalsIgnoreCase("NOT LIKE")) {
                        rowObject.setCompare("NOT LIKE");
                    } else {
                        rowObject.setCompare("LIKE");
                    }
                }
            } else if (String.valueOf(ii).equals(String.valueOf(jj - 1))) {
                if (type.getName().indexOf("not") >= 0) {
                    rowObject.setCompareValue((Object)compareValue.substring(0, jj - 1));
                    rowObject.setCompare("NOT LEFT LIKE");
                } else {
                    rowObject.setCompareValue((Object)compareValue.substring(0, jj - 1));
                    rowObject.setCompare("LEFT LIKE");
                }
            } else if (CompareType.EQUALS.equals((Object)type)) {
                rowObject.setCompareValue((Object)compareValue);
                rowObject.setCompare("=");
            }
            if (oldComparevalue == null || oldComparevalue.equals("") || i <= 0) continue;
            rowObject.setCompareValue((Object)(oldComparevalue + token + rowObject.getCompareValue()));
        }
    }
}

