/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.cloud.datamodel.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tm.td.cloud.datamodel.ItemTypeFactory;
import com.kingdee.eas.tm.td.cloud.datamodel.ItemTypeInfo;
import com.kingdee.eas.tm.td.cloud.datamodel.client.AbstractItemTypeEditUI;
import com.kingdee.eas.tm.td.common.permsupport.IPermSupport4EditUI;
import com.kingdee.eas.tm.td.common.uihelper.EditUIHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class ItemTypeEditUI
extends AbstractItemTypeEditUI
implements IPermSupport4EditUI {
    private static final Logger logger = CoreUIObject.getLogger(ItemTypeEditUI.class);
    private EditUIHelper uiHelper = new EditUIHelper(this);
    private String currentCUID;

    @Override
    public void loadFields() {
        super.loadFields();
        this.chkIsPreinstall.setEnabled(false);
        this.currentCUID = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
    }

    protected void initDataStatus() {
        super.initDataStatus();
        this.btnSave.setVisible(false);
    }

    protected void setFieldsNull(AbstractObjectValue newData) {
        ItemTypeInfo editData = (ItemTypeInfo)newData;
        editData.setNumber(editData.getNumber() + "Copy");
        editData.setIsPreinstall(false);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected IObjectValue createNewData() {
        ItemTypeInfo itemTypeInfo = new ItemTypeInfo();
        return itemTypeInfo;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return ItemTypeFactory.getRemoteInstance();
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.uiHelper.checkCanEdit(this.currentCUID, this.editData.getId().toString());
        if (this.editData.isIsPreinstall()) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.tm.td.cloud.TDCloudResource", (String)"Preinstall_Not_Edit", (Object[])new String[]{this.editData.getNumber()}));
            SysUtil.abort();
        }
        super.actionEdit_actionPerformed(e);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        this.uiHelper.checkCanAddnew(this.currentCUID);
        super.actionAddNew_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(this.editData.getId().toString());
        this.uiHelper.checkCanRemove(this.currentCUID, ids);
        if (this.editData.isIsPreinstall()) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.tm.td.cloud.TDCloudResource", (String)"Preinstall_Not_Remove", (Object[])new String[]{this.editData.getNumber()}));
            SysUtil.abort();
        }
        super.actionRemove_actionPerformed(e);
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        this.editData.setNumber(this.txtNumber.getText());
        boolean checkNumber = ItemTypeFactory.getRemoteInstance().checkNumber((IObjectValue)this.editData);
        if (!checkNumber) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.tm.td.cloud.TDCloudResource", (String)"Number_Not_Repeat", (Object[])new String[]{this.editData.getNumber()}));
            SysUtil.abort();
        }
        super.actionSave_actionPerformed(e);
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.editData.setNumber(this.txtNumber.getText());
        boolean checkNumber = ItemTypeFactory.getRemoteInstance().checkNumber((IObjectValue)this.editData);
        if (!checkNumber) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.tm.td.cloud.TDCloudResource", (String)"Number_Not_Repeat", (Object[])new String[]{this.editData.getNumber()}));
            SysUtil.abort();
        }
        super.actionSubmit_actionPerformed(e);
    }

    @Override
    public String getBizOrgProperty(OrgType orgType) throws BOSException, EASBizException {
        return "CU";
    }

    @Override
    public String getPermItem(String status) {
        return null;
    }

    @Override
    public KDBizPromptBox getPermMainBizOrg() {
        return null;
    }

    @Override
    public IObjectValue getValueObject() {
        return this.editData;
    }

    @Override
    public ICoreBase getPermInterface() throws Exception {
        return this.getBizInterface();
    }
}

