/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.cloud.datamodel.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTMenuManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestListener;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.framework.report.ICommRptBase;
import com.kingdee.eas.framework.report.client.CommRptBaseConditionUI;
import com.kingdee.eas.framework.report.util.KDTableUtil;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.RptTableHeader;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.basedata.DataTypeEnum;
import com.kingdee.eas.tm.td.cloud.datamodel.DataFetchEntryCollection;
import com.kingdee.eas.tm.td.cloud.datamodel.DataFetchEntryInfo;
import com.kingdee.eas.tm.td.cloud.datamodel.DataFetchInfo;
import com.kingdee.eas.tm.td.cloud.datamodel.rpt.DataFetchAnalysisFacadeFactory;
import com.kingdee.eas.tm.td.cloud.datamodel.rpt.client.AbstractDataFetchAnalysisRptUI;
import com.kingdee.eas.tm.td.cloud.datamodel.rpt.client.DataFetchAnalysisConditionUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import com.kingdee.util.enums.Enum;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JMenuItem;
import org.apache.log4j.Logger;

public class DataFetchAnalysisRptUI
extends AbstractDataFetchAnalysisRptUI {
    private static final long serialVersionUID = -8615773231523662049L;
    private static final Logger logger = CoreUIObject.getLogger(DataFetchAnalysisRptUI.class);
    protected static final String TBL_SELECTED = "selected";
    protected static final String TBL_ID = "FID";
    protected static final String TBL_CONTENT = "FContent";
    protected static final String[] EDIT_COLUMNS = new String[]{"selected"};

    public DataFetchAnalysisRptUI() throws Exception {
        this.tbl.checkParsed();
        this.tbl.getDataRequestManager().addDataRequestListener((KDTDataRequestListener)this);
        this.tbl.getDataRequestManager().setDataRequestMode(1);
        this.tbl.getDataRequestManager().setPageRowCount(500);
        this.enableExportExcel(this.tbl);
        this.tbl.setEditable(false);
        this.tbl.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                DataFetchAnalysisRptUI.this.tbl_afterDataFill(e);
            }
        });
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.afterLoad();
    }

    protected void afterLoad() {
        this.tbl.getSelectManager().setSelectMode(10);
        this.tbl.getSelectManager().select(0, 0);
        this.tbl.getActionMap().remove("Paste");
        this.tbl.getActionMap().remove("Delete");
        KDTMenuManager tm = this.getMenuManager(this.tbl);
        if (tm != null) {
            Component[] menus = tm.getMenu().getComponents();
            for (int i = 0; i < menus.length; ++i) {
                if (!(menus[i] instanceof JMenuItem)) continue;
                JMenuItem menu = (JMenuItem)menus[i];
                menu.setVisible(false);
            }
        }
        this.tbl.setEditable(true);
        this.actionSelectAll.setEnabled(true);
        this.actionNoSelect.setEnabled(true);
    }

    protected ICommRptBase getRemoteInstance() throws BOSException {
        return DataFetchAnalysisFacadeFactory.getRemoteInstance();
    }

    protected KDTable getTableForPrintSetting() {
        return this.tbl;
    }

    protected RptParams getParamsForInit() {
        return null;
    }

    protected CommRptBaseConditionUI getQueryDialogUserPanel() throws Exception {
        DataFetchAnalysisConditionUI filterUI = new DataFetchAnalysisConditionUI();
        return filterUI;
    }

    public void getData(KDTDataRequestEvent e) {
        try {
            RptParams rpt;
            this.tbl.getDataRequestManager().removeDataRequestListener((KDTDataRequestListener)this);
            int from = e.getFirstRow();
            int len = e.getLastRow() - from + 1;
            RptParams para = new RptParams();
            para.setString("tempTable", this.getTempTable());
            para.setObject("group", this.params.getObject("group"));
            para.setObject("companys", this.params.getObject("companys"));
            para.setObject("dataFetch", this.params.getObject("dataFetch"));
            para.setObject("yearFrom", this.params.getObject("yearFrom"));
            para.setObject("monthFrom", this.params.getObject("monthFrom"));
            para.setObject("yearTo", this.params.getObject("yearTo"));
            para.setObject("monthTo", this.params.getObject("monthTo"));
            if (from == 0) {
                rpt = this.getRemoteInstance().createTempTable(para);
                this.setTempTable(rpt.getString("tempTable"));
                RptTableHeader header = (RptTableHeader)rpt.getObject("header");
                KDTableUtil.setHeader((RptTableHeader)header, (KDTable)this.tbl);
                this.params.setObject("dataFetch", rpt.getObject("dataFetch"));
            }
            para.setString("tempTable", this.getTempTable());
            rpt = this.getRemoteInstance().query(para, from, len);
            if (from == 0) {
                this.tbl.setRowCount(rpt.getInt("totalCount"));
            }
            this.afterGetData(e);
            RptRowSet rs = (RptRowSet)rpt.getObject("rowset");
            KDTableUtil.insertRows((RptRowSet)rs, (int)from, (KDTable)this.tbl);
            this.tbl.getDataRequestManager().addDataRequestListener((KDTDataRequestListener)this);
        }
        catch (Exception ex) {
            String error = TDUtils.getString("com.kingdee.eas.tm.td.cloud.TDCloudResource", "DataFetch_error", null);
            MsgBox.showDetailAndOK((Component)((Object)this), (String)error, (String)ex.getMessage(), (int)0);
            SysUtil.abort();
        }
    }

    protected void afterGetData(KDTDataRequestEvent e) throws Exception {
        for (int i = 0; i < this.tbl.getColumnCount(); ++i) {
            if (i == 0) continue;
            this.tbl.getColumn(i).getStyleAttributes().setLocked(true);
        }
        DataFetchInfo dataFetchInfo = (DataFetchInfo)this.params.getObject("dataFetch");
        HashMap<String, DataFetchEntryInfo> dataFieldMap = new HashMap<String, DataFetchEntryInfo>();
        if (dataFetchInfo != null) {
            DataFetchEntryCollection entries = dataFetchInfo.getEntry();
            DataFetchEntryInfo entryInfo = null;
            int size = entries.size();
            for (int i = 0; i < size; ++i) {
                entryInfo = entries.get(i);
                dataFieldMap.put(entryInfo.getName(), entryInfo);
            }
        }
        this.params.setObject("dataFieldMap", dataFieldMap);
    }

    protected void query() {
        this.tbl.removeColumns();
        this.tbl.removeRows();
    }

    protected boolean showQueryDialog(boolean useDefaultSolution) {
        if (this.params != null && this.params.size() > 0) {
            this.params.clear();
        }
        return super.showQueryDialog(useDefaultSolution);
    }

    @Override
    public void actionSelectAll_actionPerformed(ActionEvent e) throws Exception {
        this.checkRows(this.tbl, TBL_SELECTED, true);
    }

    @Override
    public void actionNoSelect_actionPerformed(ActionEvent e) throws Exception {
        this.checkRows(this.tbl, TBL_SELECTED, false);
    }

    protected void checkRows(KDTable table, String colName, boolean isSelect) {
        for (int i = 0; i < table.getRowCount(); ++i) {
            IRow row = this.tbl.getRow(i);
            row.getCell(colName).setValue((Object)new Boolean(isSelect));
        }
    }

    protected void checkSelected() {
        if (!this.isSelected()) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
    }

    protected boolean isSelected() {
        IRow row = null;
        for (int i = 0; i < this.tbl.getRowCount(); ++i) {
            row = this.tbl.getRow(i);
            if (!Boolean.TRUE.equals(row.getCell(TBL_SELECTED).getValue())) continue;
            return true;
        }
        return false;
    }

    protected ArrayList getSelectedIdValues() {
        HashSet<Object> ids = new HashSet<Object>();
        IRow row = null;
        for (int i = 0; i < this.tbl.getRowCount(); ++i) {
            row = this.tbl.getRow(i);
            if (!Boolean.TRUE.equals(row.getCell(TBL_SELECTED).getValue())) continue;
            Object id = this.tbl.getRow(i).getCell(TBL_ID).getValue();
            ids.add(id);
        }
        return new ArrayList(ids);
    }

    public void tbl_afterDataFill(KDTDataRequestEvent e) {
        Map dataFieldMap;
        IColumn col = this.tbl.getColumn(TBL_CONTENT);
        if (col == null) {
            return;
        }
        col.getStyleAttributes().setWrapText(true);
        float cellweight = 0.0f;
        int rowTxtCount = 0;
        int from = e.getFirstRow();
        int to = e.getLastRow();
        if (to >= 0) {
            cellweight = this.tbl.getRow(0).getCell(TBL_CONTENT).getStyleAttributes().getWeight();
            rowTxtCount = (int)Math.floor(cellweight / 58.0f);
        }
        if ((dataFieldMap = (Map)this.params.getObject("dataFieldMap")) == null) {
            return;
        }
        for (int i = from; i <= to; ++i) {
            this.tbl.getRow(i).getCell(TBL_SELECTED).setValue((Object)Boolean.FALSE);
            String prompt = (String)this.tbl.getRow(i).getCell(TBL_CONTENT).getValue();
            if (!StringUtils.isEmpty((String)prompt) && rowTxtCount >= 1) {
                this.tbl.getRow(i).setHeight((int)Math.ceil((double)prompt.length() / (double)rowTxtCount) * 20);
            }
            DataFetchEntryInfo entryInfo = null;
            Iterator iter = dataFieldMap.keySet().iterator();
            while (iter.hasNext()) {
                SimpleDateFormat formatter;
                Object value;
                entryInfo = (DataFetchEntryInfo)dataFieldMap.get(iter.next());
                if (DataTypeEnum.Enum.equals((Object)entryInfo.getDataType())) {
                    value = this.tbl.getRow(i).getCell(entryInfo.getName()).getValue();
                    if (value == null) continue;
                    Enum enums = null;
                    try {
                        enums = TDUtils.getEnumValue(entryInfo.getBaseDataBOSType(), value);
                        if (enums == null) continue;
                        this.tbl.getRow(i).getCell(entryInfo.getName()).setValue((Object)enums.getAlias());
                    }
                    catch (Exception ex) {
                        this.handUIException(ex);
                    }
                    continue;
                }
                if (DataTypeEnum.Boolean.equals((Object)entryInfo.getDataType())) {
                    value = this.tbl.getRow(i).getCell(entryInfo.getName()).getValue();
                    if (value == null || value == null) continue;
                    value = Character.valueOf(Integer.parseInt(value.toString()) == 1 ? (char)'\u662f' : '\u5426');
                    this.tbl.getRow(i).getCell(entryInfo.getName()).setValue(value);
                    continue;
                }
                if (DataTypeEnum.Date.equals((Object)entryInfo.getDataType())) {
                    value = this.tbl.getRow(i).getCell(entryInfo.getName()).getValue();
                    if (value == null) continue;
                    formatter = new SimpleDateFormat("yyyy-MM-dd");
                    value = formatter.format((Date)value);
                    this.tbl.getRow(i).getCell(entryInfo.getName()).setValue(value);
                    continue;
                }
                if (!DataTypeEnum.Timestamp.equals((Object)entryInfo.getDataType()) || (value = this.tbl.getRow(i).getCell(entryInfo.getName()).getValue()) == null) continue;
                formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                value = formatter.format((Date)value);
                this.tbl.getRow(i).getCell(entryInfo.getName()).setValue(value);
            }
        }
    }
}

