/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.cloud.datamodel.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.resource.BizEnumInfo;
import com.kingdee.bos.metadata.resource.BizEnumValueType;
import com.kingdee.bos.sql.util.UUTN;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.td.TDException;
import com.kingdee.eas.tm.td.basedata.DataTypeEnum;
import com.kingdee.eas.tm.td.basedata.TakeDataContditionCollection;
import com.kingdee.eas.tm.td.basedata.TakeDataContditionFactory;
import com.kingdee.eas.tm.td.cloud.datamodel.BizDataTypeEnum;
import com.kingdee.eas.tm.td.cloud.datamodel.DataFetchEntryCollection;
import com.kingdee.eas.tm.td.cloud.datamodel.DataFetchEntryInfo;
import com.kingdee.eas.tm.td.cloud.datamodel.DataFetchInfo;
import com.kingdee.eas.tm.td.cloud.datamodel.DataSourceToDataFetchCollection;
import com.kingdee.eas.tm.td.cloud.datamodel.DataSourceToDataFetchFactory;
import com.kingdee.eas.tm.td.cloud.datamodel.check.info.YearMonthVo;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class DataModelUtil {
    public static Object[] getF7Values(KDBizPromptBox box) {
        Object[] values = null;
        IObjectValue value = null;
        if (box.getValue() instanceof IObjectValue) {
            value = (IObjectValue)box.getValue();
            if (value != null) {
                values = new Object[]{value};
            }
        } else {
            ArrayList<Object> arrList = new ArrayList<Object>();
            Object[] arrs = (Object[])box.getValue();
            if (arrs == null) {
                return null;
            }
            int size = arrs.length;
            for (int i = 0; i < size; ++i) {
                if (arrs[i] == null) continue;
                arrList.add(arrs[i]);
            }
            if (arrList.size() > 0) {
                values = arrList.toArray();
            }
        }
        return values;
    }

    public static List<YearMonthVo> getRangePeriod(int yearFrom, int monthFrom, int yearTo, int monthTo) {
        ArrayList<YearMonthVo> rangePeriod = new ArrayList<YearMonthVo>();
        int startPeriod = yearFrom * 100 + monthFrom;
        int endPeriod = yearTo * 100 + monthTo;
        for (int periodNow = startPeriod; periodNow <= endPeriod; ++periodNow) {
            int year = Integer.parseInt((periodNow + "").substring(0, 4));
            int month = Integer.parseInt((periodNow + "").substring(4, 6));
            if (month > 12 || month < 1) continue;
            YearMonthVo period = new YearMonthVo(year, month);
            rangePeriod.add(period);
        }
        return rangePeriod;
    }

    public static String getPkName(String tableName) {
        UUTN u = new UUTN(true, "");
        String name = u.toString().substring(0, 15);
        return "PK_" + name;
    }

    public static String getDataTypeStr(Context ctx, DataFetchEntryInfo fieldInfo) throws EASBizException {
        String dataType = "";
        if (fieldInfo.getDataType().equals((Object)DataTypeEnum.String)) {
            dataType = "Varchar(" + (fieldInfo.getLength() != 0 ? fieldInfo.getLength() : 100) + ")";
        } else if (fieldInfo.getDataType().equals((Object)DataTypeEnum.Integer)) {
            dataType = "Int";
        } else if (fieldInfo.getDataType().equals((Object)DataTypeEnum.Date)) {
            dataType = "DateTime";
        } else if (fieldInfo.getDataType().equals((Object)DataTypeEnum.Timestamp)) {
            dataType = "DateTime";
        } else if (fieldInfo.getDataType().equals((Object)DataTypeEnum.Boolean)) {
            dataType = "Int";
        } else if (fieldInfo.getDataType().equals((Object)DataTypeEnum.BOSUuid)) {
            dataType = "Varchar(44)";
        } else if (fieldInfo.getDataType().equals((Object)DataTypeEnum.Qty)) {
            dataType = "Numeric(21, 8)";
        } else if (fieldInfo.getDataType().equals((Object)DataTypeEnum.Amount)) {
            dataType = "Numeric(17, 4)";
        } else if (fieldInfo.getDataType().equals((Object)DataTypeEnum.Price)) {
            dataType = "Numeric(21, 8)";
        } else if (fieldInfo.getDataType().equals((Object)DataTypeEnum.Enum)) {
            String eClassName = fieldInfo.getBaseDataBOSType();
            IMetaDataLoader loader = null;
            loader = ctx == null ? MetaDataLoaderFactory.getRemoteMetaDataLoader() : MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
            BizEnumInfo bizEnum = (BizEnumInfo)loader.get(MetaDataTypeList.BIZENUM, (IMetaDataPK)MetaDataPK.create((String)eClassName));
            if (bizEnum == null) {
                throw new TDException(TDException.ERROR_MSG, new Object[]{"\u6570\u636e\u7c7b\u578b\u4e0d\u5408\u6cd5"});
            }
            if (BizEnumValueType.INTEGER.equals((Object)bizEnum.getDataType())) {
                dataType = "Int";
            } else if (BizEnumValueType.STRING.equals((Object)bizEnum.getDataType())) {
                dataType = "Varchar(100)";
            }
        } else {
            throw new TDException(TDException.ERROR_MSG, new Object[]{"\u6570\u636e\u7c7b\u578b\u4e0d\u5408\u6cd5"});
        }
        return dataType;
    }

    public static String getDefaultValueSQL(DataFetchEntryInfo fieldInfo, boolean isCreateSQL) {
        String defaultValue = "";
        if (StringUtils.isEmpty((String)fieldInfo.getDefaultValue())) {
            return defaultValue;
        }
        if (fieldInfo.getDataType().equals((Object)DataTypeEnum.String) || fieldInfo.getDataType().equals((Object)DataTypeEnum.Date) || fieldInfo.getDataType().equals((Object)DataTypeEnum.BOSUuid)) {
            defaultValue = "'" + fieldInfo.getDefaultValue() + "'";
        } else if (fieldInfo.getDataType().equals((Object)DataTypeEnum.Integer) || fieldInfo.getDataType().equals((Object)DataTypeEnum.Boolean) || fieldInfo.getDataType().equals((Object)DataTypeEnum.Qty) || fieldInfo.getDataType().equals((Object)DataTypeEnum.Price) || fieldInfo.getDataType().equals((Object)DataTypeEnum.Amount)) {
            defaultValue = fieldInfo.getDefaultValue();
        } else if (fieldInfo.getDataType().equals((Object)DataTypeEnum.Enum)) {
            defaultValue = fieldInfo.getDefaultValue();
        }
        if (isCreateSQL) {
            return "default " + defaultValue;
        }
        return defaultValue;
    }

    public static String getDataFetchFieldStr(DataFetchInfo dataFetchInfo, String prefix) {
        StringBuffer str = new StringBuffer();
        DataFetchEntryCollection coll = dataFetchInfo.getEntry();
        coll.sort("seq");
        DataFetchEntryInfo fieldInfo = null;
        String tmpPrefix = "";
        if (!StringUtils.isEmpty((String)prefix)) {
            tmpPrefix = prefix + ".";
        }
        for (int i = 0; i < coll.size(); ++i) {
            fieldInfo = coll.get(i);
            if (i > 0) {
                str.append(",");
            }
            str.append(tmpPrefix).append(fieldInfo.getName());
        }
        return str.toString();
    }

    public static String getDataFetchDimFieldStr(DataFetchInfo dataFetchInfo, String prefix) {
        StringBuffer str = new StringBuffer();
        DataFetchEntryCollection coll = dataFetchInfo.getEntry();
        DataFetchEntryInfo fieldInfo = null;
        String tmpPrefix = "";
        if (!StringUtils.isEmpty((String)prefix)) {
            tmpPrefix = prefix + ".";
        }
        for (int i = 0; i < coll.size(); ++i) {
            fieldInfo = coll.get(i);
            if (!BizDataTypeEnum.Dim.equals((Object)fieldInfo.getBizDataType())) continue;
            str.append(tmpPrefix).append(fieldInfo.getName()).append(",");
        }
        return str.substring(0, str.length() - 1);
    }

    public static List<String> getDataFetchDimFields(DataFetchInfo dataFetchInfo) {
        DataFetchEntryCollection coll = dataFetchInfo.getEntry();
        DataFetchEntryInfo fieldInfo = null;
        ArrayList<String> dim = new ArrayList<String>();
        for (int i = 0; i < coll.size(); ++i) {
            fieldInfo = coll.get(i);
            if (!BizDataTypeEnum.Dim.equals((Object)fieldInfo.getBizDataType())) continue;
            dim.add(fieldInfo.getName());
        }
        return dim;
    }

    public static String getCreateSQLByDataFetch(Context ctx, DataFetchInfo info) throws BOSException, EASBizException {
        String newLine = "\n\t";
        StringBuffer createSQL = new StringBuffer();
        createSQL.append("Create Table TempReportTable").append("(").append(newLine);
        DataFetchEntryCollection coll = info.getEntry();
        coll.sort("seq");
        DataFetchEntryInfo fieldInfo = null;
        for (int i = 0; i < coll.size(); ++i) {
            fieldInfo = coll.get(i);
            String fieldName = fieldInfo.getName();
            String dataType = DataModelUtil.getDataTypeStr(ctx, fieldInfo);
            String defaultValue = DataModelUtil.getDefaultValueSQL(fieldInfo, true);
            String constraint = !fieldInfo.isIsNullable() ? "Not Null" : "";
            createSQL.append("  ").append(fieldName).append(" ").append(dataType).append(" ").append(defaultValue).append(" ").append(constraint);
            if (i != coll.size() - 1) {
                createSQL.append(",");
            }
            createSQL.append(newLine);
        }
        createSQL.append(")");
        return createSQL.toString();
    }

    public static TakeDataContditionCollection getCondition(Context ctx, DataFetchInfo info) throws EASBizException, BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("dataFetch.id", (Object)info.getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("dataSource.state", (Object)"2", CompareType.EQUALS));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("dataSource.id"));
        view.setSelector(sic);
        DataSourceToDataFetchCollection dsColl = DataSourceToDataFetchFactory.getLocalInstance(ctx).getDataSourceToDataFetchCollection(view);
        HashSet<String> dataSourceIds = new HashSet<String>();
        int size = dsColl.size();
        for (int i = 0; i < size; ++i) {
            dataSourceIds.add(dsColl.get(i).getDataSource().getId().toString());
        }
        if (dataSourceIds.size() == 0) {
            return null;
        }
        view = new EntityViewInfo();
        filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("dataSource.id", dataSourceIds, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)"1", CompareType.EQUALS));
        view.setFilter(filter);
        sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("dataSource.*"));
        sic.add(new SelectorItemInfo("dataSource.entry.*"));
        view.setSelector(sic);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("dataSource.number"));
        view.setSorter(sorter);
        TakeDataContditionCollection coll = TakeDataContditionFactory.getLocalInstance(ctx).getTakeDataContditionCollection(view);
        return coll;
    }

    public static String getInsertSQL(String tableName, DataFetchInfo info) {
        StringBuffer insertSQL = new StringBuffer();
        insertSQL.append("INSERT INTO ").append(tableName).append("(");
        insertSQL.append(DataModelUtil.getDataFetchFieldStr(info, null));
        insertSQL.append(")");
        return insertSQL.toString();
    }
}

