/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.cloud.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.tm.td.basedata.DataTypeEnum;
import com.kingdee.eas.tm.td.cloud.datamodel.IItemDimension;
import com.kingdee.eas.tm.td.cloud.datamodel.ItemDimensionEntryInfo;
import com.kingdee.eas.tm.td.cloud.datamodel.ItemDimensionFactory;
import com.kingdee.eas.tm.td.cloud.datamodel.ItemDimensionInfo;
import com.kingdee.eas.tm.td.cloud.datamodel.ItemFormatEnum;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public class TDCloudUtil {
    public static String structureFilter(Context ctx, String filterItems, String queryPK) throws BOSException {
        IQueryExecutor exec = null;
        exec = ctx == null ? QueryExecutorFactory.getRemoteInstance((IMetaDataPK)new MetaDataPK(queryPK)) : QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK(queryPK));
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("id"));
        if (filterItems != null && filterItems.length() > 0) {
            try {
                view.setFilter(new FilterInfo(filterItems));
            }
            catch (ParserException e) {
                throw new BOSException((Throwable)e);
            }
        }
        exec.setObjectView(view);
        String sql = exec.getSQL();
        return sql;
    }

    public static BigDecimal toBigDecimal(Object obj) {
        if (obj != null) {
            Variant v;
            if (obj instanceof BigDecimal) {
                return (BigDecimal)obj;
            }
            if (obj instanceof Variant && ((v = (Variant)obj).isEmpty() || v.isNull())) {
                return new BigDecimal(0.0);
            }
            if (obj.toString().startsWith("#PARAMETER")) {
                return new BigDecimal(0.0);
            }
            return new BigDecimal(obj.toString());
        }
        return null;
    }

    public static boolean isEqual(Object newValue, Object oldValue) {
        Object[] newValueArr = null;
        newValueArr = newValue instanceof Object[] ? (Object[])newValue : new Object[]{newValue};
        Object[] oldValueArr = null;
        oldValueArr = oldValue instanceof Object[] ? (Object[])oldValue : new Object[]{oldValue};
        if (newValueArr.length != oldValueArr.length) {
            return false;
        }
        HashMap<String, CoreBaseInfo> oldValueMap = new HashMap<String, CoreBaseInfo>();
        CoreBaseInfo oldValueInfo = null;
        for (int i = 0; i < oldValueArr.length; ++i) {
            oldValueInfo = (CoreBaseInfo)oldValueArr[i];
            if (oldValueInfo == null) continue;
            oldValueMap.put(oldValueInfo.getId().toString(), oldValueInfo);
        }
        HashMap<String, CoreBaseInfo> newValueMap = new HashMap<String, CoreBaseInfo>();
        CoreBaseInfo newValueInfo = null;
        for (int i = 0; i < newValueArr.length; ++i) {
            newValueInfo = (CoreBaseInfo)newValueArr[i];
            if (newValueInfo == null) continue;
            newValueMap.put(newValueInfo.getId().toString(), newValueInfo);
            if (oldValueMap.get(newValueInfo.getId().toString()) != null) continue;
            return false;
        }
        return oldValueMap.size() == newValueMap.size();
    }

    public static boolean isEmpty(String id) {
        return id == null || StringUtils.isEmpty((String)id) || id.equals("null");
    }

    public static ItemDimensionInfo getItemDimensionInfo(Context ctx, String itemDimensionId) throws EASBizException, BOSException {
        IItemDimension iitem = null;
        iitem = ctx == null ? ItemDimensionFactory.getRemoteInstance() : ItemDimensionFactory.getLocalInstance(ctx);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("entry.*");
        sic.add("entry.item.*");
        sic.add("entry.item.sumItems.*");
        sic.add("entry.item.sumItems.sourceItem.*");
        sic.add("mergeEntry.*");
        sic.add("mergeEntry.item.*");
        sic.add("taxReportSheet.*");
        ItemDimensionInfo dimensionInfo = iitem.getItemDimensionInfo((IObjectPK)new ObjectUuidPK(itemDimensionId), sic);
        return dimensionInfo;
    }

    public static Date getMonthFirstDay(int year, int month) {
        Calendar newDate = Calendar.getInstance();
        newDate.set(1, year);
        newDate.set(2, month - 1);
        newDate.set(5, 1);
        return newDate.getTime();
    }

    public static Date getMonthLastDay(int year, int month) {
        Calendar newDate = Calendar.getInstance();
        newDate.set(1, year);
        newDate.set(2, month - 1);
        newDate.set(5, newDate.getActualMaximum(5));
        return newDate.getTime();
    }

    public static List getColumnsByDimension(ItemDimensionInfo dimensionInfo, String taxTypeId, int statPeriod) {
        ArrayList ret = new ArrayList();
        HashMap<String, Object> headColumn = null;
        headColumn = new HashMap<String, Object>();
        headColumn.put("label", "\u5e8f\u53f7");
        headColumn.put("name", "customSn");
        headColumn.put("hidden", false);
        headColumn.put("settable", false);
        headColumn.put("dataType", (Object)DataTypeEnum.String);
        ret.add(headColumn);
        headColumn = null;
        headColumn = new HashMap();
        headColumn.put("label", "FID");
        headColumn.put("name", "FID");
        headColumn.put("hidden", true);
        headColumn.put("settable", false);
        headColumn.put("dataType", (Object)DataTypeEnum.String);
        ret.add(headColumn);
        headColumn = new HashMap();
        headColumn.put("label", "FGROUPID");
        headColumn.put("name", "FGROUPID");
        headColumn.put("hidden", true);
        headColumn.put("settable", false);
        headColumn.put("dataType", (Object)DataTypeEnum.String);
        ret.add(headColumn);
        headColumn = new HashMap();
        headColumn.put("label", "FPARENTID");
        headColumn.put("name", "FPARENTID");
        headColumn.put("hidden", true);
        headColumn.put("settable", false);
        headColumn.put("dataType", (Object)DataTypeEnum.String);
        ret.add(headColumn);
        headColumn = null;
        headColumn = new HashMap();
        headColumn.put("label", "FCOMPANYID");
        headColumn.put("name", "FCOMPANYID");
        headColumn.put("hidden", true);
        headColumn.put("settable", false);
        headColumn.put("dataType", (Object)DataTypeEnum.String);
        ret.add(headColumn);
        headColumn = new HashMap();
        headColumn.put("label", "\u516c\u53f8");
        headColumn.put("name", "FBILLNAME");
        headColumn.put("hidden", false);
        headColumn.put("formatter", "groupFomatter");
        headColumn.put("width", 380);
        headColumn.put("dataType", (Object)DataTypeEnum.String);
        ret.add(headColumn);
        headColumn = new HashMap();
        headColumn.put("label", "\u516c\u53f8\u603b\u6570");
        headColumn.put("name", "FCOMPANYTOTAL");
        headColumn.put("formatter", "companyTotalFormat");
        headColumn.put("hidden", false);
        headColumn.put("dataType", (Object)DataTypeEnum.String);
        ret.add(headColumn);
        headColumn = new HashMap();
        headColumn.put("label", "\u533a\u57df");
        headColumn.put("name", "FAREANAME");
        headColumn.put("hidden", false);
        headColumn.put("dataType", (Object)DataTypeEnum.String);
        ret.add(headColumn);
        headColumn = new HashMap();
        headColumn.put("label", "\u7701/\u76f4\u8f96\u5e02");
        headColumn.put("name", "FPROVINCENAME");
        headColumn.put("hidden", false);
        headColumn.put("dataType", (Object)DataTypeEnum.String);
        ret.add(headColumn);
        headColumn = new HashMap();
        headColumn.put("label", "\u57ce\u5e02");
        headColumn.put("name", "FCITYNAME");
        headColumn.put("hidden", false);
        headColumn.put("dataType", (Object)DataTypeEnum.String);
        ret.add(headColumn);
        headColumn = new HashMap();
        headColumn.put("label", "\u533a/\u53bf");
        headColumn.put("name", "FREGIONNAME");
        headColumn.put("hidden", false);
        headColumn.put("dataType", (Object)DataTypeEnum.String);
        ret.add(headColumn);
        headColumn = new HashMap();
        headColumn.put("label", "\u5e74");
        headColumn.put("name", "FYEAR");
        headColumn.put("hidden", false);
        headColumn.put("dataType", (Object)DataTypeEnum.String);
        ret.add(headColumn);
        headColumn = new HashMap();
        headColumn.put("label", "\u534a\u5e74");
        headColumn.put("name", "FHALFYEAR");
        headColumn.put("formatter", "halfYearFomatter");
        headColumn.put("hidden", false);
        headColumn.put("dataType", (Object)DataTypeEnum.String);
        ret.add(headColumn);
        headColumn = new HashMap();
        headColumn.put("label", "\u5b63\u5ea6");
        headColumn.put("name", "FQUARTER");
        headColumn.put("formatter", "quarterFomatter");
        headColumn.put("hidden", false);
        headColumn.put("dataType", (Object)DataTypeEnum.String);
        ret.add(headColumn);
        headColumn = new HashMap();
        headColumn.put("label", "\u6708");
        headColumn.put("name", "FMONTH");
        headColumn.put("hidden", false);
        headColumn.put("dataType", (Object)DataTypeEnum.String);
        ret.add(headColumn);
        headColumn = new HashMap();
        headColumn.put("label", "FLEVEL");
        headColumn.put("name", "FLEVEL");
        headColumn.put("hidden", true);
        headColumn.put("settable", false);
        headColumn.put("dataType", (Object)DataTypeEnum.String);
        ret.add(headColumn);
        headColumn = new HashMap();
        headColumn.put("label", "FISLEAF");
        headColumn.put("name", "FISLEAF");
        headColumn.put("hidden", true);
        headColumn.put("settable", false);
        headColumn.put("dataType", (Object)DataTypeEnum.String);
        ret.add(headColumn);
        boolean it = false;
        headColumn = new HashMap();
        headColumn.put("label", "FISSHOW");
        headColumn.put("name", "FISSHOW");
        headColumn.put("hidden", true);
        headColumn.put("settable", false);
        headColumn.put("dataType", (Object)DataTypeEnum.String);
        ret.add(headColumn);
        dimensionInfo.getEntry().sort("seq");
        ItemDimensionEntryInfo entryInfo = null;
        int size = dimensionInfo.getEntry().size();
        for (int i = 0; i < size; ++i) {
            entryInfo = dimensionInfo.getEntry().get(i);
            if (!TDCloudUtil.isFitTaxType(entryInfo, taxTypeId) || !TDCloudUtil.isNeedStat(entryInfo, statPeriod)) continue;
            headColumn = new HashMap();
            headColumn.put("label", entryInfo.getAlias());
            headColumn.put("name", entryInfo.getItemField().toUpperCase());
            headColumn.put("hidden", entryInfo.isIsHide());
            headColumn.put("dataType", (Object)DataTypeEnum.Amount);
            if (ItemFormatEnum.thousands.equals((Object)entryInfo.getItemFormat())) {
                headColumn.put("formatter", "thousandsFomatter");
            } else if (ItemFormatEnum.percentage.equals((Object)entryInfo.getItemFormat())) {
                headColumn.put("formatter", "percentageFomatter");
            } else if (ItemFormatEnum.defaults.equals((Object)entryInfo.getItemFormat())) {
                headColumn.put("formatter", "defaults");
            }
            headColumn.put("width", 120);
            headColumn.put("archiveUrl", entryInfo.getArchiveUrl() != null ? entryInfo.getArchiveUrl().getId().toString() : null);
            ret.add(headColumn);
        }
        return ret;
    }

    public static boolean isNeedStat(ItemDimensionEntryInfo entryInfo, int statPeriod) {
        return entryInfo.getStatPeriod() == null || entryInfo.getStatPeriod().getValue() == 0 || entryInfo.getStatPeriod().getValue() == statPeriod;
    }

    public static boolean isFitTaxType(ItemDimensionEntryInfo entryInfo, String taxTypeId) {
        if (TDCloudUtil.isEmpty(taxTypeId)) {
            return true;
        }
        if (entryInfo.getItem() != null && entryInfo.getItem().getTaxType() != null && !taxTypeId.equals(entryInfo.getItem().getTaxType().getId().toString())) {
            return false;
        }
        return entryInfo.getTaxReportSheet() == null || entryInfo.getTaxReportSheet().getTaxType() == null || taxTypeId.equals(entryInfo.getTaxReportSheet().getTaxType().getId().toString());
    }
}

