/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.common.billimport;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.app.util.TDServerCache;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.StringUtils;
import com.kingdee.util.enums.Enum;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class TDBillImportBase
extends AbstractDataTransmission {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.td.common.billimport.TDBillImportBase");
    protected EntityObjectInfo entity = null;

    protected String getString(Hashtable hsData, String key) {
        Object o = ((DataToken)hsData.get((Object)key)).data;
        return o == null ? null : o.toString();
    }

    protected String getString(Map hsData, String key) {
        Object o = hsData.get(key);
        return o == null ? null : o.toString();
    }

    public static BigDecimal getNumberByString(Context ctx, String numberString, int precision, String formatErrorString, boolean isRate) throws TaskExternalException {
        String rateStringSplit1;
        String[] rateStringSplit;
        numberString = numberString.trim();
        BigDecimal numberBigDecimal = new BigDecimal(0.0);
        try {
            numberBigDecimal = new BigDecimal(numberString);
        }
        catch (Exception e) {
            throw new TaskExternalException(formatErrorString);
        }
        if (isRate && (BigDecimal.ZERO.compareTo(numberBigDecimal) > 0 || BigDecimal.ONE.compareTo(numberBigDecimal) < 0)) {
            throw new TaskExternalException(formatErrorString);
        }
        if (precision >= 0 && (rateStringSplit = numberString.split("\\.")).length == 2 && (rateStringSplit1 = rateStringSplit[1].replaceAll("(0)+$", "")).length() > precision) {
            throw new TaskExternalException(formatErrorString);
        }
        return numberBigDecimal;
    }

    protected BigDecimal getBigDecimal(Context ctx, Map hsData, String colName) throws TaskExternalException {
        try {
            String strNum = this.getString(hsData, colName);
            if (strNum != null && strNum.length() > 0) {
                return new BigDecimal(strNum);
            }
            return null;
        }
        catch (Exception e) {
            throw new TaskExternalException(this.getTDResource(ctx, "ColumnFormatError", new Object[]{colName}));
        }
    }

    protected Timestamp getTimestamp(String time) {
        try {
            return Timestamp.valueOf(time);
        }
        catch (Exception e) {
            try {
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
                return new Timestamp(format.parse(time).getTime());
            }
            catch (Exception e2) {
                return null;
            }
        }
    }

    protected Enum getEnumValue(String enumSource, Object value) throws EASBizException, BOSException {
        return TDUtils.getEnumValue(enumSource, value);
    }

    protected Enum getEnum(Context ctx, String enumSource, String enumValue, Enum defaultValue, String propertyAlias) throws TaskExternalException {
        Enum value = null;
        if (StringUtils.isEmpty((String)enumValue)) {
            value = defaultValue;
        } else {
            try {
                value = TDUtils.getEnumValue(enumSource, enumValue);
            }
            catch (Exception e) {
                throw new TaskExternalException(e.getMessage());
            }
            if (value == null) {
                throw new TaskExternalException(this.getTDResource(ctx, "INPUT_ERROR", new Object[]{propertyAlias, enumValue}));
            }
        }
        return value;
    }

    protected boolean getBoolean(Context ctx, String booleanVal, String propertyAlias) throws TaskExternalException {
        String yes = TDUtils.getString("com.kingdee.eas.tm.td.TDResource", "YES", ctx.getLocale());
        String no = TDUtils.getString("com.kingdee.eas.tm.td.TDResource", "NO", ctx.getLocale());
        boolean retVal = false;
        if (!StringUtils.isEmpty((String)booleanVal)) {
            if (yes.equals(booleanVal) || "TRUE".equalsIgnoreCase(booleanVal)) {
                retVal = true;
            } else if (no.equals(booleanVal) || "FALSE".equalsIgnoreCase(booleanVal)) {
                retVal = false;
            } else {
                throw new TaskExternalException(this.getTDResource(ctx, "INPUT_ERROR", new Object[]{propertyAlias, booleanVal}));
            }
        }
        return retVal;
    }

    protected Date getDate(Context ctx, String dateValue, String propertyAlias) throws TaskExternalException {
        Date date = null;
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        if (!StringUtils.isEmpty((String)dateValue)) {
            try {
                date = df.parse(dateValue);
            }
            catch (ParseException pex) {
                throw new TaskExternalException(this.getTDResource(ctx, "DATE_ERROR", new Object[]{propertyAlias, dateValue}));
            }
        }
        return date;
    }

    protected IObjectValue getF7Value(Context ctx, ICoreBase iCoreBase, String matchField, String value, String propertyAlias, FilterInfo outFilter) throws TaskExternalException {
        IObjectValue info = null;
        if (!StringUtils.isEmpty((String)value)) {
            try {
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo(matchField, (Object)value, CompareType.EQUALS));
                if (outFilter != null) {
                    filter.mergeFilter(outFilter, "AND");
                }
                view.setFilter(filter);
                CoreBaseCollection coll = iCoreBase.getCollection(view);
                if (coll.size() > 0) {
                    info = coll.getObject(0);
                }
            }
            catch (Exception ex) {
                throw new TaskExternalException(ex.getMessage());
            }
            if (info == null) {
                throw new TaskExternalException(this.getTDResource(ctx, "F7_ERROR", new Object[]{propertyAlias, value}));
            }
        }
        return info;
    }

    protected boolean parseBoolean(Context ctx, Map hsData, IObjectValue info, String property, String dataField) throws TaskExternalException {
        String propertyAlias = this.getProperyAlias(ctx, info, property);
        boolean booleanValue = this.getBoolean(ctx, this.getString(hsData, dataField), propertyAlias);
        info.put(property, (Object)booleanValue);
        return booleanValue;
    }

    protected Enum parseEnum(Context ctx, Map hsData, IObjectValue info, String enumSource, String property, String dataField, Enum defaultValue) throws TaskExternalException {
        String enumAlias;
        String enumValue = this.getString(hsData, dataField);
        Enum enumObject = this.getEnum(ctx, enumSource, enumValue, defaultValue, enumAlias = this.getProperyAlias(ctx, info, property));
        if (enumObject != null) {
            info.put(property, (Object)enumObject);
        } else {
            info.put(property, null);
        }
        return enumObject;
    }

    protected String parseString(Context ctx, Map hsData, IObjectValue info, String property, String dataField) throws TaskExternalException {
        String value = this.getString(hsData, dataField);
        info.put(property, (Object)value);
        return value;
    }

    protected Date parseDate(Context ctx, Map hsData, IObjectValue info, String property, String dataField) throws TaskExternalException {
        String dateValue = this.getString(hsData, dataField);
        String propertyAlias = this.getProperyAlias(ctx, info, property);
        Date date = this.getDate(ctx, dateValue, propertyAlias);
        info.put(property, (Object)date);
        return date;
    }

    protected IObjectValue parseF7(Context ctx, Map hsData, IObjectValue info, ICoreBase iCoreBase, String property, String dataField, String matchField) throws TaskExternalException {
        String value = this.getString(hsData, dataField);
        String propertyAlias = this.getProperyAlias(ctx, info, property);
        IObjectValue f7Value = this.getF7Value(ctx, iCoreBase, matchField, value, propertyAlias, null);
        info.put(property, (Object)f7Value);
        return f7Value;
    }

    protected IObjectValue parseF7(Context ctx, Map hsData, IObjectValue info, ICoreBase iCoreBase, String property, String dataField, String matchField, FilterInfo outFilter) throws TaskExternalException {
        String value = this.getString(hsData, dataField);
        String propertyAlias = this.getProperyAlias(ctx, info, property);
        IObjectValue f7Value = this.getF7Value(ctx, iCoreBase, matchField, value, propertyAlias, outFilter);
        info.put(property, (Object)f7Value);
        return f7Value;
    }

    protected String getProperyAlias(Context ctx, IObjectValue info, String property) {
        PropertyInfo propertyInfo;
        if (info == null || StringUtils.isEmpty((String)property)) {
            return "";
        }
        String bosType = info.getBOSType().toString();
        this.entity = TDServerCache.getEntity((Context)ctx, (String)bosType);
        String propertyAlias = "";
        if (this.entity != null && (propertyInfo = this.entity.getPropertyByName(property)) != null) {
            propertyAlias = propertyInfo.getAlias();
        }
        return propertyAlias;
    }

    public void putToHashtable(Hashtable htable, Object key, Object value) {
        if (value != null) {
            htable.put(key, value);
        }
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        String filterStr;
        FilterInfo filter = new FilterInfo();
        if (this.getContextMap().get("bizCommonQueryFilter") != null) {
            filterStr = this.getContextMap().get("bizCommonQueryFilter").toString();
            filterStr = filterStr.replace("$", "'");
            try {
                filter = new FilterInfo(filterStr);
            }
            catch (ParserException e) {
                logger.error((Object)e);
            }
        }
        if (this.getContextMap().get("filter") != null) {
            filterStr = this.getContextMap().get("filter").toString();
            filterStr = filterStr.replace("$", "'");
            try {
                filter = new FilterInfo(filterStr);
            }
            catch (ParserException e) {
                logger.error((Object)e);
            }
        }
        return filter;
    }

    protected String getTDResource(Context ctx, String resName, Object[] params) {
        return ResourceBase.getString((String)"com.kingdee.eas.tm.td.TDImportResource", (String)resName, (Locale)ctx.getLocale(), (Object[])params);
    }

    protected String getTDResource(Context ctx, String resName) {
        return ResourceBase.getString((String)"com.kingdee.eas.tm.td.TDImportResource", (String)resName, (Locale)ctx.getLocale());
    }
}

