/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.common.uihelper;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.framework.client.ListUiHelper;
import com.kingdee.eas.tm.td.TDFacadeFactory;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.common.actionproxy.TDActionProxy;
import com.kingdee.eas.tm.td.common.permsupport.IPermSupport4ListUI;
import com.kingdee.eas.tm.td.common.uihelper.UIHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;

public class ListUIHelper
extends UIHelper {
    private ListUI ui = null;
    private OrgUnitCollection authorizedMainOrgs = null;

    public ListUIHelper(ListUI ui) {
        super((CoreUI)ui);
        this.ui = ui;
    }

    public void bindPermission(AbstractButton button, IItemAction target, Map serviceContext) {
        TDActionProxy actionProxy = new TDActionProxy(serviceContext, null, target);
        String text = button.getText();
        Icon icon = button.getIcon();
        String toolTip = button.getToolTipText();
        int mnemonic = button.getMnemonic();
        boolean isVisible = button.isVisible();
        ActionListener[] listeners = button.getActionListeners();
        if (listeners != null && listeners.length > 0) {
            for (int i = 0; i < listeners.length; ++i) {
                button.removeActionListener(listeners[i]);
            }
        }
        button.setAction((Action)((Object)actionProxy));
        button.setText(text);
        button.setMnemonic(mnemonic);
        button.setVisible(isVisible);
        button.setIcon(icon);
        if (button instanceof KDWorkButton) {
            ((KDWorkButton)button).setAutoToolTipText(true);
        }
        button.setToolTipText(toolTip);
    }

    public FilterInfo getHasPermissionOrgFilterForQuery() {
        FilterInfo filterInfo = new FilterInfo();
        if (!(this.ui instanceof IPermSupport4ListUI)) {
            return filterInfo;
        }
        try {
            IPermSupport4ListUI uiSupport = (IPermSupport4ListUI)this.ui;
            if (this.authorizedMainOrgs == null) {
                this.authorizedMainOrgs = this.getAuthOrgsByType(this.ui.getMainType(), this.ui.getMainQueryPK());
            }
            HashSet<String> keys = new HashSet<String>();
            String key = uiSupport.getBizOrgProperty(this.ui.getMainType());
            if (this.authorizedMainOrgs != null && this.authorizedMainOrgs.size() > 0) {
                if (key == null) {
                    throw new IllegalArgumentException("getMainBizOrgType() should return a correct value.");
                }
                int index = 0;
                for (int i = 0; i < this.authorizedMainOrgs.size(); ++i) {
                    if (this.ui.getMainOrgInfo() != null && this.authorizedMainOrgs.get(i).getId().toString().equals(this.ui.getMainOrgInfo().getId().toString())) {
                        index = i;
                    }
                    keys.add(this.authorizedMainOrgs.get(i).getId().toString());
                }
                filterInfo.getFilterItems().add(new FilterItemInfo(key + ".id", keys, CompareType.INCLUDE));
                if (this.ui.getMainType().equals((Object)OrgType.Company)) {
                    uiSupport.initPermMainOrgContext(this.authorizedMainOrgs.get(index).getId().toString());
                }
                return filterInfo;
            }
        }
        catch (Exception e) {
            this.ui.handUIException((Throwable)e);
        }
        return filterInfo;
    }

    public void checkStatusCanEdit(KDTable table, String statusColumnName, int enableValue) {
        this.checkStatusOperation(table, statusColumnName, enableValue, "EnableNotAllowEdit");
    }

    public void checkStatusCanRemove(KDTable table, String statusColumnName, int enableValue) {
        this.checkStatusOperation(table, statusColumnName, enableValue, "EnableNotAllowRemove");
    }

    private void checkStatusOperation(KDTable table, String statusColumnName, int enableValue, String operation) {
        BizEnumValueDTO statusEnum;
        IRow row = KDTableUtil.getSelectedRow((KDTable)table);
        Object state = row.getCell(statusColumnName).getValue();
        if (state != null && state instanceof BizEnumValueDTO && (statusEnum = (BizEnumValueDTO)state).getInt() == enableValue) {
            String msg = EASResource.getString((String)"com.kingdee.eas.tm.td.TDResource", (String)operation);
            MsgBox.showInfo((String)msg);
            SysUtil.abort();
        }
    }

    protected OrgUnitCollection getAuthOrgsByType(OrgType orgType, IMetaDataPK queryPK) throws EASBizException, BOSException {
        return TDFacadeFactory.getRemoteInstance().getAuthOrgsByType(orgType, queryPK);
    }

    public OrgUnitCollection getAuthorizedMainOrgs() {
        return this.authorizedMainOrgs;
    }

    public void setAuthorizedMainOrgs(OrgUnitCollection authorizedMainOrgs) {
        this.authorizedMainOrgs = authorizedMainOrgs;
    }

    public void batchOperation(String method, KDTable table, String keyFieldName, String numberColumn, String billBosType) throws Exception {
        String summaryMsg;
        this.ui.checkSelected();
        String bizMethodName = this.getBizMethodName(method);
        ArrayList ids = this.ui.getSelectedIdValuesArrayList();
        int billCount = ids.size();
        ListUiHelper listUiHelper = new ListUiHelper();
        Map mapNumber = listUiHelper.getSelectColumnValue(table, keyFieldName, numberColumn);
        Map rowNumberMap = new HashMap();
        if (mapNumber.isEmpty()) {
            rowNumberMap = listUiHelper.getSelectRowNumberMap(table, keyFieldName);
        }
        Map result = TDFacadeFactory.getRemoteInstance().batchOperation(billBosType, method, ids.toArray(new String[ids.size()]));
        String numbetMsg = TDUtils.getString("com.kingdee.eas.tm.td.TDBizResource", "Msg_ByNumber");
        String rowIndexMsg = TDUtils.getString("com.kingdee.eas.tm.td.TDBizResource", "Msg_ByRowIndex");
        int errorCount = 0;
        StringBuffer errorMsg = new StringBuffer();
        if (!"0".equals(result.get("ERROR_COUNT"))) {
            for (Object cause : result.keySet()) {
                if ("ERROR_COUNT".equals(cause.toString())) {
                    errorCount = Integer.parseInt(result.get(cause).toString());
                    continue;
                }
                String id = cause.toString();
                if (mapNumber.isEmpty()) {
                    errorMsg.append(MessageFormat.format(rowIndexMsg, rowNumberMap.get(id)));
                } else {
                    errorMsg.append(MessageFormat.format(numbetMsg, mapNumber.get(id)));
                }
                errorMsg.append("," + result.get(cause).toString() + "\n");
            }
        }
        if (errorCount > 0) {
            summaryMsg = TDUtils.getString("com.kingdee.eas.tm.td.TDBizResource", "Msg_Error", new Object[]{bizMethodName, String.valueOf(billCount - errorCount), String.valueOf(errorCount)}, null);
            MsgBox.showDetailAndOK(null, (String)summaryMsg, (String)errorMsg.toString(), (int)1);
        } else {
            summaryMsg = TDUtils.getString("com.kingdee.eas.tm.td.TDBizResource", "Msg_Success", new Object[]{bizMethodName}, null);
            MsgBox.showInfo((String)summaryMsg);
        }
    }

    protected String getBizMethodName(String method) {
        HashMap<String, String> bizAliasMap = new HashMap<String, String>();
        bizAliasMap.put("delete", "OPER_Delete");
        bizAliasMap.put("cancel", "OPER_Cancel");
        bizAliasMap.put("cancelCancel", "OPER_CancelCancel");
        String methodAlias = null;
        String value = (String)bizAliasMap.get(method);
        methodAlias = value != null ? TDUtils.getString("com.kingdee.eas.tm.td.TDBizResource", value) : TDUtils.getString("com.kingdee.eas.tm.td.TDBizResource", "OPER_Default");
        return methodAlias;
    }
}

