/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.directdeclare.comm.service;

import com.kingdee.bos.Context;
import com.kingdee.bos.json.Kson;
import com.kingdee.eas.tm.td.DraftStatusEnum;
import com.kingdee.eas.tm.td.ITaxDraftRecord;
import com.kingdee.eas.tm.td.TaxDraftRecordFactory;
import com.kingdee.eas.tm.td.directdeclare.ITeFacade;
import com.kingdee.eas.tm.td.directdeclare.TeException;
import com.kingdee.eas.tm.td.directdeclare.TeFacadeFactory;
import com.kingdee.eas.tm.td.directdeclare.comm.model.TePwyParam;
import com.kingdee.eas.tm.td.directdeclare.comm.service.AbstractTePwyService;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;

public class TeDeclarePwyService
extends AbstractTePwyService {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.td.directdeclare.comm.service.TeDeclarePwyService");
    private String declareXml = null;

    public String getDeclareXml() {
        return this.declareXml;
    }

    public void setDeclareXml(String declareXml) {
        this.declareXml = declareXml;
    }

    public TeDeclarePwyService(Context ctx, TePwyParam pwyParam) {
        super(ctx, pwyParam);
    }

    @Override
    protected String getData() throws Exception {
        String data = null;
        try {
            VelocityEngine ve = new VelocityEngine();
            ve.setProperty("resource.loader", (Object)"class");
            ve.setProperty("class.resource.loader.class", (Object)"org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
            ve.setProperty("UTF-8", (Object)"UTF-8");
            ve.setProperty("resource.default_encoding", (Object)"UTF-8");
            ve.init();
            String modulePath = "com/kingdee/eas/tm/td/directdeclare/comm/config/" + this.pwyParam.getVmModule().getSource();
            Template template = ve.getTemplate(modulePath, "UTF-8");
            VelocityContext context = new VelocityContext();
            Map declareData = this.pwyParam.getDeclareData();
            Map declareDetailData = this.pwyParam.getDeclareDetailData();
            context.put("data", (Object)declareData);
            context.put("detail", (Object)declareDetailData);
            StringWriter stringWriter = new StringWriter();
            template.merge((org.apache.velocity.context.Context)context, (Writer)stringWriter);
            data = stringWriter.toString();
            this.setDeclareXml(data);
            ITeFacade iTeFacade = this.ctx == null ? TeFacadeFactory.getRemoteInstance() : TeFacadeFactory.getLocalInstance(this.ctx);
            data = iTeFacade.encryptASE128(data, this.getTeServiceInfo().getSecretKey());
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            throw new TeException(TeException.GETDECLAREDATAERROR, new Object[]{this.getReportInfo().getNumber(), this.getReportInfo().getName()});
        }
        return data;
    }

    @Override
    protected String getOriginPwyData() throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("transeq", this.getTranSeq());
        map.put("transrc", this.getTranSrc());
        map.put("tranid", this.getTranId());
        map.put("sbdq", this.getSbdq());
        map.put("nsrsbh", this.getNsrsbh());
        map.put("skssqq", this.getSkssqq());
        map.put("skssqz", this.getSkssqz());
        map.put("data", "");
        String msg = Kson.getGson().toJson(map) + "\n";
        msg = msg + this.getDeclareXml();
        return msg;
    }

    @Override
    protected void doSuccess() throws Exception {
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(this.getReportInfo().getId().toString());
        ITaxDraftRecord iTaxDraftRecord = this.ctx == null ? TaxDraftRecordFactory.getRemoteInstance() : TaxDraftRecordFactory.getLocalInstance(this.ctx);
        iTaxDraftRecord.updateReportStatus(ids, DraftStatusEnum.DECLARING);
    }
}

