/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.directdeclare.comm.util;

import com.kingdee.bos.Context;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class SSLClientConfig
extends HashMap {
    private static Logger logger = Logger.getLogger(SSLClientConfig.class);
    public static final String DEFAULT_CONTENTTYPE = "application/json";
    private int connectionRequestTimeout = 6000;
    private int connectTimeout = 6000;
    private int socketTimeout = 60000;
    private String contentType = "application/json";
    private Map<String, String> headers = new HashMap<String, String>();
    private boolean isNeedEncrypt = false;

    protected SSLClientConfig(int connectionRequestTimeout, int connectTimeout, int socketTimeout, String contentType, Map<String, String> headers, boolean isNeedEncrypt) {
        this.connectionRequestTimeout = connectionRequestTimeout;
        this.connectTimeout = connectTimeout;
        this.socketTimeout = socketTimeout;
        this.contentType = contentType;
        this.headers = headers;
        this.isNeedEncrypt = isNeedEncrypt;
        if (isNeedEncrypt) {
            this.headers.put("encType", "2");
        }
    }

    public static Builder custom() {
        return new Builder();
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public int getConnectionRequestTimeout() {
        return this.connectionRequestTimeout;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public String getContentType() {
        return this.contentType;
    }

    public boolean isNeedEncrypt() {
        return this.isNeedEncrypt;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public static class Builder {
        private int connectionRequestTimeout = 6000;
        private int connectTimeout = 6000;
        private int socketTimeout = 60000;
        private String contentType = "application/json";
        private Map<String, String> headers = new HashMap<String, String>();
        private boolean isNeedEncrypt = false;

        public Builder setConfig(Context ctx) {
            return this;
        }

        public Builder setConnectionRequestTimeout(int connectionRequestTimeout) {
            this.connectionRequestTimeout = connectionRequestTimeout;
            return this;
        }

        public Builder setConnectTimeout(int connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder setSocketTimeout(int socketTimeout) {
            this.socketTimeout = socketTimeout;
            return this;
        }

        public Builder setContentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public Builder setNeedEncrypt(boolean isNeedEncrypt) {
            this.isNeedEncrypt = isNeedEncrypt;
            return this;
        }

        public Builder setHeaders(Map<String, String> headers) {
            this.headers = headers;
            return this;
        }

        public SSLClientConfig build() {
            return new SSLClientConfig(this.connectionRequestTimeout, this.connectTimeout, this.socketTimeout, this.contentType, this.headers, this.isNeedEncrypt);
        }
    }
}

