/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.est.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.common.permsupport.IPermSupport4EditUI;
import com.kingdee.eas.tm.td.common.uihelper.EditUIHelper;
import com.kingdee.eas.tm.td.est.AbstractRealEstateGroupEntryInfo;
import com.kingdee.eas.tm.td.est.CalcFormulaFactory;
import com.kingdee.eas.tm.td.est.CalcFormulaInfo;
import com.kingdee.eas.tm.td.est.EstStateEnum;
import com.kingdee.eas.tm.td.est.LandDataFactory;
import com.kingdee.eas.tm.td.est.LandDataInfo;
import com.kingdee.eas.tm.td.est.LandLevelEnum;
import com.kingdee.eas.tm.td.est.LandTaxStandardEntryCollection;
import com.kingdee.eas.tm.td.est.LandTaxStandardEntryInfo;
import com.kingdee.eas.tm.td.est.MonthEnum;
import com.kingdee.eas.tm.td.est.RealEstateGroupEntryCollection;
import com.kingdee.eas.tm.td.est.RealEstateGroupInfo;
import com.kingdee.eas.tm.td.est.TaxCycleEnum;
import com.kingdee.eas.tm.td.est.client.AbstractLandDataEditUI;
import com.kingdee.eas.tm.td.est.client.util.EstClientUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import com.kingdee.util.enums.EnumUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class LandDataEditUI
extends AbstractLandDataEditUI
implements IPermSupport4EditUI {
    private static final Logger logger = CoreUIObject.getLogger(LandDataEditUI.class);
    protected boolean isNumberEditable = false;
    private static Map<KDBizPromptBox, DataChangeListener> listenerCache = new HashMap<KDBizPromptBox, DataChangeListener>();
    private DataChangeListener realEstateGroupListener;
    private ItemListener landLevelListener;
    private Map landLevelMap;
    private List<KDFormattedTextField> numberText = Arrays.asList(this.txtArea, this.txtLandPrice, this.txtUsageAmount, this.txtLandCost, this.txtTaxStandard);
    private EditUIHelper uiHelper = null;
    private Map btnMap;

    protected void setFieldsNull(AbstractObjectValue newData) {
        LandDataInfo info = (LandDataInfo)newData;
        CompanyOrgUnitInfo company = info.getCompany();
        if (company != null) {
            try {
                IPermission permission = PermissionFactory.getRemoteInstance();
                ObjectUuidPK orgId = new ObjectUuidPK(company.getId());
                try {
                    if (!permission.hasFunctionPermission(this.getUserPk(), (IObjectPK)orgId, this.getPermItem(""))) {
                        info.setCompany(null);
                    }
                }
                catch (EASBizException e) {
                    this.handleException((Exception)((Object)e));
                }
            }
            catch (BOSException e) {
                this.handleException((Exception)((Object)e));
            }
        }
        info.setNumber(info.getNumber() + "copy");
        info.setName(info.getName() + "copy");
        info.setState(EstStateEnum.USING);
        info.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
        info.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        info.setLastUpdateUser(null);
        Timestamp tt = new Timestamp(System.currentTimeMillis());
        info.setCreateTime(tt);
        info.setLastUpdateTime(null);
        String companyID = info.getCU().getId().toString();
        try {
            String number = TDUtils.getNewNumber((IObjectValue)info, companyID);
            if (!StringUtils.isEmpty((String)number)) {
                info.setNumber(number);
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        EstClientUtils.textFieldTrim(this.getComponents());
    }

    private void checkBefore() {
        StringBuffer msgSB = new StringBuffer();
        StringBuffer notNullSB = new StringBuffer();
        if (this.prmtCompany.getValue() == null) {
            notNullSB.append(EASResource.getString((String)"com.kingdee.eas.tm.td.est.ESTResource", (String)"Company"));
        }
        if (this.txtNumber.getText().trim().isEmpty()) {
            notNullSB.append(EASResource.getString((String)"com.kingdee.eas.tm.td.est.ESTResource", (String)"Calc_Number"));
        }
        if (this.prmtRealEstateGroup.getValue() == null) {
            notNullSB.append(EASResource.getString((String)"com.kingdee.eas.tm.td.est.ESTResource", (String)"RealEstateGroup"));
        }
        if (this.txtName.getText().trim().isEmpty()) {
            notNullSB.append(EASResource.getString((String)"com.kingdee.eas.tm.td.est.ESTResource", (String)"LandName"));
        }
        if (this.pkLandTime.getValue() == null) {
            notNullSB.append(EASResource.getString((String)"com.kingdee.eas.tm.td.est.ESTResource", (String)"LandTime"));
        }
        if (this.comboState.getSelectedItem() == null) {
            notNullSB.append(EASResource.getString((String)"com.kingdee.eas.tm.td.est.ESTResource", (String)"State"));
        }
        if (this.comboTaxCycle.getSelectedItem() == null) {
            notNullSB.append(EASResource.getString((String)"com.kingdee.eas.tm.td.est.ESTResource", (String)"StatePeriod"));
        }
        if (this.comboFirstPaymentMonth.getSelectedItem() == null || MonthEnum.Null.equals(this.comboFirstPaymentMonth.getSelectedItem())) {
            notNullSB.append(EASResource.getString((String)"com.kingdee.eas.tm.td.est.ESTResource", (String)"FirstPaymentMonth"));
        }
        if (this.prmtCalcFormula.getValue() == null) {
            notNullSB.append(EASResource.getString((String)"com.kingdee.eas.tm.td.est.ESTResource", (String)"CalcFormula"));
        }
        if (this.comboTaxPayerType.getSelectedItem() == null) {
            notNullSB.append(EASResource.getString((String)"com.kingdee.eas.tm.td.est.ESTResource", (String)"TaxPayerType_Asset"));
        }
        if (notNullSB.length() > 0) {
            notNullSB.append(EASResource.getString((String)"com.kingdee.eas.tm.td.est.ESTResource", (String)"NOTNULL"));
        }
        String largerZeroSB = EstClientUtils.largerZero(new Object[]{this.contArea, this.contTaxStandard}, false);
        String notSmallerZero = EstClientUtils.largerZero(new Object[]{this.contLandPrice, this.contUsageAmount, this.contLandCost}, true);
        if (notNullSB.length() > 0) {
            msgSB.append(notNullSB.toString().substring(1)).append("\n");
        }
        if (largerZeroSB.length() > 0) {
            msgSB.append(largerZeroSB);
        }
        if (notSmallerZero.length() > 0) {
            msgSB.append(notSmallerZero);
        }
        if (msgSB.length() > 0) {
            MsgBox.showWarning((String)msgSB.toString());
            SysUtil.abort();
        }
    }

    protected String transmitNumber(String number) {
        if (number == null || number.length() == 0) {
            return "";
        }
        return number.replace(",", "");
    }

    public LandDataEditUI() throws Exception {
        logger.info((Object)this.getName());
        this.uiHelper = new EditUIHelper(this);
        this.btnMap = new HashMap();
        this.btnMap.put("actionRemove", this.actionRemove);
        this.btnMap.put("actionCancel", this.actionCancel);
        this.btnMap.put("actionCancelCancel", this.actionCancelCancel);
        this.btnMap.put("actionEdit", this.actionEdit);
        this.btnMap.put("actionSave", this.actionSubmit);
        this.btnMap.put("actionCopy", this.actionCopy);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initControls();
        this.initNumMinValue();
    }

    private void initNumMinValue() {
        this.txtLandPrice.setMinimumValue((Comparable)BigDecimal.ZERO);
        this.txtUsageAmount.setMinimumValue((Comparable)BigDecimal.ZERO);
        this.txtLandCost.setMinimumValue((Comparable)BigDecimal.ZERO);
    }

    private void initCalcFormula(LandDataInfo landInfo) throws BOSException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("taxItemType", "d8umkg7qNn3gU0ETqMCsX9uK96Y=");
        CalcFormulaInfo calcInfo = CalcFormulaFactory.getRemoteInstance().getDefaultCalcFormula(params);
        if (calcInfo != null) {
            landInfo.setCalcFormula(calcInfo);
        }
    }

    private void removeListeners() {
        if (this.realEstateGroupListener != null) {
            this.prmtRealEstateGroup.removeDataChangeListener(this.realEstateGroupListener);
        }
        if (this.landLevelListener != null) {
            this.comboLandLevel.removeItemListener(this.landLevelListener);
        }
    }

    @Override
    public void loadFields() {
        this.removeListeners();
        super.loadFields();
        this.initNumber();
        EstClientUtils.initProvinceFilter(this.prmtProvince, this.prmtCountry);
        EstClientUtils.initCityFilter(this.prmtCity, this.prmtProvince);
        EstClientUtils.initRegionFilter(this.prmtRegion, this.prmtCity);
        this.initFilter();
        this.initActionEnableByState();
        this.initListeners();
    }

    private void initControls() {
        for (int i = 0; i < this.numberText.size(); ++i) {
            this.numberText.get(i).setHorizontalAlignment(4);
        }
    }

    private void initFilter() {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("taxItemType.id", (Object)"d8umkg7qNn3gU0ETqMCsX9uK96Y=", CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)"1", CompareType.EQUALS));
        view.setFilter(filter);
        this.prmtCalcFormula.setEntityViewInfo(view);
        try {
            this.uiHelper.setMainBizOrgFilter();
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
    }

    private void initActionEnableByState() {
        EstStateEnum state = this.editData.getState();
        boolean isLight = false;
        if (EstStateEnum.FORBIDDEN.equals((Object)state)) {
            isLight = true;
        }
        this.uiHelper.initBtnStatus(this.btnMap, isLight);
        this.txtNumber.setEditable(this.isNumberEditable);
    }

    private void initListeners() {
        EstClientUtils.initCountryListener(listenerCache, this.prmtCountry, this.prmtProvince);
        EstClientUtils.initProvinceListener(listenerCache, this.prmtCountry, this.prmtProvince, this.prmtCity);
        EstClientUtils.initCityListener(listenerCache, this.prmtProvince, this.prmtCountry, this.prmtCity, this.prmtRegion);
        EstClientUtils.initRegionListener(listenerCache, this.prmtProvince, this.prmtCountry, this.prmtCity, this.prmtRegion);
        if (this.realEstateGroupListener == null) {
            this.realEstateGroupListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent eventObj) {
                    LandDataEditUI.this.dataChange_handleRealEstateGroup(eventObj);
                }
            };
        }
        this.prmtRealEstateGroup.addDataChangeListener(this.realEstateGroupListener);
        if (this.landLevelListener == null) {
            this.landLevelListener = new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    LandDataEditUI.this.itemChange_handleLandLevel(e);
                }
            };
        }
        this.comboLandLevel.addItemListener(this.landLevelListener);
    }

    protected void itemChange_handleLandLevel(ItemEvent e) {
        if (this.landLevelMap == null || this.landLevelMap.isEmpty() || this.prmtRealEstateGroup.getValue() == null) {
            return;
        }
        LandLevelEnum landLevelEnum = (LandLevelEnum)((Object)this.comboLandLevel.getSelectedItem());
        this.txtTaxStandard.setValue((Object)new BigDecimal(this.landLevelMap.get((Object)landLevelEnum).toString()));
    }

    protected void dataChange_handleRealEstateGroup(DataChangeEvent eventObj) {
        if (eventObj.getNewValue() == null) {
            this.comboLandLevel.removeAllItems();
            this.comboLandLevel.addItems(EnumUtils.getEnumList((String)"com.kingdee.eas.tm.td.est.LandLevelEnum").toArray());
            return;
        }
        RealEstateGroupInfo info = (RealEstateGroupInfo)eventObj.getNewValue();
        LandTaxStandardEntryCollection coll = info.getLandTaxEntry();
        ArrayList<LandLevelEnum> landItemList = new ArrayList<LandLevelEnum>();
        if (coll != null && coll.size() > 0) {
            this.landLevelMap = new HashMap();
            this.comboLandLevel.removeAllItems();
            int size = coll.size();
            for (int i = 0; i < size; ++i) {
                LandTaxStandardEntryInfo landTaxInfo = coll.get(i);
                landItemList.add(landTaxInfo.getLandLevel());
                this.landLevelMap.put(landTaxInfo.getLandLevel(), landTaxInfo.getTaxStandard());
            }
            this.comboLandLevel.addItems(landItemList.toArray());
            this.comboLandLevel.setSelectedItem((Object)0);
        } else {
            this.landLevelMap = null;
            this.comboLandLevel.removeAllItems();
            this.comboLandLevel.addItems(EnumUtils.getEnumList((String)"com.kingdee.eas.tm.td.est.LandLevelEnum").toArray());
            this.comboLandLevel.setSelectedItem(null);
        }
        RealEstateGroupEntryCollection regEntryColl = info.getEntry();
        AbstractRealEstateGroupEntryInfo realEstateGroupEntryInfo = null;
        if (regEntryColl != null && regEntryColl.size() > 0) {
            int j = regEntryColl.size();
            for (int i = 0; i < j; ++i) {
                if (!"d8umkg7qNn3gU0ETqMCsX9uK96Y=".equals(regEntryColl.get(i).getTaxItemType().getId().toString())) continue;
                realEstateGroupEntryInfo = regEntryColl.get(i);
                break;
            }
            if (realEstateGroupEntryInfo != null) {
                this.comboTaxCycle.setSelectedItem((Object)TaxCycleEnum.getEnum(realEstateGroupEntryInfo.getTaxCycle().getValue()));
                this.comboFirstPaymentMonth.setSelectedItem((Object)realEstateGroupEntryInfo.getFirstPaymentMonth());
            } else {
                this.comboFirstPaymentMonth.setSelectedItem((Object)MonthEnum.Null);
            }
        }
    }

    private void initNumber() {
        try {
            String companyID = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
            ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
            CodingRuleInfo codingRule = iCodingRuleManager.getCodingRule((IObjectValue)this.editData, companyID);
            if (codingRule == null) {
                this.isNumberEditable = true;
                return;
            }
            if (codingRule.isIsModifiable()) {
                this.isNumberEditable = true;
            }
            if (codingRule.isIsAddView() && this.txtNumber.getText().trim().isEmpty()) {
                this.txtNumber.setText(iCodingRuleManager.getNumber((IObjectValue)this.editData, companyID));
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.checkBefore();
        super.actionSubmit_actionPerformed(e);
        if (!this.getOprtState().equals(OprtState.ADDNEW)) {
            if (this.editData.getState() != null && EstStateEnum.USING.equals((Object)this.editData.getState())) {
                this.setOprtState("VIEW");
            } else {
                this.setOprtState("EDIT");
            }
        }
        this.setDataObject((IObjectValue)this.editData);
        this.loadFields();
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        this.initActionEnableByState();
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemove_actionPerformed(e);
    }

    private void refresh(IObjectPK pk) throws Exception {
        this.setDataObject(this.getValue(pk));
        this.loadFields();
        this.initOldData((IObjectValue)this.editData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        String id = this.editData.getId().toString();
        HashSet<String> ids = new HashSet<String>();
        ArrayList<String> idsList = new ArrayList<String>();
        idsList.add(id);
        ids.add(id);
        try {
            TDUtils.tryLock(idsList);
            ArrayList error = LandDataFactory.getRemoteInstance().cancel(ids);
            if (error != null && error.size() > 0) {
                MsgBox.showWarning((String)((String)error.get(0)));
            } else {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Forbid _OK"));
                ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)id));
                this.refresh((IObjectPK)pk);
            }
        }
        finally {
            TDUtils.releaseLock(idsList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        String id = this.editData.getId().toString();
        HashSet<String> ids = new HashSet<String>();
        ArrayList<String> idsList = new ArrayList<String>();
        idsList.add(id);
        ids.add(id);
        if (!this.uiHelper.modifySaveOrExit((ItemAction)this.actionSubmit, this.btnSubmit, (ItemAction)this.actionSave, this.btnSave, this.isModifySave())) {
            return;
        }
        try {
            TDUtils.tryLock(idsList);
            ArrayList error = LandDataFactory.getRemoteInstance().cancelCancel(ids);
            if (error.size() > 0) {
                MsgBox.showWarning((String)((String)error.get(0)));
            } else {
                this.setDataObject(this.getValue((IObjectPK)new ObjectUuidPK(id)));
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Startup_OK"));
                if (this.editData.getState() != null && EstStateEnum.USING.equals((Object)this.editData.getState())) {
                    this.setOprtState("VIEW");
                } else {
                    this.setOprtState("EDIT");
                }
                this.setDataObject((IObjectValue)this.editData);
                this.loadFields();
            }
        }
        finally {
            TDUtils.releaseLock(idsList);
        }
    }

    protected IObjectValue createNewData() {
        LandDataInfo info = new LandDataInfo();
        info.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
        info.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        info.setState(EstStateEnum.USING);
        try {
            this.initCalcFormula(info);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        return info;
    }

    protected KDTable getDetailTable() {
        return null;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return LandDataFactory.getRemoteInstanceWithObjectContext(this.getMainOrgContext());
    }

    @Override
    public String getBizOrgProperty(OrgType orgType) throws BOSException, EASBizException {
        return "company";
    }

    @Override
    public ICoreBase getPermInterface() throws Exception {
        return this.getBizInterface();
    }

    @Override
    public String getPermItem(String status) {
        return "land_landData_new";
    }

    @Override
    public KDBizPromptBox getPermMainBizOrg() {
        return this.prmtCompany;
    }

    @Override
    public IObjectValue getValueObject() {
        return this.editData;
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        IObjectPK pk = null;
        try {
            pk = this.uiHelper.getOrgPK();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        if (pk != null) {
            return pk;
        }
        if (this.getMainOrgContext() != null && this.getMainOrgContext().get((Object)this.getMainBizOrgType()) != null) {
            pk = new ObjectUuidPK(((OrgUnitInfo)this.getMainOrgContext().get((Object)this.getMainBizOrgType())).getId().toString());
            return pk;
        }
        return super.getOrgPK(action);
    }
}

