/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.est.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.framework.query.QuickFilteringSupportItems;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.common.permsupport.IPermSupport4ListUI;
import com.kingdee.eas.tm.td.common.uihelper.ListUIHelper;
import com.kingdee.eas.tm.td.est.EstStateEnum;
import com.kingdee.eas.tm.td.est.RentalEstateFactory;
import com.kingdee.eas.tm.td.est.RentalEstateInfo;
import com.kingdee.eas.tm.td.est.client.AbstractRentalEstateListUI;
import com.kingdee.eas.tm.td.est.client.RentalEstateEditUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import javax.swing.AbstractButton;
import org.apache.log4j.Logger;

public class RentalEstateListUI
extends AbstractRentalEstateListUI
implements IPermSupport4ListUI {
    private static final Logger logger = CoreUIObject.getLogger(RentalEstateListUI.class);
    private static final String[] MONEYCOLUMNS = new String[]{"rentalArea", "contractEntry.totalAmount", "contractEntry.monthRent", "contractEntry.firstRent", "contractEntry.lastRent"};
    private ListUIHelper uiHelper = null;
    private QuickFilteringSupportItems qfsi = new QuickFilteringSupportItems(true, true);

    public RentalEstateListUI() throws Exception {
        logger.info((Object)this.getName());
        this.uiHelper = new ListUIHelper((ListUI)this);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.btnAuditResult.setVisible(false);
        int j = MONEYCOLUMNS.length;
        for (int i = 0; i < j; ++i) {
            this.getMainTable().getColumn(MONEYCOLUMNS[i]).getStyleAttributes().setNumberFormat("#,##0.00");
        }
    }

    protected FilterInfo getDefaultFilterForQuery() {
        return this.uiHelper.getHasPermissionOrgFilterForQuery();
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    protected boolean isOrderByIDForBill() {
        return false;
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        if (this.confirmRemove()) {
            this.checkSelected();
            ArrayList result = RentalEstateFactory.getRemoteInstance().batchDelete(new HashSet(this.getSelectedIdValues()));
            String error = "";
            String errorDetail = "";
            if (result != null && !result.isEmpty()) {
                error = EASResource.getString((String)"com.kingdee.eas.tm.td.est.ESTResource", (String)"REMOVE_ERROR");
                errorDetail = TDUtils.buildErrorMsg(result);
                MsgBox.showDetailAndOK(null, (String)error, (String)errorDetail, (int)1);
            }
            this.refreshList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList ids = this.getSelectedIdValues();
        String cancelMsg = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Cancel");
        try {
            TDUtils.tryLock(ids);
            ArrayList errorList = RentalEstateFactory.getRemoteInstance().cancel(new HashSet(ids));
            if (errorList.size() > 0) {
                String cancelError = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_CancelError");
                String errorDetailMSG = TDUtils.buildErrorMsg(errorList);
                MsgBox.showDetailAndOK((Component)((Object)this), (String)cancelError, (String)errorDetailMSG, (int)8188);
            }
            this.actionRefresh_actionPerformed(e);
        }
        finally {
            TDUtils.releaseLock(ids);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList ids = this.getSelectedIdValues();
        try {
            TDUtils.tryLock(ids);
            ArrayList errorList = RentalEstateFactory.getRemoteInstance().cancelCancel(new HashSet(ids));
            String cancelCancelError = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_CancelCancelError");
            if (errorList.size() > 0) {
                String errorDetailMSG = TDUtils.buildErrorMsg(errorList);
                MsgBox.showDetailAndOK((Component)((Object)this), (String)cancelCancelError, (String)errorDetailMSG, (int)8188);
            }
            this.actionRefresh_actionPerformed(e);
        }
        finally {
            TDUtils.releaseLock(ids);
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        RentalEstateInfo info = RentalEstateFactory.getRemoteInstance().getRentalEstateInfo((IObjectPK)new ObjectUuidPK(id));
        if (EstStateEnum.USING.equals((Object)info.getState())) {
            MsgBox.showWarning((String)TDUtils.getString("com.kingdee.eas.tm.td.est.ESTResource", "Error_USINGEdit", TDUtils.getLocale()));
            return;
        }
        super.actionEdit_actionPerformed(e);
    }

    protected String getEditUIName() {
        return RentalEstateEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return RentalEstateFactory.getRemoteInstance();
    }

    public String[] getMergeColumnKeys() {
        String[] columns = new String[]{"id", "company.name", "company.number", "number", "realEstate.name", "realEstate.number", "name", "sysNumber", "rentalArea", "address", "state", "remark"};
        return columns;
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    protected QuickFilteringSupportItems getQuickFilteringSupport() {
        this.qfsi.setMustQueryAtFirst(true);
        return this.qfsi;
    }

    @Override
    public String getBizOrgProperty(OrgType orgType) throws BOSException, EASBizException {
        return "company";
    }

    @Override
    public ICoreBase getPermInterface() throws Exception {
        return this.getBizInterface();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        try {
            this.initPermActions();
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void initPermActions() throws BOSException, EASBizException {
        this.uiHelper.bindPermission((AbstractButton)this.btnRemove, (IItemAction)this.actionRemove, this.getServiceContext());
        this.uiHelper.bindPermission((AbstractButton)this.btnCancelCancel, (IItemAction)this.actionCancelCancel, this.getServiceContext());
        this.uiHelper.bindPermission((AbstractButton)this.btnCancel, (IItemAction)this.actionCancel, this.getServiceContext());
        this.uiHelper.bindPermission((AbstractButton)this.menuItemRemove, (IItemAction)this.actionRemove, this.getServiceContext());
        this.uiHelper.bindPermission((AbstractButton)this.menuItemCancelCancel, (IItemAction)this.actionCancelCancel, this.getServiceContext());
        this.uiHelper.bindPermission((AbstractButton)this.menuItemCancel, (IItemAction)this.actionCancel, this.getServiceContext());
    }

    @Override
    public void initPermMainOrgContext(String orgID) throws Exception {
        this.initUIMainOrgContext(orgID);
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        ObjectUuidPK pk = null;
        if (this.isSupportedBatchActions()) {
            RentalEstateInfo info = null;
            try {
                if (!StringUtils.isEmpty((String)this.getSelectedKeyValue()) && this.getBizInterface().exists((IObjectPK)new ObjectUuidPK(this.getSelectedKeyValue())) && (info = RentalEstateFactory.getRemoteInstance().getRentalEstateInfo((IObjectPK)new ObjectUuidPK(this.getSelectedKeyValue()))) != null && info.getCompany() != null) {
                    pk = new ObjectUuidPK(info.getCompany().getId().toString());
                }
            }
            catch (Exception e) {
                this.handUIException(e);
            }
            if (pk != null) {
                return pk;
            }
        }
        if (this.getMainOrgContext() != null && this.getMainOrgContext().get((Object)this.getMainBizOrgType()) != null) {
            pk = new ObjectUuidPK(((OrgUnitInfo)this.getMainOrgContext().get((Object)this.getMainBizOrgType())).getId().toString());
            return pk;
        }
        return super.getOrgPK(action);
    }

    public boolean isSupportedBatchActions() {
        return true;
    }
}

