/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.est.util;

import com.kingdee.eas.tm.td.est.EstCalculateRecordInfo;
import com.kingdee.eas.tm.td.est.TaxMethodEnum;
import com.kingdee.eas.tm.td.est.util.EstReportHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EstTaxDeclareParam {
    private String taxDeclareKey;
    private Map<String, EstCalculateRecordInfo> taxDeclareLandMap = new HashMap<String, EstCalculateRecordInfo>();
    private Map<String, List<EstCalculateRecordInfo>> taxDeclarePriceMap = new HashMap<String, List<EstCalculateRecordInfo>>();
    private Map<String, EstCalculateRecordInfo> taxDeclareRentMap = new HashMap<String, EstCalculateRecordInfo>();
    private Map<String, EstCalculateRecordInfo> taxDeclareVatMap = new HashMap<String, EstCalculateRecordInfo>();

    public EstTaxDeclareParam(String taxDeclareKey) {
        this.taxDeclareKey = taxDeclareKey;
    }

    public void addRecord(EstCalculateRecordInfo record) {
        String taxItemID = record.getTaxItemType().getId().toString();
        if ("ZCyrvv6oAnPgU0ETqMCc49uK96Y=".equals(taxItemID)) {
            if (TaxMethodEnum.PRICE.equals((Object)record.getTaxMethod())) {
                String taxDeclarePriceKey = EstReportHelper.getTaxDeclarePriceKey(record);
                if (this.taxDeclarePriceMap.containsKey(taxDeclarePriceKey)) {
                    this.taxDeclarePriceMap.get(taxDeclarePriceKey).add(record);
                } else {
                    ArrayList<EstCalculateRecordInfo> records = new ArrayList<EstCalculateRecordInfo>();
                    records.add(record);
                    this.taxDeclarePriceMap.put(taxDeclarePriceKey, records);
                }
            } else {
                this.taxDeclareRentMap.put(EstReportHelper.getTaxDeclareRentKey(record), record);
            }
        } else if ("d8umkg7qNn3gU0ETqMCsX9uK96Y=".equals(taxItemID)) {
            this.taxDeclareLandMap.put(EstReportHelper.getTaxDeclareLandKey(record), record);
        } else if ("Xip0em3cA6rgU0ETqMAGKduK96Y=".equals(taxItemID)) {
            this.taxDeclareVatMap.put(EstReportHelper.getTaxDeclareVatKey(record), record);
        }
    }

    public String getTaxDeclareKey() {
        return this.taxDeclareKey;
    }

    public void setTaxDeclareKey(String taxDeclareKey) {
        this.taxDeclareKey = taxDeclareKey;
    }

    public Map<String, EstCalculateRecordInfo> getTaxDeclareLandMap() {
        return this.taxDeclareLandMap;
    }

    public void setTaxDeclareLandMap(Map taxDeclareLandMap) {
        this.taxDeclareLandMap = taxDeclareLandMap;
    }

    public Map<String, List<EstCalculateRecordInfo>> getTaxDeclarePriceMap() {
        return this.taxDeclarePriceMap;
    }

    public void setTaxDeclarePriceMap(Map taxDeclarePriceMap) {
        this.taxDeclarePriceMap = taxDeclarePriceMap;
    }

    public Map<String, EstCalculateRecordInfo> getTaxDeclareRentMap() {
        return this.taxDeclareRentMap;
    }

    public void setTaxDeclareRentMap(Map taxDeclareRentMap) {
        this.taxDeclareRentMap = taxDeclareRentMap;
    }

    public Map<String, EstCalculateRecordInfo> getTaxDeclareVatMap() {
        return this.taxDeclareVatMap;
    }

    public void setTaxDeclareVatMap(Map<String, EstCalculateRecordInfo> taxDeclareVatMap) {
        this.taxDeclareVatMap = taxDeclareVatMap;
    }
}

