/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.formula;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.util.SortedParameterArray;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.formula.ITaxDraftBatchCalculate;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.enums.Enum;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class AbstractBatchCalculater
implements ITaxDraftBatchCalculate {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.td.formula.AbstractBatchCalculater");
    private static Map<String, EntityObjectInfo> entityCache = new HashMap<String, EntityObjectInfo>();
    protected ICalculateContextProvider contextProvider = null;
    protected Context ctx = null;
    private boolean isDebug = false;
    private String paramName = "isTaxRptDebug";

    public boolean isDebug() {
        return this.isDebug;
    }

    public void setDebug(boolean isDebug) {
        this.isDebug = isDebug;
    }

    public void initDebug(Context ctx) {
        String sql = "SELECT FValue From T_DT_DTTempParam WHERE FKey = '" + this.paramName + "'";
        try {
            int value;
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (rs.next() && (value = rs.getInt("FValue")) == 1) {
                this.isDebug = true;
            }
        }
        catch (Exception e) {
            logger.info((Object)e);
        }
    }

    @Override
    public void execute(SortedParameterArray paramArray) {
        this.ctx = this.contextProvider.getServerContext();
        this.initDebug(this.ctx);
    }

    protected boolean isEmpty(String value) {
        return value == null || "".equals(value);
    }

    protected EntityObjectInfo getEntity(String bosType) {
        EntityObjectInfo entity = null;
        if (entityCache.containsKey(bosType)) {
            entity = entityCache.get(bosType);
        } else {
            entity = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)this.ctx).getEntity(BOSObjectType.create((String)bosType));
            entityCache.put(bosType, entity);
        }
        return entity;
    }

    protected Object getPropertyValue(PropertyInfo property, Object value) {
        if (null == value) {
            return "";
        }
        Object retObj = value;
        SimpleDateFormat formatter = null;
        String dataType = (String)property.get("dataType");
        String enumSource = null;
        if ("Enum".equals(dataType)) {
            enumSource = (String)property.get("metadataRef");
            try {
                Enum retenum = TDUtils.getEnumValue(enumSource, value);
                retObj = retenum.getAlias();
            }
            catch (Exception e) {
                retObj = "";
                logger.error((Object)e.getMessage());
            }
        } else if ("Boolean".equals(dataType)) {
            retObj = value != null && (value.equals("1") || value.equals("\u662f") || value.equals("true")) || value.equals(true) ? TDUtils.getString("com.kingdee.eas.tm.td.TDCommonResource", "Data_True", this.ctx.getLocale()) : TDUtils.getString("com.kingdee.eas.tm.td.TDCommonResource", "Data_false", this.ctx.getLocale());
        } else if ("Date".equals(dataType)) {
            formatter = new SimpleDateFormat("yyyy-MM-dd");
            retObj = formatter.format(value);
        } else if ("TimeStamp".equals(dataType)) {
            formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            retObj = formatter.format(value);
        }
        return retObj;
    }
}

