/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.formula;

import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.bos.ctrl.excel.model.util.SortedParameterArray;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.tm.td.RecordTypeEnum;
import com.kingdee.eas.tm.td.TaxDraftRecordCollection;
import com.kingdee.eas.tm.td.TaxDraftRecordFactory;
import com.kingdee.eas.tm.td.TaxDraftRecordInfo;
import com.kingdee.eas.tm.td.TaxItemBillCollection;
import com.kingdee.eas.tm.td.TaxItemBillFactory;
import com.kingdee.eas.tm.td.TaxItemBillInfo;
import com.kingdee.eas.tm.td.basedata.TaxItemTypeInfo;
import com.kingdee.eas.tm.td.est.RealEstateGroupInfo;
import com.kingdee.eas.tm.td.formula.AbstractBatchCalculater;
import com.kingdee.eas.tm.td.formula.ParamsInfo;
import com.kingdee.util.StringUtils;

public class ItemCalculater
extends AbstractBatchCalculater {
    public ItemCalculater(ICalculateContextProvider contextProvider) {
        this.contextProvider = contextProvider;
    }

    @Override
    public void execute(SortedParameterArray paramArray) {
        super.execute(paramArray);
        IReportPropertyAdapter reportAdapter = this.contextProvider.getReportAdapter();
        int querySize = paramArray.size();
        ReportBaseInfo info = (ReportBaseInfo)reportAdapter.getReportProperty("editData");
        for (int i = 0; i < querySize; ++i) {
            Parameter params = paramArray.getParameter(i);
            ParamsInfo formulaParam = new ParamsInfo();
            formulaParam.buildItemParam(params);
            formulaParam.setInfo(info);
            this.innerExecute(formulaParam);
        }
    }

    protected void innerExecute(ParamsInfo param) {
        ReportBaseInfo seftInfo = param.getInfo();
        String companyNumber = param.getCompany();
        String periodNumber = param.getPeriod();
        String taxTypeNumber = param.getTaxItemType();
        RecordTypeEnum recordTypeEnum = RecordTypeEnum.getEnum(param.getRecordType());
        String accountConfigNumber = param.getAccountConfig();
        String itemNumber = param.getItem();
        String buildingTaxesGroupNumber = param.getBuildingTaxesGroup();
        try {
            if (StringUtils.isEmpty((String)companyNumber)) {
                companyNumber = ((CompanyOrgUnitInfo)seftInfo.get("companyOrgUnit")).getNumber();
            }
            if (StringUtils.isEmpty((String)periodNumber)) {
                periodNumber = ((PeriodInfo)seftInfo.get("rptPeriod")).getNumber() + "";
            }
            if (StringUtils.isEmpty((String)taxTypeNumber) && seftInfo.get("taxType") != null) {
                taxTypeNumber = ((TaxItemTypeInfo)seftInfo.get("taxType")).getNumber();
            }
            if (StringUtils.isEmpty((String)buildingTaxesGroupNumber) && seftInfo != null && seftInfo.get("buildingTaxesGroup") != null) {
                buildingTaxesGroupNumber = ((RealEstateGroupInfo)seftInfo.get("buildingTaxesGroup")).getNumber();
            }
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("rptPeriod.number", (Object)periodNumber, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("companyOrgUnit.number", (Object)companyNumber, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("taxType.number", (Object)taxTypeNumber, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("recordType", (Object)recordTypeEnum.getValue(), CompareType.EQUALS));
            if (recordTypeEnum.equals((Object)RecordTypeEnum.Account)) {
                filter.getFilterItems().add(new FilterItemInfo("relateAccount.number", (Object)accountConfigNumber, CompareType.EQUALS));
            }
            if (!StringUtils.isEmpty((String)buildingTaxesGroupNumber)) {
                filter.getFilterItems().add(new FilterItemInfo("buildingTaxesGroup.number", (Object)buildingTaxesGroupNumber, CompareType.EQUALS));
            }
            view.setFilter(filter);
            TaxDraftRecordCollection rtpcoll = TaxDraftRecordFactory.getLocalInstance(this.ctx).getTaxDraftRecordCollection(view);
            if (rtpcoll == null || rtpcoll.size() == 0) {
                param.getBackFiller().setValue((Object)"");
                return;
            }
            TaxDraftRecordInfo info = rtpcoll.get(0);
            view = new EntityViewInfo();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("rptId.id", (Object)info.getId().toString(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("item.number", (Object)itemNumber, CompareType.EQUALS));
            view.setFilter(filter);
            TaxItemBillCollection itemColl = TaxItemBillFactory.getLocalInstance(this.ctx).getTaxItemBillCollection(view);
            if (itemColl == null || itemColl.size() == 0) {
                param.getBackFiller().setValue((Object)"");
                return;
            }
            TaxItemBillInfo itemInfo = itemColl.get(0);
            param.getBackFiller().setValue((Object)itemInfo.getFormulaValue());
        }
        catch (Exception e) {
            param.getBackFiller().setException((Throwable)e);
        }
    }
}

