/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.formula;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.bos.ctrl.excel.model.util.SortedParameterArray;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.tm.td.formula.AbstractBatchCalculater;
import com.kingdee.eas.tm.td.formula.ParamsInfo;
import org.apache.log4j.Logger;

public class ReportTimeCalculater
extends AbstractBatchCalculater {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.td.formula.ReportTimeCalculater");

    public ReportTimeCalculater(ICalculateContextProvider contextProvider) {
        this.contextProvider = contextProvider;
    }

    @Override
    public void execute(SortedParameterArray paramArray) {
        super.execute(paramArray);
        IReportPropertyAdapter reportAdapter = this.contextProvider.getReportAdapter();
        int querySize = paramArray.size();
        String rptID = reportAdapter.getReportProperty("Report.ID").toString();
        ReportBaseInfo info = (ReportBaseInfo)reportAdapter.getReportProperty("editData");
        for (int i = 0; i < querySize; ++i) {
            Parameter params = paramArray.getParameter(i);
            ParamsInfo formulaParam = new ParamsInfo();
            formulaParam.buildReportTimeParam(params);
            formulaParam.setInfo(info);
            this.innerExecute(formulaParam);
        }
    }

    protected void innerExecute(ParamsInfo param) {
        String periodID = ((PeriodInfo)param.getInfo().get("rptPeriod")).getId().toString();
        String fieldName = param.getFieldName();
        if (fieldName.isEmpty()) {
            param.getBackFiller().setValue((Object)"");
            return;
        }
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)periodID, CompareType.EQUALS));
        ev.setFilter(filter);
        PeriodCollection periondColl = null;
        try {
            periondColl = PeriodFactory.getLocalInstance((Context)this.ctx).getPeriodCollection(ev);
        }
        catch (BOSException e1) {
            param.getBackFiller().setValue((Object)"");
            return;
        }
        if (periondColl == null || periondColl.size() == 0) {
            param.getBackFiller().setValue((Object)"");
            return;
        }
        EntityObjectInfo entity = this.getEntity("82388C4C");
        if (fieldName.isEmpty()) {
            param.getBackFiller().setValue((Object)"");
            return;
        }
        String[] props = fieldName.split("\\.");
        IObjectValue valueInfo = periondColl.getObject(0);
        PropertyInfo property = null;
        if (props.length == 1) {
            if (valueInfo.get(props[0]) == null) {
                param.getBackFiller().setValue((Object)"");
            } else {
                property = entity.getPropertyByName(fieldName);
                param.getBackFiller().setValue(this.getPropertyValue(property, valueInfo.get(props[0])));
            }
            return;
        }
        IObjectValue tempInfo = null;
        IObjectValue seftInfo = valueInfo;
        EntityObjectInfo tempEntity = entity;
        for (int i = 0; i < props.length; ++i) {
            property = tempEntity.getPropertyByName(props[i]);
            if (i == props.length - 1) {
                param.getBackFiller().setValue(this.getPropertyValue(property, seftInfo.get(props[i])));
                return;
            }
            if (property instanceof LinkPropertyInfo) {
                tempEntity = ((LinkPropertyInfo)property).getRelationship().getSupplierObject();
            }
            if (seftInfo.get(props[i]) instanceof IObjectValue) {
                tempInfo = (IObjectValue)seftInfo.get(props[i]);
                String id = tempInfo.getString("id");
                IDynamicObject iDynamicObject = DynamicObjectFactory.getLocalInstance((Context)this.ctx);
                try {
                    seftInfo = iDynamicObject.getValue(tempInfo.getBOSType(), (IObjectPK)new ObjectUuidPK(id));
                    continue;
                }
                catch (BOSException e) {
                    param.getBackFiller().setValue((Object)"");
                    return;
                }
            }
            param.getBackFiller().setValue((Object)"");
            return;
        }
    }
}

