/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.formula.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.PreChangeEvent;
import com.kingdee.bos.ctrl.swing.event.PreChangeListener;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.rpt.client.FormulaWizardUI;
import com.kingdee.eas.fi.rpt.client.RptFormulaEnumEntry;
import com.kingdee.eas.tm.td.FilterCommonStatusEnum;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.TaxDraftRecordInfo;
import com.kingdee.eas.tm.td.basedata.TaxItemTypeFactory;
import com.kingdee.eas.tm.td.basedata.TaxItemTypeInfo;
import com.kingdee.eas.tm.td.basedata.util.EntitySelector;
import com.kingdee.eas.tm.td.basedata.util.EntitySelectorType;
import com.kingdee.eas.tm.td.est.RealEstateFactory;
import com.kingdee.eas.tm.td.est.RealEstateGroupFactory;
import com.kingdee.eas.tm.td.est.RealEstateGroupInfo;
import com.kingdee.eas.tm.td.est.RealEstateInfo;
import com.kingdee.eas.tm.td.est.TaxMethodEnum;
import com.kingdee.eas.tm.td.formula.client.FormulaWizardUIHelper;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.enums.Enum;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.Set;

public class EstCalculateRecordFormulaWizardUI
extends FormulaWizardUI {
    private EntityObjectInfo entity = null;
    private DataChangeListener companyOrgUnitListener = null;
    private DataChangeListener realEstateListener = null;
    private DataChangeListener realEstateGroupListener = null;
    private DataChangeListener taxTypeListener = null;
    private DataChangeListener rentalEstateListener = null;
    private PreChangeListener dataFieldPreChangeListener = null;
    private KDBizPromptBox companyOrgUnitF7 = null;
    private KDBizPromptBox realEstateGroupF7 = null;
    private KDBizPromptBox realEstateF7 = null;
    private KDBizPromptBox taxTypeF7 = null;
    private KDBizPromptBox rentalEstateF7 = null;
    private KDBizPromptBox dataFieldF7 = null;
    private KDComboBox taxMethodComboBox = null;
    private KDTextField companyOrgUnit = null;
    private KDTextField contractNumberTxt = null;
    private KDTextField realEstateGroup = null;
    private KDTextField realEstate = null;
    private KDTextField rentalEstate = null;
    private KDTextField contractNumber = null;
    private KDTextField taxMethod = null;
    private KDTextField dataField = null;
    private KDTextField txtPeriodFromValue = null;
    private KDTextField txtPeriodToValue = null;

    protected void onOpen() {
        this.initControls();
        this.removeListener();
        this.initRealEstateFilter();
        this.initTaxMethodEnumEnabled();
        this.initRentalEstateFilter();
        this.initListeners();
    }

    private void initControls() {
        this.initCompanyF7();
        this.realEstateGroupF7 = (KDBizPromptBox)this.getParamComponent("realEstateGroup");
        this.realEstateGroup = (KDTextField)this.getBaseParamComponent("realEstateGroup");
        this.realEstateF7 = (KDBizPromptBox)this.getParamComponent("realEstate");
        this.realEstate = (KDTextField)this.getBaseParamComponent("realEstate");
        this.taxTypeF7 = (KDBizPromptBox)this.getParamComponent("taxType");
        this.rentalEstateF7 = (KDBizPromptBox)this.getParamComponent("rentalEstate");
        this.rentalEstate = (KDTextField)this.getBaseParamComponent("rentalEstate");
        this.contractNumberTxt = (KDTextField)this.getParamComponent("contractNumber");
        this.contractNumber = (KDTextField)this.getBaseParamComponent("contractNumber");
        this.taxMethodComboBox = (KDComboBox)this.getParamComponent("taxMethod");
        this.taxMethod = (KDTextField)this.getBaseParamComponent("taxMethod");
        this.dataFieldF7 = (KDBizPromptBox)this.getParamComponent("dataField");
        this.dataField = (KDTextField)this.getBaseParamComponent("dataField");
        this.txtPeriodFromValue = (KDTextField)this.getBaseParamComponent("periodFrom");
        this.txtPeriodToValue = (KDTextField)this.getBaseParamComponent("periodTo");
        this.initDataFieldControl();
    }

    private void initCompanyF7() {
        this.companyOrgUnitF7 = (KDBizPromptBox)this.getParamComponent("companyOrgUnit");
        this.companyOrgUnit = (KDTextField)this.getBaseParamComponent("companyOrgUnit");
        CompanyOrgUnitInfo companyOrgUnitInfo = null;
        if (this.companyOrgUnitF7.getValue() instanceof String) {
            if ("".equals(this.companyOrgUnitF7.getValue())) {
                this.companyOrgUnitF7.setValue(null);
            } else {
                try {
                    companyOrgUnitInfo = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo("where Number ='" + this.companyOrgUnitF7.getValue() + "'");
                }
                catch (EASBizException e) {
                    this.handUIException(e);
                }
                catch (BOSException e) {
                    this.handUIException(e);
                }
            }
        } else {
            companyOrgUnitInfo = (CompanyOrgUnitInfo)this.companyOrgUnitF7.getValue();
        }
        this.companyOrgUnitF7.setValue(null);
        this.companyOrgUnitF7.setEditable(false);
        this.companyOrgUnitF7.setEnabledMultiSelection(false);
        this.companyOrgUnitF7.setHistoryRecordEnabled(false);
        if (companyOrgUnitInfo != null) {
            this.companyOrgUnitF7.setValue((Object)companyOrgUnitInfo);
            if (!"".equals(companyOrgUnitInfo.getName())) {
                this.companyOrgUnit.setText(companyOrgUnitInfo.getName());
            }
        }
    }

    private void initDataFieldControl() {
        this.entity = FormulaWizardUIHelper.getEntity("9E3F8034");
        EntitySelector selector = new EntitySelector(this.getUIWindow(), TDUtils.getString("com.kingdee.eas.tm.td.TDCommonResource", "SelectFields", TDUtils.getLocale()), EntitySelectorType.Property, this.entity, "isSearchable");
        this.dataFieldF7.setSelector((KDPromptSelector)selector);
    }

    private void removeListener() {
        if (this.companyOrgUnitListener != null) {
            this.companyOrgUnitF7.removeDataChangeListener(this.companyOrgUnitListener);
        }
        if (this.realEstateGroupListener != null) {
            this.realEstateGroupF7.removeDataChangeListener(this.realEstateGroupListener);
        }
        if (this.realEstateListener != null) {
            this.realEstateF7.removeDataChangeListener(this.realEstateListener);
        }
        if (this.taxTypeListener != null) {
            this.taxTypeF7.removeDataChangeListener(this.taxTypeListener);
        }
        if (this.rentalEstateListener != null) {
            this.rentalEstateF7.removeDataChangeListener(this.rentalEstateListener);
        }
        if (this.dataFieldPreChangeListener != null) {
            this.dataFieldF7.removePreChangeListener(this.dataFieldPreChangeListener);
        }
    }

    private void initListeners() {
        if (this.companyOrgUnitListener == null) {
            this.companyOrgUnitListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent eventObj) {
                    EstCalculateRecordFormulaWizardUI.this.companyOrgUnit_dataChanged(eventObj);
                }
            };
        }
        this.companyOrgUnitF7.addDataChangeListener(this.companyOrgUnitListener);
        if (this.realEstateGroupListener == null) {
            this.realEstateGroupListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent eventObj) {
                    EstCalculateRecordFormulaWizardUI.this.realEstateGroup_dataChanged(eventObj);
                }
            };
        }
        this.realEstateGroupF7.addDataChangeListener(this.realEstateGroupListener);
        if (this.realEstateListener == null) {
            this.realEstateListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent eventObj) {
                    EstCalculateRecordFormulaWizardUI.this.realEstate_dataChanged(eventObj);
                }
            };
        }
        this.realEstateF7.addDataChangeListener(this.realEstateListener);
        if (this.taxTypeListener == null) {
            this.taxTypeListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent eventObj) {
                    EstCalculateRecordFormulaWizardUI.this.taxType_dataChanged(eventObj);
                }
            };
        }
        this.taxTypeF7.addDataChangeListener(this.taxTypeListener);
        if (this.rentalEstateListener == null) {
            this.rentalEstateListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent eventObj) {
                    EstCalculateRecordFormulaWizardUI.this.rentalEstate_dataChanged(eventObj);
                }
            };
        }
        this.rentalEstateF7.addDataChangeListener(this.rentalEstateListener);
        if (this.dataFieldPreChangeListener == null) {
            this.dataFieldPreChangeListener = new PreChangeListener(){

                public void preChange(PreChangeEvent e) {
                    try {
                        EstCalculateRecordFormulaWizardUI.this.dataField_preChange(e);
                        e.setResult(1);
                    }
                    catch (Exception err) {
                        ExceptionHandler.handle((Throwable)err);
                    }
                }
            };
        }
        this.dataFieldF7.addPreChangeListener(this.dataFieldPreChangeListener);
    }

    private void dataField_preChange(PreChangeEvent e) {
        KDPromptBox f7Box = (KDPromptBox)e.getSource();
        if (e.getData() != null && e.getData() instanceof OwnPropertyInfo) {
            OwnPropertyInfo prop = (OwnPropertyInfo)e.getData();
            if (this.entity != null) {
                e.setData(prop.get("fullName"));
                f7Box.setUserObject((Object)prop);
            } else {
                e.setData(null);
                f7Box.setUserObject(null);
            }
        } else {
            e.setData(null);
            f7Box.setUserObject(null);
        }
    }

    protected void companyOrgUnit_dataChanged(DataChangeEvent eventObj) {
        this.initRealEstateFilter();
    }

    protected void realEstateGroup_dataChanged(DataChangeEvent eventObj) {
        this.initRealEstateFilter();
        this.cleanRealEstate();
    }

    protected void realEstate_dataChanged(DataChangeEvent eventObj) {
        this.initRentalEstateFilter();
        this.cleanRentalEstate();
    }

    protected void taxType_dataChanged(DataChangeEvent eventObj) {
        TaxItemTypeInfo taxTypeInfo = (TaxItemTypeInfo)this.taxTypeF7.getValue();
        this.setTaxMethodEnumEnabled(taxTypeInfo);
    }

    protected void rentalEstate_dataChanged(DataChangeEvent eventObj) {
        this.cleanContractNumber();
    }

    private void cleanRealEstate() {
        this.realEstateF7.setValue(null);
        this.realEstate.setText("");
    }

    private void cleanRentalEstate() {
        this.rentalEstateF7.setValue(null);
        this.rentalEstate.setText("");
    }

    private void cleanContractNumber() {
        this.contractNumberTxt.setText("");
        this.contractNumber.setText("");
    }

    private void initRealEstateFilter() {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        RealEstateGroupInfo realEstateGroupInfo = null;
        CompanyOrgUnitInfo companyOrgUnitInfo = null;
        IObjectValue info = null;
        if (!"".equals(this.realEstateGroupF7.getValue()) && this.realEstateGroupF7.getValue() != null) {
            if (this.realEstateGroupF7.getValue() instanceof RealEstateGroupInfo) {
                realEstateGroupInfo = (RealEstateGroupInfo)this.realEstateGroupF7.getValue();
            } else if (this.realEstateGroupF7.getValue() instanceof String) {
                try {
                    realEstateGroupInfo = RealEstateGroupFactory.getRemoteInstance().getRealEstateGroupInfo(" where number = '" + this.realEstateGroupF7.getValue() + "'");
                }
                catch (EASBizException e) {
                    this.handUIException(e);
                }
                catch (BOSException e) {
                    this.handUIException(e);
                }
            }
        } else if (this.getRptContext() != null && (info = (IObjectValue)this.getRptContext().getPropertyAdapter().getReportProperty("editData")) != null) {
            realEstateGroupInfo = (RealEstateGroupInfo)info.get("buildingTaxesGroup");
        }
        if (!"".equals(this.companyOrgUnitF7.getValue()) && this.companyOrgUnitF7.getValue() != null) {
            if (this.companyOrgUnitF7.getValue() instanceof Object[] && ((Object[])this.companyOrgUnitF7.getValue()).length != 0) {
                filter.getFilterItems().add(new FilterItemInfo("company.number", (Object)this.getNumberSet(this.companyOrgUnitF7.getValue()), CompareType.INCLUDE));
            } else if (this.companyOrgUnitF7.getValue() instanceof String) {
                String companyNumberString = (String)this.companyOrgUnitF7.getValue();
                String[] companyNumberList = companyNumberString.split("; ");
                filter.getFilterItems().add(new FilterItemInfo("company.number", (Object)this.getNumberSet(companyNumberList), CompareType.INCLUDE));
            }
        } else {
            if (info == null && this.getRptContext() != null) {
                info = (IObjectValue)this.getRptContext().getPropertyAdapter().getReportProperty("editData");
            }
            if (info != null) {
                companyOrgUnitInfo = (CompanyOrgUnitInfo)info.get("companyOrgUnit");
            }
            if (companyOrgUnitInfo != null) {
                filter.getFilterItems().add(new FilterItemInfo("company.number", (Object)companyOrgUnitInfo.getNumber(), CompareType.INCLUDE));
            }
        }
        if (realEstateGroupInfo != null) {
            filter.getFilterItems().add(new FilterItemInfo("realEstateGroup.id", (Object)realEstateGroupInfo.getId()));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("realEstateGroup.id", (Object)"111111111111111111111111111="));
        }
        view.setFilter(filter);
        this.realEstateF7.setEntityViewInfo(view);
    }

    private void initTaxMethodEnumEnabled() {
        int taxMethodSelectedIndex = this.taxMethodComboBox.getSelectedIndex();
        TaxItemTypeInfo taxTypeInfo = null;
        if ("".equals(this.taxTypeF7.getValue())) {
            IObjectValue info = null;
            if (this.getRptContext() != null && (info = (IObjectValue)this.getRptContext().getPropertyAdapter().getReportProperty("editData")) != null) {
                taxTypeInfo = (TaxItemTypeInfo)info.get("taxType");
            }
        } else {
            try {
                taxTypeInfo = TaxItemTypeFactory.getRemoteInstance().getTaxItemTypeInfo(" where number = '" + this.taxTypeF7.getValue() + "'");
            }
            catch (EASBizException e) {
                this.handUIException(e);
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        }
        this.setTaxMethodEnumEnabled(taxTypeInfo);
        this.taxMethodComboBox.setSelectedIndex(taxMethodSelectedIndex);
        RptFormulaEnumEntry rptFormulaEnumEntry = (RptFormulaEnumEntry)this.taxMethodComboBox.getSelectedItem();
        this.taxMethod.setText(rptFormulaEnumEntry.getLocalName());
    }

    protected RptFormulaEnumEntry getRptFormulaEnumEntry(Enum enumValue) {
        RptFormulaEnumEntry entry = new RptFormulaEnumEntry(enumValue.getName(), null);
        String[] local = new String[]{"zh_CN", "zh_TW", "en_US"};
        for (int i = 0; i < local.length; ++i) {
            entry.setLocalName(local[i], enumValue.getAlias());
            entry.setDescription(local[i], enumValue.getAlias());
        }
        return entry;
    }

    private void setTaxMethodEnumEnabled(TaxItemTypeInfo taxTypeInfo) {
        if (taxTypeInfo == null) {
            IObjectValue info = null;
            if (this.getRptContext() != null) {
                info = (IObjectValue)this.getRptContext().getPropertyAdapter().getReportProperty("editData");
                if (info != null) {
                    taxTypeInfo = (TaxItemTypeInfo)info.get("taxType");
                }
                if (taxTypeInfo != null && "ZCyrvv6oAnPgU0ETqMCc49uK96Y=".equals(taxTypeInfo.getId())) {
                    this.taxMethodComboBox.setEnabled(true);
                    this.taxMethodComboBox.setRequired(true);
                } else {
                    this.taxMethodComboBox.setEnabled(false);
                    this.taxMethodComboBox.setRequired(false);
                }
            }
        } else if (taxTypeInfo != null && "ZCyrvv6oAnPgU0ETqMCc49uK96Y=".equals(taxTypeInfo.getId().toString())) {
            this.taxMethodComboBox.setEnabled(true);
            this.taxMethodComboBox.setRequired(true);
        } else {
            this.taxMethodComboBox.setEnabled(false);
            this.taxMethodComboBox.setRequired(false);
        }
        if (taxTypeInfo != null && "ZCyrvv6oAnPgU0ETqMCc49uK96Y=".equals(taxTypeInfo.getId().toString())) {
            this.taxMethodComboBox.setEnabled(true);
            this.taxMethodComboBox.removeItem((Object)this.getRptFormulaEnumEntry((Enum)FilterCommonStatusEnum.NULL));
            this.taxMethodComboBox.setSelectedIndex(0);
            this.taxMethod.setText(((RptFormulaEnumEntry)this.taxMethodComboBox.getSelectedItem()).getDescription());
        } else {
            this.taxMethodComboBox.setEnabled(false);
            this.taxMethodComboBox.removeAllItems();
            this.taxMethodComboBox.addItem((Object)this.getRptFormulaEnumEntry((Enum)FilterCommonStatusEnum.NULL));
            this.taxMethodComboBox.addItem((Object)this.getRptFormulaEnumEntry((Enum)TaxMethodEnum.PRICE));
            this.taxMethodComboBox.addItem((Object)this.getRptFormulaEnumEntry((Enum)TaxMethodEnum.RENT));
            this.taxMethodComboBox.setSelectedItem((Object)this.getRptFormulaEnumEntry((Enum)FilterCommonStatusEnum.NULL));
            this.taxMethod.setText("");
        }
    }

    private void initRentalEstateFilter() {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        RealEstateInfo realEstateInfo = null;
        if (!"".equals(this.realEstateF7.getValue()) && this.realEstateF7.getValue() != null) {
            if (this.realEstateF7.getValue() instanceof RealEstateInfo) {
                realEstateInfo = (RealEstateInfo)this.realEstateF7.getValue();
            } else if (this.realEstateF7.getValue() instanceof String) {
                try {
                    realEstateInfo = RealEstateFactory.getRemoteInstance().getRealEstateInfo(" where number = '" + this.realEstateF7.getValue() + "'");
                }
                catch (EASBizException e) {
                    this.handUIException(e);
                }
                catch (BOSException e) {
                    this.handUIException(e);
                }
            }
        }
        if (realEstateInfo != null) {
            filter.getFilterItems().add(new FilterItemInfo("realEstate.id", (Object)realEstateInfo.getId()));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("realEstate.id", (Object)"111111111111111111111111111="));
        }
        view.setFilter(filter);
        this.rentalEstateF7.setEntityViewInfo(view);
    }

    private Set getNumberSet(Object object) {
        if (object == null) {
            return null;
        }
        HashSet<String> ids = new HashSet<String>();
        if (object instanceof Object[]) {
            Object[] infos;
            for (Object info : infos = (Object[])object) {
                if (info == null) {
                    return null;
                }
                if (info instanceof CompanyOrgUnitInfo) {
                    ids.add(((CompanyOrgUnitInfo)info).getNumber().toString());
                    continue;
                }
                ids.add(info.toString());
            }
        } else if (object instanceof CompanyOrgUnitInfo) {
            ids.add(((CompanyOrgUnitInfo)object).getNumber().toString());
        }
        return ids;
    }

    public void actionFinish_actionPerformed(ActionEvent e) throws Exception {
        if ("okey".equals(e.getActionCommand())) {
            if (this.checkPeriodValue()) {
                super.actionFinish_actionPerformed(e);
            }
        } else if ("cancel".equals(e.getActionCommand())) {
            super.actionFinish_actionPerformed(e);
        }
    }

    private boolean checkPeriodValue() {
        String periodFromValueString = this.txtPeriodFromValue.getText();
        String periodToValueString = this.txtPeriodToValue.getText();
        if ("".equals(periodFromValueString) && "".equals(periodToValueString)) {
            return true;
        }
        IObjectValue info = null;
        int rptPeriodFromNumber = 0;
        int rptPeriodToNumber = 999999;
        int periodFromValue = 0;
        int periodToValue = 999999;
        if (this.getRptContext() != null) {
            info = (IObjectValue)this.getRptContext().getPropertyAdapter().getReportProperty("editData");
        }
        if (info instanceof TaxDraftRecordInfo) {
            TaxDraftRecordInfo value = (TaxDraftRecordInfo)info;
            if (value.getRptPeriodFrom() != null) {
                rptPeriodFromNumber = value.getRptPeriodFrom().getNumber();
            }
            if (value.getRptPeriodTo() != null) {
                rptPeriodToNumber = value.getRptPeriodTo().getNumber();
            }
        }
        if ("".equals(periodFromValueString)) {
            periodFromValue = rptPeriodFromNumber;
        } else {
            try {
                if (!periodFromValueString.matches("[0-9]{6}")) {
                    MsgBox.showInfo((String)TDUtils.getString("com.kingdee.eas.tm.td.formula.TaxFormulaResource", "PeriodFromValue_Error", TDUtils.getLocale()));
                    return false;
                }
                periodFromValue = Integer.valueOf(periodFromValueString);
            }
            catch (Exception e) {
                MsgBox.showInfo((String)TDUtils.getString("com.kingdee.eas.tm.td.formula.TaxFormulaResource", "PeriodFromValue_Error", TDUtils.getLocale()));
                return false;
            }
        }
        if ("".equals(periodToValueString)) {
            periodToValue = rptPeriodToNumber;
        } else {
            try {
                if (!periodToValueString.matches("[0-9]{6}")) {
                    MsgBox.showInfo((String)TDUtils.getString("com.kingdee.eas.tm.td.formula.TaxFormulaResource", "PeriodToValue_Error", TDUtils.getLocale()));
                    return false;
                }
                periodToValue = Integer.valueOf(periodToValueString);
            }
            catch (Exception e) {
                MsgBox.showInfo((String)TDUtils.getString("com.kingdee.eas.tm.td.formula.TaxFormulaResource", "PeriodToValue_Error", TDUtils.getLocale()));
                return false;
            }
        }
        if (periodFromValue > periodToValue) {
            MsgBox.showInfo((String)TDUtils.getString("com.kingdee.eas.tm.td.formula.TaxFormulaResource", "Period_Error", TDUtils.getLocale()));
            return false;
        }
        return true;
    }
}

