/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.formula.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.rpt.client.FormulaWizardUI;
import com.kingdee.eas.fi.rpt.client.RptFormulaEnumEntry;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.basedata.AccountConfigFactory;
import com.kingdee.eas.tm.td.basedata.AccountConfigInfo;
import com.kingdee.eas.tm.td.basedata.AccountTypeFactory;
import com.kingdee.eas.tm.td.basedata.AccountTypeInfo;
import com.kingdee.eas.tm.td.basedata.TaxItemTypeFactory;
import com.kingdee.eas.tm.td.basedata.TaxItemTypeInfo;
import com.kingdee.eas.tm.td.formula.client.FormulaWizardUIHelper;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

public class EstReportRefFormulaWizardUI
extends FormulaWizardUI {
    private DataChangeListener prmtTaxItemTypeListener = null;
    private ItemListener recordTypeListener = null;
    private DataChangeListener prmtCompanyListener = null;
    private KDBizPromptBox prmtCompany = null;
    private KDBizPromptBox prmtTaxItemType = null;
    private KDComboBox cbRecordType = null;
    private KDBizPromptBox prmtAccountConfig = null;
    private KDBizPromptBox prmtBuildingTaxesGroup = null;
    private KDTextField sheetName = null;
    private KDTextField cellName = null;
    private KDTextField txtCompany = null;
    private KDTextField txtTaxItemType = null;
    private KDTextField txtRecordType = null;
    private KDTextField txtAccountConfig = null;
    private KDTextField txtBuildingTaxesGroup = null;
    private KDTextField txtSheetName = null;
    private KDTextField txtCellName = null;

    protected void onOpen() {
        this.initControl();
        this.initListeners();
        this.initFilter();
        try {
            this.initAccountConfigFilter();
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
    }

    private void initFilter() {
        this.initTaxItemTypeFilter();
    }

    private void initTaxItemTypeFilter() {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("sign", (Object)"1"));
        view.setFilter(filter);
        this.prmtTaxItemType.setEntityViewInfo(view);
    }

    private void initControl() {
        this.prmtCompany = (KDBizPromptBox)this.getParamComponent("companyOrgUnit");
        this.txtCompany = (KDTextField)this.getBaseParamComponent("companyOrgUnit");
        CompanyOrgUnitInfo companyInfo = null;
        if (this.prmtCompany.getValue() instanceof String && !"".equals(this.prmtCompany.getValue())) {
            try {
                companyInfo = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo("where number ='" + this.prmtCompany.getValue() + "'");
            }
            catch (EASBizException e) {
                this.handUIException(e);
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        }
        this.prmtCompany.setValue(null);
        this.prmtCompany.setEnabledMultiSelection(false);
        this.prmtCompany.setHistoryRecordEnabled(false);
        this.prmtCompany.setEditable(false);
        if (companyInfo != null) {
            this.prmtCompany.setValue((Object)companyInfo);
            if (!"".equals(companyInfo.getName())) {
                this.txtCompany.setText(companyInfo.getName());
            }
        }
        this.prmtTaxItemType = (KDBizPromptBox)this.getParamComponent("taxItemType");
        this.prmtAccountConfig = (KDBizPromptBox)this.getParamComponent("accountConfig");
        this.cbRecordType = (KDComboBox)this.getParamComponent("recordType");
        this.prmtBuildingTaxesGroup = (KDBizPromptBox)this.getParamComponent("buildingTaxesGroup");
        this.sheetName = (KDTextField)this.getParamComponent("sheetName");
        this.cellName = (KDTextField)this.getParamComponent("cellName");
        this.txtTaxItemType = (KDTextField)this.getBaseParamComponent("taxItemType");
        this.txtAccountConfig = (KDTextField)this.getBaseParamComponent("accountConfig");
        this.txtRecordType = (KDTextField)this.getBaseParamComponent("recordType");
        this.txtBuildingTaxesGroup = (KDTextField)this.getBaseParamComponent("buildingTaxesGroup");
        this.txtSheetName = (KDTextField)this.getBaseParamComponent("sheetName");
        this.txtCellName = (KDTextField)this.getBaseParamComponent("cellName");
        try {
            this.loadData();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        this.initControlsRequired();
        this.initDataStatus();
    }

    protected void initControlsRequired() {
        this.cbRecordType.setRequired(true);
        this.txtRecordType.setRequired(true);
        this.prmtAccountConfig.setRequired(true);
        this.txtAccountConfig.setRequired(true);
        this.sheetName.setRequired(true);
        this.txtSheetName.setRequired(true);
        this.cellName.setRequired(true);
        this.txtCellName.setRequired(true);
    }

    private void initDataStatus() {
        RptFormulaEnumEntry recordType = (RptFormulaEnumEntry)this.cbRecordType.getSelectedItem();
        boolean isAccount = "Account".equals(recordType.getName());
        this.prmtAccountConfig.setEnabled(isAccount);
        this.prmtAccountConfig.setRequired(isAccount);
        this.txtAccountConfig.setEnabled(isAccount);
        this.txtAccountConfig.setRequired(isAccount);
    }

    private void loadData() throws EASBizException, BOSException {
        String taxItemTypeNumber = this.txtTaxItemType.getText();
        if (!StringUtils.isEmpty((String)taxItemTypeNumber)) {
            TaxItemTypeInfo taxType = TaxItemTypeFactory.getRemoteInstance().getTaxItemTypeInfo(" where number = '" + taxItemTypeNumber + "'");
            this.prmtTaxItemType.setValue((Object)taxType);
        } else {
            this.prmtTaxItemType.setValue(null);
        }
        String accountConfigNumber = this.txtAccountConfig.getText();
        if (!StringUtils.isEmpty((String)accountConfigNumber)) {
            AccountConfigInfo accountConfig = AccountConfigFactory.getRemoteInstance().getAccountConfigInfo(" where number = '" + accountConfigNumber + "'");
            this.prmtAccountConfig.setValue((Object)accountConfig);
        }
    }

    private void initListeners() {
        if (this.prmtTaxItemTypeListener == null) {
            this.prmtTaxItemTypeListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent eventObj) {
                    EstReportRefFormulaWizardUI.this.prmtTaxItemType_dataChanged(eventObj);
                }
            };
        }
        this.prmtTaxItemType.addDataChangeListener(this.prmtTaxItemTypeListener);
        if (this.recordTypeListener == null) {
            this.recordTypeListener = new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent eventObj) {
                    EstReportRefFormulaWizardUI.this.recordType_dataChanged(eventObj);
                }
            };
        }
        this.cbRecordType.addItemListener(this.recordTypeListener);
        if (this.prmtCompanyListener == null) {
            this.prmtCompanyListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent eventObj) {
                    EstReportRefFormulaWizardUI.this.prmtCompany_dataChanged(eventObj);
                }
            };
        }
        this.prmtCompany.addDataChangeListener(this.prmtTaxItemTypeListener);
    }

    protected void prmtTaxItemType_dataChanged(DataChangeEvent e) {
        if (FormulaWizardUIHelper.isEqual(e.getNewValue(), e.getOldValue())) {
            return;
        }
        try {
            this.initAccountConfigFilter();
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
        this.initDataStatus();
        this.prmtAccountConfig.setValue(null);
        this.txtAccountConfig.setText("");
    }

    protected void prmtCompany_dataChanged(DataChangeEvent e) {
        if (FormulaWizardUIHelper.isEqual(e.getNewValue(), e.getOldValue())) {
            return;
        }
        try {
            this.initAccountConfigFilter();
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
    }

    private void initAccountConfigFilter() throws EASBizException, BOSException {
        IObjectValue info;
        AccountTypeInfo accountType;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("relation.state", (Object)"2", CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("taxTypeItem.sign", (Object)"1"));
        if (!FormulaWizardUIHelper.isEmpty(this.prmtTaxItemType.getValue())) {
            TaxItemTypeInfo taxType = this.prmtTaxItemType.getValue() instanceof String ? TaxItemTypeFactory.getRemoteInstance().getTaxItemTypeInfo(" where number ='" + this.prmtTaxItemType.getValue() + "'") : (TaxItemTypeInfo)this.prmtTaxItemType.getValue();
            try {
                accountType = AccountTypeFactory.getRemoteInstance().getAccountTypeInfo("where taxTypeItem.id = '" + taxType.getId().toString() + "'");
                filter.getFilterItems().add(new FilterItemInfo("accountType.id", (Object)accountType.getId().toString(), CompareType.EQUALS));
            }
            catch (EASBizException e) {
                this.handUIException(e);
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        } else {
            info = null;
            if (this.getRptContext() != null && (info = (IObjectValue)this.getRptContext().getPropertyAdapter().getReportProperty("editData")) != null) {
                TaxItemTypeInfo taxTypeInfo = (TaxItemTypeInfo)info.get("taxType");
                accountType = AccountTypeFactory.getRemoteInstance().getAccountTypeInfo("where taxTypeItem.id = '" + taxTypeInfo.getId().toString() + "'");
                filter.getFilterItems().add(new FilterItemInfo("accountType.id", (Object)String.valueOf(accountType.getId()), CompareType.EQUALS));
            }
        }
        if (!FormulaWizardUIHelper.isEmpty(this.prmtCompany.getValue())) {
            if (this.prmtCompany.getValue() instanceof CompanyOrgUnitInfo) {
                CompanyOrgUnitInfo companyOrgUnitInfo = (CompanyOrgUnitInfo)this.prmtCompany.getValue();
                filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)String.valueOf(companyOrgUnitInfo.getId()), CompareType.EQUALS));
            } else if (this.prmtCompany.getValue() instanceof String) {
                String numberString = String.valueOf(this.prmtCompany.getValue());
                filter.getFilterItems().add(new FilterItemInfo("company.number", (Object)numberString, CompareType.EQUALS));
            }
        } else {
            CompanyOrgUnitInfo companyOrgUnitInfo;
            info = null;
            if (this.getRptContext() != null && (info = (IObjectValue)this.getRptContext().getPropertyAdapter().getReportProperty("editData")) != null && (companyOrgUnitInfo = (CompanyOrgUnitInfo)info.get("companyOrgUnit")) != null) {
                filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)String.valueOf(companyOrgUnitInfo.getId()), CompareType.EQUALS));
            }
        }
        view.setFilter(filter);
        this.prmtAccountConfig.setEntityViewInfo(view);
    }

    protected void recordType_dataChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            this.initDataStatus();
        }
    }

    public void actionFinish_actionPerformed(ActionEvent e) throws Exception {
        if ("okey".equals(e.getActionCommand())) {
            if (this.checkRequired()) {
                super.actionFinish_actionPerformed(e);
            }
        } else if ("cancel".equals(e.getActionCommand())) {
            super.actionFinish_actionPerformed(e);
        }
    }

    protected boolean checkRequired() {
        String msg = "";
        StringBuffer buildMsg = new StringBuffer();
        if (this.prmtAccountConfig.isRequired() && (this.prmtAccountConfig.getValue() == null || "".equals(this.prmtAccountConfig.getValue()))) {
            buildMsg.append(TDUtils.getString("com.kingdee.eas.tm.td.formula.TaxFormulaResource", "AccountConfig", TDUtils.getLocale()));
        }
        if ("".equals(this.sheetName.getText().trim())) {
            buildMsg.append(TDUtils.getString("com.kingdee.eas.tm.td.formula.TaxFormulaResource", "SheetName", TDUtils.getLocale()));
        }
        if ("".equals(this.cellName.getText().trim())) {
            buildMsg.append(TDUtils.getString("com.kingdee.eas.tm.td.formula.TaxFormulaResource", "CellName", TDUtils.getLocale()));
        }
        if (buildMsg.length() > 0) {
            msg = TDUtils.getString("com.kingdee.eas.fi.gr.cslrpt.cslcommon.CSLCOMMONAutoGenerateResource", "0_FormulaWizardUI", TDUtils.getLocale(), new Object[]{buildMsg.toString().substring(1)});
        }
        if (buildMsg.length() > 0 && msg.length() > 0) {
            return MsgBox.isYes((int)MsgBox.showConfirm2((String)msg));
        }
        return buildMsg.length() == 0;
    }
}

