/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.kds.model.struct.embed.browser.jfx.KDWebViewPanel;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.eas.framework.ITreeBase;
import com.kingdee.eas.framework.client.tree.DefaultLNTreeNodeCtrl;
import com.kingdee.eas.framework.client.tree.ILNTreeNodeCtrl;
import com.kingdee.eas.framework.client.tree.ITreeBuilder;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.framework.client.tree.TreeBuilderFactory;
import com.kingdee.eas.rpts.ctrlreport.util.PortalUtil;
import com.kingdee.eas.tm.td.rpt.TaxAnalysisThemeFactory;
import com.kingdee.eas.tm.td.rpt.TaxAnalysisThemeInfo;
import com.kingdee.eas.tm.td.rpt.client.AbstractTaxAnalysisPlatformUI;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.UUID;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;

public class TaxAnalysisPlatformUI
extends AbstractTaxAnalysisPlatformUI {
    private KDWebViewPanel browser = null;
    private String url;
    private String tag;
    private String bizTag;
    private String className;
    private String schemaId;
    private String title;

    public void onLoad() throws Exception {
        super.onLoad();
        this.afterLoad();
    }

    private void afterLoad() throws Exception {
        this.initQingPanel();
        this.initTree();
        this.initGroupButton();
    }

    protected void initGroupButton() {
        this.treeView.getControlPane().add((Component)this.btnGroupRefresh);
        this.btnGroupRefresh.setEnabled(true);
    }

    private void initTree() throws Exception {
        ITreeBuilder treeBuilder = TreeBuilderFactory.createTreeBuilder((ILNTreeNodeCtrl)this.getLNTreeNodeCtrl(), (int)1, (int)1, (FilterInfo)new FilterInfo(), null);
        if (this.getRootName() != null) {
            KDTreeNode rootNode = new KDTreeNode(this.getRootObject());
            ((DefaultTreeModel)this.groupTree.getModel()).setRoot((TreeNode)rootNode);
        } else {
            ((DefaultTreeModel)this.groupTree.getModel()).setRoot(null);
        }
        treeBuilder.buildTree(this.groupTree);
        this.groupTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                try {
                    TaxAnalysisPlatformUI.this.treeMain_valueChanged(e);
                }
                catch (Exception exc) {
                    TaxAnalysisPlatformUI.this.handUIException(exc);
                }
            }
        });
        this.groupTree.setSelectionRow(1);
    }

    protected String getRootName() {
        return "\u4e3b\u9898";
    }

    protected Object getRootObject() {
        return this.getRootName();
    }

    protected void treeMain_valueChanged(TreeSelectionEvent e) throws Exception {
        KDTreeNode selectedNode = this.getSelectedTreeNode();
        if (selectedNode != null && selectedNode.getUserObject() instanceof TaxAnalysisThemeInfo) {
            this.showPage();
        }
    }

    private ILNTreeNodeCtrl getLNTreeNodeCtrl() throws BOSException {
        return new DefaultLNTreeNodeCtrl((ITreeBase)TaxAnalysisThemeFactory.getRemoteInstance());
    }

    private void initQingPanel() throws Exception {
        this.browser = new KDWebViewPanel("", false);
        this.qingPanel.add((Component)this.browser, (Object)"Center");
    }

    protected void showPage() throws UnsupportedEncodingException {
        this.initParam();
        this.initUrl();
        this.browser.load(this.url);
    }

    private void initParam() {
        this.tag = this.getFilterTag();
        this.bizTag = this.getBizTag();
        this.className = this.getQingDataProviderClass();
        this.schemaId = this.getSchemaId();
    }

    private void initUrl() throws UnsupportedEncodingException {
        this.url = PortalUtil.getGUItoPortalUrl((String)("/easweb/bos/qing-analysis/controller-index.do?&tag=" + URLEncoder.encode(this.tag, "UTF-8") + "&" + "bizTag" + "=" + URLEncoder.encode(this.bizTag, "UTF-8") + "&" + "className" + "=" + URLEncoder.encode(this.className, "UTF-8") + "&" + "schemaId" + "=" + URLEncoder.encode(this.schemaId, "UTF-8")));
    }

    @Override
    public void actionGroupRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.initTree();
    }

    public String getFilterTag() {
        String tag = this.getSchemaId();
        if (StringUtil.isEmptyString((String)tag)) {
            tag = UUID.randomUUID().toString();
        }
        return "01_" + tag;
    }

    public KDTreeNode getSelectedTreeNode() {
        return (KDTreeNode)this.groupTree.getLastSelectedPathComponent();
    }

    public String getSchemaId() {
        KDTreeNode selectedNode = this.getSelectedTreeNode();
        String schemaId = "11111111111111111";
        if (selectedNode != null) {
            TaxAnalysisThemeInfo themeInfo = (TaxAnalysisThemeInfo)selectedNode.getUserObject();
            schemaId = themeInfo.getId().toString();
        }
        return "";
    }

    public String getBizTag() {
        KDTreeNode selectedNode = this.getSelectedTreeNode();
        String schemaId = "11111111111111111";
        if (selectedNode != null) {
            TaxAnalysisThemeInfo themeInfo = (TaxAnalysisThemeInfo)selectedNode.getUserObject();
            schemaId = themeInfo.getId().toString();
        }
        return schemaId;
    }

    public String getQingDataProviderClass() {
        return "com.kingdee.eas.tm.td.rpt.app.TaxQingCommonDataProvider";
    }
}

