/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.backport.Arrays;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.tm.td.rpt.TaxAnalysisThemeFactory;
import com.kingdee.eas.tm.td.rpt.TaxAnalysisThemeInfo;
import com.kingdee.eas.tm.td.rpt.TaxDimSettingsCollection;
import com.kingdee.eas.tm.td.rpt.TaxDimSettingsInfo;
import com.kingdee.eas.tm.td.rpt.TaxDimSettingsMemberCollection;
import com.kingdee.eas.tm.td.rpt.TaxDimSettingsMemberInfo;
import com.kingdee.eas.tm.td.rpt.client.AbstractTaxAnalysisThemeEditUI;
import com.kingdee.eas.tm.td.rpt.client.TaxDimensionMemberSelectDialog;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Calendar;
import java.util.List;
import org.apache.log4j.Logger;

public class TaxAnalysisThemeEditUI
extends AbstractTaxAnalysisThemeEditUI {
    private static final Logger logger = CoreUIObject.getLogger(TaxAnalysisThemeEditUI.class);
    protected final String DIM_NUMBER = "dimNumber";
    protected final String DIM_NAME = "dimName";
    protected final String DIM_MEMBERS = "dimMembers";
    private TaxDimensionMemberSelectDialog dialog = new TaxDimensionMemberSelectDialog((CoreUI)this);
    private KDBizPromptBox prmtMembers = new KDBizPromptBox();
    private KDTEditAdapter entryTableChange = null;

    public void onLoad() throws Exception {
        this.kdtDimSettings.checkParsed();
        super.onLoad();
        this.afterLoad();
    }

    protected void afterLoad() throws Exception {
        this.initSchemeF7();
        this.initTblDim();
        this.initDimMemberF7();
    }

    private void initSchemeF7() {
        this.prmtScheme.setEditFormat("$number$");
        this.prmtScheme.setDisplayFormat("$name$");
        this.prmtScheme.setCommitFormat("$number$");
        this.prmtScheme.setQueryInfo("com.kingdee.eas.tm.td.cloud.datamodel.app.DataFetchQuery");
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)1, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("fetchType", (Object)2, CompareType.EQUALS));
        view.setFilter(filter);
        this.prmtScheme.setEntityViewInfo(view);
    }

    public void initDimMemberF7() {
        this.dialog = new TaxDimensionMemberSelectDialog((CoreUI)this);
        this.prmtMembers = new KDBizPromptBox();
        this.prmtMembers.setDisplayFormat("$number$");
        this.prmtMembers.setEditFormat("$number$");
        this.prmtMembers.setCommitFormat("$number$");
        this.prmtMembers.setEditable(false);
        this.prmtMembers.setSelector((KDPromptSelector)this.dialog);
        this.kdtDimSettings.getColumn("dimMembers").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)this.prmtMembers));
        this.dialog.setF7((Component)this.prmtMembers);
        this.dialog.setThemeInfo(this.editData);
        this.prmtMembers.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                if (TaxAnalysisThemeEditUI.this.prmtMembers.getData() instanceof List) {
                    List data = (List)TaxAnalysisThemeEditUI.this.prmtMembers.getData();
                    if (data.size() == 0) {
                        data = null;
                        TaxAnalysisThemeEditUI.this.kdtDimSettings.getRow(TaxAnalysisThemeEditUI.this.kdtDimSettings.getSelectManager().getActiveRowIndex()).getCell("dimMembers").setValue(null);
                    } else {
                        TaxAnalysisThemeEditUI.this.kdtDimSettings.getRow(TaxAnalysisThemeEditUI.this.kdtDimSettings.getSelectManager().getActiveRowIndex()).getCell("dimMembers").setValue((Object)data);
                    }
                }
            }
        });
    }

    @Override
    public void loadFields() {
        this.removeEventLiseners();
        super.loadFields();
        this.innerLoadFields();
        this.initEventLiseners();
    }

    protected void removeEventLiseners() {
        this.getDetailTable().removeKDTEditListener((KDTEditListener)this.entryTableChange);
    }

    protected void initEventLiseners() {
        if (this.entryTableChange == null) {
            this.entryTableChange = new KDTEditAdapter(){

                public void editStarted(KDTEditEvent e) {
                    try {
                        TaxAnalysisThemeEditUI.this.kdtEntries_editStarted(e);
                    }
                    catch (Exception ex) {
                        TaxAnalysisThemeEditUI.this.handUIException(ex);
                    }
                }

                public void editStopped(KDTEditEvent e) {
                    try {
                        TaxAnalysisThemeEditUI.this.kdtEntries_editStopped(e);
                    }
                    catch (Exception ex) {
                        TaxAnalysisThemeEditUI.this.handUIException(ex);
                    }
                }
            };
        }
        this.getDetailTable().addKDTEditListener((KDTEditListener)this.entryTableChange);
    }

    protected void kdtEntries_editStarted(KDTEditEvent e) throws Exception {
        int rowIndex = this.getDetailTable().getSelectManager().getActiveRowIndex();
        String dimNumber = (String)this.getDetailTable().getRow(rowIndex).getCell("dimNumber").getValue();
        String dimName = (String)this.getDetailTable().getRow(rowIndex).getCell("dimName").getValue();
        this.dialog.setDimNumber(dimNumber);
        this.dialog.setDimName(dimName);
    }

    protected void kdtEntries_editStopped(KDTEditEvent e) throws Exception {
    }

    protected KDTable getDetailTable() {
        return this.kdtDimSettings;
    }

    protected void innerLoadFields() {
        TaxDimSettingsCollection settingsColls = this.editData.getDimSettings();
        settingsColls.sort("seq");
        TaxDimSettingsMemberCollection memberColls = null;
        TaxDimSettingsInfo settings = null;
        this.kdtDimSettings.removeRows();
        IRow row = null;
        ICell cell = null;
        for (int i = 0; i < settingsColls.size(); ++i) {
            settings = settingsColls.get(i);
            row = this.kdtDimSettings.addRow();
            row.setUserObject((Object)settings);
            cell = row.getCell("dimNumber");
            if (cell != null) {
                cell.getStyleAttributes().setLocked(true);
                cell.setUserObject((Object)settings);
                cell.setValue((Object)settings.getDimNumber());
            }
            if ((cell = row.getCell("dimName")) != null) {
                cell.getStyleAttributes().setLocked(true);
                cell.setValue((Object)settings.getDimName());
            }
            memberColls = settings.getMembers();
            memberColls.sort("seq");
            List memberList = Arrays.asList((Object[])memberColls.toArray());
            if (memberList.size() <= 0) continue;
            row.getCell("dimMembers").setValue((Object)memberList);
            row.getCell("dimMembers").setUserObject((Object)memberList);
        }
        this.initOldData((IObjectValue)this.editData);
    }

    protected void initDataStatus() {
        super.initDataStatus();
        this.btnSave.setVisible(false);
    }

    @Override
    public void storeFields() {
        super.storeFields();
        try {
            this.storeSettings();
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    protected void checkRequiredFields() {
        StringBuffer sb = new StringBuffer();
        if (this.txtNumber.getText().isEmpty()) {
            sb.append("\u3001\u7f16\u7801");
        }
        if (this.txtName.getText().isEmpty()) {
            sb.append("\u3001\u540d\u79f0");
        }
        if (this.prmtScheme.getValue() == null) {
            sb.append("\u3001\u65b9\u6848");
        }
        if (sb.length() > 0) {
            sb.append("\u4e0d\u80fd\u4e3a\u7a7a");
            MsgBox.showWarning((String)sb.substring(1));
            SysUtil.abort();
        }
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.checkRequiredFields();
        super.actionSubmit_actionPerformed(e);
    }

    protected void storeSettings() throws Exception {
        TaxDimSettingsInfo settings = null;
        TaxDimSettingsMemberCollection memberColl = null;
        TaxDimSettingsCollection settingsColl = new TaxDimSettingsCollection();
        for (int i = 0; i < this.kdtDimSettings.getRowCount(); ++i) {
            IRow row = this.kdtDimSettings.getRow(i);
            if (StringUtils.isEmpty((String)((String)row.getCell("dimNumber").getValue()))) continue;
            settings = (TaxDimSettingsInfo)row.getUserObject();
            settings.setSeq(i + 1);
            settings.setTheme(this.editData);
            settingsColl.add(settings);
            memberColl = new TaxDimSettingsMemberCollection();
            if (row.getCell("dimMembers").getValue() == null) continue;
            for (TaxDimSettingsMemberInfo member : (List)row.getCell("dimMembers").getValue()) {
                member.setDimSettings(settings);
                memberColl.add(member);
            }
            settings.getMembers().clear();
            settings.getMembers().addCollection(memberColl);
        }
        this.editData.getDimSettings().clear();
        this.editData.getDimSettings().addCollection(settingsColl);
    }

    public void initTblDim() throws EASBizException, BOSException {
        this.kdtDimSettings.getColumn("dimNumber").getStyleAttributes().setLocked(true);
        this.kdtDimSettings.getColumn("dimNumber").setRequired(true);
        this.kdtDimSettings.getColumn("dimName").getStyleAttributes().setLocked(true);
        this.kdtDimSettings.getColumn("dimName").setRequired(true);
        this.kdtDimSettings.getColumn("dimMembers").setRequired(false);
    }

    protected IObjectValue createNewData() {
        TaxAnalysisThemeInfo themeInfo = new TaxAnalysisThemeInfo();
        themeInfo.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
        Calendar cale = Calendar.getInstance();
        int year = cale.get(1);
        int month = cale.get(2) + 1;
        themeInfo.setStartYear(year);
        themeInfo.setEndYear(year);
        themeInfo.setStartPeriod(month);
        themeInfo.setEndPeriod(month);
        TaxDimSettingsInfo settings = new TaxDimSettingsInfo();
        settings.setSeq(1);
        settings.setTheme(themeInfo);
        settings.setDimNumber("GroupDim");
        settings.setDimName("\u5206\u7ec4");
        themeInfo.getDimSettings().add(settings);
        settings = new TaxDimSettingsInfo();
        settings.setSeq(2);
        settings.setTheme(themeInfo);
        settings.setDimNumber("CompanyDim");
        settings.setDimName("\u8d22\u52a1\u7ec4\u7ec7");
        themeInfo.getDimSettings().add(settings);
        return themeInfo;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return TaxAnalysisThemeFactory.getRemoteInstance();
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection selector = super.getSelectors();
        selector.add("dimSettings.*");
        selector.add("dimSettings.members.*");
        return selector;
    }
}

