/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.structure.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.impl.facade.rangesel.RangeSelector;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.newrpt.client.designer.SpreadManager;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.TaxDraftRecordInfo;
import com.kingdee.eas.tm.td.cloud.utils.TDCloudUtil;
import com.kingdee.eas.tm.td.structure.ReportItemDimensionEnum;
import com.kingdee.eas.tm.td.structure.TaxReportItemCollection;
import com.kingdee.eas.tm.td.structure.TaxReportItemInfo;
import com.kingdee.eas.tm.td.structure.TaxReportSheetFactory;
import com.kingdee.eas.tm.td.structure.TaxReportSheetInfo;
import com.kingdee.eas.tm.td.structure.TaxReportTemplateInfo;
import com.kingdee.eas.tm.td.structure.TaxValueTypeEnum;
import com.kingdee.eas.tm.td.structure.client.AbstractItemFormulaLayoutEditUI;
import com.kingdee.eas.tm.td.structure.client.TaxReportItemSelectedUI;
import com.kingdee.eas.tm.td.structure.utils.ItemLayoutEntryParams;
import com.kingdee.eas.tm.td.structure.utils.ItemLayoutParams;
import com.kingdee.eas.tm.td.structure.utils.StructureUIHelper;
import com.kingdee.eas.tm.td.utils.Location;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class ItemFormulaLayoutEditUI
extends AbstractItemFormulaLayoutEditUI {
    private static final Logger logger = CoreUIObject.getLogger(ItemFormulaLayoutEditUI.class);
    private Sheet rptSheet = null;
    private SpreadManager spreadManager = null;
    private IObjectValue editData = null;
    private boolean isCanceled = true;
    private static final String COL_NUMBER = "number";
    private static final String COL_NAME = "name";
    private static final String COL_DATATYPE = "dataType";
    private static final String COL_OBJECT = "OBJECT";
    private PropertyChangeListener propertyChangeListener = null;
    private RangeSelector selectorChooser = null;
    private Point basePoint = null;
    private boolean isModify = false;
    private ItemLayoutParams itemParams = new ItemLayoutParams();
    private ArrayList basePointList = new ArrayList();
    private DataChangeListener reportSheetChangeListener = null;
    private TaxReportSheetInfo tempSheetInfo = null;

    public void onLoad() throws Exception {
        this.tblMain.checkParsed();
        super.onLoad();
        this.initContext();
        this.initBasePointList();
        this.initParameters();
        this.initControl();
        this.setF7Filter();
    }

    protected void initListener() {
        this.reportSheetChangeListener = new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                if (TDCloudUtil.isEqual(e.getNewValue(), e.getOldValue())) {
                    return;
                }
                try {
                    ItemFormulaLayoutEditUI.this.reportSheet_dataChanged(e);
                }
                catch (Exception e1) {
                    ItemFormulaLayoutEditUI.this.handleException(e1);
                }
            }
        };
        this.prmtReportSheet.addDataChangeListener(this.reportSheetChangeListener);
        if (this.propertyChangeListener == null) {
            this.propertyChangeListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    try {
                        ItemFormulaLayoutEditUI.this.properyChange(e);
                    }
                    catch (Exception e1) {
                        ItemFormulaLayoutEditUI.this.handUIException(e1);
                    }
                }
            };
            this.selectorChooser.addPropertyChangeListener("RangeSelected", this.propertyChangeListener);
        }
    }

    private String getPosition() {
        int top = this.rptSheet.getActiveRow();
        int left = this.rptSheet.getActiveCol();
        top = top < 0 ? 0 : top;
        left = left < 0 ? 0 : left;
        return TableToolkit.xy2range((int)left, (int)top);
    }

    private void properyChange(PropertyChangeEvent e) throws EASBizException, BOSException {
        String rangeText = this.selectorChooser.getText();
        if (StringUtils.isEmpty((String)rangeText)) {
            return;
        }
        String[] str = rangeText.split("!");
        if (str.length <= 1) {
            return;
        }
        String[] cells = str[1].split(":");
        int[] point1 = Location.getCellRowAndColumn(cells[0]);
        int[] point2 = null;
        if (cells.length > 1) {
            point2 = Location.getCellRowAndColumn(cells[1]);
        }
        int row1 = point1[0];
        int column1 = point1[1];
        int row2 = point1[0];
        int column2 = point1[1];
        if (point2 != null) {
            row2 = point2[0];
            column2 = point2[1];
        }
        this.txtRowCount.setText(row2 - row1 + 1 + "");
    }

    protected void reportSheet_dataChanged(DataChangeEvent e) throws Exception {
        if (this.prmtReportSheet.getValue() == null) {
            return;
        }
        if (TDCloudUtil.isEqual(e.getNewValue(), e.getOldValue())) {
            return;
        }
        TaxReportSheetInfo sheetInfo = (TaxReportSheetInfo)this.prmtReportSheet.getValue();
        if (this.tempSheetInfo != null && !this.tempSheetInfo.getId().equals((Object)sheetInfo.getId()) && this.hasVolidData()) {
            int flag = MsgBox.showConfirm2((Component)((Object)this), (String)TDUtils.getString("com.kingdee.eas.tm.td.structure.TaxStructureResource", "ChangeReportSheet", TDUtils.getLocale()));
            if (flag == 0) {
                this.clearData();
            } else {
                this.prmtReportSheet.setValue(e.getOldValue());
            }
        }
        this.tempSheetInfo = (TaxReportSheetInfo)this.prmtReportSheet.getValue();
    }

    protected void clearData() {
        this.tblMain.removeRows();
    }

    protected boolean hasVolidData() {
        return this.tblMain.getRowCount() > 0;
    }

    private void initBasePointList() {
        this.basePointList = StructureUIHelper.getBasePointList(this.rptSheet);
    }

    private void initParameters() {
        Point point = new Point(0, 0);
        point.y = this.rptSheet.getActiveRow();
        point.x = this.rptSheet.getActiveCol();
        this.basePoint = StructureUIHelper.getBasePoint(this.rptSheet, point, this.basePointList);
        if (this.basePoint != null) {
            this.isModify = true;
            this.itemParams = StructureUIHelper.getParametersFromCell(this.rptSheet, this.basePoint.y, this.basePoint.x);
        } else {
            this.itemParams = new ItemLayoutParams();
            this.isModify = false;
            this.basePoint = point;
        }
    }

    protected void initControl() {
        this.prmtReportSheet.setHistoryRecordEnabled(false);
        this.tblMain.getSelectManager().setSelectMode(2);
        this.selectorChooser = this.initSelectedRange(this.areaContainer);
        KDComboBox enumEditor = new KDComboBox();
        enumEditor.addItem((Object)TaxValueTypeEnum.MONEY);
        enumEditor.addItem((Object)TaxValueTypeEnum.QUANTITY);
        enumEditor.addItem((Object)TaxValueTypeEnum.TXT);
        this.tblMain.getColumn(COL_DATATYPE).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)enumEditor));
        this.tblMain.getColumn(COL_NUMBER).getStyleAttributes().setLocked(true);
        this.tblMain.getColumn(COL_NAME).getStyleAttributes().setLocked(true);
        if (this.isModify()) {
            try {
                this.loadData(this.itemParams);
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
    }

    private void loadData(ItemLayoutParams itemParams) throws EASBizException, BOSException {
        this.selectorChooser.setText(itemParams.getAnalysisArea());
        this.prmtReportSheet.setValue((Object)TaxReportSheetFactory.getRemoteInstance().getTaxReportSheetInfo((IObjectPK)new ObjectUuidPK(itemParams.getSheetID())));
        this.txtRowCount.setText(itemParams.getRowCounter() + "");
        List<ItemLayoutEntryParams> entry = itemParams.getEntry();
        ItemLayoutEntryParams entryInfo2 = null;
        HashSet<String> numberSet = new HashSet<String>();
        for (ItemLayoutEntryParams entryInfo2 : entry) {
            numberSet.add(entryInfo2.getNumber());
        }
        TaxReportItemCollection itemColl = StructureUIHelper.getTaxReportItemByNumber(numberSet);
        TaxReportItemInfo itemInfo = null;
        HashMap<String, TaxReportItemInfo> itemMap = new HashMap<String, TaxReportItemInfo>();
        int size = itemColl.size();
        for (int i = 0; i < size; ++i) {
            itemInfo = itemColl.get(i);
            itemMap.put(itemInfo.getNumber(), itemInfo);
        }
        ArrayList<TaxReportItemInfo> itemList = new ArrayList<TaxReportItemInfo>();
        for (ItemLayoutEntryParams entryInfo2 : entry) {
            itemInfo = (TaxReportItemInfo)itemMap.get(entryInfo2.getNumber());
            if (itemInfo == null) continue;
            itemInfo.setValueType(entryInfo2.getDataType());
            itemList.add(itemInfo);
        }
        this.addArrayListToTable(itemList, this.tblMain);
    }

    public boolean isModify() {
        return this.isModify;
    }

    public void setModify(boolean isModify) {
        this.isModify = isModify;
    }

    private RangeSelector initSelectedRange(KDLabelContainer container) {
        RangeSelector chooser = this.spreadManager.createRangeSelector(TDUtils.getString("com.kingdee.eas.tm.td.structure.TaxStructureResource", "SELECTAREA", TDUtils.getLocale()));
        container.setBoundEditor((JComponent)chooser);
        return chooser;
    }

    protected void initContext() {
        this.rptSheet = (Sheet)this.getUIContext().get("rptSheet");
        this.spreadManager = (SpreadManager)this.getUIContext().get("spreadManager");
        this.editData = (IObjectValue)this.getUIContext().get("editData");
    }

    protected void setF7Filter() {
        if (this.editData instanceof TaxReportTemplateInfo) {
            TaxReportTemplateInfo templateInfo = (TaxReportTemplateInfo)this.editData;
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("taxType.id", (Object)templateInfo.getTaxType().getId(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("recordType", (Object)templateInfo.getRecordType().getValue(), CompareType.EQUALS));
            view.setFilter(filter);
            this.prmtReportSheet.setEntityViewInfo(view);
        } else if (this.editData instanceof TaxDraftRecordInfo) {
            TaxDraftRecordInfo reportInfo = (TaxDraftRecordInfo)this.editData;
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("taxType.id", (Object)reportInfo.getTaxType().getId(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("recordType", (Object)reportInfo.getRecordType().getValue(), CompareType.EQUALS));
            view.setFilter(filter);
            this.prmtReportSheet.setEntityViewInfo(view);
        }
    }

    private void checkRequiredFields() {
        if (this.tblMain.getRowCount() == 0) {
            MsgBox.showInfo((String)"\u9879\u76ee\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
            SysUtil.abort();
        }
    }

    @Override
    public void actionOK_actionPerformed(ActionEvent e) throws Exception {
        this.checkRequiredFields();
        this.itemParams = this.buildItemParams();
        if (this.hasBasePointIntersects()) {
            MsgBox.showInfo((String)"\u6821\u9a8c\u660e\u7ec6\u9879\u76ee\u516c\u5f0f\u533a\u57df\u4e0e\u5176\u4ed6\u660e\u7ec6\u9879\u76ee\u516c\u5f0f\u533a\u57df\u6709\u91cd\u5408\u90e8\u5206,\u8bf7\u91cd\u65b0\u914d\u7f6e");
            SysUtil.abort();
        }
        StructureUIHelper.saveBasePointCell(this.rptSheet, this.basePoint, this.itemParams);
        this.destroyWindow();
    }

    private boolean hasBasePointIntersects() {
        int headWidth = this.itemParams.getEntry().size();
        int bodyHeight = this.itemParams.getRowCounter();
        Rectangle r = new Rectangle(this.basePoint.x, this.basePoint.y, headWidth, bodyHeight);
        for (int i = this.basePointList.size() - 1; i >= 0; --i) {
            Point element = (Point)this.basePointList.get(i);
            if (element.equals(this.basePoint) || !StructureUIHelper.getRectangle(this.rptSheet, element).intersects(r)) continue;
            return true;
        }
        return false;
    }

    protected ItemLayoutParams buildItemParams() {
        ItemLayoutParams itemParams = new ItemLayoutParams();
        itemParams.setRowCounter(StructureUIHelper.getDefaultCounter(this.selectorChooser.getText()));
        itemParams.setAnalysisArea(this.selectorChooser.getText());
        itemParams.setSheetID(this.getReportSheetInfo().getId().toString());
        itemParams.setEntry(this.buildItemLayoutEntryParamsList());
        itemParams.setNumber(this.getReportSheetInfo().getNumber() + "_" + this.getPosition());
        return itemParams;
    }

    protected List<ItemLayoutEntryParams> buildItemLayoutEntryParamsList() {
        ArrayList<ItemLayoutEntryParams> itemParamsList = new ArrayList<ItemLayoutEntryParams>();
        IRow row = null;
        TaxReportItemInfo itemInfo = null;
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            row = this.tblMain.getRow(i);
            itemInfo = (TaxReportItemInfo)row.getCell(COL_OBJECT).getValue();
            itemInfo.setValueType((TaxValueTypeEnum)((Object)row.getCell(COL_DATATYPE).getValue()));
            itemParamsList.add(this.buildItemLayoutEntryParam(itemInfo));
        }
        return itemParamsList;
    }

    protected ItemLayoutEntryParams buildItemLayoutEntryParam(TaxReportItemInfo itemInfo) {
        ItemLayoutEntryParams entryParams = new ItemLayoutEntryParams();
        entryParams.setNumber(itemInfo.getNumber());
        entryParams.setName(itemInfo.getName());
        entryParams.setDataType(itemInfo.getValueType());
        return entryParams;
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.isCanceled = true;
        this.getUIWindow().close();
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    @Override
    public void actionItemSelected_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"reportSheet", (Object)this.getReportSheetInfo());
        uiContext.put((Object)"itemDimension", (Object)ReportItemDimensionEnum.COLUMN);
        uiContext.put((Object)"rptItemSelected", this.getRptItemListFromTable(this.tblMain));
        IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        IUIWindow window = uiFactory.create(TaxReportItemSelectedUI.class.getName(), (Map)uiContext, null, this.getOprtState());
        window.show();
        TaxReportItemSelectedUI selectUI = (TaxReportItemSelectedUI)window.getUIObject();
        if (!selectUI.isCanceled()) {
            this.addArrayListToTable(selectUI.getRptArrSelected(), this.tblMain);
        }
    }

    public List<TaxReportItemInfo> getRptItemListFromTable(KDTable table) {
        ArrayList<TaxReportItemInfo> rptItemSelected = new ArrayList<TaxReportItemInfo>();
        IRow row = null;
        Object value = null;
        TaxReportItemInfo info = null;
        for (int i = 0; i < table.getRowCount(); ++i) {
            row = table.getRow(i);
            value = row.getCell(COL_OBJECT).getValue();
            if (value == null || !(value instanceof TaxReportItemInfo)) continue;
            info = (TaxReportItemInfo)row.getCell(COL_OBJECT).getValue();
            rptItemSelected.add(info);
        }
        return rptItemSelected;
    }

    private void addArrayListToTable(List rptArr, KDTable table) {
        table.removeRows();
        int count = rptArr.size();
        TaxReportItemInfo info = null;
        IRow row = null;
        for (int i = 0; i < count; ++i) {
            info = (TaxReportItemInfo)rptArr.get(i);
            row = table.addRow();
            row.getCell(COL_NUMBER).setValue((Object)info.getNumber());
            row.getCell(COL_NAME).setValue((Object)info.getName());
            row.getCell(COL_DATATYPE).setValue((Object)info.getValueType());
            row.getCell(COL_OBJECT).setValue((Object)info);
        }
    }

    protected TaxReportSheetInfo getReportSheetInfo() {
        return (TaxReportSheetInfo)this.prmtReportSheet.getValue();
    }

    private void checkSelected() {
        if (this.prmtReportSheet.getValue() == null) {
            MsgBox.showInfo((String)TDUtils.getString("com.kingdee.eas.tm.td.structure.TaxStructureResource", "INPUTREPORTSHEET", TDUtils.getLocale()));
            this.prmtReportSheet.requestFocus();
            SysUtil.abort();
        }
    }
}

