/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.structure.client;

import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.tm.td.FilterCommonStatusEnum;
import com.kingdee.eas.tm.td.RecordTypeEnum;
import com.kingdee.eas.tm.td.StatusEnum;
import com.kingdee.eas.tm.td.basedata.TaxItemTypeFactory;
import com.kingdee.eas.tm.td.basedata.TaxItemTypeInfo;
import com.kingdee.eas.tm.td.structure.ReportItemDimensionEnum;
import com.kingdee.eas.tm.td.structure.TaxReportSheetFactory;
import com.kingdee.eas.tm.td.structure.TaxReportSheetInfo;
import com.kingdee.eas.tm.td.structure.client.AbstractTaxReportItemFilterUI;
import com.kingdee.eas.tm.td.structure.utils.StructureUtils;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class TaxReportItemFilterUI
extends AbstractTaxReportItemFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(TaxReportItemFilterUI.class);
    private CustomerParams customerParams = null;
    private DataChangeListener taxTypeChangeListener = null;
    private ItemListener recordTypeChangeListener = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.afterLoad();
        this.initListener();
    }

    protected void initListener() {
        this.taxTypeChangeListener = new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                TaxReportItemFilterUI.this.taxType_dataChanged(e);
            }
        };
        this.prmtTaxType.addDataChangeListener(this.taxTypeChangeListener);
        this.recordTypeChangeListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                TaxReportItemFilterUI.this.recordType_dataChanged(e);
            }
        };
        this.comboRecordType.addItemListener(this.recordTypeChangeListener);
    }

    protected void taxType_dataChanged(DataChangeEvent e) {
        this.prmtReportSheet.setValue(null);
        this.setReportSheetF7Filter();
    }

    protected void recordType_dataChanged(ItemEvent e) {
        this.prmtReportSheet.setValue(null);
        this.setReportSheetF7Filter();
    }

    protected void setReportSheetF7Filter() {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        Object value = this.prmtTaxType.getValue();
        if (value != null && value instanceof TaxItemTypeInfo) {
            TaxItemTypeInfo taxType = (TaxItemTypeInfo)value;
            filter.getFilterItems().add(new FilterItemInfo("taxType.id", (Object)taxType.getId().toString(), CompareType.EQUALS));
        }
        if ((value = this.comboRecordType.getSelectedItem()) != null && value instanceof RecordTypeEnum) {
            RecordTypeEnum recordType = (RecordTypeEnum)((Object)value);
            filter.getFilterItems().add(new FilterItemInfo("recordType", (Object)recordType.getValue(), CompareType.EQUALS));
        }
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)"2", CompareType.EQUALS));
        view.setFilter(filter);
        this.prmtReportSheet.setEntityViewInfo(view);
    }

    private void afterLoad() {
        this.comboRecordType.removeAllItems();
        this.comboRecordType.addItem((Object)FilterCommonStatusEnum.NULL);
        this.comboRecordType.addItems(RecordTypeEnum.getEnumList().toArray());
        this.comboStatus.removeAllItems();
        this.comboStatus.addItem((Object)FilterCommonStatusEnum.NULL);
        this.comboStatus.addItem((Object)StatusEnum.Enable);
        this.comboStatus.addItem((Object)StatusEnum.DisEnable);
        this.comboItemDimension.removeAllItems();
        this.comboItemDimension.addItem((Object)FilterCommonStatusEnum.NULL);
        this.comboItemDimension.addItems(ReportItemDimensionEnum.getEnumList().toArray());
        StructureUtils.setTaxTypeFilter(this.prmtTaxType);
    }

    public FilterInfo getFilterInfo() {
        StatusEnum status;
        ReportItemDimensionEnum itemDim;
        RecordTypeEnum type;
        FilterInfo filter = new FilterInfo();
        String maskString = "";
        int index = 0;
        Object data = this.txtNumber.getText();
        if (data != null && !data.toString().trim().equals("")) {
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)data.toString()));
            maskString = index == 0 ? maskString + "#" + index : maskString + " and #" + index;
            ++index;
        }
        if ((data = this.prmtTaxType.getData()) != null && data instanceof TaxItemTypeInfo) {
            filter.getFilterItems().add(new FilterItemInfo("taxType.id", (Object)((TaxItemTypeInfo)this.prmtTaxType.getData()).getId().toString()));
            maskString = index == 0 ? maskString + "#" + index : maskString + " and #" + index;
            ++index;
        }
        if ((data = this.comboRecordType.getSelectedItem()) instanceof RecordTypeEnum && (type = (RecordTypeEnum)((Object)data)) != null) {
            filter.getFilterItems().add(new FilterItemInfo("reportSheet.recordType", (Object)type.getValue()));
            maskString = index == 0 ? maskString + "#" + index : maskString + " and #" + index;
            ++index;
        }
        if ((data = this.prmtReportSheet.getData()) != null && data instanceof TaxReportSheetInfo) {
            filter.getFilterItems().add(new FilterItemInfo("reportSheet.id", (Object)((TaxReportSheetInfo)this.prmtReportSheet.getData()).getId().toString()));
            maskString = index == 0 ? maskString + "#" + index : maskString + " and #" + index;
            ++index;
        }
        if ((data = this.comboItemDimension.getSelectedItem()) instanceof ReportItemDimensionEnum && (itemDim = (ReportItemDimensionEnum)((Object)data)) != null) {
            filter.getFilterItems().add(new FilterItemInfo("itemDimension", (Object)itemDim.getValue()));
            maskString = index == 0 ? maskString + "#" + index : maskString + " and #" + index;
            ++index;
        }
        if ((data = this.comboStatus.getSelectedItem()) instanceof StatusEnum && (status = (StatusEnum)((Object)data)) != null) {
            filter.getFilterItems().add(new FilterItemInfo("state", (Object)status.getValue()));
            maskString = index == 0 ? maskString + "#" + index : maskString + " and #" + index;
            ++index;
        }
        filter.setMaskString(maskString);
        return filter;
    }

    public void setFilterInfo(FilterInfo filterInfo) {
        this.filterInfo = filterInfo;
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        FilterInfo filterInfo = entityViewInfo.getFilter();
        if (filterInfo == null || filterInfo.getFilterItems().size() == 0) {
            return;
        }
        FilterItemCollection currentFilterItemCollection = entityViewInfo.getFilter().getFilterItems();
        for (int i = 0; i < currentFilterItemCollection.size(); ++i) {
            DataBaseInfo data;
            String id;
            FilterItemInfo filterItemInfo = currentFilterItemCollection.get(i);
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("number")) {
                String number = (String)filterItemInfo.getCompareValue();
                this.txtNumber.setText(number);
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("taxType.id")) {
                id = (String)filterItemInfo.getCompareValue();
                try {
                    data = TaxItemTypeFactory.getRemoteInstance().getTaxItemTypeInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)));
                    this.prmtTaxType.setData((Object)data);
                }
                catch (Exception e) {
                    this.handUIException(e);
                }
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("reportSheet.recordType")) {
                int type = (Integer)filterItemInfo.getCompareValue();
                if ("-1".equals(filterItemInfo.getCompareValue().toString())) {
                    this.comboRecordType.setSelectedItem((Object)FilterCommonStatusEnum.NULL);
                } else {
                    this.comboRecordType.setSelectedItem((Object)RecordTypeEnum.getEnum(type));
                }
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("reportSheet.id")) {
                id = (String)filterItemInfo.getCompareValue();
                try {
                    data = TaxReportSheetFactory.getRemoteInstance().getTaxReportSheetInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)));
                    this.prmtReportSheet.setData((Object)data);
                }
                catch (Exception e) {
                    this.handUIException(e);
                }
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("itemDimension")) {
                int type = (Integer)filterItemInfo.getCompareValue();
                if ("-1".equals(filterItemInfo.getCompareValue().toString())) {
                    this.comboItemDimension.setSelectedItem((Object)FilterCommonStatusEnum.NULL);
                } else {
                    this.comboItemDimension.setSelectedItem((Object)ReportItemDimensionEnum.getEnum(type));
                }
            }
            if (!filterItemInfo.getPropertyName().equalsIgnoreCase("state")) continue;
            String type = (String)filterItemInfo.getCompareValue();
            if ("-1".equals(type)) {
                this.comboStatus.setSelectedItem((Object)FilterCommonStatusEnum.NULL);
                continue;
            }
            this.comboStatus.setSelectedItem((Object)StatusEnum.getEnum(type));
        }
    }

    public boolean verify() {
        return true;
    }

    public Component getFocusComponent() {
        return null;
    }

    public void clear() {
        try {
            TaxItemTypeInfo taxTypeInfo = TaxItemTypeFactory.getRemoteInstance().getTaxItemTypeInfo((IObjectPK)new ObjectUuidPK("Xip0em3cA6rgU0ETqMAGKduK96Y="));
            this.prmtTaxType.setValue((Object)taxTypeInfo);
        }
        catch (Exception e) {
            this.prmtTaxType.setValue(null);
        }
        this.comboRecordType.setSelectedItem((Object)RecordTypeEnum.TaxDeclare);
        this.prmtReportSheet.setValue(null);
        this.comboStatus.setSelectedIndex(0);
        this.comboItemDimension.setSelectedIndex(0);
        this.txtNumber.setText(null);
    }

    public void setCustomerParams(CustomerParams cp) {
        this.clear();
        this.customerParams = cp;
    }

    public CustomerParams getCustomerParams() {
        HashMap hm = new HashMap();
        this.customerParams = new CustomerParams();
        this.customerParams.setHm(hm);
        return this.customerParams;
    }
}

