/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.structure.client;

import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.tm.td.FilterCommonStatusEnum;
import com.kingdee.eas.tm.td.RecordTypeEnum;
import com.kingdee.eas.tm.td.StatusEnum;
import com.kingdee.eas.tm.td.basedata.TaxItemTypeFactory;
import com.kingdee.eas.tm.td.basedata.TaxItemTypeInfo;
import com.kingdee.eas.tm.td.structure.client.AbstractTaxReportSheetFilterUI;
import com.kingdee.eas.tm.td.structure.utils.StructureUtils;
import java.awt.Component;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class TaxReportSheetFilterUI
extends AbstractTaxReportSheetFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(TaxReportSheetFilterUI.class);
    private CustomerParams customerParams = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.afterLoad();
    }

    private void afterLoad() {
        this.comboRecordType.removeAllItems();
        this.comboRecordType.addItem((Object)FilterCommonStatusEnum.NULL);
        this.comboRecordType.addItems(RecordTypeEnum.getEnumList().toArray());
        this.comboStatus.removeAllItems();
        this.comboStatus.addItem((Object)FilterCommonStatusEnum.NULL);
        this.comboStatus.addItem((Object)StatusEnum.Enable);
        this.comboStatus.addItem((Object)StatusEnum.DisEnable);
        StructureUtils.setTaxTypeFilter(this.prmtTaxType);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public FilterInfo getFilterInfo() {
        StatusEnum status;
        RecordTypeEnum type;
        Object value;
        FilterInfo filter = new FilterInfo();
        String maskString = "";
        int index = 0;
        Object data = this.prmtTaxType.getData();
        if (data != null && data instanceof TaxItemTypeInfo) {
            filter.getFilterItems().add(new FilterItemInfo("taxType.id", (Object)((TaxItemTypeInfo)this.prmtTaxType.getData()).getId().toString()));
            maskString = maskString + "#" + index;
            ++index;
        }
        if ((value = this.comboRecordType.getSelectedItem()) instanceof RecordTypeEnum && (type = (RecordTypeEnum)((Object)value)) != null) {
            filter.getFilterItems().add(new FilterItemInfo("recordType", (Object)type.getValue()));
            maskString = index == 0 ? maskString + "#" + index : maskString + " and #" + index;
            ++index;
        }
        if ((value = this.comboStatus.getSelectedItem()) instanceof StatusEnum && (status = (StatusEnum)((Object)value)) != null) {
            filter.getFilterItems().add(new FilterItemInfo("state", (Object)status.getValue()));
            maskString = index == 0 ? maskString + "#" + index : maskString + " and #" + index;
            ++index;
        }
        if ((value = this.txtNumber.getText()) != null && !value.toString().trim().equals("")) {
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)value.toString()));
            maskString = index == 0 ? maskString + "#" + index : maskString + " and #" + index;
            ++index;
        }
        filter.setMaskString(maskString);
        return filter;
    }

    public void setFilterInfo(FilterInfo filterInfo) {
        this.filterInfo = filterInfo;
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        FilterInfo filterInfo = entityViewInfo.getFilter();
        if (filterInfo == null || filterInfo.getFilterItems().size() == 0) {
            return;
        }
        FilterItemCollection currentFilterItemCollection = entityViewInfo.getFilter().getFilterItems();
        for (int i = 0; i < currentFilterItemCollection.size(); ++i) {
            Object type;
            FilterItemInfo filterItemInfo = currentFilterItemCollection.get(i);
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("taxType.id")) {
                String id = (String)filterItemInfo.getCompareValue();
                try {
                    TaxItemTypeInfo data = TaxItemTypeFactory.getRemoteInstance().getTaxItemTypeInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)));
                    this.prmtTaxType.setData((Object)data);
                }
                catch (Exception e) {
                    this.handUIException(e);
                }
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("state")) {
                type = (String)filterItemInfo.getCompareValue();
                if ("-1".equals(type)) {
                    this.comboStatus.setSelectedItem((Object)FilterCommonStatusEnum.NULL);
                } else {
                    this.comboStatus.setSelectedItem((Object)StatusEnum.getEnum((String)type));
                }
            }
            if (filterItemInfo.getPropertyName().equalsIgnoreCase("recordType")) {
                type = filterItemInfo.getCompareValue();
                if ("-1".equals(type)) {
                    this.comboRecordType.setSelectedItem((Object)FilterCommonStatusEnum.NULL);
                } else {
                    this.comboRecordType.setSelectedItem((Object)RecordTypeEnum.getEnum((Integer)type));
                }
            }
            if (!filterItemInfo.getPropertyName().equalsIgnoreCase("number")) continue;
            String number = (String)filterItemInfo.getCompareValue();
            this.txtNumber.setText(number);
        }
    }

    public boolean verify() {
        return true;
    }

    public Component getFocusComponent() {
        return null;
    }

    public void clear() {
        this.prmtTaxType.setValue(null);
        this.comboRecordType.setSelectedIndex(0);
        this.comboStatus.setSelectedIndex(0);
        this.txtNumber.setText(null);
    }

    public void setCustomerParams(CustomerParams cp) {
        this.clear();
        this.customerParams = cp;
    }

    public CustomerParams getCustomerParams() {
        HashMap hm = new HashMap();
        this.customerParams = new CustomerParams();
        this.customerParams.setHm(hm);
        return this.customerParams;
    }
}

