/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.structure.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.commonquery.ShareTypeEnum;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.IProcessor;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchHandler.UtilRequest;
import com.kingdee.eas.framework.query.QuickFilteringSupportItems;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.common.permsupport.IPermSupport4ListUI;
import com.kingdee.eas.tm.td.common.uihelper.ListUIHelper;
import com.kingdee.eas.tm.td.structure.TaxReportSheetFactory;
import com.kingdee.eas.tm.td.structure.client.AbstractTaxReportSheetListUI;
import com.kingdee.eas.tm.td.structure.client.TaxReportSheetFilterUI;
import com.kingdee.eas.tm.td.structure.utils.StructureCommonProcessor;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public class TaxReportSheetListUI
extends AbstractTaxReportSheetListUI
implements IPermSupport4ListUI {
    private static final Logger logger = CoreUIObject.getLogger(TaxReportSheetListUI.class);
    public static final String TBL_STATE = "state";
    public static final String TBL_ISSCHEDULED = "isScheduled";
    private ListUIHelper uiHelper = null;
    private String currentCUID;
    private QuickFilteringSupportItems qfsi = new QuickFilteringSupportItems(true, true);

    public void onLoad() throws Exception {
        super.onLoad();
        this.afterLoad();
        this.uiHelper = new ListUIHelper(this);
        this.currentCUID = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
    }

    protected void afterLoad() {
        this.btnCancel.setEnabled(true);
        this.btnCancelCancel.setEnabled(true);
        this.btnCancel.setVisible(true);
        this.btnCancelCancel.setVisible(true);
    }

    protected QuickFilteringSupportItems getQuickFilteringSupport() {
        this.qfsi.setMustQueryAtFirst(true);
        return this.qfsi;
    }

    protected String getEditUIName() {
        return "com.kingdee.eas.tm.td.structure.client.TaxReportSheetEditUI";
    }

    protected ICoreBase getBizInterface() throws Exception {
        return TaxReportSheetFactory.getRemoteInstance();
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.ControlUnit;
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        TDUtils.checkPermission(null, null, null, "td_taxreportsheet_new");
        super.actionAddNew_actionPerformed(e);
    }

    protected void checkStateEnableEdit() throws Exception {
        Boolean isShcheduled;
        this.checkSelected();
        IRow row = KDTableUtil.getSelectedRow((KDTable)this.getDetailTable());
        BizEnumValueDTO state = (BizEnumValueDTO)row.getCell(TBL_STATE).getValue();
        if ("2".equals(state.getString())) {
            MsgBox.showInfo((String)TDUtils.getString("com.kingdee.eas.tm.td.structure.TaxStructureResource", "ENABLENOEDIT", SysContext.getSysContext().getLocale()));
            SysUtil.abort();
        }
        if ((isShcheduled = (Boolean)row.getCell(TBL_ISSCHEDULED).getValue()).booleanValue()) {
            MsgBox.showInfo((String)TDUtils.getString("com.kingdee.eas.tm.td.structure.TaxStructureResource", "BASEDATA_EIDT_SCHEDULEDERROR", SysContext.getSysContext().getLocale()));
            SysUtil.abort();
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkStateEnableEdit();
        this.uiHelper.checkCanEdit(this.currentCUID, this.getSelectedKeyValue());
        super.actionEdit_actionPerformed(e);
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        CommonQueryDialog dialog = new CommonQueryDialog();
        if (this.getUIWindow() == null) {
            dialog.setOwner((Component)this.getUIContext().get("OwnerWindow"));
        } else {
            dialog.setOwner((Component)((Object)this));
        }
        dialog.setUiObject((IUIObject)this);
        dialog.setParentUIClassName(this.getClass().getName());
        dialog.setQueryObjectPK(this.getMainQueryPK());
        dialog.setShowShareType(16);
        dialog.setCurrentShareType(ShareTypeEnum.USER_NOORG_LEVEL);
        try {
            dialog.setProcessor((IProcessor)new StructureCommonProcessor((IUIObject)this));
            TaxReportSheetFilterUI filterUI = new TaxReportSheetFilterUI();
            dialog.addUserPanel((KDPanel)filterUI);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        dialog.setWidth(600);
        dialog.setHeight(400);
        dialog.setShowFilter(true);
        dialog.setShowSorter(false);
        dialog.setShowToolbar(true);
        return dialog;
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.uiHelper.checkBaseDataPermission(this.currentCUID, this.getSelectedIdValues());
        String cancelMsg = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_CancelCancel");
        if (this.confirmDialog(cancelMsg)) {
            if (UtilRequest.isPrepare((String)"ActionCancelCancel", (CoreUIObject)this)) {
                this.prepareCancelCancel(null).callHandler();
            }
            this.cancelCancel();
            this.refreshList();
        }
    }

    protected KDTable getDetailTable() {
        return this.tblMain;
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.uiHelper.checkBaseDataPermission(this.currentCUID, this.getSelectedIdValues());
        super.actionCancel_actionPerformed(e);
        this.refreshList();
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.uiHelper.checkCanRemove(this.currentCUID, this.getSelectedIdValues());
        super.actionRemove_actionPerformed(e);
        this.refreshList();
    }

    @Override
    public String getBizOrgProperty(OrgType orgType) throws BOSException, EASBizException {
        return "CU";
    }

    @Override
    public void initPermActions() throws BOSException, EASBizException {
    }

    @Override
    public ICoreBase getPermInterface() throws Exception {
        return this.getBizInterface();
    }

    @Override
    public void initPermMainOrgContext(String orgID) throws Exception {
        this.initUIMainOrgContext(orgID);
    }

    public void refreshList() throws Exception {
        this.saveCurrentLocation();
        super.refreshList();
        this.restoreCurrentLocation();
    }
}

