/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.structure.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.basedata.org.client.f7.NewCompanyF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.util.CommRptResourceUtil;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.basedata.TaxItemTypeFactory;
import com.kingdee.eas.tm.td.basedata.TaxItemTypeInfo;
import com.kingdee.eas.tm.td.structure.client.AbstractTaxReportTemplateSynchUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import org.apache.log4j.Logger;

public class TaxReportTemplateSynchUI
extends AbstractTaxReportTemplateSynchUI {
    private static final Logger logger = CoreUIObject.getLogger(TaxReportTemplateSynchUI.class);
    private boolean isOk = false;
    private HashMap retMap = new HashMap();

    public boolean isOk() {
        return this.isOk;
    }

    public void setOk(boolean isOk) {
        this.isOk = isOk;
    }

    public HashMap getRetMap() {
        return this.retMap;
    }

    public void setRetMap(HashMap retMap) {
        this.retMap = retMap;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initControl();
        this.setDefaultValue();
    }

    protected void initControl() throws EASBizException, BOSException {
        NewCompanyF7 companySelector = new NewCompanyF7((IUIObject)this);
        companySelector.setShowAssistantOrg(false);
        companySelector.setIsCUFilter(false);
        companySelector.setShowVirtual(true);
        companySelector.setContainSealUp(false);
        companySelector.setNeedAddAssistant(true);
        companySelector.setMultiSelect(true);
        String taxTypeID = (String)this.getUIContext().get("taxType");
        int recordType = (Integer)this.getUIContext().get("recordType");
        TaxItemTypeInfo taxItemTypeInfo = TaxItemTypeFactory.getRemoteInstance().getTaxItemTypeInfo((IObjectPK)new ObjectUuidPK(taxTypeID));
        String simpleName = taxItemTypeInfo.getSimpleName().toLowerCase();
        String permissionName = "";
        if (this.getUIContext().get("Owner").toString().contains("TaxDeclareTemplateListUI")) {
            permissionName = simpleName + "_taxdeclare_edit";
        } else if (this.getUIContext().get("Owner").toString().contains("AccountTemplateListUI")) {
            permissionName = simpleName + "_taxaccount_edit";
        } else if (this.getUIContext().get("Owner").toString().contains("DraftItemTemplateListUI")) {
            permissionName = simpleName + "_taxdraftitem_edit";
        }
        if (3 == recordType) {
            permissionName = simpleName + "_mouthdeclaredraft_edit";
        } else if (4 == recordType) {
            permissionName = simpleName + "_mouthtaxdeclare_edit";
        } else if (5 == recordType) {
            permissionName = simpleName + "_sumdeclaredraft_edit";
        } else if (6 == recordType) {
            permissionName = simpleName + "_sumtaxdeclare_edit";
        }
        companySelector.setPermissionItem(permissionName);
        this.prmtCompany.setSelector((KDPromptSelector)companySelector);
        this.prmtCompany.setHistoryRecordEnabled(false);
        Date a = new Date();
        int year = a.getYear() + 1900;
        this.spinBeginYear.setModel((SpinnerModel)new SpinnerNumberExModel(year, 0, 9999, 1));
        this.spinBeginPeriod.setModel((SpinnerModel)new SpinnerNumberExModel(a.getMonth() + 1, 1, 12, 1));
        this.spinEndYear.setModel((SpinnerModel)new SpinnerNumberExModel(year, 0, 9999, 1));
        this.spinEndPeriod.setModel((SpinnerModel)new SpinnerNumberExModel(a.getMonth() + 1, 1, 12, 1));
    }

    protected void setDefaultValue() {
        Calendar cale = Calendar.getInstance();
        int year = cale.get(1);
        int month = cale.get(2) + 1;
        this.spinBeginYear.setValue((Object)year);
        this.spinEndYear.setValue((Object)year);
        this.spinBeginPeriod.setValue((Object)month);
        this.spinEndPeriod.setValue((Object)month);
    }

    public boolean verify() {
        StringBuffer sb = new StringBuffer();
        if (this.prmtCompany.getValue() == null) {
            sb.append("\u3001");
            sb.append(TDUtils.getString("com.kingdee.eas.tm.td.structure.TaxStructureResource", "CompanyName", TDUtils.getLocale()));
        }
        if (this.spinBeginYear.getValue() == null || this.spinEndYear.getValue() == null || this.spinBeginPeriod.getValue() == null || this.spinEndPeriod.getValue() == null) {
            sb.append("\u3001");
            sb.append(TDUtils.getString("com.kingdee.eas.tm.td.structure.TaxStructureResource", "Period", TDUtils.getLocale()));
        }
        if (sb.length() > 0) {
            sb.append(TDUtils.getString("com.kingdee.eas.tm.td.structure.TaxStructureResource", "NotNull", TDUtils.getLocale()));
            MsgBox.showWarning((String)sb.substring(1));
            SysUtil.abort();
        }
        if ((Integer)this.spinBeginYear.getValue() > (Integer)this.spinEndYear.getValue() || ((Integer)this.spinBeginYear.getValue()).intValue() == ((Integer)this.spinEndYear.getValue()).intValue() && (Integer)this.spinBeginPeriod.getValue() > (Integer)this.spinEndPeriod.getValue()) {
            MsgBox.showWarning((String)TDUtils.getString("com.kingdee.eas.tm.td.structure.TaxStructureResource", "Period_Error", TDUtils.getLocale()));
            SysUtil.abort();
        }
        return true;
    }

    @Override
    public void actionOK_actionPerformed(ActionEvent e) throws Exception {
        this.verify();
        this.retMap.put("company", this.prmtCompany.getValue());
        this.retMap.put("yearFrom", this.spinBeginYear.getValue());
        this.retMap.put("monthFrom", this.spinBeginPeriod.getValue());
        this.retMap.put("yearTo", this.spinEndYear.getValue());
        this.retMap.put("monthTo", this.spinEndPeriod.getValue());
        if (this.chkIsSynchTaxReport.isSelected()) {
            this.retMap.put("isSynch", true);
        } else {
            this.retMap.put("isSynch", false);
        }
        this.setOk(true);
        this.actionExitCurrent_actionPerformed(e);
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.actionExitCurrent_actionPerformed(e);
    }

    private static class SpinnerNumberExModel
    extends SpinnerNumberModel {
        private Object lastValue = null;

        public SpinnerNumberExModel(int value, int minimum, int maximum, int stepSize) {
            super(value, minimum, maximum, stepSize);
            this.lastValue = new Integer(value);
        }

        @Override
        public void setValue(Object value) {
            Object curValue = this.getValue();
            super.setValue(value);
            if (curValue != value) {
                this.lastValue = value;
            }
        }

        public int getLastValue() {
            if (this.lastValue == null) {
                throw new RuntimeException(CommRptResourceUtil.getRes((String)"not_init"));
            }
            return (Integer)this.lastValue;
        }

        public int getIntValue() {
            return (Integer)this.getValue();
        }

        public boolean isUp() {
            return this.getIntValue() > this.getLastValue();
        }
    }
}

