/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.structure.rpt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestListener;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.framework.report.ICommRptBase;
import com.kingdee.eas.framework.report.client.CommRptBaseConditionUI;
import com.kingdee.eas.framework.report.util.KDTableUtil;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.RptTableHeader;
import com.kingdee.eas.tm.td.DraftRecordTypeEnum;
import com.kingdee.eas.tm.td.RecordTypeEnum;
import com.kingdee.eas.tm.td.structure.TaxValueTypeEnum;
import com.kingdee.eas.tm.td.structure.rpt.TaxItemDataAnalysisFacadeFactory;
import com.kingdee.eas.tm.td.structure.rpt.client.AbstractTaxItemDataAnalysisRptUI;
import com.kingdee.eas.tm.td.structure.rpt.client.TaxItemDataAnalysisConditionUI;
import org.apache.log4j.Logger;

public class TaxItemDataAnalysisRptUI
extends AbstractTaxItemDataAnalysisRptUI {
    private static final Logger logger = CoreUIObject.getLogger(TaxItemDataAnalysisRptUI.class);
    private static final String TBL_ID = "ID";
    private static final String TBL_RECORDTYPE = "recordType";
    private static final String TBL_SUBRECORDTYPE = "subRecordType";
    private static final String TBL_VALUETYPE = "valueType";

    public TaxItemDataAnalysisRptUI() throws Exception {
        this.tblMain.checkParsed();
        this.tblMain.getDataRequestManager().addDataRequestListener((KDTDataRequestListener)this);
        this.tblMain.getDataRequestManager().setDataRequestMode(1);
        this.tblMain.getDataRequestManager().setPageRowCount(500);
        this.enableExportExcel(this.tblMain);
        this.tblMain.setEditable(false);
        this.tblMain.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                TaxItemDataAnalysisRptUI.this.tbl_afterDataFill(e);
            }
        });
    }

    public void getData(KDTDataRequestEvent e) {
        try {
            RptParams rpt;
            this.tblMain.getDataRequestManager().removeDataRequestListener((KDTDataRequestListener)this);
            int from = e.getFirstRow();
            int len = e.getLastRow() - from + 1;
            RptParams para = new RptParams();
            if (from == 0) {
                para.setString("tempTable", this.getTempTable());
                para.setObject("company", this.params.getObject("company"));
                para.setObject("yearFrom", this.params.getObject("yearFrom"));
                para.setObject("monthFrom", this.params.getObject("monthFrom"));
                para.setObject("yearTo", this.params.getObject("yearTo"));
                para.setObject("monthTo", this.params.getObject("monthTo"));
                para.setObject("taxType", this.params.getObject("taxType"));
                para.setObject(TBL_RECORDTYPE, this.params.getObject(TBL_RECORDTYPE));
                para.setObject("report", this.params.getObject("report"));
                para.setObject(TBL_SUBRECORDTYPE, this.params.getObject(TBL_SUBRECORDTYPE));
                para.setObject("account", this.params.getObject("account"));
                para.setObject("buildingTaxesGroup", this.params.getObject("buildingTaxesGroup"));
                para.setObject("reportSheet", this.params.getObject("reportSheet"));
                para.setObject("rowItem", this.params.getObject("rowItem"));
                para.setObject("columnItem", this.params.getObject("columnItem"));
                rpt = this.getRemoteInstance().createTempTable(para);
                this.setTempTable(rpt.getString("tempTable"));
                RptTableHeader header = (RptTableHeader)rpt.getObject("header");
                KDTableUtil.setHeader((RptTableHeader)header, (KDTable)this.tblMain);
            }
            para.setString("tempTable", this.getTempTable());
            rpt = this.getRemoteInstance().query(para, from, len);
            if (from == 0) {
                this.tblMain.setRowCount(rpt.getInt("totalCount"));
            }
            RptRowSet rs = (RptRowSet)rpt.getObject("rowset");
            KDTableUtil.insertRows((RptRowSet)rs, (int)from, (KDTable)this.tblMain);
            if (this.tblMain.getColumn("itemValue") != null) {
                this.tblMain.getColumn("itemValue").getStyleAttributes().setNumberFormat("%{0.##########}f");
            }
            this.tblMain.getDataRequestManager().addDataRequestListener((KDTDataRequestListener)this);
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    protected ICommRptBase getRemoteInstance() throws BOSException {
        return TaxItemDataAnalysisFacadeFactory.getRemoteInstance();
    }

    protected KDTable getTableForPrintSetting() {
        return this.tblMain;
    }

    protected RptParams getParamsForInit() {
        return null;
    }

    protected CommRptBaseConditionUI getQueryDialogUserPanel() throws Exception {
        TaxItemDataAnalysisConditionUI conditionUI = new TaxItemDataAnalysisConditionUI();
        return conditionUI;
    }

    protected void query() {
        this.tblMain.removeColumns();
        this.tblMain.removeRows();
    }

    public void tbl_afterDataFill(KDTDataRequestEvent e) {
        int from = e.getFirstRow();
        int to = e.getLastRow();
        Object value = null;
        Object enumValue = null;
        for (int i = from; i <= to; ++i) {
            value = this.tblMain.getRow(i).getCell(TBL_RECORDTYPE).getValue();
            enumValue = RecordTypeEnum.getEnum(Integer.parseInt(value.toString()));
            if (enumValue != null) {
                this.tblMain.getRow(i).getCell(TBL_RECORDTYPE).setValue((Object)enumValue.getAlias());
            }
            if ((enumValue = DraftRecordTypeEnum.getEnum((value = this.tblMain.getRow(i).getCell(TBL_SUBRECORDTYPE).getValue()).toString())) != null) {
                this.tblMain.getRow(i).getCell(TBL_SUBRECORDTYPE).setValue((Object)enumValue.getAlias());
            }
            if ((enumValue = TaxValueTypeEnum.getEnum((value = this.tblMain.getRow(i).getCell(TBL_VALUETYPE).getValue()).toString())) == null) continue;
            this.tblMain.getRow(i).getCell(TBL_VALUETYPE).setValue((Object)enumValue.getAlias());
        }
    }
}

