/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.structure.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.core.ICellDisplayProvider;
import com.kingdee.bos.ctrl.excel.core.KDSpread;
import com.kingdee.bos.ctrl.excel.model.expr.IErrorProvider;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.fi.newrpt.client.designer.SpreadManager;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.fi.newrpt.formula.ReportCalculateContext;
import com.kingdee.eas.fi.newrpt.formula.define.FormulaDefinition;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.fi.rpt.util.BookProperties;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.tm.td.RecordTypeEnum;
import com.kingdee.eas.tm.td.TaxDraftRecordInfo;
import com.kingdee.eas.tm.td.basedata.ITaxItemType;
import com.kingdee.eas.tm.td.basedata.TaxItemTypeCollection;
import com.kingdee.eas.tm.td.basedata.TaxItemTypeFactory;
import com.kingdee.eas.tm.td.basedata.TaxItemTypeInfo;
import com.kingdee.eas.tm.td.est.IRealEstateGroup;
import com.kingdee.eas.tm.td.est.RealEstateGroupCollection;
import com.kingdee.eas.tm.td.est.RealEstateGroupFactory;
import com.kingdee.eas.tm.td.est.RealEstateGroupInfo;
import com.kingdee.eas.tm.td.structure.DetailItemDataEntryCollection;
import com.kingdee.eas.tm.td.structure.DetailItemDataEntryInfo;
import com.kingdee.eas.tm.td.structure.DetailItemDataInfo;
import com.kingdee.eas.tm.td.structure.ITaxReportItem;
import com.kingdee.eas.tm.td.structure.ITaxReportSheet;
import com.kingdee.eas.tm.td.structure.TaxReportItemCollection;
import com.kingdee.eas.tm.td.structure.TaxReportItemFactory;
import com.kingdee.eas.tm.td.structure.TaxReportItemInfo;
import com.kingdee.eas.tm.td.structure.TaxReportSheetCollection;
import com.kingdee.eas.tm.td.structure.TaxReportSheetFactory;
import com.kingdee.eas.tm.td.structure.TaxReportSheetInfo;
import com.kingdee.eas.tm.td.structure.TaxValueTypeEnum;
import com.kingdee.eas.tm.td.structure.utils.ItemLayoutEntryParams;
import com.kingdee.eas.tm.td.structure.utils.ItemLayoutParams;
import com.kingdee.eas.tm.td.structure.utils.StructureUIHelper;
import com.kingdee.eas.tm.td.structure.utils.TaxItemFormula;
import com.kingdee.eas.tm.td.utils.TaxDraftRptPropertyAdapter;
import com.kingdee.util.StringUtils;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class StructureUtils {
    private static final int SPACE_32 = 32;
    private static final int SPACE_12288 = 12288;
    private static final int SPACE_160 = 160;
    private static final int SPACE_8194 = 8194;
    private static final int SPACE_8195 = 8195;
    private static final int SPACE_8197 = 8197;
    private static final int SPACE_8201 = 8201;

    public static void setTaxTypeFilter(KDBizPromptBox bizBox) {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("sign", (Object)"1", CompareType.EQUALS));
        ev.setFilter(filter);
        bizBox.setEntityViewInfo(ev);
    }

    public static void autoSetColWidth(SpreadManager spreadManager, Sheet sheet, int row, int col) {
        int w;
        if (spreadManager == null) {
            return;
        }
        KDSpread spread = spreadManager.getSpreadContainer().getSpread();
        Graphics2D g2d = (Graphics2D)spread.getGraphics();
        if (g2d == null) {
            return;
        }
        Cell cell = sheet.getCell(row, col, false);
        int width = sheet.getColRange(col, col).getColumnWidth();
        FontMetrics fm = g2d.getFontMetrics((Font)cell.getStyle().getKDFont());
        ICellDisplayProvider cvp = spread.getCellDisplayProvider();
        Object value = cvp.getBaseValue(cell, spread.getBook().getActiveSheet().getSheetOption().getCellDisplayMode());
        if (value instanceof String && ((w = fm.stringWidth((String)value)) > width || width - w < 12)) {
            width = w + 12;
        }
        if (width > 0) {
            sheet.getColRange(col, col).setColumnWidth(width + 8);
        }
    }

    public static Book prepareBook(Context ctx, TaxDraftRecordInfo recordInfo) throws Exception {
        Book book = null;
        book = recordInfo.getData() != null ? recordInfo.getBook() : Book.Manager.getNewBook((String)"Sheet1", (int)3);
        book.setCalculate(false);
        BookProperties p = BookProperties.loadFromBook((Book)book);
        TaxDraftRptPropertyAdapter adapter = new TaxDraftRptPropertyAdapter();
        adapter.initReportProperties((IObjectValue)recordInfo, ctx);
        FormulaDefinition.registerFormulaToBook((Book)book, (ICalculateContextProvider)new ReportCalculateContext(ctx, (IReportPropertyAdapter)adapter, p.getVariables(), (IErrorProvider)p.getErrorProvider(), null));
        return book;
    }

    public static Map getItemformulaByBook(Book book) {
        ArrayList<Sheet> sheetList = new ArrayList<Sheet>();
        for (int i = 0; i < book.getSheetCount(); ++i) {
            sheetList.add(book.getSheet(i));
        }
        Sheet sheet = null;
        HashMap itemData = new HashMap();
        for (int i = 0; i < sheetList.size(); ++i) {
            sheet = (Sheet)sheetList.get(i);
            StructureUtils.getItemFormulaBySheet(sheet, itemData);
        }
        return itemData;
    }

    public static void getItemFormulaBySheet(Sheet sheet, Map data) {
        int row = sheet.getRows().getMaxIntMark() + 1;
        int col = sheet.getCols().getMaxIntMark() + 1;
        Sheet.ICellsIterator iter = sheet.getCellsIterator(0, 0, row, col, true, true);
        while (iter.hasNext()) {
            Cell cell = iter.next();
            Range range = sheet.getRange(cell);
            TaxItemFormula f = (TaxItemFormula)range.getUserObject("TAXITEM");
            if (f == null || f.getFormula() == null) continue;
            f.setSheet(sheet);
            f.setCell(cell);
            StringBuffer key = new StringBuffer();
            key.append(f.getReportSheet()).append("_");
            key.append(f.getRowItem()).append("_");
            key.append(f.getColumnItem());
            data.put(key.toString(), f);
        }
    }

    public static void scanItemFormulaDataBySheet(Context ctx, TaxDraftRecordInfo report, Sheet sheet, Map mapI, CoreBaseCollection dItems) throws BOSException {
        int row = sheet.getRows().getMaxIntMark() + 1;
        int col = sheet.getCols().getMaxIntMark() + 1;
        Sheet.ICellsIterator iter = sheet.getCellsIterator(0, 0, row, col, false, true);
        DetailItemDataInfo dItem = null;
        while (iter.hasNext()) {
            Cell cell = iter.next();
            StructureUtils.parseItemData(sheet, cell, mapI);
            if (dItems == null || (dItem = StructureUtils.parseDItemData(ctx, report, sheet, cell)) == null || dItem.getEntries().size() <= 0) continue;
            dItems.add((CoreBaseInfo)dItem);
        }
    }

    private static DetailItemDataInfo parseDItemData(Context ctx, TaxDraftRecordInfo report, Sheet sheet, Cell cell) throws BOSException {
        DetailItemDataInfo info = null;
        ItemLayoutParams itemParams = StructureUIHelper.getParametersFromCell(sheet, cell.getRow(), cell.getCol());
        if (itemParams != null) {
            info = StructureUtils.parseDetailItemData(ctx, report, sheet, cell, itemParams);
        }
        return info;
    }

    private static DetailItemDataInfo parseDetailItemData(Context ctx, TaxDraftRecordInfo report, Sheet sheet, Cell cell, ItemLayoutParams itemParams) throws BOSException {
        DetailItemDataInfo info = new DetailItemDataInfo();
        TaxReportSheetInfo sheetInfo = new TaxReportSheetInfo();
        sheetInfo.setId(BOSUuid.read((String)itemParams.getSheetID()));
        info.setReport(report);
        info.setSheet(sheetInfo);
        info.setRow(cell.getRow());
        info.setCol(cell.getCol());
        info.setHeadSize(itemParams.getEntry().size());
        info.setNumber(itemParams.getNumber());
        DetailItemDataEntryCollection entryColl = new DetailItemDataEntryCollection();
        DetailItemDataEntryInfo entry = null;
        ItemLayoutEntryParams entryParams = null;
        int baseRow = cell.getRow();
        int baseCol = cell.getCol();
        int rowCount = itemParams.getRowCounter();
        List<ItemLayoutEntryParams> entryParamsList = itemParams.getEntry();
        Cell tempCell = null;
        CellBlock cellBlock = null;
        int spanRow = 0;
        int spanColumn = 0;
        int count = 0;
        boolean isVolidRow = true;
        for (int j = 0; j < rowCount; ++j) {
            spanColumn = 0;
            int headsize = entryParamsList.size();
            for (int i = 0; i < headsize; ++i) {
                Object cellValue;
                entryParams = entryParamsList.get(i);
                entry = new DetailItemDataEntryInfo();
                entry.setParent(info);
                entry.setValueType(entryParams.getDataType());
                entry.setRow(j);
                entry.setCol(i);
                entry.setColumnItem(StructureUtils.getTaxReportItemByNumber(ctx, entryParams.getNumber()));
                tempCell = sheet.getCell(baseRow + j + spanRow, baseCol + i + spanColumn, false);
                if (tempCell == null) continue;
                cellBlock = sheet.getMergeBlock(baseRow + j + spanRow, baseCol + i + spanColumn);
                if (cellBlock != null) {
                    spanColumn += cellBlock.getWidth() - 1;
                }
                if ((cellValue = StructureUtils.getCellValue(sheet, tempCell, entryParams.getDataType())) == null) {
                    if (i != 0) continue;
                    isVolidRow = false;
                    break;
                }
                if (TaxValueTypeEnum.TXT.equals((Object)entryParams.getDataType())) {
                    entry.setTextValue(cellValue.toString());
                } else {
                    entry.setValue((BigDecimal)cellValue);
                }
                entryColl.add(entry);
            }
            if (isVolidRow) {
                ++count;
            }
            if (cellBlock == null) continue;
            spanRow += cellBlock.getHeight() - 1;
        }
        info.setRowCount(count);
        info.getEntries().addCollection(entryColl);
        return info;
    }

    private static Object getCellValue(Sheet sheet, Cell cell, TaxValueTypeEnum valueType) {
        Range range = sheet.getRange(cell);
        Variant var = range.getValue();
        Object cellValue = var.isEmpty() ? null : var.getValue();
        Object value = null;
        if (cellValue != null && !cellValue.toString().equals("")) {
            if ("TXT".equals(valueType.getValue())) {
                value = range.getText();
            } else if (var.isNumeric()) {
                try {
                    value = var.toBigDecimal();
                }
                catch (SyntaxErrorException e) {
                    value = null;
                }
            } else {
                value = null;
            }
        }
        return value;
    }

    private static void parseItemData(Sheet sheet, Cell cell, Map mapI) {
        block11: {
            Range range = sheet.getRange(cell);
            TaxItemFormula f = (TaxItemFormula)range.getUserObject("TAXITEM");
            if (f == null || f.getFormula() == null) {
                return;
            }
            String sheetID = null;
            Map detailMap = null;
            f.setSheet(sheet);
            f.setCell(cell);
            sheetID = f.getReportSheet();
            if (!mapI.containsKey(sheetID)) {
                mapI.put(sheetID, new HashMap());
            }
            detailMap = (Map)mapI.get(sheetID);
            StringBuffer key = new StringBuffer();
            key.append(f.getReportSheet()).append("_");
            key.append(f.getRowItem()).append("_");
            key.append(f.getColumnItem()).append("_");
            key.append(f.getValueType());
            String ks = key.toString();
            Variant var = range.getValue();
            Object cellValue = var.isEmpty() ? null : var.getValue();
            boolean moneyOrQtyIsEmpty = false;
            if (("MONEY".equals(f.getValueType()) || "QUANTITY".equals(f.getValueType())) && cellValue == null) {
                moneyOrQtyIsEmpty = true;
            }
            if (cellValue != null && !cellValue.toString().equals("") || moneyOrQtyIsEmpty) {
                Object value = null;
                if ("TXT".equals(f.getValueType())) {
                    value = range.getText();
                    f.setValue(value);
                    detailMap.put(ks, f);
                } else if (moneyOrQtyIsEmpty || var.isNumeric()) {
                    try {
                        if (moneyOrQtyIsEmpty) {
                            value = BigDecimal.ZERO;
                            f.setValue(value);
                            detailMap.put(ks, f);
                            break block11;
                        }
                        value = var.toBigDecimal();
                        f.setValue(value);
                        detailMap.put(ks, f);
                    }
                    catch (SyntaxErrorException e) {
                        value = range.getText();
                    }
                } else {
                    value = range.getText();
                }
            }
        }
    }

    public static String getCellLocation(Sheet sheet, Cell cell) {
        StringBuffer sb = new StringBuffer();
        sb.append(sheet.getSyntaxName()).append('!');
        int top = cell.getRow();
        int left = cell.getCol();
        top = top < 0 ? 0 : top;
        left = left < 0 ? 0 : left;
        sb.append(TableToolkit.xy2range((int)left, (int)top));
        return sb.toString();
    }

    public static String getCellLocation(Sheet sheet, Range range) {
        StringBuffer sb = new StringBuffer();
        sb.append(sheet.getSyntaxName()).append('!');
        int top = range.getBounds().getRow();
        int left = range.getBounds().getCol();
        top = top < 0 ? 0 : top;
        left = left < 0 ? 0 : left;
        sb.append(TableToolkit.xy2range((int)left, (int)top));
        return sb.toString();
    }

    public static String constructFormula(TaxReportSheetInfo sheetInfo, TaxReportItemInfo rowData, TaxReportItemInfo columnData, TaxValueTypeEnum valueType) {
        StringBuffer strBuffer = new StringBuffer();
        strBuffer.append("=TaxItem(");
        strBuffer.append("\"" + sheetInfo.getNumber() + "\",");
        strBuffer.append("\"" + rowData.getNumber() + "\",");
        strBuffer.append("\"" + columnData.getNumber() + "\",");
        strBuffer.append("\"" + valueType.getValue() + "\"");
        strBuffer.append(")");
        return strBuffer.toString();
    }

    public static TaxReportSheetInfo getTaxReportSheetByNumber(Context ctx, String number) throws BOSException {
        if (StringUtils.isEmpty((String)number)) {
            return null;
        }
        TaxReportSheetInfo info = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
        view.setFilter(filter);
        ITaxReportSheet iTaxReportSheet = null;
        iTaxReportSheet = ctx == null ? TaxReportSheetFactory.getRemoteInstance() : TaxReportSheetFactory.getLocalInstance(ctx);
        TaxReportSheetCollection coll = iTaxReportSheet.getTaxReportSheetCollection(view);
        if (coll.size() > 0) {
            info = coll.get(0);
        }
        return info;
    }

    public static TaxReportSheetInfo getTaxReportSheetByNumber(Context ctx, Set numbers, TaxItemTypeInfo taxType, RecordTypeEnum recordType) throws BOSException {
        TaxReportSheetInfo info = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)numbers, CompareType.INCLUDE));
        if (taxType != null) {
            filter.getFilterItems().add(new FilterItemInfo("taxType.id", (Object)taxType.getId().toString(), CompareType.EQUALS));
        }
        if (recordType != null) {
            filter.getFilterItems().add(new FilterItemInfo("recordType", (Object)recordType.getValue(), CompareType.EQUALS));
        }
        view.setFilter(filter);
        ITaxReportSheet iTaxReportSheet = null;
        iTaxReportSheet = ctx == null ? TaxReportSheetFactory.getRemoteInstance() : TaxReportSheetFactory.getLocalInstance(ctx);
        TaxReportSheetCollection coll = iTaxReportSheet.getTaxReportSheetCollection(view);
        if (coll.size() > 0) {
            info = coll.get(0);
        }
        return info;
    }

    public static TaxReportItemInfo getTaxReportItemByNumber(Context ctx, String number) throws BOSException {
        if (StringUtils.isEmpty((String)number)) {
            return null;
        }
        TaxReportItemInfo info = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
        view.setFilter(filter);
        ITaxReportItem iTaxReportItem = null;
        iTaxReportItem = ctx == null ? TaxReportItemFactory.getRemoteInstance() : TaxReportItemFactory.getLocalInstance(ctx);
        TaxReportItemCollection coll = iTaxReportItem.getTaxReportItemCollection(view);
        if (coll.size() > 0) {
            info = coll.get(0);
        }
        return info;
    }

    public static RealEstateGroupInfo getBuildingTaxesGroupNumberByNumber(Context ctx, String number) throws BOSException {
        if (StringUtils.isEmpty((String)number)) {
            return null;
        }
        RealEstateGroupInfo info = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
        view.setFilter(filter);
        IRealEstateGroup iRealEstateGroup = null;
        iRealEstateGroup = ctx == null ? RealEstateGroupFactory.getRemoteInstance() : RealEstateGroupFactory.getLocalInstance(ctx);
        RealEstateGroupCollection coll = iRealEstateGroup.getRealEstateGroupCollection(view);
        if (coll.size() > 0) {
            info = coll.get(0);
        }
        return info;
    }

    public static TaxItemTypeInfo getTaxItemTypeByNumber(Context ctx, String number) throws BOSException {
        if (StringUtils.isEmpty((String)number)) {
            return null;
        }
        TaxItemTypeInfo info = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
        view.setFilter(filter);
        ITaxItemType iTaxItemType = null;
        iTaxItemType = ctx == null ? TaxItemTypeFactory.getRemoteInstance() : TaxItemTypeFactory.getLocalInstance(ctx);
        TaxItemTypeCollection coll = iTaxItemType.getTaxItemTypeCollection(view);
        if (coll.size() > 0) {
            info = coll.get(0);
        }
        return info;
    }

    public static CompanyOrgUnitInfo getCompanyByNumber(Context ctx, String number) throws BOSException {
        if (StringUtils.isEmpty((String)number)) {
            return null;
        }
        CompanyOrgUnitInfo info = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
        view.setFilter(filter);
        ICompanyOrgUnit iCompanyOrgUnit = null;
        iCompanyOrgUnit = ctx == null ? CompanyOrgUnitFactory.getRemoteInstance() : CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        CompanyOrgUnitCollection coll = iCompanyOrgUnit.getCompanyOrgUnitCollection(view);
        if (coll.size() > 0) {
            info = coll.get(0);
        }
        return info;
    }

    public static String getFixSequenceNumber(int seq, int fix) {
        StringBuffer seqStr = new StringBuffer(seq + "");
        int strLen = seqStr.length();
        if (strLen < fix) {
            for (int i = 0; i < fix - strLen; ++i) {
                seqStr.insert(0, "0");
            }
            return seqStr.toString();
        }
        return seqStr.substring(0, fix);
    }

    public static String trim(String str) {
        int st;
        if (StringUtils.isEmpty((String)str)) {
            return str;
        }
        char[] val = str.toCharArray();
        int len = val.length;
        for (st = 0; st < len && StructureUtils.isSpace(val[st]); ++st) {
        }
        while (st < len && StructureUtils.isSpace(val[len - 1])) {
            --len;
        }
        return st > 0 || len < val.length ? str.substring(st, len) : str;
    }

    public static boolean isSpace(char aChar) {
        return aChar == ' ' || aChar == '\u3000' || aChar == '\u00a0' || aChar == '\u2002' || aChar == '\u2003' || aChar == '\u2005' || aChar == '\u2009';
    }

    public static IRow[] getTableSelection(KDTable tbl) {
        ArrayList blocks = tbl.getSelectManager().getBlocks();
        ArrayList<IRow> rows = new ArrayList<IRow>();
        for (int i = 0; i < blocks.size(); ++i) {
            KDTSelectBlock block = (KDTSelectBlock)blocks.get(i);
            if (block.getMode() == 8) {
                for (int j = 0; j < tbl.getRowCount(); ++j) {
                    rows.add(tbl.getRow(j));
                }
                break;
            }
            int smallLine = block.getBeginRow() < block.getEndRow() ? block.getBeginRow() : block.getEndRow();
            int bigLine = block.getBeginRow() > block.getEndRow() ? block.getBeginRow() : block.getEndRow();
            for (int row = smallLine; row <= bigLine; ++row) {
                rows.add(tbl.getRow(row));
            }
        }
        return rows.toArray(new IRow[rows.size()]);
    }

    public static List getF7Value(Object value) {
        ArrayList<String> ids;
        block6: {
            block5: {
                ids = new ArrayList<String>();
                if (!(value instanceof CoreBaseInfo)) break block5;
                CoreBaseInfo info = (CoreBaseInfo)value;
                if (info == null) break block6;
                ids.add(info.getId().toString());
                break block6;
            }
            if (value instanceof List) {
                List list = (List)value;
                CoreBaseInfo info2 = null;
                for (CoreBaseInfo info2 : list) {
                    if (info2 == null) continue;
                    ids.add(info2.getId().toString());
                }
            } else if (value instanceof Object[]) {
                Object[] objs = (Object[])value;
                CoreBaseInfo info = null;
                for (int i = 0; i < objs.length; ++i) {
                    info = (CoreBaseInfo)objs[i];
                    if (info == null) continue;
                    ids.add(info.getId().toString());
                }
            }
        }
        return ids;
    }

    public static String getPeriodNumber(String year, String month) {
        String periodNumber = null;
        periodNumber = month.length() == 1 ? year + "0" + month : year + month;
        return periodNumber;
    }
}

