/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.taxes.ert.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.tm.td.DraftStatusEnum;
import com.kingdee.eas.tm.td.ITaxDraftRecord;
import com.kingdee.eas.tm.td.OwnerMenuEnum;
import com.kingdee.eas.tm.td.RecordTypeEnum;
import com.kingdee.eas.tm.td.TaxDraftRecordCollection;
import com.kingdee.eas.tm.td.TaxDraftRecordFactory;
import com.kingdee.eas.tm.td.TaxDraftRecordInfo;
import com.kingdee.eas.tm.td.basedata.AccountTypeFactory;
import com.kingdee.eas.tm.td.basedata.AccountTypeInfo;
import com.kingdee.eas.tm.td.basedata.TaxItemTypeFactory;
import com.kingdee.eas.tm.td.basedata.TaxItemTypeInfo;
import com.kingdee.eas.tm.td.est.RealEstateGroupInfo;
import com.kingdee.eas.tm.td.structure.TaxReportTemplateFactory;
import com.kingdee.eas.tm.td.structure.TaxReportTemplateInfo;
import com.kingdee.eas.tm.td.taxes.ert.client.AbstractErtTaxDeclareTaxDraftEditUI;
import com.kingdee.eas.tm.td.taxes.ert.client.ErtTaxDeclareTaxDraftRptUI;
import com.kingdee.eas.tm.td.utils.TDPermissionUtil;
import com.kingdee.eas.tm.td.utils.TDSelectorFactory;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public class ErtTaxDeclareTaxDraftEditUI
extends AbstractErtTaxDeclareTaxDraftEditUI {
    private static final Logger logger = CoreUIObject.getLogger(ErtTaxDeclareTaxDraftEditUI.class);
    private TaxItemTypeInfo taxType = null;
    private AccountTypeInfo accountType = null;
    private DataChangeListener btGroupListener = null;

    @Override
    public void loadFields() {
        this.removeListener();
        super.loadFields();
        this.addListener();
        this.initControl();
    }

    @Override
    protected void addListener() {
        super.addListener();
        if (this.btGroupListener == null) {
            this.btGroupListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent e) {
                    ErtTaxDeclareTaxDraftEditUI.this.btGroupChange(e);
                }
            };
        }
        this.prmtBuildingTaxesGroup.addDataChangeListener(this.btGroupListener);
    }

    @Override
    protected void removeListener() {
        super.removeListener();
        this.prmtBuildingTaxesGroup.removeDataChangeListener(this.btGroupListener);
    }

    @Override
    protected String getTaxDraftRptUI() {
        return ErtTaxDeclareTaxDraftRptUI.class.getName();
    }

    @Override
    public SelectorItemCollection getSelectors() {
        return TDSelectorFactory.getTaxDraftRecordSelectors();
    }

    @Override
    protected AccountTypeInfo getAccountTypeInfo() throws Exception {
        if (this.accountType == null) {
            try {
                this.accountType = AccountTypeFactory.getRemoteInstance().getAccountTypeInfo((IObjectPK)new ObjectUuidPK("nJREYCMKQxixsNoL09ZUjT2YoPU="));
            }
            catch (Exception e) {
                return null;
            }
        }
        return this.accountType;
    }

    @Override
    protected String getPermissionItem(String actionType) {
        return TDPermissionUtil.getTaxDraftPermissionItem(actionType, "ert", "taxdeclare");
    }

    @Override
    protected TaxItemTypeInfo getTaxTypeInfo() throws Exception {
        if (this.taxType == null) {
            try {
                this.taxType = TaxItemTypeFactory.getRemoteInstance().getTaxItemTypeInfo((IObjectPK)new ObjectUuidPK("ZCyrvv6oAnPgU0ETqMCc49uK96Y="));
            }
            catch (Exception e) {
                return null;
            }
        }
        return this.taxType;
    }

    @Override
    protected RecordTypeEnum getRecordType() {
        return RecordTypeEnum.TaxDeclare;
    }

    @Override
    protected OwnerMenuEnum getOwnerMenu() {
        return OwnerMenuEnum.ErtTaxDeclareTaxDraft;
    }

    @Override
    public void dataChanged(DataChangeEvent e) {
        if (!e.getSource().equals(this.prmtCompanyOrgUnit)) {
            return;
        }
        if (e.getNewValue() != null && this.isEqual(e.getNewValue(), e.getOldValue())) {
            return;
        }
        try {
            this.setPrmtRelateAccountFilter();
        }
        catch (Exception e3) {
            this.handleException(e3);
        }
        if (this.copyRecordInfo == null || this.prmtCompanyOrgUnit.getValue() == null) {
            return;
        }
        TaxDraftRecordInfo tempInfo = (TaxDraftRecordInfo)this.copyRecordInfo.clone();
        this.number.setText("");
        StringBuffer numbersb = new StringBuffer();
        boolean isMutiOrg = false;
        Object[] orgUnitObj = this.getOrgUnitObj();
        if (orgUnitObj != null && orgUnitObj.length > 1) {
            isMutiOrg = true;
        }
        this.prmtRelateNextAccount.setValue(null);
        if (isMutiOrg) {
            this.prmtRelateNextAccount.setEnabled(false);
        } else {
            this.prmtRelateNextAccount.setEnabled(true);
            try {
                this.setPrmtRelateRecordAccountFilter();
            }
            catch (Exception e1) {
                this.handleException(e1);
            }
        }
        if (isMutiOrg) {
            this.prmtBuildingTaxesGroup.setEnabled(false);
            this.prmtBuildingTaxesGroup.setValue(null);
        } else {
            this.prmtBuildingTaxesGroup.setEnabled(true);
            this.prmtBuildingTaxesGroup.setValue(null);
        }
        for (int i = 0; i < orgUnitObj.length; ++i) {
            CompanyOrgUnitInfo companyOrgUnit = (CompanyOrgUnitInfo)orgUnitObj[i];
            tempInfo.setCompanyOrgUnit(companyOrgUnit);
            String newNumber = "";
            try {
                newNumber = this.getNewNumberByUnit(tempInfo, companyOrgUnit.getId().toString());
                numbersb.append(newNumber).append(";");
                continue;
            }
            catch (EASBizException e1) {
                logger.error((Object)e1.getMessage());
                continue;
            }
            catch (BOSException e2) {
                logger.error((Object)e2.getMessage());
            }
        }
        this.number.setText(numbersb.toString());
        this.initNumber();
    }

    protected void btGroupChange(DataChangeEvent e) {
        if (this.copyRecordInfo == null) {
            return;
        }
        StringBuffer numbersb = new StringBuffer();
        TaxDraftRecordInfo tempInfo = (TaxDraftRecordInfo)this.copyRecordInfo.clone();
        try {
            Object[] orgUnitObj = this.getOrgUnitObj();
            CompanyOrgUnitInfo companyOrgUnit = (CompanyOrgUnitInfo)orgUnitObj[0];
            tempInfo.setCompanyOrgUnit(companyOrgUnit);
            Object[] btGroupObj = this.getBtGroupObj();
            if (btGroupObj != null) {
                for (int j = 0; j < btGroupObj.length; ++j) {
                    tempInfo.setBuildingTaxesGroup((RealEstateGroupInfo)btGroupObj[j]);
                    String newNumber = "";
                    newNumber = this.getNewNumberByUnit(tempInfo, companyOrgUnit.getId().toString());
                    numbersb.append(newNumber).append(";");
                }
            } else {
                String newNumber = "";
                newNumber = this.getNewNumberByUnit(tempInfo, companyOrgUnit.getId().toString());
                numbersb.append(newNumber).append(";");
            }
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
        this.number.setText(numbersb.toString());
        this.initNumber();
    }

    @Override
    protected void checkBeforeSaveOrSubmit(boolean isSubmit, boolean isCopy) throws Exception {
        String nameStr;
        String numberStr;
        if (this.prmtCompanyOrgUnit.getValue() == null) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.tm.td.TaxDraftResource", (String)"companyNoNull"));
            SysUtil.abort();
        }
        if ((numberStr = this.number.getText()) == null || StringUtils.isEmpty((String)numberStr)) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.tm.td.TaxDraftResource", (String)"NumberBlank"));
            SysUtil.abort();
        }
        if (isCopy) {
            String[] numStr = numberStr.split(";");
            Object[] orgUnitObj = this.getOrgUnitObj();
            Object[] btGroupObj = this.getBtGroupObj();
            if (orgUnitObj.length > 1 && numStr.length != orgUnitObj.length) {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.tm.td.TaxDraftResource", (String)"NotEnoughNumber"));
                SysUtil.abort();
            } else if (btGroupObj.length > 1 && numStr.length != btGroupObj.length) {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.tm.td.TaxDraftResource", (String)"NotEnoughNumber"));
                SysUtil.abort();
            }
        }
        if ((nameStr = this.name.getText()) == null || StringUtils.isEmpty((String)nameStr)) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.tm.td.TaxDraftResource", (String)"NAME_NOT_NULL"));
            SysUtil.abort();
        }
        if (this.prmtPeriod.getValue() == null) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.tm.td.TaxDraftResource", (String)"PERIOD_NOT_NULL"));
            SysUtil.abort();
        }
        if (this.startDate.getValue() == null) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.tm.td.TaxDraftResource", (String)"beginDateNoNull"));
            SysUtil.abort();
        }
        if (this.endDate.getValue() == null) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.tm.td.TaxDraftResource", (String)"endDateNoNull"));
            SysUtil.abort();
        }
        if (RecordTypeEnum.Account.equals((Object)this.getRecordType()) && this.prmtRelateAccount.getValue() == null) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.tm.td.TaxDraftResource", (String)"ACCOUNT_NOT_NULL"));
            SysUtil.abort();
        }
        if (RecordTypeEnum.TaxDeclare.equals((Object)this.getRecordType()) && this.prmtBuildingTaxesGroup.getValue() == null) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.tm.td.TaxDraftResource", (String)"buildingTaxesGroupNotNull"));
            SysUtil.abort();
        }
        ITaxDraftRecord iFactory = (ITaxDraftRecord)this.getBizInterface();
        iFactory.checkNumberDup((IObjectValue)this.editData);
    }

    @Override
    protected IObjectPK doSaveOrSubmit(ActionEvent e, boolean isSubmit, boolean isCopy) throws Exception {
        IObjectPK pk = null;
        String[] numStr = null;
        if (isCopy) {
            numStr = this.number.getText().split(";");
        }
        TaxDraftRecordInfo recordInfo = null;
        CompanyOrgUnitInfo unitInfo = null;
        RealEstateGroupInfo btGroupInfo = null;
        int errorCount = 0;
        StringBuffer errorDetail = new StringBuffer();
        Object[] orgUnitObj = this.getOrgUnitObj();
        Object[] btGroupObj = this.getBtGroupObj();
        int orgLength = orgUnitObj.length;
        int btGLength = btGroupObj.length;
        TaxDraftRecordCollection recordColl = new TaxDraftRecordCollection();
        for (int i = 0; i < orgLength; ++i) {
            for (int j = 0; j < btGLength; ++j) {
                unitInfo = (CompanyOrgUnitInfo)orgUnitObj[i];
                btGroupInfo = (RealEstateGroupInfo)btGroupObj[j];
                if (isCopy) {
                    recordInfo = (TaxDraftRecordInfo)this.editData.clone();
                    recordInfo.setId(BOSUuid.create((BOSObjectType)recordInfo.getBOSType()));
                    recordInfo.setCompanyOrgUnit(unitInfo);
                    recordInfo.setBuildingTaxesGroup(btGroupInfo);
                    recordInfo.setNumber(numStr[i + j]);
                    recordInfo.setDraftStatus(DraftStatusEnum.SAVE);
                } else {
                    recordInfo = this.editData;
                }
                recordColl.add(recordInfo);
            }
        }
        TaxReportTemplateInfo templetReportInfo = (TaxReportTemplateInfo)this.prmtTempletReport.getValue();
        boolean isAddNew = false;
        if (this.getOprtState().equals(OprtState.ADDNEW) || this.getOprtState().equals(OprtState.COPYADDNEW)) {
            isAddNew = true;
        }
        if (isAddNew && templetReportInfo != null) {
            templetReportInfo = (TaxReportTemplateInfo)TaxReportTemplateFactory.getRemoteInstance().getValue((IObjectPK)new ObjectUuidPK(templetReportInfo.getId().toString()), TaxReportTemplateInfo.getSelectors());
        }
        for (int i = 0; i < recordColl.size(); ++i) {
            recordInfo = recordColl.get(i);
            if (isAddNew && templetReportInfo != null) {
                recordInfo.setData(templetReportInfo.getData());
            }
            try {
                if (isSubmit) {
                    this.checkPermission(recordInfo.getCompanyOrgUnit().getId().toString(), this.getPermissionItem("submit"));
                    pk = TaxDraftRecordFactory.getRemoteInstance().submit((CoreBaseInfo)recordInfo);
                    continue;
                }
                String actionType = null;
                actionType = this.getOprtState().equals(OprtState.ADDNEW) || this.getOprtState().equals(OprtState.COPYADDNEW) ? "add" : "edit";
                this.checkPermission(recordInfo.getCompanyOrgUnit().getId().toString(), this.getPermissionItem(actionType));
                pk = TaxDraftRecordFactory.getRemoteInstance().save((CoreBaseInfo)recordInfo);
                continue;
            }
            catch (Exception ex) {
                if (ex.getCause() != null) {
                    errorDetail.append(ex.getCause().getMessage()).append("\n");
                } else {
                    errorDetail.append(ex.getMessage()).append("\n");
                }
                ++errorCount;
            }
        }
        if (errorCount == 0) {
            this.getUIWindow().hide();
            if (isSubmit) {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.tm.td.TaxDraftResource", (String)"submitSuccess"));
            } else {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.tm.td.TaxDraftResource", (String)"saveSuccess"));
            }
        } else if (errorCount == orgLength * btGLength) {
            if (isSubmit) {
                MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.tm.td.TaxDraftResource", (String)"submitFailure"), (String)errorDetail.toString(), (int)0);
            } else {
                MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.tm.td.TaxDraftResource", (String)"saveFailure"), (String)errorDetail.toString(), (int)0);
            }
        } else {
            this.getUIWindow().hide();
            if (isSubmit) {
                MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.tm.td.TaxDraftResource", (String)"submitPartSuccess", (Object[])new Object[]{orgLength * btGLength - errorCount, errorCount}), (String)errorDetail.toString(), (int)0);
            } else {
                MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.tm.td.TaxDraftResource", (String)"savePartSuccess", (Object[])new Object[]{orgLength * btGLength - errorCount, errorCount}), (String)errorDetail.toString(), (int)0);
            }
        }
        return pk;
    }

    private Object[] getBtGroupObj() {
        Object[] btGroupObj = null;
        if (this.prmtBuildingTaxesGroup.getValue() instanceof RealEstateGroupInfo) {
            RealEstateGroupInfo btGroupInfo = (RealEstateGroupInfo)this.prmtBuildingTaxesGroup.getValue();
            btGroupObj = new RealEstateGroupInfo[]{btGroupInfo};
        } else {
            Object[] objectArray;
            if (this.prmtBuildingTaxesGroup.getValue() == null) {
                RealEstateGroupInfo[] realEstateGroupInfoArray = new RealEstateGroupInfo[1];
                objectArray = realEstateGroupInfoArray;
                realEstateGroupInfoArray[0] = null;
            } else {
                objectArray = (Object[])this.prmtBuildingTaxesGroup.getValue();
            }
            btGroupObj = objectArray;
        }
        return btGroupObj;
    }

    private Object[] getOrgUnitObj() {
        Object[] orgUnitObj = null;
        if (this.prmtCompanyOrgUnit.getValue() instanceof CompanyOrgUnitInfo) {
            CompanyOrgUnitInfo unitInfo = (CompanyOrgUnitInfo)this.prmtCompanyOrgUnit.getValue();
            orgUnitObj = new Object[]{unitInfo};
            this.prmtRelateNextAccount.setEnabled(true);
        } else {
            orgUnitObj = (Object[])this.prmtCompanyOrgUnit.getValue();
        }
        return orgUnitObj;
    }
}

