/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.codingrule.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSortManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.codingrule.CodingRuleEntryFactory;
import com.kingdee.eas.base.codingrule.CodingRuleEntryInfo;
import com.kingdee.eas.base.codingrule.IIntermilNO;
import com.kingdee.eas.base.codingrule.ISeqSegmentEntry;
import com.kingdee.eas.base.codingrule.IntermilNOCollection;
import com.kingdee.eas.base.codingrule.IntermilNOFactory;
import com.kingdee.eas.base.codingrule.IntermilNOInfo;
import com.kingdee.eas.base.codingrule.MaxSerialCollection;
import com.kingdee.eas.base.codingrule.MaxSerialFactory;
import com.kingdee.eas.base.codingrule.MaxSerialInfo;
import com.kingdee.eas.base.codingrule.SeqSegmentEntryCollection;
import com.kingdee.eas.base.codingrule.SeqSegmentEntryFactory;
import com.kingdee.eas.base.codingrule.client.AbstractCodingBreakPointListUI;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class CodingBreakPointListUI
extends AbstractCodingBreakPointListUI {
    private static final Logger logger = CoreUIObject.getLogger(CodingBreakPointListUI.class);
    private ArrayList sortItems = null;
    private Color[] color = new Color[]{Color.WHITE, new Color(217, 217, 208)};
    private Map intermitNoMap = new HashMap();
    private Map maxserialMap = new HashMap();
    private Map addDHs = new HashMap();
    private Map delDHs = new HashMap();
    private boolean isNeedSegment = false;
    private boolean isAllDisplay = false;
    private MaxSerialCollection maxCollection = null;
    private static final String splitSign = "_split_";

    public void onLoad() throws Exception {
        super.onLoad();
        this.initContext();
        this.initTable();
        this.menuItemCopy.setEnabled(false);
    }

    protected void loadData() throws Exception {
        this.setOprtState("ADDNEW");
        super.loadData();
    }

    @Override
    public void loadFields() {
        this.dataBinder.loadHeader();
        this.loadDetailData();
    }

    private void loadDetailData() {
    }

    private void initContext() {
        if (this.getUIContext().get("sortItems") != null) {
            this.sortItems = (ArrayList)this.getUIContext().get("sortItems");
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnRefresh.setEnabled(true);
        this.btnAddDH.setEnabled(true);
        this.btnDisplayAll.setEnabled(true);
        this.btnAddDH.setVisible(false);
        this.btnDisplayAll.setVisible(true);
        this.actionAddDH.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnAddDH.setToolTipText(EASResource.getString((String)"com.kingdee.eas.base.codingrule.CodingRuleResource.Msg_AddNewOrgLine"));
        this.actionDisplayAll.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_entirely"));
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
    }

    private void initTableHead() throws EASBizException, BOSException, Exception {
        IColumn col;
        while (this.kdtIntermilNOs.getRowCount() > 0) {
            this.kdtIntermilNOs.removeRow(0);
        }
        this.kdtIntermilNOs.removeHeadRows();
        this.kdtIntermilNOs.removeColumns();
        this.kdtIntermilNOs.setFormatXml("");
        IRow headRow = this.kdtIntermilNOs.addHeadRow();
        int index = 0;
        int segIndex = 0;
        if (this.editData.getId() != null && this.editData.getIntermilNOs().size() == 0) {
            this.editData = (CodingRuleEntryInfo)this.getBizInterface().getValue((IObjectPK)new ObjectUuidPK(this.editData.getId()));
        }
        if (this.isNeedSegment) {
            col = this.kdtIntermilNOs.addColumn();
            col.setKey("segment");
            headRow.getCell(index).setValue((Object)EASResource.getString((String)"com.kingdee.eas.base.codingrule.CODINGRULEAutoGenerateResource", (String)"47_CodingBreakPointListUI"));
            segIndex = 1;
        }
        while (index < this.sortItems.size()) {
            col = this.kdtIntermilNOs.addColumn();
            col.setKey("attr" + index);
            StringBuffer strSortItem = new StringBuffer(this.sortItems.get(index).toString());
            if (this.sortItems.size() > 1) {
                strSortItem.append(EASResource.getString((String)"com.kingdee.eas.base.codingrule.CODINGRULEAutoGenerateResource", (String)"48_CodingBreakPointListUI") + (index + 1) + ")");
            } else {
                strSortItem.append(EASResource.getString((String)"com.kingdee.eas.base.codingrule.CODINGRULEAutoGenerateResource", (String)"49_CodingBreakPointListUI"));
            }
            headRow.getCell(index + segIndex).setValue((Object)strSortItem);
            ++index;
        }
        IColumn maxCol = this.kdtIntermilNOs.addColumn();
        maxCol.setKey("maxNo");
        headRow.getCell(index++ + segIndex).setValue((Object)EASResource.getString((String)"com.kingdee.eas.base.codingrule.CODINGRULEAutoGenerateResource", (String)"50_CodingBreakPointListUI"));
        IColumn dhCol = this.kdtIntermilNOs.addColumn();
        dhCol.setKey("IntermitNo");
        dhCol.setWidth(200);
        headRow.getCell(index++ + segIndex).setValue((Object)EASResource.getString((String)"com.kingdee.eas.base.codingrule.CODINGRULEAutoGenerateResource", (String)"51_CodingBreakPointListUI"));
        IColumn adddhCol = this.kdtIntermilNOs.addColumn();
        adddhCol.setKey("AddNo");
        adddhCol.setWidth(150);
        headRow.getCell(index++ + segIndex).setValue((Object)EASResource.getString((String)"com.kingdee.eas.base.codingrule.CODINGRULEAutoGenerateResource", (String)"52_CodingBreakPointListUI"));
        IColumn deldhCol = this.kdtIntermilNOs.addColumn();
        deldhCol.setKey("DelNo");
        adddhCol.setWidth(150);
        headRow.getCell(index++ + segIndex).setValue((Object)EASResource.getString((String)"com.kingdee.eas.base.codingrule.CODINGRULEAutoGenerateResource", (String)"53_CodingBreakPointListUI"));
        IColumn sortItemCol = this.kdtIntermilNOs.addColumn();
        sortItemCol.setKey("sortItemValue");
        sortItemCol.getStyleAttributes().setHided(true);
        headRow.getCell(index++ + segIndex).setValue((Object)EASResource.getString((String)"com.kingdee.eas.base.codingrule.CODINGRULEAutoGenerateResource", (String)"54_CodingBreakPointListUI"));
        int iWidth = this.sortItems.size() * this.kdtIntermilNOs.getColumn(0).getWidth() + 770;
        iWidth = iWidth < 720 ? iWidth : 720;
        this.setBounds(new Rectangle(10, 10, iWidth, 400));
        this.kdtIntermilNOs.setBounds(new Rectangle(0, 0, iWidth, 400));
    }

    private boolean isNeedSegment() {
        MaxSerialInfo maxInfo = this.getMaxSerialCollection().get(0);
        return maxInfo != null && maxInfo.getSegmentAttrValue() != null && maxInfo.getSegmentAttrValue().trim().length() > 0;
    }

    private void initIntermitNos() {
        this.intermitNoMap.clear();
        this.maxserialMap.clear();
        IntermilNOCollection inc = this.getIntermitNumberCollection();
        Iterator it = inc.iterator();
        while (it.hasNext()) {
            IntermilNOInfo inInfo = (IntermilNOInfo)it.next();
            String sortItem = inInfo.getSortItemValue();
            if (sortItem == null) continue;
            if (this.intermitNoMap.get(sortItem) != null) {
                ((StringBuffer)this.intermitNoMap.get(sortItem)).append("," + inInfo.getSerialNumber());
                continue;
            }
            this.intermitNoMap.put(sortItem, new StringBuffer("" + inInfo.getSerialNumber()));
        }
        MaxSerialCollection mxc = this.getMaxSerialCollection();
        it = mxc.iterator();
        while (it.hasNext()) {
            MaxSerialInfo inInfo = (MaxSerialInfo)it.next();
            String sortItem = inInfo.getSortItemValue();
            if (sortItem == null) continue;
            if (inInfo.getSegmentAttrValue() != null && inInfo.getSegmentAttrValue().trim().length() > 0) {
                sortItem = sortItem + splitSign + inInfo.getSegmentAttrValue();
            }
            this.maxserialMap.put(sortItem, inInfo);
        }
    }

    private void initTableData() {
        this.initIntermitNos();
        Object[] keySet = this.maxserialMap.keySet().toArray();
        Arrays.sort(keySet, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                return arg0.toString().compareTo(arg1.toString());
            }
        });
        int keyIndex = 0;
        while (keyIndex < keySet.length) {
            String sortItem;
            String[] strSortItems;
            if ((strSortItems = (sortItem = (String)keySet[keyIndex++]).split(splitSign)) == null || strSortItems.length != this.sortItems.size() && !this.isNeedSegment || strSortItems.length != this.sortItems.size() + 1 && this.isNeedSegment || !this.isAllDisplay && this.intermitNoMap.get(sortItem) == null) continue;
            long maxSerialNumber = this.getMaxSerialNumber(sortItem);
            IRow row = this.kdtIntermilNOs.addRow();
            int segIndex = 0;
            if (this.isNeedSegment) {
                String segAttr = "";
                try {
                    int tmpIndex;
                    ISeqSegmentEntry ssEntry = SeqSegmentEntryFactory.getRemoteInstance();
                    EntityViewInfo eviTemp = new EntityViewInfo();
                    FilterInfo filterTemp = new FilterInfo();
                    filterTemp.getFilterItems().add(new FilterItemInfo("linkID", (Object)strSortItems[strSortItems.length - 1]));
                    eviTemp.setFilter(filterTemp);
                    eviTemp.getSorter().add(new SorterItemInfo("endNum"));
                    SeqSegmentEntryCollection ssCol = ssEntry.getSeqSegmentEntryCollection(eviTemp);
                    int n = tmpIndex = ssCol.size() > 0 ? ssCol.size() - 1 : 0;
                    if (ssCol.get(tmpIndex) != null) {
                        segAttr = ssCol.get(tmpIndex).getAttrValue();
                        if (maxSerialNumber == -1L) {
                            maxSerialNumber = ssCol.get(tmpIndex).getEndNum();
                            MaxSerialInfo tmpMaxInfo = new MaxSerialInfo();
                            tmpMaxInfo.setSerialNumber(maxSerialNumber);
                            this.maxserialMap.put(sortItem, tmpMaxInfo);
                        }
                    }
                }
                catch (BOSException bOSException) {
                    // empty catch block
                }
                row.getCell("segment").setValue((Object)segAttr);
                row.getCell("segment").getStyleAttributes().setLocked(true);
                row.getCell("segment").getStyleAttributes().setBackground(this.color[1]);
                segIndex = 0;
            }
            for (int iItem = 0; iItem < this.sortItems.size(); ++iItem) {
                if (iItem == 0 && strSortItems[iItem + segIndex].equalsIgnoreCase("codingrule_maxserial")) {
                    row.getCell("attr" + iItem).setValue((Object)EASResource.getString((String)"com.kingdee.eas.base.codingrule.CodingRuleResource.Msg_AllItems"));
                } else {
                    row.getCell("attr" + iItem).setValue((Object)strSortItems[iItem + segIndex]);
                }
                row.getCell("attr" + iItem).getStyleAttributes().setLocked(true);
                row.getCell("attr" + iItem).getStyleAttributes().setBackground(this.color[1]);
            }
            row.getCell("maxNo").setValue((Object)("" + maxSerialNumber));
            row.getCell("maxNo").getStyleAttributes().setLocked(true);
            row.getCell("maxNo").getStyleAttributes().setBackground(this.color[1]);
            row.getCell("IntermitNo").setValue(this.intermitNoMap.get(sortItem));
            row.getCell("IntermitNo").getStyleAttributes().setLocked(true);
            row.getCell("IntermitNo").getStyleAttributes().setBackground(this.color[1]);
            row.getCell("sortItemValue").setValue((Object)sortItem);
        }
        int rowCount = 0;
        for (rowCount = 0 - this.intermitNoMap.keySet().size(); rowCount > 0; --rowCount) {
            IRow row = this.kdtIntermilNOs.addRow();
            row.getStyleAttributes().setLocked(true);
        }
        KDTSortManager sm = new KDTSortManager(this.kdtIntermilNOs);
        sm.setSortAuto(true);
        for (int index = 0; index < this.kdtIntermilNOs.getColumnCount(); ++index) {
            this.kdtIntermilNOs.getColumn(index).setSortable(true);
        }
    }

    private void initTable() throws EASBizException, BOSException, Exception {
        if (this.sortItems == null) {
            return;
        }
        this.isNeedSegment = this.isNeedSegment();
        this.initTableHead();
        this.initTableData();
    }

    private String parseNums(String strNo, long maxNumber) {
        if (strNo == null) {
            return null;
        }
        Pattern p = Pattern.compile("[^0123456789]");
        String[] nums = p.split(strNo);
        StringBuffer retNums = new StringBuffer();
        for (int index = 0; index < nums.length; ++index) {
            if (nums[index] == null || nums[index].trim().length() == 0 || this.editData.getStep() > 0 && Long.parseLong(nums[index].trim()) > maxNumber || this.editData.getStep() < 0 && Long.parseLong(nums[index].trim()) < maxNumber) continue;
            if (retNums.length() > 0) {
                retNums.append(",");
            }
            retNums.append(nums[index].trim());
        }
        return retNums.toString();
    }

    @Override
    protected void kdtIntermilNOs_editValueChanged(KDTEditEvent e) throws Exception {
        Object addNos;
        KDTable table = this.kdtIntermilNOs;
        IRow row = table.getRow(e.getRowIndex());
        IColumn col = table.getColumn(e.getColIndex());
        Object sortItem = row.getCell("sortItemValue").getValue();
        if (sortItem == null) {
            StringBuffer strSortItem = new StringBuffer();
            for (int iItem = 0; iItem < this.sortItems.size(); ++iItem) {
                Object objSort = row.getCell("attr" + iItem).getValue();
                if (objSort == null) {
                    return;
                }
                if (strSortItem.length() > 0) {
                    strSortItem.append(splitSign + objSort.toString());
                    continue;
                }
                strSortItem.append(objSort.toString());
            }
        }
        if (sortItem == null || sortItem.toString().length() == 0) {
            return;
        }
        if (col.getKey().equalsIgnoreCase("AddNo")) {
            addNos = e.getValue();
            if (addNos == null || addNos.toString().length() == 0) {
                this.addDHs.remove(sortItem);
            } else {
                this.addDHs.put(sortItem, addNos);
            }
        } else if (col.getKey().equalsIgnoreCase("DelNo")) {
            addNos = e.getValue();
            if (addNos == null || addNos.toString().length() == 0) {
                this.delDHs.remove(sortItem);
            } else {
                this.delDHs.put(sortItem, addNos);
            }
        }
    }

    public void saveBreakPointList() throws EASBizException, BOSException, Exception {
        String validNums;
        String key;
        Set keySet = this.addDHs.keySet();
        IIntermilNO itNum = IntermilNOFactory.getRemoteInstance();
        Iterator it = keySet.iterator();
        int modifyFlag = 1;
        long maxSerial = -999L;
        while (it.hasNext()) {
            key = it.next().toString();
            if (this.addDHs.get(key) != null) {
                maxSerial = this.getMaxSerialNumber(key);
                validNums = this.parseNums((String)this.addDHs.get(key), maxSerial);
                if (validNums != null && validNums.trim().length() > 0) {
                    itNum.addDuanHao(this.editData.getId(), key, validNums);
                }
            }
            modifyFlag = 2;
        }
        keySet = this.delDHs.keySet();
        it = keySet.iterator();
        while (it.hasNext()) {
            key = it.next().toString();
            if (this.delDHs.get(key) != null) {
                maxSerial = this.getMaxSerialNumber(key);
                validNums = this.parseNums((String)this.delDHs.get(key), maxSerial);
                if (validNums != null && validNums.trim().length() > 0) {
                    itNum.deleteDuanHao(this.editData.getId(), key, validNums);
                }
            }
            if (modifyFlag == 2) {
                modifyFlag = 1;
                continue;
            }
            modifyFlag = 3;
        }
        this.addDHs.clear();
        this.delDHs.clear();
        switch (modifyFlag) {
            case 1: {
                this.showResultMessage("com.kingdee.eas.base.codingrule.CodingRuleResource.Msg_ModifyIntermitNoSuccessful");
                break;
            }
            case 2: {
                this.showResultMessage("com.kingdee.eas.base.codingrule.CodingRuleResource.Msg_AddIntermitNoSuccessful");
                break;
            }
            case 3: {
                this.showResultMessage("com.kingdee.eas.base.codingrule.CodingRuleResource.Msg_DelIntermitNoSuccessful");
            }
        }
    }

    private long getMaxSerialNumber(String key) {
        MaxSerialInfo mInfo = (MaxSerialInfo)this.maxserialMap.get(key);
        long maxSerial = mInfo.getSerialNumber();
        return maxSerial;
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.saveBreakPointList();
        this.initTable();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    private MaxSerialCollection getMaxSerialCollection() {
        if (this.maxCollection != null) {
            return this.maxCollection;
        }
        MaxSerialCollection retColl = null;
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filterTemp = new FilterInfo();
        filterTemp.getFilterItems().add(new FilterItemInfo("codingRuleEntry", (Object)this.editData.getId()));
        ev.setFilter(filterTemp);
        try {
            retColl = MaxSerialFactory.getRemoteInstance().getMaxSerialCollection(ev);
        }
        catch (BOSException e) {
            retColl = this.editData.getMaxSerials();
        }
        this.maxCollection = retColl;
        return retColl;
    }

    private IntermilNOCollection getIntermitNumberCollection() {
        IntermilNOCollection retColl = null;
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filterTemp = new FilterInfo();
        ev.getSorter().add(new SorterItemInfo("sortItemValue"));
        filterTemp.getFilterItems().add(new FilterItemInfo("codingRuleEntry", (Object)this.editData.getId()));
        ev.setFilter(filterTemp);
        try {
            retColl = IntermilNOFactory.getRemoteInstance().getIntermilNOCollection(ev);
        }
        catch (BOSException e) {
            retColl = this.editData.getIntermilNOs();
        }
        return retColl;
    }

    protected IObjectValue createNewData() {
        CodingRuleEntryInfo info = (CodingRuleEntryInfo)this.getUIContext().get("seqInfo");
        return info;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return CodingRuleEntryFactory.getRemoteInstance();
    }

    public void onShow() throws Exception {
        this.setMessageText(this.getUITitle());
        this.showMessage();
    }

    @Override
    public void actionAddDH_actionPerformed(ActionEvent e) throws Exception {
        IRow row = this.kdtIntermilNOs.addRow();
        row.getCell("IntermitNo").getStyleAttributes().setLocked(true);
        row.getCell("IntermitNo").getStyleAttributes().setBackground(this.color[1]);
        this.kdtIntermilNOs.scrollToVisible(row.getRowIndex(), 0);
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.addDHs.clear();
        this.delDHs.clear();
        this.initTable();
    }

    @Override
    public void actionDisplayAll_actionPerformed(ActionEvent e) throws Exception {
        boolean bl = this.isAllDisplay = !this.isAllDisplay;
        if (this.isAllDisplay) {
            this.btnDisplayAll.setText(EASResource.getString((String)"com.kingdee.eas.base.codingrule.CodingRuleResource.Msg_DisplayPart"));
            this.btnDisplayAll.setToolTipText(EASResource.getString((String)"com.kingdee.eas.base.codingrule.CodingRuleResource.Msg_DisplayPartTips"));
            this.actionDisplayAll.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_partshow"));
        } else {
            this.btnDisplayAll.setText(EASResource.getString((String)"com.kingdee.eas.base.codingrule.CodingRuleResource.Msg_DisplayAll"));
            this.btnDisplayAll.setToolTipText(EASResource.getString((String)"com.kingdee.eas.base.codingrule.CodingRuleResource.Msg_DisplayAllTips"));
            this.actionDisplayAll.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_entirely"));
        }
        this.actionRefresh_actionPerformed(e);
    }

    public boolean isModify() {
        return !this.addDHs.isEmpty() || !this.delDHs.isEmpty();
    }

    protected void showResultMessage(String message) {
        this.setMessageText(EASResource.getString((String)message));
        this.showMessage();
    }
}

