/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.codingrule.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.codingrule.client.AbstractCodingRuleReferencF7;
import com.kingdee.eas.base.codingrule.client.CodingRuleClientUtils;
import com.kingdee.eas.base.codingrule.client.EntityProperty;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.Locale;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreeSelectionModel;
import org.apache.log4j.Logger;

public class CodingRuleReferencF7
extends AbstractCodingRuleReferencF7
implements KDPromptSelector {
    protected IUIWindow currDialog = null;
    private String boType;
    private boolean canceled = false;
    private IMetaDataLoader metaLoader;
    private String propertyName = "";
    private String propertyNameText = "";
    private Logger logger = Logger.getLogger(CodingRuleReferencF7.class);
    private Object parentWindow;

    public void setBoType(String boType) {
        this.boType = boType;
    }

    public void setMetaLoader(IMetaDataLoader metaLoader) {
        this.metaLoader = metaLoader;
    }

    public void setParentWindow(Object parentWindow) {
        this.parentWindow = parentWindow;
    }

    public String getBoType() {
        return this.boType;
    }

    public IMetaDataLoader getMetaLoader() {
        return this.metaLoader;
    }

    public CodingRuleReferencF7() throws Exception {
        this.setUITitle(EASResource.getString((String)"com.kingdee.eas.base.codingrule.CodingRuleResource.Msg_Title_ReferencF7"));
    }

    public void onLoad() {
        if (this.getUIContext().get("boType") != null) {
            this.boType = this.getUIContext().get("boType").toString().trim();
        }
        this.metaLoader = this.getUIContext().get("metaLoader") != null ? (IMetaDataLoader)this.getUIContext().get("metaLoader") : this.createIMetaDataLoader();
        this.initTree();
        this.initKDTable();
    }

    private void initKDTable() {
        this.tblList.getSelectManager().setSelectMode(2);
        this.tblList.getStyleAttributes().setLocked(true);
    }

    void initTree() {
        DefaultKingdeeTreeNode root = this.createNode();
        this.treeProperty.setModel((TreeModel)new KingdeeTreeModel((TreeNode)root));
        this.treeProperty.repaint();
        TreeSelectionModel treeSelectionModel = this.treeProperty.getSelectionModel();
        this.treeProperty.getSelectionModel();
        treeSelectionModel.setSelectionMode(1);
    }

    private DefaultKingdeeTreeNode createNode() {
        DefaultKingdeeTreeNode rootNode = null;
        try {
            if (this.metaLoader == null) {
                this.metaLoader = this.createIMetaDataLoader();
            }
            EntityObjectInfo meta = this.metaLoader.getEntity((IMetaDataPK)new MetaDataPK(this.boType));
            Locale mylocale = SysContext.getSysContext().getOriginLocale();
            rootNode = new DefaultKingdeeTreeNode((Object)this.getDefaultName(meta.getAlias(mylocale)));
            PropertyCollection pc = meta.getInheritedPropertiesRuntime();
            for (int i = 0; i < pc.size(); ++i) {
                PropertyInfo property = pc.get(i);
                this.logger.debug((Object)property.getClass().getName());
                this.logger.debug((Object)property.getAlias(mylocale));
                if (property instanceof OwnPropertyInfo || !(property instanceof LinkPropertyInfo)) continue;
                LinkPropertyInfo lp = (LinkPropertyInfo)property;
                String nodeText = lp.getAlias(mylocale);
                DefaultKingdeeTreeNode childNode = new DefaultKingdeeTreeNode((Object)nodeText);
                childNode.setUserObject((Object)new TreeObject(lp, nodeText));
                rootNode.add((MutableTreeNode)childNode);
            }
        }
        catch (Exception err) {
            ExceptionHandler.handle((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.base.codingrule.CodingRuleResource.Error_PropertyTree"), (Throwable)err);
        }
        return rootNode;
    }

    private String getDefaultName(String nodeText) {
        if (nodeText != null && nodeText.length() > 0) {
            return nodeText;
        }
        return "no name";
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void treeProperty_valueChanged(TreeSelectionEvent e) throws Exception {
        super.treeProperty_valueChanged(e);
        KDTree tree = (KDTree)e.getSource();
        DefaultKingdeeTreeNode selectedNode = (DefaultKingdeeTreeNode)tree.getLastSelectedPathComponent();
        if (selectedNode != null) {
            this.logger.debug((Object)("tree event:" + selectedNode.getUserObject().toString()));
            Object uo = selectedNode.getUserObject();
            String str1 = "";
            if (uo != null && !uo.getClass().getName().equals("java.lang.String")) {
                LinkPropertyInfo lp = ((TreeObject)uo).getLinkPropertyInfo();
                this.logger.debug((Object)(((TreeObject)uo).nodeText + " , " + lp.getName() + " , " + lp.getRelationship().getSupplierObject().getType().toString()));
                this.propertyName = lp.getName();
                this.propertyNameText = ((TreeObject)uo).nodeText;
                if (lp.getRelationship().getSupplierObject().getType().toString().equals(this.getBoType())) {
                    this.filterData(lp.getRelationship().getClientObject().getPackage() + "." + lp.getRelationship().getClientObject().getName());
                } else {
                    this.filterData(lp.getRelationship().getSupplierObject().getPackage() + "." + lp.getRelationship().getSupplierObject().getName());
                }
            } else {
                this.logger.debug((Object)"Not a Leaf Node!");
            }
        }
    }

    @Override
    protected void treeProperty_mouseClicked(MouseEvent e) throws Exception {
        super.treeProperty_mouseClicked(e);
    }

    @Override
    protected void tblList_tableClicked(KDTMouseEvent e) throws Exception {
        super.tblList_tableClicked(e);
        if (e.getClickCount() == 2) {
            try {
                if (this.tblList.getSelectManager().getActiveRowIndex() == -1) {
                    return;
                }
                if (this.checkData()) {
                    this.canceled = false;
                    this.getUIWindow().close();
                }
            }
            catch (Exception err) {
                ExceptionHandler.handle((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.base.codingrule.CodingRuleResource.Error_Select_CR"), (Throwable)err);
            }
        }
    }

    @Override
    public void actionOK_actionPerformed(ActionEvent e) throws Exception {
        if (this.checkData()) {
            this.canceled = false;
            this.getUIWindow().close();
        }
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.canceled = true;
        this.getUIWindow().close();
    }

    @Override
    protected void bt_OK_mouseClicked(MouseEvent e) throws Exception {
        super.bt_OK_mouseClicked(e);
        this.logger.debug((Object)"bt_OK_mouseClicked Event!");
    }

    @Override
    protected void bt_Cancel_mouseClicked(MouseEvent e) throws Exception {
        super.bt_Cancel_mouseClicked(e);
        this.logger.debug((Object)"bt_Cancel_mouseClicked Event!");
        this.canceled = true;
        this.getUIWindow().close();
    }

    @Override
    protected void tblList_doRequestRowSet(RequestRowSetEvent e) {
        if (this.codingRuleListQuery != null) {
            int start = (Integer)e.getParam1();
            int length = (Integer)e.getParam2() - start + 1;
            try {
                IQueryExecutor exec = this.getQueryExecutor(this.codingRuleListQueryPK, this.codingRuleListQuery);
                IRowSet rowSet = exec.executeQuery(start, length);
                while (rowSet.next()) {
                    if (rowSet.getString("bp.propertyName") == null || rowSet.getString("bp.propertyName").length() <= 0) continue;
                    rowSet.updateString("bp.propertyName", CodingRuleClientUtils.getPropertyAlias(rowSet.getString("bp.propertyName"), rowSet.getString("businessObject"), this.metaLoader, null));
                }
                rowSet.beforeFirst();
                e.setRowSet(rowSet);
                this.onGetRowSet(rowSet);
            }
            catch (Exception ee) {
                e.setRowSet(null);
                this.handUIException(ee);
            }
        }
    }

    public void show() {
        this.logger.debug((Object)"show Event!");
        IUIFactory uiFactory = null;
        try {
            UIContext hm = new UIContext(this.getParentWindow());
            hm.put("boType", this.getBoType());
            hm.put("metaLoader", this.getMetaLoader());
            uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
            this.currDialog = uiFactory.create(((Object)((Object)this)).getClass().getName(), (Map)hm);
            this.currDialog.show();
        }
        catch (BOSException ex) {
            ExceptionHandler.handle((Throwable)ex);
        }
    }

    public boolean isCanceled() {
        CodingRuleReferencF7 me = (CodingRuleReferencF7)this.currDialog.getUIObject();
        this.logger.debug((Object)("BoType: " + me.getBoType()));
        this.logger.debug((Object)("isCanceled Event: " + me.canceled));
        return me.canceled;
    }

    public Object getParentWindow() {
        return this.parentWindow;
    }

    public Object getData() {
        CodingRuleReferencF7 me = (CodingRuleReferencF7)this.currDialog.getUIObject();
        this.logger.debug((Object)("getData Event: " + me.canceled));
        if (me.canceled) {
            return null;
        }
        EntityProperty ep = this.createDataObject();
        return ep;
    }

    private boolean checkData() {
        boolean returnValue = false;
        if (this.tblList.getSelectManager().getActiveRowIndex() == -1) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.base.codingrule.CodingRuleResource.Msg_SelectCR"));
            return returnValue;
        }
        if (this.propertyName == null || this.propertyName.length() < 1) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.base.codingrule.CodingRuleResource.Error_TreeData_Invalid"));
            return returnValue;
        }
        returnValue = true;
        return returnValue;
    }

    private EntityProperty createDataObject() {
        CodingRuleReferencF7 me = (CodingRuleReferencF7)this.currDialog.getUIObject();
        if (me.tblList.getSelectManager().getActiveRowIndex() == -1) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.base.codingrule.CodingRuleResource.Msg_SelectCR"));
            return null;
        }
        if (me.propertyName == null || me.propertyName.length() < 1) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.base.codingrule.CodingRuleResource.Error_TreeData_Invalid"));
            return null;
        }
        String number = me.propertyNameText + "." + me.tblList.getRow(me.tblList.getSelectManager().getActiveRowIndex()).getCell("number").getValue().toString();
        String value = me.propertyName + "." + me.tblList.getRow(me.tblList.getSelectManager().getActiveRowIndex()).getCell("id").getValue().toString() + "." + me.tblList.getRow(me.tblList.getSelectManager().getActiveRowIndex()).getCell("number").getValue().toString();
        EntityProperty ep = new EntityProperty(number, value);
        return ep;
    }

    private void filterData(String boId) {
        FilterInfo filter = new FilterInfo();
        FilterItemInfo fi = new FilterItemInfo("businessObject", (Object)boId, CompareType.EQUALS);
        filter.getFilterItems().add(fi);
        if (this.codingRuleListQuery == null) {
            this.makeQuery();
        }
        this.codingRuleListQuery.setFilter(filter);
        this.tblList.removeRows();
    }

    private void makeQuery() {
        EntityViewInfo evi;
        this.codingRuleListQuery = evi = new EntityViewInfo();
    }

    public IMetaDataLoader createIMetaDataLoader() {
        this.metaLoader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        return this.metaLoader;
    }

    protected JButton getDefaultButton() {
        return this.bt_OK;
    }

    static class TreeObject {
        private LinkPropertyInfo lp;
        private String nodeText;

        TreeObject(LinkPropertyInfo lp, String nodeText) {
            this.lp = lp;
            this.nodeText = nodeText;
        }

        public LinkPropertyInfo getLinkPropertyInfo() {
            return this.lp;
        }

        public String toString() {
            return this.nodeText;
        }
    }
}

