/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.codingrule;

import com.kingdee.bos.framework.cache.CustomCacheService;
import com.kingdee.bos.framework.cache.Utils;
import com.kingdee.bos.util.MultiParamKeyString;
import com.kingdee.eas.base.codingrule.BindingPropertyInfo;
import com.kingdee.eas.base.codingrule.CodingRuleMultiOrgCollection;
import com.kingdee.jdbc.rowset.impl.JdbcRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import javax.sql.RowSet;
import org.apache.log4j.Logger;

public class CodingRuleCacheUtil {
    private static Logger logger = Logger.getLogger(CodingRuleCacheUtil.class);
    public static final String CACHE_CODING_RULE_INFO = "codingRule.codingRuleInfo";
    public static final String CACHE_CODING_RULE_INFO_MARKER = "codingRule.codingRuleInfoMarker";
    private static CustomCacheService codingRuleInfoCache = new CustomCacheService("codingRule.codingRuleInfo");
    private static CustomCacheService codingRuleInfoMarkerCache = new CustomCacheService("codingRule.codingRuleInfoMarker");
    private static String CODINGRULE_MARKER = "CodingRuleMarker";

    public static RowSet getCodingRuleInfoFromCache(String businessObject, String org, int ruleType, String propertyName, String propertyValue, String customProperty) {
        if (businessObject == null || org == null) {
            try {
                return new JdbcRowSet();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        String key = CodingRuleCacheUtil.getCodingRuleInfoKey(businessObject, org, ruleType, propertyName, propertyValue, customProperty);
        logger.error((Object)("codingrule getcache----------------------- :  " + key));
        RowSet ret = (RowSet)codingRuleInfoCache.get(key);
        if (ret == null) {
            return ret;
        }
        try {
            ret.beforeFirst();
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
        }
        return ret;
    }

    public static String getCodingRuleInfoFromCacheNew(String businessObject, String org, int ruleType, String propertyName, String propertyValue, String customProperty) {
        if (businessObject == null || org == null) {
            return "";
        }
        String key = CodingRuleCacheUtil.getCodingRuleInfoKey(businessObject, org, ruleType, propertyName, propertyValue, customProperty);
        logger.error((Object)("codingRule getCache new----------------------- :  " + key));
        String ret = (String)codingRuleInfoCache.get(key);
        logger.error((Object)("get rule id from cache is:" + ret));
        return ret;
    }

    public static void putCodingRuleInfoToCache(String businessObject, String org, int ruleType, String propertyName, String propertyValue, String customProperty, RowSet codingRules) {
        if (businessObject == null || org == null) {
            return;
        }
        String key = CodingRuleCacheUtil.getCodingRuleInfoKey(businessObject, org, ruleType, propertyName, propertyValue, customProperty);
        logger.error((Object)("codingruleputcache----------- :" + key));
        codingRuleInfoCache.put(key, (Object)codingRules);
    }

    public static void putCodingRuleInfoToCacheNew(String businessObject, String org, int ruleType, String propertyName, String propertyValue, String customProperty, String ruleId) {
        if (businessObject == null || org == null) {
            return;
        }
        String key = CodingRuleCacheUtil.getCodingRuleInfoKey(businessObject, org, ruleType, propertyName, propertyValue, customProperty);
        logger.error((Object)("codingruleputcache----------- :" + key + ",ruleId:" + ruleId));
        codingRuleInfoCache.put(key, (Object)ruleId);
    }

    @Deprecated
    public static void updateCodingRuleMarker(String businessObject) {
        if (StringUtils.isEmpty((String)businessObject)) {
            return;
        }
        String marker = Utils.randomStr((String)CODINGRULE_MARKER);
        codingRuleInfoMarkerCache.put(businessObject, (Object)marker);
    }

    public static void removeCodingRuleCache(String businessObject, String org, int ruleType, String propertyName, String propertyValue, String customProperty) {
        String key = CodingRuleCacheUtil.getCodingRuleInfoKey(businessObject, org, ruleType, propertyName, propertyValue, customProperty);
        logger.error((Object)("codingruleremovecache---------------- : " + key));
        codingRuleInfoCache.remove(key);
    }

    public static void removeCodingRuleCache(String businessObject, String org, int ruleType, BindingPropertyInfo crBindProperty, String customProperty) {
        String propertyName = crBindProperty != null ? crBindProperty.getPropertyName() : null;
        String propertyValue = crBindProperty != null ? crBindProperty.getPropertyValue() : null;
        String key = CodingRuleCacheUtil.getCodingRuleInfoKey(businessObject, org, ruleType, propertyName, propertyValue, customProperty);
        logger.error((Object)("codingruleremovecache---------------- : " + key));
        codingRuleInfoCache.remove(key);
    }

    private static String getCodingRuleInfoKey(String businessObject, String org, int ruleType, String propertyName, String propertyValue, String customProperty) {
        Object[] args = new Object[]{StringUtils.cnulls((String)businessObject), StringUtils.cnulls((String)org), ruleType, StringUtils.cnulls((String)propertyName), StringUtils.cnulls((String)propertyValue), StringUtils.cnulls((String)customProperty)};
        return Utils.transMD5((String)MultiParamKeyString.toString(null, (Object[])args));
    }

    public static void removeCodingRuleCache(String businessObject, String org, CodingRuleMultiOrgCollection multiOrgColl, int ruleType, BindingPropertyInfo crBindProperty, String customProperty) {
        String propertyName = crBindProperty != null ? crBindProperty.getPropertyName() : null;
        String propertyValue = crBindProperty != null ? crBindProperty.getPropertyValue() : null;
        String key = CodingRuleCacheUtil.getCodingRuleInfoKey(businessObject, org, ruleType, propertyName, propertyValue, customProperty);
        codingRuleInfoCache.remove(key);
        if (multiOrgColl != null && multiOrgColl.size() > 0) {
            for (int i = 0; i < multiOrgColl.size(); ++i) {
                org = multiOrgColl.get(i).getAppOrgUnit().getId().toString();
                key = CodingRuleCacheUtil.getCodingRuleInfoKey(businessObject, org, ruleType, propertyName, propertyValue, customProperty);
                codingRuleInfoCache.remove(key);
            }
        }
    }
}

