/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.codingrule.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.STConverter;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleCacheUtil;
import com.kingdee.eas.base.codingrule.CodingRuleCollection;
import com.kingdee.eas.base.codingrule.CodingRuleEntryCollection;
import com.kingdee.eas.base.codingrule.CodingRuleEntryInfo;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.base.codingrule.CodingRuleFactory;
import com.kingdee.eas.base.codingrule.CodingRuleInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.CodingRuleMultiOrgCollection;
import com.kingdee.eas.base.codingrule.ICodingRule;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.codingrule.IIntermilNO;
import com.kingdee.eas.base.codingrule.IMaxSerial;
import com.kingdee.eas.base.codingrule.IntermilNOCollection;
import com.kingdee.eas.base.codingrule.IntermilNOFactory;
import com.kingdee.eas.base.codingrule.MaxSerialCollection;
import com.kingdee.eas.base.codingrule.MaxSerialFactory;
import com.kingdee.eas.base.codingrule.RuleStatus;
import com.kingdee.eas.base.codingrule.SeqSegmentEntryCollection;
import com.kingdee.eas.base.codingrule.SeqSegmentEntryInfo;
import com.kingdee.eas.base.codingrule.SeqSegmentInfo;
import com.kingdee.eas.base.codingrule.app.AbstractCodingRuleManagerControllerBean;
import com.kingdee.eas.base.codingrule.app.CodingRuleAppUtils;
import com.kingdee.eas.base.codingrule.app.CodingRuleDAO;
import com.kingdee.eas.base.codingrule.ext.IBindingPropery;
import com.kingdee.eas.base.codingrule.util.BindingPropertyExtendInfo;
import com.kingdee.eas.base.codingrule.util.BindingPropertyInfo;
import com.kingdee.eas.base.codingrule.util.CodingRuleServerUtil;
import com.kingdee.eas.base.codingrule.util.ParmCodingRule;
import com.kingdee.eas.base.codingrule.util.RecycleCollection;
import com.kingdee.eas.base.codingrule.util.RecycleItem;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.service.OrgCommonUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.ConfigurationItem;
import com.kingdee.util.StringUtils;
import com.kingdee.util.XMLConfiguration;
import java.io.File;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.naming.InitialContext;
import javax.sql.RowSet;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.apache.log4j.Logger;

public class CodingRuleManagerControllerBean
extends AbstractCodingRuleManagerControllerBean {
    private Logger logger = Logger.getLogger(CodingRuleManagerControllerBean.class);
    private static final String RESOURCE_NAME = "com.kingdee.eas.base.codingrule.CodingRuleResource.";

    @Override
    protected IObjectValue _getCodingRuleByNumber(Context ctx, String number) throws BOSException, CodingRuleException, EASBizException {
        ICodingRule iCodingRule = CodingRuleFactory.getLocalInstance(ctx);
        FilterInfo filters = new FilterInfo();
        filters.getFilterItems().add(new FilterItemInfo("Number", (Object)number, CompareType.EQUALS));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filters);
        evi.getSelector().add(new SelectorItemInfo("id"));
        CodingRuleCollection crl = iCodingRule.getCodingRuleCollection(evi);
        CodingRuleInfo cr = null;
        if (crl.size() == 1) {
            cr = CodingRuleAppUtils.createCodingRuleInfo(ctx, CodingRuleDAO.getCodingRuleInfoValueByID(ctx, crl.get(0).getId().toString()));
        } else if (crl.size() > 1) {
            throw new CodingRuleException(CodingRuleException.ERROR_SAMENUMBERCR);
        }
        return cr;
    }

    @Override
    protected boolean _delete(Context ctx, IObjectValue codingRuleInfo) throws BOSException, CodingRuleException, EASBizException {
        CodingRuleInfo cr = (CodingRuleInfo)codingRuleInfo;
        return this.deleteCodingRule(ctx, cr, true);
    }

    @Override
    protected boolean _deleteByNumber(Context ctx, String number) throws BOSException, EASBizException {
        return this._deleteByNumber(ctx, number, true);
    }

    @Override
    protected boolean _deleteByNumber(Context ctx, String number, boolean isCheck) throws BOSException, CodingRuleException, EASBizException {
        CodingRuleInfo cr = (CodingRuleInfo)this._getCodingRuleByNumber(ctx, number);
        return this.deleteCodingRule(ctx, cr, isCheck);
    }

    private boolean deleteCodingRule(Context ctx, CodingRuleInfo cr, boolean isCheck) throws BOSException, CodingRuleException, EASBizException {
        try {
            if (cr == null) {
                return false;
            }
            if (isCheck) {
                this.checkHasMaxSerial(ctx, cr);
            }
            ICodingRule iCodingRule = CodingRuleFactory.getLocalInstance(ctx);
            for (int i = 0; i < cr.getCodingRuleEntrys().size(); ++i) {
                ObjectUuidPK refPk;
                CodingRuleInfo refCr;
                String refId;
                String codeAttribute = cr.getCodingRuleEntrys().get(i).getCodeAttribute();
                if ("sn".equals(codeAttribute) || !"reference".equals(codeAttribute) || (refId = cr.getCodingRuleEntrys().get(i).getValueAttribute()) == null || refId.length() <= 0 || (refCr = iCodingRule.getCodingRuleInfo((IObjectPK)(refPk = new ObjectUuidPK(BOSUuid.read((String)refId))))) == null) continue;
                throw new CodingRuleException(CodingRuleException.ERROR_DELETEREFERENCE);
            }
            if (!isCheck) {
                StringBuffer sb = new StringBuffer();
                sb.append(ResourceBase.getString((String)"com.kingdee.eas.base.codingrule.CODINGRULEAutoGenerateResource", (String)"9_CodingRuleManagerControllerBean", (Locale)ctx.getOriginLocale()));
                sb.append("\n");
                sb.append(ResourceBase.getString((String)"com.kingdee.eas.base.codingrule.CODINGRULEAutoGenerateResource", (String)"10_CodingRuleManagerControllerBean", (Locale)ctx.getOriginLocale()) + cr.getNumber());
                sb.append(ResourceBase.getString((String)"com.kingdee.eas.base.codingrule.CODINGRULEAutoGenerateResource", (String)"11_CodingRuleManagerControllerBean", (Locale)ctx.getOriginLocale()) + cr.getName());
                sb.append("\n");
                if (cr.isGroupFirst()) {
                    sb.append(ResourceBase.getString((String)"com.kingdee.eas.base.codingrule.CODINGRULEAutoGenerateResource", (String)"12_CodingRuleManagerControllerBean", (Locale)ctx.getOriginLocale()));
                    sb.append(" " + cr.getAppOrgUnit());
                }
                if (cr.isOrgFirst()) {
                    sb.append(ResourceBase.getString((String)"com.kingdee.eas.base.codingrule.CODINGRULEAutoGenerateResource", (String)"13_CodingRuleManagerControllerBean", (Locale)ctx.getOriginLocale()));
                    sb.append(" " + cr.getAppOrgUnit());
                }
                if (cr.isMultiOrgFirst()) {
                    sb.append(ResourceBase.getString((String)"com.kingdee.eas.base.codingrule.CODINGRULEAutoGenerateResource", (String)"14_CodingRuleManagerControllerBean", (Locale)ctx.getOriginLocale()));
                    CodingRuleMultiOrgCollection crmcol = cr.getMultiOrg();
                    if (crmcol != null && crmcol.size() != 0) {
                        for (int i = 0; i < crmcol.size(); ++i) {
                            if (i == 0) {
                                sb.append(" ");
                            } else {
                                sb.append("\u3001");
                            }
                            sb.append(crmcol.get(i).getOrgName());
                        }
                    }
                }
                CodingRuleEntryInfo einfo = null;
                CodingRuleEntryCollection ecol = cr.getCodingRuleEntrys();
                Iterator it = ecol.iterator();
                int i = 1;
                String codeAttu = "";
                while (it.hasNext()) {
                    sb.append("\n");
                    einfo = (CodingRuleEntryInfo)it.next();
                    sb.append("(" + i + ResourceBase.getString((String)"com.kingdee.eas.base.codingrule.CODINGRULEAutoGenerateResource", (String)"15_CodingRuleManagerControllerBean", (Locale)ctx.getOriginLocale()));
                    codeAttu = einfo.getCodeAttribute();
                    if (!StringUtils.isEmpty((String)codeAttu)) {
                        if (codeAttu.equals("systime")) {
                            sb.append(ResourceBase.getString((String)"com.kingdee.eas.base.codingrule.CODINGRULEAutoGenerateResource", (String)"16_CodingRuleManagerControllerBean", (Locale)ctx.getOriginLocale()));
                        } else if (codeAttu.equals("attribute")) {
                            sb.append(ResourceBase.getString((String)"com.kingdee.eas.base.codingrule.CODINGRULEAutoGenerateResource", (String)"17_CodingRuleManagerControllerBean", (Locale)ctx.getOriginLocale()));
                        } else if (codeAttu.equals("fixedvalue")) {
                            sb.append(ResourceBase.getString((String)"com.kingdee.eas.base.codingrule.CODINGRULEAutoGenerateResource", (String)"18_CodingRuleManagerControllerBean", (Locale)ctx.getOriginLocale()));
                        } else if (codeAttu.equals("custom")) {
                            sb.append(ResourceBase.getString((String)"com.kingdee.eas.base.codingrule.CODINGRULEAutoGenerateResource", (String)"19_CodingRuleManagerControllerBean", (Locale)ctx.getOriginLocale()));
                        } else if (codeAttu.equals("sn")) {
                            sb.append(ResourceBase.getString((String)"com.kingdee.eas.base.codingrule.CODINGRULEAutoGenerateResource", (String)"20_CodingRuleManagerControllerBean", (Locale)ctx.getOriginLocale()));
                        } else if (codeAttu.equals("check")) {
                            sb.append(ResourceBase.getString((String)"com.kingdee.eas.base.codingrule.CODINGRULEAutoGenerateResource", (String)"21_CodingRuleManagerControllerBean", (Locale)ctx.getOriginLocale()));
                        } else if (codeAttu.equals("whole")) {
                            sb.append(ResourceBase.getString((String)"com.kingdee.eas.base.codingrule.CODINGRULEAutoGenerateResource", (String)"22_CodingRuleManagerControllerBean", (Locale)ctx.getOriginLocale()));
                        }
                    } else {
                        sb.append(ResourceBase.getString((String)"com.kingdee.eas.base.codingrule.CODINGRULEAutoGenerateResource", (String)"23_CodingRuleManagerControllerBean", (Locale)ctx.getOriginLocale()));
                    }
                    if (!StringUtils.isEmpty((String)einfo.getAttUsingMode())) {
                        sb.append(ResourceBase.getString((String)"com.kingdee.eas.base.codingrule.CODINGRULEAutoGenerateResource", (String)"24_CodingRuleManagerControllerBean", (Locale)ctx.getOriginLocale()) + einfo.getAttUsingMode());
                    } else {
                        sb.append(ResourceBase.getString((String)"com.kingdee.eas.base.codingrule.CODINGRULEAutoGenerateResource", (String)"25_CodingRuleManagerControllerBean", (Locale)ctx.getOriginLocale()));
                    }
                    if (!StringUtils.isEmpty((String)einfo.getValueAttribute())) {
                        sb.append(ResourceBase.getString((String)"com.kingdee.eas.base.codingrule.CODINGRULEAutoGenerateResource", (String)"26_CodingRuleManagerControllerBean", (Locale)ctx.getOriginLocale()) + einfo.getValueAttribute());
                    } else {
                        sb.append(ResourceBase.getString((String)"com.kingdee.eas.base.codingrule.CODINGRULEAutoGenerateResource", (String)"27_CodingRuleManagerControllerBean", (Locale)ctx.getOriginLocale()));
                    }
                    if (!StringUtils.isEmpty((String)einfo.getFormat())) {
                        sb.append(ResourceBase.getString((String)"com.kingdee.eas.base.codingrule.CODINGRULEAutoGenerateResource", (String)"28_CodingRuleManagerControllerBean", (Locale)ctx.getOriginLocale()) + einfo.getFormat());
                    } else {
                        sb.append(ResourceBase.getString((String)"com.kingdee.eas.base.codingrule.CODINGRULEAutoGenerateResource", (String)"29_CodingRuleManagerControllerBean", (Locale)ctx.getOriginLocale()));
                    }
                    sb.append(ResourceBase.getString((String)"com.kingdee.eas.base.codingrule.CODINGRULEAutoGenerateResource", (String)"30_CodingRuleManagerControllerBean", (Locale)ctx.getOriginLocale()) + einfo.getLength());
                    sb.append(ResourceBase.getString((String)"com.kingdee.eas.base.codingrule.CODINGRULEAutoGenerateResource", (String)"31_CodingRuleManagerControllerBean", (Locale)ctx.getOriginLocale()) + einfo.getInitial());
                    sb.append(ResourceBase.getString((String)"com.kingdee.eas.base.codingrule.CODINGRULEAutoGenerateResource", (String)"32_CodingRuleManagerControllerBean", (Locale)ctx.getOriginLocale()) + einfo.getStep());
                    if (!StringUtils.isEmpty((String)einfo.getFillSign())) {
                        sb.append(ResourceBase.getString((String)"com.kingdee.eas.base.codingrule.CODINGRULEAutoGenerateResource", (String)"33_CodingRuleManagerControllerBean", (Locale)ctx.getOriginLocale()) + einfo.getFillSign());
                    } else {
                        sb.append(ResourceBase.getString((String)"com.kingdee.eas.base.codingrule.CODINGRULEAutoGenerateResource", (String)"34_CodingRuleManagerControllerBean", (Locale)ctx.getOriginLocale()));
                    }
                    sb.append(ResourceBase.getString((String)"com.kingdee.eas.base.codingrule.CODINGRULEAutoGenerateResource", (String)"35_CodingRuleManagerControllerBean", (Locale)ctx.getOriginLocale()) + (Object)((Object)einfo.getFillSignDirection()));
                    if (einfo.isIsDisplay()) {
                        sb.append(ResourceBase.getString((String)"com.kingdee.eas.base.codingrule.CODINGRULEAutoGenerateResource", (String)"36_CodingRuleManagerControllerBean", (Locale)ctx.getOriginLocale()));
                    } else {
                        sb.append(ResourceBase.getString((String)"com.kingdee.eas.base.codingrule.CODINGRULEAutoGenerateResource", (String)"37_CodingRuleManagerControllerBean", (Locale)ctx.getOriginLocale()));
                    }
                    if (einfo.isIsSortByItem()) {
                        sb.append(ResourceBase.getString((String)"com.kingdee.eas.base.codingrule.CODINGRULEAutoGenerateResource", (String)"38_CodingRuleManagerControllerBean", (Locale)ctx.getOriginLocale()));
                    } else {
                        sb.append(ResourceBase.getString((String)"com.kingdee.eas.base.codingrule.CODINGRULEAutoGenerateResource", (String)"39_CodingRuleManagerControllerBean", (Locale)ctx.getOriginLocale()));
                    }
                    if (einfo.isIsSplitSign()) {
                        sb.append(ResourceBase.getString((String)"com.kingdee.eas.base.codingrule.CODINGRULEAutoGenerateResource", (String)"40_CodingRuleManagerControllerBean", (Locale)ctx.getOriginLocale()));
                    } else {
                        sb.append(ResourceBase.getString((String)"com.kingdee.eas.base.codingrule.CODINGRULEAutoGenerateResource", (String)"41_CodingRuleManagerControllerBean", (Locale)ctx.getOriginLocale()));
                    }
                    sb.append(ResourceBase.getString((String)"com.kingdee.eas.base.codingrule.CODINGRULEAutoGenerateResource", (String)"42_CodingRuleManagerControllerBean", (Locale)ctx.getOriginLocale()) + einfo.getInterceptLength());
                    sb.append(ResourceBase.getString((String)"com.kingdee.eas.base.codingrule.CODINGRULEAutoGenerateResource", (String)"43_CodingRuleManagerControllerBean", (Locale)ctx.getOriginLocale()) + einfo.getInterceptPos());
                    sb.append(ResourceBase.getString((String)"com.kingdee.eas.base.codingrule.CODINGRULEAutoGenerateResource", (String)"44_CodingRuleManagerControllerBean", (Locale)ctx.getOriginLocale()) + (Object)((Object)einfo.getInterceptDirection()));
                    ++i;
                }
                String titilestr = ResourceBase.getString((String)"com.kingdee.eas.base.codingrule.CODINGRULEAutoGenerateResource", (String)"45_CodingRuleManagerControllerBean", (Locale)ctx.getOriginLocale());
                String contents = sb.toString();
                if (ctx.getOriginLocale() != null && ctx.getOriginLocale().toString().toLowerCase().equals("L3".toLowerCase())) {
                    titilestr = STConverter.sc2tc((String)titilestr);
                    contents = STConverter.sc2tc((String)contents);
                }
                LogUtil.afterLog((Context)ctx, (IObjectPK)LogUtil.beginLog((Context)ctx, (String)titilestr, (BOSObjectType)BOSUuid.read((String)cr.getId().toString()).getType(), (IObjectPK)new ObjectUuidPK(cr.getId().toString()), (String)contents));
            }
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)cr.getId().toString()));
            iCodingRule.delete((IObjectPK)pk);
            String crAppOrgID = cr.getAppOrgUnit() == null ? null : cr.getAppOrgUnit().getId().toString();
            CodingRuleCacheUtil.removeCodingRuleCache(cr.getBusinessObject(), crAppOrgID, 0, cr.getBindingProperty(), null);
            return true;
        }
        catch (CodingRuleException err) {
            throw err;
        }
        catch (Exception err) {
            throw new BOSException(err.getMessage(), (Throwable)err);
        }
    }

    protected boolean deleteCodingRule(Context ctx, CodingRuleInfo cr) throws BOSException, CodingRuleException, EASBizException {
        return this.deleteCodingRule(ctx, cr, true);
    }

    @Override
    protected boolean _update(Context ctx, IObjectValue codingRuleInfo) throws BOSException, CodingRuleException, EASBizException {
        CodingRuleInfo cr = (CodingRuleInfo)codingRuleInfo;
        if (this.hasBindingProperty(ctx, cr.getBusinessObject()) && (cr.getBindingProperty() == null || cr.getBindingProperty().getPropertyName() == null || cr.getBindingProperty().getPropertyValue() == null) && !cr.getBusinessObjectID().equals("8BBEC24B")) {
            throw new CodingRuleException(CodingRuleException.ERROR_MUSTHASBINDINGPROPERTY);
        }
        return this._updateWithNoBindingProperty(ctx, codingRuleInfo);
    }

    @Override
    protected boolean _updateWithNoBindingProperty(Context ctx, IObjectValue codingRuleInfo) throws BOSException, CodingRuleException, EASBizException {
        CodingRuleInfo cr = (CodingRuleInfo)codingRuleInfo;
        ICodingRule iCodingRule = CodingRuleFactory.getLocalInstance(ctx);
        ObjectUuidPK pk = new ObjectUuidPK(cr.getId());
        this.updateEnabled(ctx, cr, cr.isIsEnabled());
        this.checkHasMaxSerial(ctx, cr);
        iCodingRule.update((IObjectPK)pk, (CoreBaseInfo)((CodingRuleInfo)codingRuleInfo));
        String crAppOrgID = cr.getAppOrgUnit() == null ? null : cr.getAppOrgUnit().getId().toString();
        CodingRuleCacheUtil.removeCodingRuleCache(cr.getBusinessObject(), crAppOrgID, 0, cr.getBindingProperty(), null);
        return true;
    }

    private void checkHasMaxSerial(Context ctx, CodingRuleInfo cr) throws CodingRuleException, BOSException {
        IMaxSerial iMaxSerial = null;
        for (int i = 0; i < cr.getCodingRuleEntrys().size(); ++i) {
            MaxSerialCollection msc;
            String codeAttribute = cr.getCodingRuleEntrys().get(i).getCodeAttribute();
            if (!codeAttribute.equals("sn") || cr.getCodingRuleEntrys().get(i).getId() == null) continue;
            if (iMaxSerial == null) {
                iMaxSerial = MaxSerialFactory.getLocalInstance(ctx);
            }
            if ((msc = iMaxSerial.getCollection(cr.getCodingRuleEntrys().get(i).getId().toString(), "")).size() <= 0) continue;
            throw new CodingRuleException(CodingRuleException.ERROR_HASMAXSERIAL);
        }
    }

    @Override
    protected String _addNew(Context ctx, IObjectValue codingRuleInfo) throws BOSException, CodingRuleException, EASBizException {
        CodingRuleInfo cr = (CodingRuleInfo)codingRuleInfo;
        this.updateEnabled(ctx, cr, cr.isIsEnabled());
        if (this.hasBindingProperty(ctx, cr.getBusinessObject()) && (cr.getBindingProperty() == null || cr.getBindingProperty().getPropertyName() == null || cr.getBindingProperty().getPropertyValue() == null) && !cr.getBusinessObjectID().equals("8BBEC24B")) {
            throw new CodingRuleException(CodingRuleException.ERROR_MUSTHASBINDINGPROPERTY);
        }
        return this._addnewWithNoBingdingProperty(ctx, codingRuleInfo);
    }

    @Override
    protected String _addnewWithNoBingdingProperty(Context ctx, IObjectValue codingRuleInfo) throws BOSException, CodingRuleException, EASBizException {
        CodingRuleInfo cr = (CodingRuleInfo)codingRuleInfo;
        ICodingRule iCodingRule = CodingRuleFactory.getLocalInstance(ctx);
        if (!this.checkData(ctx, (CodingRuleInfo)codingRuleInfo)) {
            throw new CodingRuleException(CodingRuleException.ERROR_VALIDDATA);
        }
        IMaxSerial iMaxSerial = MaxSerialFactory.getLocalInstance(ctx);
        this.logger.debug((Object)("ctx.getAIS() : " + ctx.getAIS()));
        Calendar cal = Calendar.getInstance();
        cal.set(2198, 12, 31);
        Date disableDate = cal.getTime();
        cr.setDisabledDate(disableDate);
        IObjectPK ipk = iCodingRule.addnew((CoreBaseInfo)cr);
        for (int i = 0; i < cr.getCodingRuleEntrys().size(); ++i) {
            String codeAttribute = cr.getCodingRuleEntrys().get(i).getCodeAttribute();
            if (!codeAttribute.equals("sn") || cr.getCodingRuleEntrys().get(i).getMaxSerials().size() <= 0) continue;
            for (int j = 0; j < cr.getCodingRuleEntrys().get(i).getMaxSerials().size(); ++j) {
                iMaxSerial.addnew(cr.getCodingRuleEntrys().get(i).getMaxSerials().get(j));
            }
        }
        String crAppOrgID = cr.getAppOrgUnit() == null ? null : cr.getAppOrgUnit().getId().toString();
        CodingRuleCacheUtil.removeCodingRuleCache(cr.getBusinessObject(), crAppOrgID, 0, cr.getBindingProperty(), null);
        return ipk.toString();
    }

    private void updateEnabled(Context ctx, CodingRuleInfo cr, boolean enabled) throws BOSException, CodingRuleException, EASBizException {
        cr.setIsEnabled(enabled);
        if (enabled) {
            this.enabledCodingRule(ctx, cr);
        } else {
            cr.setDisabledDate(new Date());
        }
    }

    @Override
    protected String[] _getBatchNumber(Context ctx, IObjectValue caller, IObjectValue codingRuleInfo, int count) throws BOSException, CodingRuleException, EASBizException {
        ICodingRule iCodingRule = CodingRuleFactory.getLocalInstance(ctx);
        this.logger.debug((Object)"hello");
        return iCodingRule.getBatchNumber(caller, (CodingRuleInfo)codingRuleInfo, count);
    }

    @Override
    protected String[] _getBatchNumber(Context ctx, IObjectValue caller, String org, int count) throws BOSException, CodingRuleException, EASBizException {
        org = StringUtils.isEmpty((String)org) ? this._getCurrentAppOUID(ctx, caller) : org;
        ICodingRule iCodingRule = CodingRuleFactory.getLocalInstance(ctx);
        IObjectValue codingRuleInfo = this._getCodingRule(ctx, caller, org);
        if (codingRuleInfo != null) {
            return iCodingRule.getBatchNumber(caller, (CodingRuleInfo)codingRuleInfo, count);
        }
        throw this.throwNotExistRuleException(ctx, caller);
    }

    private CodingRuleException throwNotExistRuleException(Context ctx, IObjectValue caller) {
        String entityName = "";
        try {
            if (caller != null) {
                entityName = this.getMetaInfo(ctx, caller).getAlias(ctx.getOriginLocale());
            }
        }
        catch (Exception ex) {
            entityName = "";
        }
        return new CodingRuleException(CodingRuleException.ERROR_CR_NOTEXIST, new Object[]{entityName});
    }

    @Override
    protected String[] _getBatchNumber(Context ctx, IObjectValue caller, String org, String customString, int count) throws BOSException, CodingRuleException, EASBizException {
        IObjectValue codingRuleInfo = this._getCodingRule(ctx, caller, org = StringUtils.isEmpty((String)org) ? this._getCurrentAppOUID(ctx, caller) : org);
        if (codingRuleInfo != null) {
            return CodingRuleFactory.getLocalInstance(ctx).getBatchNumber(caller, (CodingRuleInfo)codingRuleInfo, customString, count);
        }
        throw this.throwNotExistRuleException(ctx, caller);
    }

    @Override
    protected String[] _getBatchNumber(Context ctx, IObjectValue caller, String org, String bindingproperty, String customString, int count) throws BOSException, CodingRuleException, EASBizException {
        IObjectValue codingRuleInfo = this._getCodingRule(ctx, caller, org = StringUtils.isEmpty((String)org) ? this._getCurrentAppOUID(ctx, caller) : org, bindingproperty);
        if (codingRuleInfo != null) {
            return CodingRuleFactory.getLocalInstance(ctx).getBatchNumber(caller, (CodingRuleInfo)codingRuleInfo, customString, count);
        }
        throw this.throwNotExistRuleException(ctx, caller);
    }

    @Override
    protected String[] _getBatchNumberFromInitialValue(Context ctx, IObjectValue caller, String org, String bindingproperty, String customString, int count) throws BOSException, CodingRuleException, EASBizException {
        IObjectValue codingRuleInfo = this._getCodingRule(ctx, caller, org = StringUtils.isEmpty((String)org) ? this._getCurrentAppOUID(ctx, caller) : org, bindingproperty);
        if (codingRuleInfo != null) {
            return CodingRuleFactory.getLocalInstance(ctx).getBatchNumberFromInitialValue(caller, (CodingRuleInfo)codingRuleInfo, customString, count);
        }
        throw this.throwNotExistRuleException(ctx, caller);
    }

    @Override
    protected String[] _getBatchNumberFromInitialValue(Context ctx, IObjectValue caller, String org, String customString, int count) throws BOSException, CodingRuleException, EASBizException {
        IObjectValue codingRuleInfo = this._getCodingRule(ctx, caller, org = StringUtils.isEmpty((String)org) ? this._getCurrentAppOUID(ctx, caller) : org);
        if (codingRuleInfo != null) {
            return CodingRuleFactory.getLocalInstance(ctx).getBatchNumberFromInitialValue(caller, (CodingRuleInfo)codingRuleInfo, customString, count);
        }
        throw this.throwNotExistRuleException(ctx, caller);
    }

    @Override
    protected String _getSimulateNumber(Context ctx, IObjectValue codingruleinfo) throws BOSException, CodingRuleException, EASBizException {
        try {
            ICodingRule iCodingRule = CodingRuleFactory.getLocalInstance(ctx);
            return iCodingRule.getSimulateNumber(null, (CodingRuleInfo)codingruleinfo);
        }
        catch (BOSException err) {
            this.logger.error((Object)err.getMessage(), (Throwable)err);
            throw err;
        }
    }

    @Override
    protected String _getSimulateNumber(Context ctx, IObjectValue caller, String org) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected String _getSimulateNumber(Context ctx, IObjectValue caller, String org, String bindingproperty) throws BOSException, EASBizException {
        return "";
    }

    @Override
    protected String _sumLength(Context ctx, IObjectValue codingruleinfo) throws BOSException, CodingRuleException, EASBizException {
        ICodingRule iCodingRule = CodingRuleFactory.getLocalInstance(ctx);
        return iCodingRule.sumLength((CodingRuleInfo)codingruleinfo);
    }

    @Override
    protected String _sumLength(Context ctx, IObjectValue caller, String org) throws BOSException, CodingRuleException, EASBizException {
        org = StringUtils.isEmpty((String)org) ? this._getCurrentAppOUID(ctx, caller) : org;
        ICodingRule iCodingRule = CodingRuleFactory.getLocalInstance(ctx);
        IObjectValue codingRuleInfo = this._getCodingRule(ctx, caller, org);
        if (codingRuleInfo != null) {
            return iCodingRule.sumLength((CodingRuleInfo)codingRuleInfo);
        }
        throw this.throwNotExistRuleException(ctx, caller);
    }

    @Override
    protected String _sumLength(Context ctx, IObjectValue caller, String org, String bindingproperty) throws BOSException, CodingRuleException, EASBizException {
        org = StringUtils.isEmpty((String)org) ? this._getCurrentAppOUID(ctx, caller) : org;
        ICodingRule iCodingRule = CodingRuleFactory.getLocalInstance(ctx);
        IObjectValue codingRuleInfo = this._getCodingRule(ctx, caller, org, bindingproperty);
        if (codingRuleInfo != null) {
            return iCodingRule.sumLength((CodingRuleInfo)codingRuleInfo);
        }
        throw this.throwNotExistRuleException(ctx, caller);
    }

    @Override
    protected String[] _getSortItems(Context ctx, IObjectValue caller, String org) throws BOSException, CodingRuleException, EASBizException {
        org = StringUtils.isEmpty((String)org) ? this._getCurrentAppOUID(ctx, caller) : org;
        ICodingRule iCodingRule = CodingRuleFactory.getLocalInstance(ctx);
        IObjectValue codingRuleInfo = this._getCodingRule(ctx, caller, org);
        if (codingRuleInfo != null) {
            return iCodingRule.getSortItems((CodingRuleInfo)codingRuleInfo);
        }
        throw this.throwNotExistRuleException(ctx, caller);
    }

    @Override
    protected String[] _getSortItems(Context ctx, IObjectValue caller, String org, String bindingproperty) throws BOSException, CodingRuleException, EASBizException {
        org = StringUtils.isEmpty((String)org) ? this._getCurrentAppOUID(ctx, caller) : org;
        ICodingRule iCodingRule = CodingRuleFactory.getLocalInstance(ctx);
        IObjectValue codingRuleInfo = this._getCodingRule(ctx, caller, org, bindingproperty);
        if (codingRuleInfo != null) {
            return iCodingRule.getSortItems((CodingRuleInfo)codingRuleInfo);
        }
        throw this.throwNotExistRuleException(ctx, caller);
    }

    @Override
    protected String[] _getProperties(Context ctx, IObjectValue caller, String org) throws BOSException, CodingRuleException, EASBizException {
        org = StringUtils.isEmpty((String)org) ? this._getCurrentAppOUID(ctx, caller) : org;
        ICodingRule iCodingRule = CodingRuleFactory.getLocalInstance(ctx);
        IObjectValue codingRuleInfo = this._getCodingRule(ctx, caller, org);
        if (codingRuleInfo != null) {
            return iCodingRule.getProperties((CodingRuleInfo)codingRuleInfo);
        }
        throw this.throwNotExistRuleException(ctx, caller);
    }

    @Override
    protected String[] _getProperties(Context ctx, IObjectValue caller, String org, String bindingproperty) throws BOSException, CodingRuleException, EASBizException {
        org = StringUtils.isEmpty((String)org) ? this._getCurrentAppOUID(ctx, caller) : org;
        ICodingRule iCodingRule = CodingRuleFactory.getLocalInstance(ctx);
        IObjectValue codingRuleInfo = this._getCodingRule(ctx, caller, org, bindingproperty);
        if (codingRuleInfo != null) {
            return iCodingRule.getProperties((CodingRuleInfo)codingRuleInfo);
        }
        throw this.throwNotExistRuleException(ctx, caller);
    }

    private boolean checkData(Context ctx, CodingRuleInfo codingruleinfo) throws BOSException, CodingRuleException, EASBizException {
        boolean isValid = true;
        codingruleinfo.setRuleType(codingruleinfo.getRuleType() == 0 ? 0 : 1);
        if (codingruleinfo.getRuleType() == 0 && codingruleinfo.isIsEnabled() && this._isExist(ctx, (IObjectValue)codingruleinfo)) {
            throw new CodingRuleException(CodingRuleException.ERROR_CR_ALREADYEXIST);
        }
        return isValid;
    }

    @Override
    protected String _getCurrentAppOUID(Context ctx, IObjectValue caller) throws EASBizException, BOSException {
        String org = null;
        EntityObjectInfo eo = this.getMetaInfo(ctx, caller);
        String orgType = eo.getExtendedProperty("OrgType");
        if (orgType == null || "NONE".equalsIgnoreCase(orgType)) {
            org = this.getDefaultOrgUnit(ctx);
            return org;
        }
        OrgType _orgType = OrgCommonUtils.getOrgType((String)orgType);
        OrgUnitInfo orgUnitInfo = ContextUtil.getCurrentOrgUnit((Context)ctx, (OrgType)_orgType);
        if (this.orgUnitIsValid(orgUnitInfo)) {
            org = String.valueOf(orgUnitInfo.getId());
            return org;
        }
        orgUnitInfo = ContextUtil.getCurrentOrgUnit((Context)ctx);
        org = this.orgUnitIsValid(orgUnitInfo) ? String.valueOf(orgUnitInfo.getId()) : this.getDefaultOrgUnit(ctx);
        return org;
    }

    private String getDefaultOrgUnit(Context ctx) throws BOSException, EASBizException {
        IFullOrgUnit iFullOrgUnit = FullOrgUnitFactory.getLocalInstance((Context)ctx);
        OrgUnitInfo OrgUnitInfo2 = iFullOrgUnit.getOrgUnitInfo((IObjectPK)new ObjectUuidPK("00000000-0000-0000-0000-000000000000CCE7AED4"));
        String org = String.valueOf(OrgUnitInfo2.getId());
        return org;
    }

    private boolean orgUnitIsValid(OrgUnitInfo orgUnitInfo) {
        return orgUnitInfo != null && orgUnitInfo.getId() != null;
    }

    private EntityObjectInfo getMetaInfo(Context ctx, IObjectValue caller) {
        IMetaDataLoader metaLoader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        EntityObjectInfo eo = null;
        if (caller != null) {
            eo = metaLoader.getEntity(caller.getBOSType());
        }
        return eo;
    }

    @Override
    protected String _readNumber(Context ctx, IObjectValue caller, String org) throws BOSException, CodingRuleException, EASBizException {
        return this.readNumber(ctx, caller, org, null);
    }

    @Override
    protected String _readNumber(Context ctx, IObjectValue caller, String org, String customString) throws BOSException, CodingRuleException, EASBizException {
        return this.readNumber(ctx, caller, org, null, customString);
    }

    @Override
    protected String _readNumber(Context ctx, IObjectValue caller, String org, String bindingproperty, String customString) throws BOSException, CodingRuleException, EASBizException {
        org = StringUtils.isEmpty((String)org) ? this._getCurrentAppOUID(ctx, caller) : org;
        ICodingRule iCodingRule = CodingRuleFactory.getLocalInstance(ctx);
        IObjectValue codingRuleInfo = this._getCodingRule(ctx, caller, org, bindingproperty);
        if (codingRuleInfo != null) {
            return iCodingRule.getNumber(caller, (CodingRuleInfo)codingRuleInfo, customString, true, false);
        }
        throw this.throwNotExistRuleException(ctx, caller);
    }

    @Override
    protected boolean _hasCuscomString(Context ctx, IObjectValue caller, String org) throws BOSException, CodingRuleException, EASBizException {
        org = StringUtils.isEmpty((String)org) ? this._getCurrentAppOUID(ctx, caller) : org;
        ICodingRule iCodingRule = CodingRuleFactory.getLocalInstance(ctx);
        IObjectValue codingRuleInfo = this._getCodingRule(ctx, caller, org);
        if (codingRuleInfo == null) {
            throw this.throwNotExistRuleException(ctx, caller);
        }
        return iCodingRule.hasCuscomString((CodingRuleInfo)codingRuleInfo);
    }

    @Override
    protected boolean _hasCuscomString(Context ctx, IObjectValue caller, String org, String bindingproperty) throws BOSException, CodingRuleException, EASBizException {
        org = StringUtils.isEmpty((String)org) ? this._getCurrentAppOUID(ctx, caller) : org;
        ICodingRule iCodingRule = CodingRuleFactory.getLocalInstance(ctx);
        IObjectValue codingRuleInfo = this._getCodingRule(ctx, caller, org, bindingproperty);
        if (codingRuleInfo == null) {
            throw this.throwNotExistRuleException(ctx, caller);
        }
        return iCodingRule.hasCuscomString((CodingRuleInfo)codingRuleInfo);
    }

    @Override
    protected String _getNonbreakNumber(Context ctx, IObjectValue caller, String org) throws BOSException, CodingRuleException, EASBizException {
        org = StringUtils.isEmpty((String)org) ? this._getCurrentAppOUID(ctx, caller) : org;
        ICodingRule iCodingRule = CodingRuleFactory.getLocalInstance(ctx);
        IObjectValue codingRuleInfo = this._getCodingRule(ctx, caller, org);
        if (codingRuleInfo != null) {
            return iCodingRule.getNumber(caller, (CodingRuleInfo)codingRuleInfo, false, true);
        }
        throw this.throwNotExistRuleException(ctx, caller);
    }

    @Override
    protected String _getNonbreakNumber(Context ctx, IObjectValue caller, String org, String customString) throws BOSException, CodingRuleException, EASBizException {
        org = StringUtils.isEmpty((String)org) ? this._getCurrentAppOUID(ctx, caller) : org;
        org = this._getCurrentAppOUID(ctx, caller);
        ICodingRule iCodingRule = CodingRuleFactory.getLocalInstance(ctx);
        IObjectValue codingRuleInfo = this._getCodingRule(ctx, caller, org);
        if (codingRuleInfo != null) {
            return iCodingRule.getNumber(caller, (CodingRuleInfo)codingRuleInfo, customString, false, true);
        }
        throw this.throwNotExistRuleException(ctx, caller);
    }

    @Override
    protected String _getNonbreakNumber(Context ctx, IObjectValue caller, String org, String bindingproperty, String customString) throws BOSException, CodingRuleException, EASBizException {
        org = StringUtils.isEmpty((String)org) ? this._getCurrentAppOUID(ctx, caller) : org;
        ICodingRule iCodingRule = CodingRuleFactory.getLocalInstance(ctx);
        IObjectValue codingRuleInfo = this._getCodingRule(ctx, caller, org, bindingproperty);
        if (codingRuleInfo != null) {
            return iCodingRule.getNumber(caller, (CodingRuleInfo)codingRuleInfo, customString, false, true);
        }
        throw this.throwNotExistRuleException(ctx, caller);
    }

    @Override
    protected boolean _isExist(Context ctx, IObjectValue crSource) throws BOSException, CodingRuleException, EASBizException {
        CodingRuleInfo cr = (CodingRuleInfo)crSource;
        String businessObject = cr.getBusinessObject();
        String org = cr.getAppOrgUnit().getId().toString();
        String propertyName = null;
        String propertyValue = null;
        if (cr.getBindingProperty() != null) {
            propertyName = cr.getBindingProperty().getPropertyName();
            propertyValue = cr.getBindingProperty().getPropertyValue();
        }
        String ruleId = null;
        ruleId = propertyName != null ? CodingRuleDAO.getCodingRuleInfoValue(ctx, businessObject, org, 0, propertyName, propertyValue) : CodingRuleDAO.getCodingRuleInfoValue(ctx, businessObject, org, 0);
        boolean exist = false;
        if (!StringUtils.isEmpty((String)ruleId)) {
            exist = true;
            CodingRuleInfo cInfo = CodingRuleFactory.getLocalInstance(ctx).getCodingRuleInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)ruleId)));
            if (StringUtils.isEmpty((String)cInfo.getCustomProperty())) {
                exist = false;
            }
        }
        return exist;
    }

    @Override
    protected boolean _isExist(Context ctx, IObjectValue caller, String org) throws BOSException, CodingRuleException, EASBizException {
        ParmCodingRule pcr = null;
        return this.isExist(ctx, caller, org, pcr);
    }

    @Override
    protected boolean _isExist(Context ctx, IObjectValue caller, String org, ParmCodingRule pcr) throws BOSException, EASBizException {
        return this.isExist(ctx, caller, org, null, pcr);
    }

    @Override
    protected boolean _isExist(Context ctx, IObjectValue caller, String org, String bindingproperty, ParmCodingRule pcr) throws BOSException, EASBizException {
        String bindingPropertyValue = null;
        String propertyValue = null;
        if (!StringUtils.isEmpty((String)bindingproperty)) {
            propertyValue = this.getPropertyValue(bindingproperty, caller);
        }
        org = StringUtils.isEmpty((String)org) ? this._getCurrentAppOUID(ctx, caller) : org;
        this.logger.error((Object)("current org is:" + org));
        EntityObjectInfo eo = this.getMetaInfo(ctx, caller);
        String businessObject = eo.getPackage() + "." + eo.getName();
        if (caller.getBOSType().toString().equals("8BBEC24B")) {
            bindingPropertyValue = this.propertyValueFromConfigXML(caller, eo, bindingproperty);
        }
        CodingRuleInfo cr = null;
        boolean exist = false;
        try {
            String ruleId;
            if (!StringUtils.isEmpty((String)bindingPropertyValue)) {
                cr = this.returncodingruleinfo(ctx, caller, businessObject, eo, org, bindingproperty, pcr);
            }
            if (cr == null && !StringUtils.isEmpty((String)(ruleId = CodingRuleDAO.getCodingRuleInfoValue(ctx, businessObject, org, 0, bindingproperty, propertyValue, pcr)))) {
                cr = CodingRuleFactory.getLocalInstance(ctx).getCodingRuleInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)ruleId)));
            }
            if (cr == null) {
                org = "00000000-0000-0000-0000-000000000000CCE7AED4";
                String defCuRuleId = CodingRuleDAO.getCodingRuleInfoValue(ctx, businessObject, org, 0, bindingproperty, propertyValue, pcr);
                if (!StringUtils.isEmpty((String)defCuRuleId)) {
                    cr = CodingRuleFactory.getLocalInstance(ctx).getCodingRuleInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)defCuRuleId)));
                }
                if (cr != null && !cr.isMultiOrgFirst()) {
                    exist = true;
                }
            } else {
                exist = true;
            }
            if (exist && cr.getSeqSegment() == null) {
                exist = true;
            }
            if (cr == null) {
                exist = false;
            }
        }
        catch (Exception err) {
            throw new BOSException(err.getMessage(), (Throwable)err);
        }
        return exist;
    }

    @Override
    protected boolean _isExist(Context ctx, IObjectValue caller, String org, String bindingproperty) throws BOSException, CodingRuleException, EASBizException {
        ParmCodingRule pcr = null;
        return this._isExist(ctx, caller, org, bindingproperty, pcr);
    }

    @Override
    protected RuleStatus _getRuleStatus(Context ctx, IObjectValue caller, String org) throws BOSException, CodingRuleException, EASBizException {
        return this._getRuleStatus(ctx, caller, org, null);
    }

    @Override
    protected RuleStatus _getRuleStatus(Context ctx, IObjectValue caller, String org, String bindingproperty) throws BOSException, CodingRuleException, EASBizException {
        return this._getRuleStatus(ctx, caller, org, bindingproperty, null);
    }

    @Override
    protected RuleStatus _getRuleStatus(Context ctx, IObjectValue caller, String org, String bindingproperty, ParmCodingRule customPro) throws BOSException, EASBizException {
        RuleStatus ruleStatus = new RuleStatus();
        CodingRuleInfo crInfo = null;
        crInfo = bindingproperty == null ? (CodingRuleInfo)this._getCodingRule(ctx, caller, org, customPro) : (CodingRuleInfo)this._getCodingRule(ctx, caller, org, bindingproperty, customPro);
        if (crInfo == null) {
            ruleStatus.setExist(false);
            return ruleStatus;
        }
        ruleStatus.setExist(true);
        ruleStatus.setAddView(crInfo.isIsAddView());
        ruleStatus.setModifiable(crInfo.isIsModifiable());
        ruleStatus.setUseIntermitNumber(crInfo.isIsMainRule());
        ruleStatus.setUserSelect(crInfo.isIsUserSelect());
        ruleStatus.setAddNoBreak(crInfo.isIsaddnewbreak());
        return ruleStatus;
    }

    private SeqSegmentEntryInfo getSegmentEntry(String attrValue, CodingRuleInfo cr) throws CodingRuleException, EASBizException, BOSException {
        SeqSegmentInfo segInfo = cr.getSeqSegment();
        if (attrValue == null || attrValue.trim().length() == 0) {
            return null;
        }
        SeqSegmentEntryCollection segInfos = segInfo.getEntries();
        SeqSegmentEntryInfo entryInfo = null;
        for (int index = 0; index < segInfos.size() && !attrValue.equalsIgnoreCase((entryInfo = segInfos.get(index)).getLinkID()); ++index) {
            entryInfo = null;
        }
        return entryInfo;
    }

    @Override
    protected boolean _isUseIntermitNumber(Context ctx, IObjectValue caller, String org, String bindingproperty) throws BOSException, CodingRuleException, EASBizException {
        org = StringUtils.isEmpty((String)org) ? this._getCurrentAppOUID(ctx, caller) : org;
        String propertyValue = this.getPropertyValue(bindingproperty, caller);
        EntityObjectInfo eo = this.getMetaInfo(ctx, caller);
        String businessObject = eo.getPackage() + "." + eo.getName();
        int imr = CodingRuleDAO.getCodingRuleForUseIntermitNumbeIsMainRule(ctx, businessObject, org, 0, bindingproperty, propertyValue);
        if (imr == -1) {
            org = "00000000-0000-0000-0000-000000000000CCE7AED4";
            int imr1 = CodingRuleDAO.getCodingRuleForUseIntermitNumbeIsMainRule(ctx, businessObject, org, 0, bindingproperty, propertyValue);
            if (imr1 > -1) {
                boolean flag = true;
                int isMainRule = imr1;
                return isMainRule == 1;
            }
            return false;
        }
        int isMainRule = imr;
        return isMainRule == 1;
    }

    @Override
    protected boolean _isUseIntermitNumber(Context ctx, IObjectValue caller, String org) throws BOSException, CodingRuleException, EASBizException {
        org = StringUtils.isEmpty((String)org) ? this._getCurrentAppOUID(ctx, caller) : org;
        EntityObjectInfo eo = this.getMetaInfo(ctx, caller);
        String businessObject = eo.getPackage() + "." + eo.getName();
        RowSet rowset = CodingRuleDAO.getCodingRuleForUseIntermitNumber(ctx, businessObject, org, 0);
        try {
            int isMainRule = 0;
            int isaddnewbreak = 0;
            if (!rowset.next()) {
                rowset.close();
                org = "00000000-0000-0000-0000-000000000000CCE7AED4";
                RowSet rowset1 = CodingRuleDAO.getCodingRuleForUseIntermitNumber(ctx, businessObject, org, 0);
                if (rowset1.next()) {
                    isMainRule = rowset1.getInt("FIsMainRule");
                    isaddnewbreak = rowset1.getInt("FIsaddnewbreak");
                    return isMainRule == 1 || isaddnewbreak == 1;
                }
                return false;
            }
            isMainRule = rowset.getInt("FIsMainRule");
            isaddnewbreak = rowset.getInt("FIsaddnewbreak");
            return isMainRule == 1 || isaddnewbreak == 1;
        }
        catch (SQLException err) {
            throw new BOSException(err.getMessage(), (Throwable)err);
        }
    }

    @Override
    protected boolean _isUseIntermitNumber(Context ctx, IObjectValue crSource) throws BOSException, CodingRuleException, EASBizException {
        ICodingRule iCodingRule = CodingRuleFactory.getLocalInstance(ctx);
        CodingRuleInfo cr = (CodingRuleInfo)crSource;
        FilterInfo filters = new FilterInfo();
        filters.getFilterItems().add(new FilterItemInfo("businessObject", (Object)cr.getBusinessObject(), CompareType.EQUALS));
        this.logger.debug((Object)("cr.getBusinessObject():" + cr.getBusinessObject()));
        if (cr.getAppOrgUnit() != null && cr.getAppOrgUnit().getId().toString().trim().length() > 0) {
            filters.getFilterItems().add(new FilterItemInfo("org", (Object)cr.getAppOrgUnit().getId().toString(), CompareType.EQUALS));
            this.logger.debug((Object)("cr.getOrg():" + cr.getAppOrgUnit().getId().toString()));
        }
        if (cr.getBindingProperty() == null) {
            filters.getFilterItems().add(new FilterItemInfo("bindingProperty", null, CompareType.EQUALS));
        } else {
            this.logger.debug((Object)("cr.getBindingProperty().getPropertyName():" + cr.getBindingProperty().getPropertyName()));
            this.logger.debug((Object)("cr.getBusinessObject():" + cr.getBindingProperty().getPropertyValue()));
            filters.getFilterItems().add(new FilterItemInfo("bindingProperty.propertyName", (Object)cr.getBindingProperty().getPropertyName(), CompareType.EQUALS));
            filters.getFilterItems().add(new FilterItemInfo("bindingProperty.propertyValue", (Object)cr.getBindingProperty().getPropertyValue(), CompareType.EQUALS));
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filters);
        evi.getSelector().add(new SelectorItemInfo("id"));
        CodingRuleCollection crl = iCodingRule.getCodingRuleCollection(evi);
        if (crl.size() > 0) {
            return crl.get(0).isIsMainRule() || crl.get(0).isIsaddnewbreak();
        }
        throw this.throwNotExistRuleException(ctx, null);
    }

    @Override
    protected boolean _recycleNumber(Context ctx, IObjectValue caller, String org, String number) throws BOSException, CodingRuleException, EASBizException {
        this.logger.error((Object)"begin recyclenumger(caller,org,number)");
        return this._recycleNumber(ctx, caller, org, null, null, number, null);
    }

    @Override
    protected boolean _recycleNumber(Context ctx, IObjectValue caller, String org, String customString, String number) throws BOSException, CodingRuleException, EASBizException {
        this.logger.error((Object)"begin recyclenumger(caller,org,customstring,number)");
        return this._recycleNumber(ctx, caller, org, null, customString, number, null);
    }

    @Override
    protected boolean _recycleNumber(Context ctx, IObjectValue caller, String org, String bindingproperty, String customString, String number) throws BOSException, CodingRuleException, EASBizException {
        this.logger.error((Object)"begin recyclenumger(caller,org,bindingproperty,customstring,number)");
        return this._recycleNumber(ctx, caller, org, bindingproperty, customString, number, null);
    }

    @Override
    protected boolean _recycleNumber(Context ctx, IObjectValue caller, String org, String bindingproperty, String customString, String number, ParmCodingRule cusPro) throws BOSException, EASBizException {
        this.logger.error((Object)"begin recyclenumger(caller,org,bindingproperty,customstring,number,cuspro)");
        org = StringUtils.isEmpty((String)org) ? this._getCurrentAppOUID(ctx, caller) : org;
        ICodingRule iCodingRule = CodingRuleFactory.getLocalInstance(ctx);
        IObjectValue codingRuleInfo = this._getCodingRule(ctx, caller, org, bindingproperty, cusPro);
        if (codingRuleInfo != null) {
            CodingRuleInfo info = (CodingRuleInfo)codingRuleInfo;
            this.logger.info((Object)("use codingrule number is" + info.getNumber()));
            if (info.isIsMainRule() || info.isIsaddnewbreak()) {
                boolean b = iCodingRule.recycleNumber(caller, info, customString, number);
                this.logger.error((Object)("boolean b is:" + String.valueOf(b)));
                return b;
            }
            return false;
        }
        throw this.throwNotExistRuleException(ctx, caller);
    }

    @Override
    protected IObjectCollection _getIntermitNumbers(Context ctx, IObjectValue caller, String org) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected IObjectCollection _getIntermitNumbers(Context ctx, IObjectValue caller, String org, String bindingproperty) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected Collection _getPropertyCollection(Context ctx, String bosType, String propertyName) throws BOSException, EASBizException {
        return null;
    }

    protected CodingRuleInfo getCodingRuleByCompany(Context ctx, IObjectValue caller, String org) throws BOSException, CodingRuleException, EASBizException {
        EntityObjectInfo eo = this.getMetaInfo(ctx, caller);
        String businessObject = eo.getPackage() + "." + eo.getName();
        String ruleId = CodingRuleDAO.getCodingRuleInfoValue(ctx, businessObject, org, 0);
        CodingRuleInfo cr = null;
        if (!StringUtils.isEmpty((String)ruleId)) {
            cr = CodingRuleAppUtils.createCodingRuleInfo(ctx, CodingRuleDAO.getCodingRuleInfoValueByID(ctx, ruleId));
        }
        return cr;
    }

    protected CodingRuleInfo getCodingRuleByOU(Context ctx, IObjectValue caller, String org) throws BOSException, CodingRuleException, EASBizException {
        EntityObjectInfo eo = this.getMetaInfo(ctx, caller);
        String businessObject = eo.getPackage() + "." + eo.getName();
        String ruleId = CodingRuleDAO.getCodingRuleInfoValue(ctx, businessObject, org, 0);
        CodingRuleInfo cr = null;
        if (!StringUtils.isEmpty((String)ruleId)) {
            cr = CodingRuleAppUtils.createCodingRuleInfo(ctx, CodingRuleDAO.getCodingRuleInfoValueByID(ctx, ruleId));
        }
        return cr;
    }

    @Override
    protected IObjectValue _getCodingRuleByName(Context ctx, String name) throws BOSException, CodingRuleException, EASBizException {
        ICodingRule iCodingRule = CodingRuleFactory.getLocalInstance(ctx);
        FilterInfo filters = new FilterInfo();
        filters.getFilterItems().add(new FilterItemInfo("Name", (Object)name, CompareType.EQUALS));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filters);
        evi.getSelector().add(new SelectorItemInfo("id"));
        CodingRuleCollection crl = iCodingRule.getCodingRuleCollection(evi);
        CodingRuleInfo cr = null;
        if (crl.size() > 1) {
            throw new CodingRuleException(CodingRuleException.ERROR_SAMENUMBERCR);
        }
        if (crl.size() == 1) {
            cr = CodingRuleAppUtils.createCodingRuleInfo(ctx, CodingRuleDAO.getCodingRuleInfoValueByID(ctx, crl.get(0).getId().toString()));
        }
        return cr;
    }

    private boolean hasBindingProperty(Context ctx, String bosType) {
        boolean hasBindingProperty = false;
        IMetaDataLoader metaLoader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        EntityObjectInfo meta = metaLoader.getEntity((IMetaDataPK)new MetaDataPK(bosType));
        PropertyCollection pc = meta.getInheritedProperties();
        block0: for (int i = 0; i < pc.size(); ++i) {
            PropertyInfo childproperty = pc.get(i);
            if (childproperty instanceof OwnPropertyInfo) {
                OwnPropertyInfo op = (OwnPropertyInfo)childproperty;
                if (op.getExtendedProperty("isBindingProperty") == null || !Boolean.valueOf(op.getExtendedProperty("isBindingProperty")).equals(Boolean.TRUE)) continue;
                hasBindingProperty = true;
                break;
            }
            if (!(childproperty instanceof LinkPropertyInfo)) continue;
            LinkPropertyInfo lp = (LinkPropertyInfo)childproperty;
            EntityObjectInfo propertyMeta = null;
            if ((lp.getRelationship().getSupplierObject().getPackage() + "." + lp.getRelationship().getSupplierObject().getName()).equals(bosType)) {
                if (lp.getRelationship().getClientCardinality().toString().trim().equals("1") && !(lp.getRelationship().getSupplierObject().getPackage() + "." + lp.getRelationship().getSupplierObject().getName()).equals(bosType)) {
                    propertyMeta = lp.getRelationship().getClientObject();
                }
            } else if (lp.getRelationship().getSupplierCardinality().toString().trim().equals("1") || lp.getRelationship().getSupplierCardinality().toString().trim().equals("0..1")) {
                propertyMeta = lp.getRelationship().getSupplierObject();
            }
            if (propertyMeta == null || lp.getExtendedProperty("isBindingProperty") == null || !Boolean.valueOf(lp.getExtendedProperty("isBindingProperty")).equals(Boolean.TRUE)) continue;
            PropertyCollection childpc = propertyMeta.getInheritedPropertiesRuntime();
            for (int j = 0; j < childpc.size(); ++j) {
                OwnPropertyInfo grandop;
                PropertyInfo grandproperty = childpc.get(j);
                if (!(grandproperty instanceof OwnPropertyInfo) || (grandop = (OwnPropertyInfo)grandproperty).getExtendedProperty("isBindingProperty") == null || !Boolean.valueOf(grandop.getExtendedProperty("isBindingProperty")).equals(Boolean.TRUE)) continue;
                hasBindingProperty = true;
                continue block0;
            }
        }
        return hasBindingProperty;
    }

    @Override
    protected boolean _hasTemplate(Context ctx, IObjectValue codingruleInfo) throws BOSException, CodingRuleException, EASBizException {
        CodingRuleInfo cr = (CodingRuleInfo)codingruleInfo;
        ICodingRule iCodingRule = CodingRuleFactory.getLocalInstance(ctx);
        FilterInfo filters = new FilterInfo();
        filters.getFilterItems().add(new FilterItemInfo("businessObject", (Object)cr.getBusinessObject(), CompareType.EQUALS));
        filters.getFilterItems().add(new FilterItemInfo("ruleType", (Object)"0", CompareType.NOTEQUALS));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filters);
        evi.getSelector().add(new SelectorItemInfo("id"));
        this.logger.debug((Object)evi.toString());
        CodingRuleCollection crl = iCodingRule.getCodingRuleCollection(evi);
        return crl.size() != 0;
    }

    @Override
    protected boolean _hasMaxValue(Context ctx, IObjectValue codingruleInfo) throws BOSException, CodingRuleException, EASBizException {
        CodingRuleInfo cr = (CodingRuleInfo)codingruleInfo;
        IMaxSerial iMaxSerial = MaxSerialFactory.getLocalInstance(ctx);
        for (int i = 0; i < cr.getCodingRuleEntrys().size(); ++i) {
            MaxSerialCollection msc;
            String codeAttribute = cr.getCodingRuleEntrys().get(i).getCodeAttribute();
            if (!codeAttribute.equals("sn") || cr.getCodingRuleEntrys().get(i).getId() == null || (msc = iMaxSerial.getCollection(cr.getCodingRuleEntrys().get(i).getId().toString(), "")).size() <= 0) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void _disabledCodingRule(Context ctx, String id) throws BOSException, CodingRuleException, EASBizException {
        CodingRuleInfo cr = CodingRuleFactory.getLocalInstance(ctx).getCodingRuleInfo((IObjectPK)new ObjectUuidPK(id));
        IObjectPK logPk = LogUtil.beginLogWithDescription((Context)ctx, (String)"disableCodingRule", (BOSObjectType)cr.getBOSType(), (IObjectPK)new ObjectStringPK(id), (String)(cr.getNumber().toString() + "  " + cr.getName().toString()), (String)ResourceBase.getString((String)"com.kingdee.eas.base.codingrule.CodingRuleResource.Msg_DisableCodingRule", (Locale)ctx.getOriginLocale()));
        if (cr.getSeqSegment() == null) {
            for (int index = 0; index < cr.getCodingRuleEntrys().size(); ++index) {
                CodingRuleEntryInfo creInfo = cr.getCodingRuleEntrys().get(index);
                if (!creInfo.getCodeAttribute().equalsIgnoreCase("sn")) continue;
                if (!"segment".equalsIgnoreCase(creInfo.getAttUsingMode())) break;
                throw new CodingRuleException(CodingRuleException.ERROR_SEGMENTINFOLACKATTR);
            }
        }
        CodingRuleDAO.disabledCodingRule(ctx, id);
        String crAppOrgID = cr.getAppOrgUnit() == null ? null : cr.getAppOrgUnit().getId().toString();
        CodingRuleCacheUtil.removeCodingRuleCache(cr.getBusinessObject(), crAppOrgID, 0, cr.getBindingProperty(), null);
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPk);
    }

    @Override
    protected void _enabledCodingRule(Context ctx, String id) throws BOSException, CodingRuleException, EASBizException {
        CodingRuleInfo cr = CodingRuleFactory.getLocalInstance(ctx).getCodingRuleInfo((IObjectPK)new ObjectUuidPK(id));
        IObjectPK logPk = LogUtil.beginLogWithDescription((Context)ctx, (String)"enableCodingRule", (BOSObjectType)cr.getBOSType(), (IObjectPK)new ObjectStringPK(id), (String)(cr.getNumber().toString() + "  " + cr.getName().toString()), (String)ResourceBase.getString((String)"com.kingdee.eas.base.codingrule.CodingRuleResource.Msg_EnableCodingRule", (Locale)ctx.getOriginLocale()));
        if (cr.getSeqSegment() == null) {
            for (int index = 0; index < cr.getCodingRuleEntrys().size(); ++index) {
                CodingRuleEntryInfo creInfo = cr.getCodingRuleEntrys().get(index);
                if (!creInfo.getCodeAttribute().equalsIgnoreCase("sn")) continue;
                if (!"segment".equalsIgnoreCase(creInfo.getAttUsingMode())) break;
                throw new CodingRuleException(CodingRuleException.ERROR_SEGMENTINFOLACKATTR);
            }
        }
        this.enabledCodingRule(ctx, cr);
        ICodingRule iCodingRule = CodingRuleFactory.getLocalInstance(ctx);
        ObjectUuidPK pk = new ObjectUuidPK(cr.getId());
        iCodingRule.update((IObjectPK)pk, (CoreBaseInfo)cr);
        String crAppOrgID = cr.getAppOrgUnit() == null ? null : cr.getAppOrgUnit().getId().toString();
        CodingRuleCacheUtil.removeCodingRuleCache(cr.getBusinessObject(), crAppOrgID, 0, cr.getBindingProperty(), null);
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPk);
    }

    private void enableCR(Context ctx, CodingRuleInfo cr, ICodingRule codRule, CodingRuleCollection codRuleCollection, EntityViewInfo evi, FilterInfo filter, Date disableDate) throws BOSException {
        if (codRuleCollection.size() != 0) {
            if (cr.isGroupFirst()) {
                this.doEnableCR(ctx, cr, codRuleCollection, disableDate);
            }
            if (cr.isOrgFirst()) {
                filter.getFilterItems().add(new FilterItemInfo("appOrgUnit", (Object)cr.getAppOrgUnit().getId().toString()));
                evi.setFilter(filter);
                codRuleCollection = codRule.getCodingRuleCollection(evi);
            }
            if (cr.isMultiOrgFirst()) {
                StringBuffer strOrgs = new StringBuffer("");
                for (int orgIndex = 0; orgIndex < cr.getMultiOrg().size(); ++orgIndex) {
                    if (cr.getMultiOrg().get(orgIndex).isIsMainOrg()) continue;
                    if (strOrgs.length() > 0) {
                        strOrgs.append(",");
                    }
                    strOrgs.append("" + cr.getMultiOrg().get(orgIndex).getAppOrgUnit().getId().toString() + "");
                }
                filter.getFilterItems().add(new FilterItemInfo("appOrgUnit", (Object)strOrgs.toString(), CompareType.INCLUDE));
                filter.getFilterItems().add(new FilterItemInfo("orgFirst", (Object)true));
                evi.setFilter(filter);
                codRuleCollection = codRule.getCodingRuleCollection(evi);
            }
        }
        this.doEnableCR(ctx, cr, codRuleCollection, disableDate);
    }

    private void doEnableCR(Context ctx, CodingRuleInfo cr, CodingRuleCollection codRuleCollection, Date disableDate) throws BOSException {
        if ((codRuleCollection = this.checkCol(codRuleCollection)).size() == 0) {
            cr.setIsEnabled(true);
            cr.setEnabledDate(new Date());
            cr.setDisabledDate(disableDate);
        } else {
            cr.setIsEnabled(true);
            cr.setEnabledDate(new Date());
            cr.setDisabledDate(disableDate);
            for (int i = 0; i < codRuleCollection.size(); ++i) {
                if (codRuleCollection.get(i).getBindingProExtent().size() != 0 && CodingRuleServerUtil.checkBindingProExtentInfo(ctx, codRuleCollection.get(i), cr) == null) continue;
                CodingRuleDAO.disabledCodingRule(ctx, codRuleCollection.get(i).getId().toString());
            }
        }
        String crAppOrgID = cr.getAppOrgUnit() == null ? null : cr.getAppOrgUnit().getId().toString();
        CodingRuleCacheUtil.removeCodingRuleCache(cr.getBusinessObject(), crAppOrgID, 0, cr.getBindingProperty(), null);
    }

    private void enabledCodingRule(Context ctx, CodingRuleInfo cr) throws BOSException, CodingRuleException, EASBizException {
        ICodingRule codRule = CodingRuleFactory.getLocalInstance(ctx);
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add("*");
        evi.getSelector().add("multiOrg.*");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("businessObjectID", (Object)cr.getBusinessObjectID()));
        filter.getFilterItems().add(new FilterItemInfo("isEnabled", (Object)true));
        evi.setFilter(filter);
        CodingRuleCollection codRuleCollection = codRule.getCodingRuleCollection(evi);
        Calendar cal = Calendar.getInstance();
        cal.set(2198, 12, 31);
        Date disableDate = cal.getTime();
        codRuleCollection = this.checkCol(codRuleCollection);
        if (codRuleCollection.size() == 0) {
            cr.setIsEnabled(true);
            cr.setEnabledDate(new Date());
            cr.setDisabledDate(disableDate);
        } else {
            if (cr.getBindingProperty() != null) {
                filter.getFilterItems().add(new FilterItemInfo("bindingProperty.propertyName", (Object)cr.getBindingProperty().getPropertyName()));
                filter.getFilterItems().add(new FilterItemInfo("bindingProperty.propertyValue", (Object)cr.getBindingProperty().getPropertyValue().toString()));
                evi.setFilter(filter);
                codRuleCollection = codRule.getCodingRuleCollection(evi);
            }
            if (cr.getBindingProExtent().size() > 0) {
                codRuleCollection = this._checkMoreAdapt(ctx, cr);
            }
            this.enableCR(ctx, cr, codRule, codRuleCollection, evi, filter, disableDate);
        }
    }

    private CodingRuleCollection checkCol(CodingRuleCollection codRuleCollection) {
        if (codRuleCollection != null && codRuleCollection.size() != 0) {
            ArrayList<CodingRuleInfo> ay = new ArrayList<CodingRuleInfo>();
            Iterator it = codRuleCollection.iterator();
            CodingRuleInfo crinfo = null;
            while (it.hasNext()) {
                crinfo = (CodingRuleInfo)it.next();
                if (crinfo.getCustomProperty() == null || StringUtils.isEmpty((String)crinfo.getCustomProperty())) continue;
                ay.add(crinfo);
            }
            if (ay != null && ay.size() != 0) {
                it = ay.iterator();
                while (it.hasNext()) {
                    codRuleCollection.remove((CodingRuleInfo)it.next());
                }
            }
        }
        return codRuleCollection;
    }

    @Override
    protected boolean _isAddView(Context ctx, IObjectValue crSource) throws BOSException, CodingRuleException, EASBizException {
        ICodingRule iCodingRule = CodingRuleFactory.getLocalInstance(ctx);
        CodingRuleInfo cr = (CodingRuleInfo)crSource;
        FilterInfo filters = new FilterInfo();
        filters.getFilterItems().add(new FilterItemInfo("businessObject", (Object)cr.getBusinessObject(), CompareType.EQUALS));
        this.logger.debug((Object)("cr.getBusinessObject():" + cr.getBusinessObject()));
        if (cr.getAppOrgUnit() != null && cr.getAppOrgUnit().getId().toString().trim().length() > 0) {
            filters.getFilterItems().add(new FilterItemInfo("org", (Object)cr.getAppOrgUnit().getId().toString(), CompareType.EQUALS));
            this.logger.debug((Object)("cr.getOrg():" + cr.getAppOrgUnit().getId().toString()));
        }
        if (cr.getBindingProperty() == null) {
            filters.getFilterItems().add(new FilterItemInfo("bindingProperty", null, CompareType.EQUALS));
        } else {
            this.logger.debug((Object)("cr.getBindingProperty().getPropertyName():" + cr.getBindingProperty().getPropertyName()));
            this.logger.debug((Object)("cr.getBusinessObject():" + cr.getBindingProperty().getPropertyValue()));
            filters.getFilterItems().add(new FilterItemInfo("bindingProperty.propertyName", (Object)cr.getBindingProperty().getPropertyName(), CompareType.EQUALS));
            filters.getFilterItems().add(new FilterItemInfo("bindingProperty.propertyValue", (Object)cr.getBindingProperty().getPropertyValue(), CompareType.EQUALS));
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filters);
        evi.getSelector().add(new SelectorItemInfo("id"));
        CodingRuleCollection crl = iCodingRule.getCodingRuleCollection(evi);
        if (crl.size() > 0) {
            return crl.get(0).isIsAddView();
        }
        throw this.throwNotExistRuleException(ctx, null);
    }

    @Override
    protected boolean _isAddView(Context ctx, IObjectValue caller, String org) throws BOSException, CodingRuleException, EASBizException {
        org = StringUtils.isEmpty((String)org) ? this._getCurrentAppOUID(ctx, caller) : org;
        EntityObjectInfo eo = this.getMetaInfo(ctx, caller);
        String businessObject = eo.getPackage() + "." + eo.getName();
        RowSet rowset = CodingRuleDAO.getCodingRuleForIsAddView(ctx, businessObject, org, 0);
        try {
            boolean flag = false;
            int isAddView = 0;
            if (!rowset.next()) {
                rowset.close();
                org = "00000000-0000-0000-0000-000000000000CCE7AED4";
                RowSet rowset1 = CodingRuleDAO.getCodingRuleForIsAddView(ctx, businessObject, org, 0);
                if (rowset1.next()) {
                    flag = true;
                    isAddView = rowset1.getInt("FisAddView");
                } else {
                    flag = false;
                }
            } else {
                flag = true;
                isAddView = rowset.getInt("FisAddView");
            }
            if (!flag) {
                throw this.throwNotExistRuleException(ctx, caller);
            }
            return isAddView == 1;
        }
        catch (SQLException err) {
            throw new BOSException(err.getMessage(), (Throwable)err);
        }
    }

    @Override
    protected boolean _isAddView(Context ctx, IObjectValue caller, String org, String bindingproperty) throws BOSException, CodingRuleException, EASBizException {
        org = StringUtils.isEmpty((String)org) ? this._getCurrentAppOUID(ctx, caller) : org;
        String propertyValue = this.getPropertyValue(bindingproperty, caller);
        EntityObjectInfo eo = this.getMetaInfo(ctx, caller);
        String businessObject = eo.getPackage() + "." + eo.getName();
        RowSet rowset = CodingRuleDAO.getCodingRuleForIsAddView(ctx, businessObject, org, 0, bindingproperty, propertyValue);
        try {
            boolean flag = false;
            int isAddView = 0;
            if (!rowset.next()) {
                rowset.close();
                org = "00000000-0000-0000-0000-000000000000CCE7AED4";
                RowSet rowset1 = CodingRuleDAO.getCodingRuleForIsAddView(ctx, businessObject, org, 0, bindingproperty, propertyValue);
                if (rowset1.next()) {
                    flag = true;
                    isAddView = rowset1.getInt("FisAddView");
                } else {
                    flag = false;
                }
            } else {
                flag = true;
                isAddView = rowset.getInt("FisAddView");
            }
            if (!flag) {
                throw this.throwNotExistRuleException(ctx, caller);
            }
            return isAddView == 1;
        }
        catch (SQLException err) {
            throw new BOSException(err.getMessage(), (Throwable)err);
        }
    }

    @Override
    protected boolean _isModifiable(Context ctx, IObjectValue crSource) throws BOSException, CodingRuleException, EASBizException {
        ICodingRule iCodingRule = CodingRuleFactory.getLocalInstance(ctx);
        CodingRuleInfo cr = (CodingRuleInfo)crSource;
        FilterInfo filters = new FilterInfo();
        filters.getFilterItems().add(new FilterItemInfo("businessObject", (Object)cr.getBusinessObject(), CompareType.EQUALS));
        this.logger.debug((Object)("cr.getBusinessObject():" + cr.getBusinessObject()));
        if (cr.getAppOrgUnit() != null && cr.getAppOrgUnit().getId().toString().trim().length() > 0) {
            filters.getFilterItems().add(new FilterItemInfo("org", (Object)cr.getAppOrgUnit().getId().toString(), CompareType.EQUALS));
            this.logger.debug((Object)("cr.getOrg():" + cr.getAppOrgUnit().getId().toString()));
        }
        if (cr.getBindingProperty() == null) {
            filters.getFilterItems().add(new FilterItemInfo("bindingProperty", null, CompareType.EQUALS));
        } else {
            this.logger.debug((Object)("cr.getBindingProperty().getPropertyName():" + cr.getBindingProperty().getPropertyName()));
            this.logger.debug((Object)("cr.getBusinessObject():" + cr.getBindingProperty().getPropertyValue()));
            filters.getFilterItems().add(new FilterItemInfo("bindingProperty.propertyName", (Object)cr.getBindingProperty().getPropertyName(), CompareType.EQUALS));
            filters.getFilterItems().add(new FilterItemInfo("bindingProperty.propertyValue", (Object)cr.getBindingProperty().getPropertyValue(), CompareType.EQUALS));
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filters);
        evi.getSelector().add(new SelectorItemInfo("id"));
        CodingRuleCollection crl = iCodingRule.getCodingRuleCollection(evi);
        if (crl.size() > 0) {
            return crl.get(0).isIsModifiable();
        }
        throw this.throwNotExistRuleException(ctx, null);
    }

    @Override
    protected boolean _isModifiable(Context ctx, IObjectValue caller, String org) throws BOSException, CodingRuleException, EASBizException {
        org = StringUtils.isEmpty((String)org) ? this._getCurrentAppOUID(ctx, caller) : org;
        EntityObjectInfo eo = this.getMetaInfo(ctx, caller);
        String businessObject = eo.getPackage() + "." + eo.getName();
        RowSet rowset = CodingRuleDAO.getCodingRuleForIsModifiable(ctx, businessObject, org, 0);
        try {
            boolean flag = false;
            int isModifiable = 0;
            if (!rowset.next()) {
                rowset.close();
                org = "00000000-0000-0000-0000-000000000000CCE7AED4";
                RowSet rowset1 = CodingRuleDAO.getCodingRuleForIsModifiable(ctx, businessObject, org, 0);
                if (rowset1.next()) {
                    flag = true;
                    isModifiable = rowset1.getInt("FisModifiable");
                } else {
                    flag = false;
                }
            } else {
                flag = true;
                isModifiable = rowset.getInt("FisModifiable");
            }
            if (!flag) {
                throw this.throwNotExistRuleException(ctx, caller);
            }
            return isModifiable == 1;
        }
        catch (SQLException err) {
            throw new BOSException(err.getMessage(), (Throwable)err);
        }
    }

    @Override
    protected boolean _isModifiable(Context ctx, IObjectValue caller, String org, String bindingproperty) throws BOSException, CodingRuleException, EASBizException {
        org = StringUtils.isEmpty((String)org) ? this._getCurrentAppOUID(ctx, caller) : org;
        String propertyValue = this.getPropertyValue(bindingproperty, caller);
        EntityObjectInfo eo = this.getMetaInfo(ctx, caller);
        String businessObject = eo.getPackage() + "." + eo.getName();
        RowSet rowset = CodingRuleDAO.getCodingRuleForIsModifiable(ctx, businessObject, org, 0, bindingproperty, propertyValue);
        try {
            boolean flag = false;
            int isModifiable = 0;
            if (!rowset.next()) {
                rowset.close();
                org = "00000000-0000-0000-0000-000000000000CCE7AED4";
                RowSet rowset1 = CodingRuleDAO.getCodingRuleForIsModifiable(ctx, businessObject, org, 0, bindingproperty, propertyValue);
                if (rowset1.next()) {
                    flag = true;
                    isModifiable = rowset1.getInt("FisModifiable");
                } else {
                    flag = false;
                }
            } else {
                flag = true;
                isModifiable = rowset.getInt("FisModifiable");
            }
            if (!flag) {
                throw this.throwNotExistRuleException(ctx, caller);
            }
            return isModifiable == 1;
        }
        catch (SQLException err) {
            throw new BOSException(err.getMessage(), (Throwable)err);
        }
    }

    @Override
    protected boolean _isUserSelect(Context ctx, IObjectValue crSource) throws BOSException, CodingRuleException, EASBizException {
        ICodingRule iCodingRule = CodingRuleFactory.getLocalInstance(ctx);
        CodingRuleInfo cr = (CodingRuleInfo)crSource;
        FilterInfo filters = new FilterInfo();
        filters.getFilterItems().add(new FilterItemInfo("businessObject", (Object)cr.getBusinessObject(), CompareType.EQUALS));
        this.logger.debug((Object)("cr.getBusinessObject():" + cr.getBusinessObject()));
        if (cr.getAppOrgUnit() != null && cr.getAppOrgUnit().getId().toString().trim().length() > 0) {
            filters.getFilterItems().add(new FilterItemInfo("org", (Object)cr.getAppOrgUnit().getId().toString(), CompareType.EQUALS));
            this.logger.debug((Object)("cr.getOrg():" + cr.getAppOrgUnit().getId().toString()));
        }
        if (cr.getBindingProperty() == null) {
            filters.getFilterItems().add(new FilterItemInfo("bindingProperty", null, CompareType.EQUALS));
        } else {
            this.logger.debug((Object)("cr.getBindingProperty().getPropertyName():" + cr.getBindingProperty().getPropertyName()));
            this.logger.debug((Object)("cr.getBusinessObject():" + cr.getBindingProperty().getPropertyValue()));
            filters.getFilterItems().add(new FilterItemInfo("bindingProperty.propertyName", (Object)cr.getBindingProperty().getPropertyName(), CompareType.EQUALS));
            filters.getFilterItems().add(new FilterItemInfo("bindingProperty.propertyValue", (Object)cr.getBindingProperty().getPropertyValue(), CompareType.EQUALS));
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filters);
        evi.getSelector().add(new SelectorItemInfo("id"));
        CodingRuleCollection crl = iCodingRule.getCodingRuleCollection(evi);
        if (crl.size() > 0) {
            return crl.get(0).isIsUserSelect();
        }
        throw this.throwNotExistRuleException(ctx, null);
    }

    @Override
    protected boolean _isUserSelect(Context ctx, IObjectValue caller, String org) throws EASBizException, BOSException {
        org = StringUtils.isEmpty((String)org) ? this._getCurrentAppOUID(ctx, caller) : org;
        EntityObjectInfo eo = this.getMetaInfo(ctx, caller);
        String businessObject = eo.getPackage() + "." + eo.getName();
        RowSet rowset = CodingRuleDAO.getCodingRuleForIsUserSelect(ctx, businessObject, org, 0);
        try {
            boolean flag = false;
            int isUserSelect = 0;
            if (!rowset.next()) {
                rowset.close();
                org = "00000000-0000-0000-0000-000000000000CCE7AED4";
                RowSet rowset1 = CodingRuleDAO.getCodingRuleForIsUserSelect(ctx, businessObject, org, 0);
                if (rowset1.next()) {
                    flag = true;
                    isUserSelect = rowset1.getInt("FisUserSelect");
                } else {
                    flag = false;
                }
            } else {
                flag = true;
                isUserSelect = rowset.getInt("FisUserSelect");
            }
            if (!flag) {
                throw this.throwNotExistRuleException(ctx, caller);
            }
            return isUserSelect == 1;
        }
        catch (SQLException err) {
            throw new BOSException(err.getMessage(), (Throwable)err);
        }
    }

    @Override
    protected boolean _isUserSelect(Context ctx, IObjectValue caller, String org, String bindingproperty) throws BOSException, CodingRuleException, EASBizException {
        org = StringUtils.isEmpty((String)org) ? this._getCurrentAppOUID(ctx, caller) : org;
        String propertyValue = this.getPropertyValue(bindingproperty, caller);
        EntityObjectInfo eo = this.getMetaInfo(ctx, caller);
        String businessObject = eo.getPackage() + "." + eo.getName();
        RowSet rowset = CodingRuleDAO.getCodingRuleForIsUserSelect(ctx, businessObject, org, 0, bindingproperty, propertyValue);
        try {
            boolean flag = false;
            int isUserSelect = 0;
            if (!rowset.next()) {
                rowset.close();
                org = "00000000-0000-0000-0000-000000000000CCE7AED4";
                RowSet rowset1 = CodingRuleDAO.getCodingRuleForIsUserSelect(ctx, businessObject, org, 0, bindingproperty, propertyValue);
                if (rowset1.next()) {
                    flag = true;
                    isUserSelect = rowset1.getInt("FisUserSelect");
                } else {
                    flag = false;
                }
            } else {
                flag = true;
                isUserSelect = rowset.getInt("FisUserSelect");
            }
            if (!flag) {
                throw this.throwNotExistRuleException(ctx, caller);
            }
            return isUserSelect == 1;
        }
        catch (SQLException err) {
            throw new BOSException(err.getMessage(), (Throwable)err);
        }
    }

    public String getPropertyValue(String propertyName, IObjectValue caller) throws BOSException, CodingRuleException, EASBizException {
        this.logger.debug((Object)"checkProperty : ");
        this.logger.debug((Object)("   propertyName : " + propertyName));
        String[] properties = propertyName.split("\\.");
        if (properties.length == 1) {
            if (!caller.containsKey(properties[0])) {
                throw new CodingRuleException(CodingRuleException.ERROR_REFERENCE_PROPERTY_NOTEXIST, new Object[]{properties[0]});
            }
            this.logger.debug((Object)("   propertyValue : " + caller.get(properties[0]).toString().trim()));
            return this.dealPropertyValue(caller, propertyName);
        }
        if (properties.length == 2) {
            this.logger.debug((Object)("   property[0] : " + properties[0]));
            this.logger.debug((Object)("   property[1] : " + properties[1].toString().trim()));
            this.logger.debug((Object)("   caller.getClass().getName() : " + caller.getClass().getName()));
            if (!caller.containsKey(properties[0])) {
                throw new CodingRuleException(CodingRuleException.ERROR_REFERENCE_PROPERTY_NOTEXIST, new Object[]{properties[0]});
            }
            Object obj = caller.get(properties[0]);
            this.logger.debug((Object)("properties[0]: " + properties[0]));
            if (!(obj instanceof IObjectValue)) {
                this.logger.debug((Object)("obj.getClass().getName(): " + obj.getClass().getName()));
                throw new CodingRuleException(CodingRuleException.ERROR_PROPERTY_INVALID);
            }
            IObjectValue propertyObj = (IObjectValue)obj;
            if (!propertyObj.containsKey(properties[1])) {
                throw new CodingRuleException(CodingRuleException.ERROR_REFERENCE_PROPERTY_NOTEXIST, new Object[]{properties[1]});
            }
            if (propertyObj.get(properties[1]) instanceof IObjectValue) {
                throw new CodingRuleException(CodingRuleException.ERROR_PROPERTY_INVALID);
            }
            return this.dealPropertyValue(propertyObj, properties[1]);
        }
        if (properties.length > 2) {
            throw new CodingRuleException(CodingRuleException.ERROR_PROPERTY_INVALID);
        }
        throw new CodingRuleException(CodingRuleException.ERROR_PROPERTY_NULL);
    }

    private String dealPropertyValue(IObjectValue caller, String propertyName) {
        String propertyValue = "";
        if (caller.get(propertyName) != null && !StringUtils.isEmpty((String)(propertyValue = caller.get(propertyName).toString())) && caller.get(propertyName) instanceof Boolean) {
            if (((Boolean)caller.get(propertyName)).booleanValue()) {
                return "1";
            }
            return "0";
        }
        return propertyValue;
    }

    @Override
    protected boolean _checkModifiedNumber(Context ctx, IObjectValue caller, String org, String number) throws BOSException, CodingRuleException, EASBizException {
        org = StringUtils.isEmpty((String)org) ? this._getCurrentAppOUID(ctx, caller) : org;
        ICodingRule iCodingRule = CodingRuleFactory.getLocalInstance(ctx);
        IObjectValue codingRuleInfo = this._getCodingRule(ctx, caller, org);
        if (codingRuleInfo != null) {
            CodingRuleInfo info = (CodingRuleInfo)codingRuleInfo;
            if (info.isIsModifiable()) {
                return iCodingRule.checkModifiedNumber(caller, info, number);
            }
            return false;
        }
        throw this.throwNotExistRuleException(ctx, caller);
    }

    @Override
    protected boolean _isDHExist(Context ctx, IObjectValue caller, String org) throws BOSException, CodingRuleException, EASBizException {
        CodingRuleInfo cr = (CodingRuleInfo)this._getCodingRule(ctx, caller, org);
        boolean flag = false;
        for (int i = 0; i < cr.getCodingRuleEntrys().size(); ++i) {
            String codeAttribute = cr.getCodingRuleEntrys().get(i).getCodeAttribute();
            if (!"sn".equals(codeAttribute)) continue;
            IIntermilNO iIntermilNO = IntermilNOFactory.getLocalInstance(ctx);
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("codingRuleEntry.id", (Object)cr.getCodingRuleEntrys().get(i).getId().toString()));
            evi.setFilter(filter);
            IntermilNOCollection asdf = iIntermilNO.getIntermilNOCollection(evi);
            if (asdf.size() <= 0) continue;
            flag = true;
        }
        return flag;
    }

    @Override
    protected boolean _isDHExist(Context ctx, IObjectValue caller, String org, String bindingProperty) throws BOSException, CodingRuleException, EASBizException {
        CodingRuleInfo cr = (CodingRuleInfo)this._getCodingRule(ctx, caller, org, bindingProperty);
        boolean flag = false;
        for (int i = 0; i < cr.getCodingRuleEntrys().size(); ++i) {
            String codeAttribute = cr.getCodingRuleEntrys().get(i).getCodeAttribute();
            if (!"sn".equals(codeAttribute)) continue;
            IIntermilNO iIntermilNO = IntermilNOFactory.getLocalInstance(ctx);
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("codingRuleEntry.id", (Object)cr.getCodingRuleEntrys().get(i).getId().toString()));
            evi.setFilter(filter);
            IntermilNOCollection asdf = iIntermilNO.getIntermilNOCollection(evi);
            if (asdf.size() <= 0) continue;
            flag = true;
        }
        return flag;
    }

    @Override
    protected boolean _checkModifiedNumber(Context ctx, IObjectValue caller, String org, String number, String bindingProperty) throws BOSException, CodingRuleException, EASBizException {
        org = StringUtils.isEmpty((String)org) ? this._getCurrentAppOUID(ctx, caller) : org;
        ICodingRule iCodingRule = CodingRuleFactory.getLocalInstance(ctx);
        IObjectValue codingRuleInfo = this._getCodingRule(ctx, caller, org, bindingProperty);
        if (codingRuleInfo != null) {
            CodingRuleInfo info = (CodingRuleInfo)codingRuleInfo;
            if (info.isIsModifiable()) {
                return iCodingRule.checkModifiedNumber(caller, info, number);
            }
            return false;
        }
        throw this.throwNotExistRuleException(ctx, caller);
    }

    @Override
    protected void _controlCustomProperty(Context ctx, CodingRuleInfo enableinfo) throws BOSException {
        try {
            ICodingRule icr = CodingRuleFactory.getLocalInstance(ctx);
            if (enableinfo.isIsEnabled()) {
                CodingRuleCollection col;
                StringBuilder oql = new StringBuilder();
                oql.append("select *,multiOrg.* where businessObjectID = '").append(enableinfo.getBusinessObjectID()).append("' and customProperty = '").append(enableinfo.getCustomProperty()).append("' and customPropertyName = '").append(enableinfo.getCustomPropertyName()).append("' and isEnabled = 1");
                if (enableinfo.getBindingProperty() != null) {
                    oql.append(" and bindingProperty.propertyName = '").append(enableinfo.getBindingProperty().getPropertyName()).append("' ").append(" and bindingProperty.propertyValue = '").append(enableinfo.getBindingProperty().getPropertyValue()).append("' ");
                }
                if ((col = icr.getCodingRuleCollection(oql.toString())).size() != 0) {
                    Iterator it = col.iterator();
                    while (it.hasNext()) {
                        CodingRuleInfo info = (CodingRuleInfo)it.next();
                        if (enableinfo.isOrgFirst() && info.isMultiOrgFirst() || info.getBindingProExtent().size() != 0 && CodingRuleServerUtil.checkBindingProExtentInfo(ctx, info, enableinfo) == null) continue;
                        info.setIsEnabled(false);
                        info.setDisabledDate(new Date());
                        icr.submit((CoreBaseInfo)info);
                    }
                }
                Calendar cal = Calendar.getInstance();
                cal.set(2198, 12, 31);
                Date disableDate = cal.getTime();
                enableinfo.setDisabledDate(disableDate);
            }
            icr.submit((CoreBaseInfo)enableinfo);
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected String _getNumber(Context ctx, IObjectValue caller, String org, long number) throws BOSException, CodingRuleException, EASBizException {
        return this._getNumber(ctx, caller, org, null, null, number);
    }

    @Override
    protected String _getNumber(Context ctx, IObjectValue caller, String org, String customString, long number) throws BOSException, CodingRuleException, EASBizException {
        return this._getNumber(ctx, caller, org, null, customString, number);
    }

    @Override
    protected String _getNumber(Context ctx, IObjectValue caller, String org, String bindingproperty, String customString, long number) throws BOSException, CodingRuleException, EASBizException {
        org = StringUtils.isEmpty((String)org) ? this._getCurrentAppOUID(ctx, caller) : org;
        this.logger.info((Object)("org is:" + org));
        ICodingRule iCodingRule = CodingRuleFactory.getLocalInstance(ctx);
        IObjectValue codingRuleInfo = this._getCodingRule(ctx, caller, org, bindingproperty);
        if (codingRuleInfo != null) {
            CodingRuleInfo info = (CodingRuleInfo)codingRuleInfo;
            this.logger.info((Object)("use codingrule is:" + info.getNumber()));
            InnerJTATransaction syn = new InnerJTATransaction(ctx, caller, org, bindingproperty, customString, "");
            try {
                this.logger.error((Object)("current codingrule:" + info.getId() + ", registerSynchronization()"));
                this.getCurrTransaction().registerSynchronization((Synchronization)syn);
                String _number = "";
                syn.number = _number = iCodingRule.getNumber(caller, (IObjectValue)info, customString, false, true, number);
                return _number;
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
        throw this.throwNotExistRuleException(ctx, caller);
    }

    @Override
    protected String _getNumber(Context ctx, IObjectValue caller, IObjectValue codingRuleInfo) throws BOSException, CodingRuleException, EASBizException {
        return this._getNumber(ctx, caller, codingRuleInfo, null);
    }

    private String _getNumber(Context ctx, IObjectValue caller, IObjectValue codingRuleInfo, String customString) throws BOSException, CodingRuleException, EASBizException {
        ICodingRule iCodingRule = CodingRuleFactory.getLocalInstance(ctx);
        String number = "";
        if (codingRuleInfo != null) {
            CodingRuleInfo info = (CodingRuleInfo)codingRuleInfo;
            this.logger.info((Object)("codingrule getnumber properties information:bostype (" + caller.getBOSType() + ") codingRuleInfo.getid (" + info.getId().toString() + ") customString (" + customString + ")"));
            if (info.isIsMainRule() || info.isIsaddnewbreak()) {
                String _org = this._getCurrentAppOUID(ctx, caller);
                InnerJTATransaction syn = new InnerJTATransaction(ctx, caller, _org, info.getBindingProperty() == null ? null : info.getBindingProperty().getPropertyName(), customString, number);
                try {
                    this.logger.error((Object)("current codingrule:" + info.getId() + ", registerSynchronization()"));
                    this.getCurrTransaction().registerSynchronization((Synchronization)syn);
                    syn.number = number = iCodingRule.getNumber(caller, info, customString, false, true);
                }
                catch (Exception e) {
                    throw new BOSException((Throwable)e);
                }
                this.logger.info((Object)("codingrule getnumber is :" + number));
                return number;
            }
            number = iCodingRule.getNumber(caller, info, customString, false, false);
            this.logger.info((Object)("codingrule getnumber is :" + number));
            return number;
        }
        throw this.throwNotExistRuleException(ctx, caller);
    }

    @Override
    protected String _getNumber(Context ctx, IObjectValue caller, String org) throws BOSException, CodingRuleException, EASBizException {
        org = StringUtils.isEmpty((String)org) ? this._getCurrentAppOUID(ctx, caller) : org;
        IObjectValue codingRuleInfo = this._getCodingRule(ctx, caller, org);
        return this._getNumber(ctx, caller, codingRuleInfo);
    }

    @Override
    protected String _getNumber(Context ctx, IObjectValue caller, String org, String customString) throws BOSException, CodingRuleException, EASBizException {
        org = StringUtils.isEmpty((String)org) ? this._getCurrentAppOUID(ctx, caller) : org;
        IObjectValue codingRuleInfo = this._getCodingRule(ctx, caller, org);
        return this._getNumber(ctx, caller, codingRuleInfo, customString);
    }

    @Override
    protected String _getNumber(Context ctx, IObjectValue caller, String org, String bindingproperty, String customString) throws BOSException, CodingRuleException, EASBizException {
        org = StringUtils.isEmpty((String)org) ? this._getCurrentAppOUID(ctx, caller) : org;
        IObjectValue codingRuleInfo = this._getCodingRule(ctx, caller, org, bindingproperty);
        return this._getNumber(ctx, caller, codingRuleInfo, customString);
    }

    @Override
    protected String _getNumber(Context ctx, IObjectValue caller, String org, ParmCodingRule customProperty) throws BOSException, EASBizException {
        return this._getNumber(ctx, caller, org, null, customProperty);
    }

    @Override
    protected String _getNumber(Context ctx, IObjectValue caller, String org, String customString, ParmCodingRule customProperty) throws BOSException, EASBizException {
        return this._getNumber(ctx, caller, org, null, customString, customProperty);
    }

    @Override
    protected String _getNumber(Context ctx, IObjectValue caller, String org, String bindingproperty, String customString, ParmCodingRule customProperty) throws BOSException, EASBizException {
        org = StringUtils.isEmpty((String)org) ? this._getCurrentAppOUID(ctx, caller) : org;
        IObjectValue codingRuleInfo = this._getCodingRule(ctx, caller, org, bindingproperty, customProperty);
        return this._getNumber(ctx, caller, codingRuleInfo, customString);
    }

    @Override
    protected IObjectValue _getCodingRule(Context ctx, IObjectValue caller, String org, ParmCodingRule customProperty) throws BOSException, CodingRuleException, EASBizException {
        return this._getCodingRule(ctx, caller, org, null, customProperty);
    }

    @Override
    protected IObjectValue _getCodingRule(Context ctx, IObjectValue caller, String org) throws BOSException, CodingRuleException, EASBizException {
        ParmCodingRule hashMap = null;
        return this._getCodingRule(ctx, caller, org, hashMap);
    }

    @Override
    protected IObjectValue _getCodingRule(Context ctx, IObjectValue caller, String org, String bindingproperty) throws BOSException, CodingRuleException, EASBizException {
        ParmCodingRule hashMap = null;
        return this._getCodingRule(ctx, caller, org, bindingproperty, hashMap);
    }

    @Override
    protected IObjectValue _getCodingRule(Context ctx, IObjectValue caller, String org, String bindingproperty, ParmCodingRule customProperty) throws BOSException, CodingRuleException, EASBizException {
        if (org == null || org.length() < 1) {
            return null;
        }
        CodingRuleInfo cr = null;
        cr = this.getCodingRuleByOU(ctx, caller, org, bindingproperty, customProperty);
        if (cr == null && !"00000000-0000-0000-0000-000000000000CCE7AED4".equals(org) && (cr = this.getCodingRuleByCompany(ctx, caller, "00000000-0000-0000-0000-000000000000CCE7AED4", bindingproperty, customProperty)) != null && cr.isMultiOrgFirst()) {
            cr = null;
        }
        return cr;
    }

    protected CodingRuleInfo getCodingRuleByOU(Context ctx, IObjectValue caller, String org, ParmCodingRule customProperty) throws BOSException, CodingRuleException, EASBizException {
        return this.getCodingRuleByOU(ctx, caller, org, null, customProperty);
    }

    @Override
    public String _returnClassname(Context ctx, String bostype, String bindingproperty) throws BOSException {
        String modelKey = "";
        String path = new StringBuffer().append(System.getProperty("eas.deploy")).append(File.separator).append("property.xml").toString();
        File fi = new File(path);
        XMLConfiguration xmlReader = XMLConfiguration.getInstance((File)fi);
        String key = bostype + ":" + bindingproperty;
        ConfigurationItem item = xmlReader.getConfigItem("attribute");
        if (item != null) {
            Map mo = item.getProperties();
            modelKey = (String)mo.get(key);
        }
        return modelKey;
    }

    private String propertyValueFromConfigXML(IObjectValue caller, EntityObjectInfo eo, String bindingproperty) throws BOSException, EASBizException {
        String bindingpropertyValue = null;
        String modelKey = null;
        String path = new StringBuffer().append(System.getProperty("eas.deploy")).append(File.separator).append("property.xml").toString();
        File fi = new File(path);
        XMLConfiguration xmlReader = XMLConfiguration.getInstance((File)fi);
        String key = caller.getBOSType().toString() + ":" + bindingproperty;
        ConfigurationItem item = xmlReader.getConfigItem("attribute");
        if (item != null) {
            Map mo = item.getProperties();
            if (mo.get(key) == null) {
                return bindingpropertyValue;
            }
            modelKey = mo.get(key).toString();
            IBindingPropery ibp = null;
            if (modelKey != null) {
                try {
                    Class<?> dealclass = Class.forName(modelKey);
                    ibp = (IBindingPropery)dealclass.newInstance();
                }
                catch (ClassNotFoundException e1) {
                    this.logger.error((Object)e1.getMessage(), (Throwable)e1);
                }
                catch (InstantiationException e2) {
                    this.logger.error((Object)e2.getMessage(), (Throwable)e2);
                }
                catch (IllegalAccessException e2) {
                    this.logger.error((Object)e2.getMessage(), (Throwable)e2);
                }
                if (ibp != null) {
                    bindingpropertyValue = ibp.getPropertyValue(caller, bindingproperty);
                }
            }
        }
        return bindingpropertyValue;
    }

    private boolean includeProperty(String[] propertyInfoAry, String bindingpropertyvalue) {
        boolean isincludeproperty = false;
        for (int i = 0; i < propertyInfoAry.length; ++i) {
            if (!propertyInfoAry[i].equals(bindingpropertyvalue)) continue;
            isincludeproperty = true;
        }
        return isincludeproperty;
    }

    private CodingRuleInfo returncodingruleinfo(Context ctx, IObjectValue caller, String businessObject, EntityObjectInfo eo, String org, String bindingproperty, ParmCodingRule customProperty) throws BOSException, EASBizException {
        CodingRuleInfo cr = null;
        RowSet rowset = CodingRuleDAO.getPropertyvalue(ctx, bindingproperty);
        try {
            ArrayList<String> dbPropertyList = new ArrayList<String>();
            while (rowset.next()) {
                dbPropertyList.add(rowset.getString("FPropertyValue"));
            }
            String bindingPropertyValue = this.propertyValueFromConfigXML(caller, eo, bindingproperty);
            for (int i = 0; i < dbPropertyList.size(); ++i) {
                String[] propertyInfoAry;
                String propertyInfoStr = (String)dbPropertyList.get(i);
                if (StringUtils.isEmpty((String)propertyInfoStr) || !this.includeProperty(propertyInfoAry = propertyInfoStr.split(";"), bindingPropertyValue) || (cr = this.getCodingruleInfo(ctx, businessObject, org, bindingproperty, propertyInfoStr, customProperty)) == null) continue;
                return cr;
            }
        }
        catch (SQLException err) {
            throw new BOSException(err.getMessage(), (Throwable)err);
        }
        return cr;
    }

    private CodingRuleInfo getCodingruleInfo(Context ctx, String businessObject, String org, String bindingproperty, String propertyInfoStr, ParmCodingRule customProperty) throws BOSException, EASBizException {
        CodingRuleInfo cr = null;
        String ruleId = CodingRuleDAO.getCodingRuleInfoValue(ctx, businessObject, org, 0, bindingproperty, propertyInfoStr, customProperty);
        if (!StringUtils.isEmpty((String)ruleId) && !this.isCheckBindingProper(cr = CodingRuleFactory.getLocalInstance(ctx).getCodingRuleInfo((IObjectPK)new ObjectUuidPK(ruleId)), customProperty)) {
            cr = null;
        }
        return cr;
    }

    private CodingRuleInfo getCodingRuleByOU(Context ctx, IObjectValue caller, String org, String bindingproperty, ParmCodingRule customProperty) throws BOSException, EASBizException {
        String ruleId;
        String bindingPropertyValue = null;
        CodingRuleInfo cr = null;
        EntityObjectInfo eo = this.getMetaInfo(ctx, caller);
        String businessObject = eo.getPackage() + "." + eo.getName();
        String propertyValue = "";
        if (caller.getBOSType().toString().equals("8BBEC24B")) {
            bindingPropertyValue = this.propertyValueFromConfigXML(caller, eo, bindingproperty);
        }
        if (!StringUtils.isEmpty(bindingPropertyValue)) {
            return this.returncodingruleinfo(ctx, caller, businessObject, eo, org, bindingproperty, customProperty);
        }
        if (!StringUtils.isEmpty((String)bindingproperty)) {
            propertyValue = this.getPropertyValue(bindingproperty, caller);
        }
        if (!StringUtils.isEmpty((String)(ruleId = CodingRuleDAO.getCodingRuleInfoValue(ctx, businessObject, org, 0, bindingproperty, propertyValue, customProperty))) && !this.isCheckBindingProper(cr = CodingRuleFactory.getLocalInstance(ctx).getCodingRuleInfo((IObjectPK)new ObjectUuidPK(ruleId)), customProperty)) {
            cr = null;
        }
        return cr;
    }

    private boolean isCheckBindingProper(CodingRuleInfo cr, ParmCodingRule customProperty) {
        List list = new ArrayList();
        String proName = null;
        String proValue = null;
        String crValue = null;
        BindingPropertyInfo bpInfo22 = null;
        BindingPropertyExtendInfo bindingPropertyExtendInfo = null;
        int numCrEntry = 0;
        int numCuPro = 0;
        boolean isCrEntry = false;
        boolean isCuPro = false;
        if (cr.getBindingProExtent() != null && cr.getBindingProExtent().size() != 0) {
            numCrEntry = cr.getBindingProExtent().size();
            isCrEntry = true;
        }
        if (customProperty != null && (bindingPropertyExtendInfo = customProperty.getBindingPropertyExtendInfo()) != null && (list = bindingPropertyExtendInfo.getList()) != null && list.size() != 0) {
            numCuPro = list.size();
            isCuPro = true;
        }
        if (isCrEntry && !isCuPro) {
            return false;
        }
        if (!isCrEntry && isCuPro) {
            return false;
        }
        if (!isCrEntry && !isCuPro) {
            return true;
        }
        if (numCuPro > numCrEntry) {
            return false;
        }
        HashMap<String, String> crMap = new HashMap<String, String>();
        HashMap<String, String> crMapRemove = new HashMap<String, String>();
        HashMap<String, String> proMap = new HashMap<String, String>();
        for (int i = 0; i < numCrEntry; ++i) {
            crValue = cr.getBindingProExtent().get(i).getProValue();
            if (StringUtils.isEmpty((String)crValue)) {
                crValue = "";
            }
            crMap.put(cr.getBindingProExtent().get(i).getProName(), crValue);
            crMapRemove.put(cr.getBindingProExtent().get(i).getProName(), crValue);
        }
        for (BindingPropertyInfo bpInfo22 : list) {
            if (StringUtils.isEmpty((String)bpInfo22.getProName())) continue;
            proValue = bpInfo22.getProValue();
            if (StringUtils.isEmpty((String)proValue)) {
                proValue = "";
            }
            proMap.put(bpInfo22.getProName(), proValue);
        }
        Iterator<Object> it = proMap.entrySet().iterator();
        Object var17_18 = null;
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry)it.next();
            proName = entry.getKey().toString();
            proValue = entry.getValue().toString();
            if (crMap.get(proName) == null) {
                return false;
            }
            if (StringUtils.isEmpty((String)proValue)) continue;
            crValue = crMap.get(proName).toString();
            if (crValue.equals(proValue)) {
                crMapRemove.remove(proName);
                continue;
            }
            return false;
        }
        for (Map.Entry entry : crMapRemove.entrySet()) {
            if (entry.getValue() == null || StringUtils.isEmpty((String)entry.getValue().toString())) continue;
            return false;
        }
        return true;
    }

    protected CodingRuleInfo getCodingRuleByCompany(Context ctx, IObjectValue caller, String org, ParmCodingRule customProperty) throws BOSException, CodingRuleException, EASBizException {
        return this.getCodingRuleByOU(ctx, caller, org, null, customProperty);
    }

    private CodingRuleInfo getCodingRuleByCompany(Context ctx, IObjectValue caller, String org, String bindingproperty, ParmCodingRule customProperty) throws BOSException, EASBizException {
        return this.getCodingRuleByOU(ctx, caller, org, bindingproperty, customProperty);
    }

    @Override
    protected CodingRuleCollection _checkMoreAdapt(Context ctx, CodingRuleInfo info) throws BOSException {
        return CodingRuleServerUtil.checkBindingProExtent(ctx, info);
    }

    @Override
    protected void _recycleBatchNumber(Context ctx, IObjectValue bizObject, String org, String[] number) throws BOSException, EASBizException {
        for (int i = 0; i < number.length; ++i) {
            this._recycleNumber(ctx, bizObject, org, number[i]);
        }
    }

    @Override
    protected void _recycleBatchNumber(Context ctx, IObjectValue caller, String org, String[] number, String custom) throws BOSException, EASBizException {
        for (int i = 0; i < number.length; ++i) {
            this._recycleNumber(ctx, caller, org, custom, number[i]);
        }
    }

    @Override
    protected void _recycleBatchNumber(Context ctx, IObjectValue caller, String org, String[] number, String custom, String bindingproperty) throws BOSException, EASBizException {
        for (int i = 0; i < number.length; ++i) {
            this._recycleNumber(ctx, caller, org, bindingproperty, custom, number[i]);
        }
    }

    @Override
    protected String[] _getBatchNumber(Context ctx, IObjectCollection bizCol, String org, String bindingproperty, String custom) throws BOSException, EASBizException {
        IObjectValue caller = null;
        String[] batchNumber = new String[bizCol.size()];
        for (int i = 0; i < bizCol.size(); ++i) {
            caller = bizCol.getObject(i);
            batchNumber[i] = this._getNumber(ctx, caller, org, bindingproperty, custom);
        }
        return batchNumber;
    }

    @Override
    protected void _recycleBatchNumber(Context ctx, RecycleCollection recycleCollection, String org, String custom, String bindingproperty, ParmCodingRule cusPro) throws BOSException, EASBizException {
        RecycleItem item = null;
        for (int i = 0; i < recycleCollection.size(); ++i) {
            item = recycleCollection.get(i);
            this._recycleNumber(ctx, item.getBizObject(), org, bindingproperty, custom, item.getNumber(), cusPro);
        }
    }

    private Transaction getCurrTransaction() throws BOSException {
        try {
            long start = System.currentTimeMillis();
            InitialContext initCtx = new InitialContext();
            long end = System.currentTimeMillis();
            this.logger.error((Object)("InitialContext\u8017\u65f6\uff1a" + (end - start)));
            TransactionManager txManager = (TransactionManager)initCtx.lookup("java:/TransactionManager");
            Transaction tx = txManager.getTransaction();
            this.logger.error((Object)("getCurrTransaction\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start)));
            return tx;
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected boolean _recycleNumberReqNew(Context ctx, IObjectValue bizObject, String org, String bindingproperty, String customString, String number, ParmCodingRule cusPro) throws BOSException, EASBizException {
        return this._recycleNumber(ctx, bizObject, org, bindingproperty, customString, number, cusPro);
    }

    @Override
    protected String[] _getBatchNumberForNoBreak(Context ctx, IObjectValue bizObject, IObjectValue codingrule, int count) throws BOSException, EASBizException {
        ICodingRule iCodingRule = CodingRuleFactory.getLocalInstance(ctx);
        CodingRuleInfo cri = (CodingRuleInfo)codingrule;
        this.logger.debug((Object)"getBatchNumberForNoBreak");
        if (cri.isIsDHSelect() || cri.isIsMainRule() || cri.isIsUserSelect() || cri.isIsaddnewbreak()) {
            return iCodingRule.getBatchNumberNoBreak(bizObject, (IObjectValue)((CodingRuleInfo)codingrule), count);
        }
        return iCodingRule.getBatchNumber(bizObject, (CodingRuleInfo)codingrule, count);
    }

    @Override
    protected String[] _getBatchNumberForNoBreak(Context ctx, IObjectValue bizObject, String org, int count) throws BOSException, EASBizException {
        org = StringUtils.isEmpty((String)org) ? this._getCurrentAppOUID(ctx, bizObject) : org;
        ICodingRule iCodingRule = CodingRuleFactory.getLocalInstance(ctx);
        IObjectValue codingRuleInfo = this._getCodingRule(ctx, bizObject, org);
        if (codingRuleInfo != null) {
            CodingRuleInfo cri = (CodingRuleInfo)codingRuleInfo;
            if (cri.isIsDHSelect() || cri.isIsMainRule() || cri.isIsUserSelect() || cri.isIsaddnewbreak()) {
                return iCodingRule.getBatchNumberNoBreak(bizObject, (IObjectValue)((CodingRuleInfo)codingRuleInfo), count);
            }
            return iCodingRule.getBatchNumber(bizObject, (CodingRuleInfo)codingRuleInfo, count);
        }
        throw this.throwNotExistRuleException(ctx, bizObject);
    }

    @Override
    protected String[] _getBatchNumberForNoBreak(Context ctx, IObjectValue bizObject, String org, String custom, int count) throws BOSException, EASBizException {
        IObjectValue codingRuleInfo = this._getCodingRule(ctx, bizObject, org = StringUtils.isEmpty((String)org) ? this._getCurrentAppOUID(ctx, bizObject) : org);
        if (codingRuleInfo != null) {
            CodingRuleInfo cri = (CodingRuleInfo)codingRuleInfo;
            if (cri.isIsDHSelect() || cri.isIsMainRule() || cri.isIsUserSelect() || cri.isIsaddnewbreak()) {
                return CodingRuleFactory.getLocalInstance(ctx).getBatchNumberNoBreak(bizObject, (IObjectValue)((CodingRuleInfo)codingRuleInfo), custom, count);
            }
            return CodingRuleFactory.getLocalInstance(ctx).getBatchNumber(bizObject, (CodingRuleInfo)codingRuleInfo, custom, count);
        }
        throw this.throwNotExistRuleException(ctx, bizObject);
    }

    @Override
    protected String[] _getBatchNumberForNoBreak(Context ctx, IObjectValue bizObject, String org, String bindingproperty, String custom, int count) throws BOSException, EASBizException {
        IObjectValue codingRuleInfo = this._getCodingRule(ctx, bizObject, org = StringUtils.isEmpty((String)org) ? this._getCurrentAppOUID(ctx, bizObject) : org, bindingproperty);
        if (codingRuleInfo != null) {
            CodingRuleInfo cri = (CodingRuleInfo)codingRuleInfo;
            if (cri.isIsDHSelect() || cri.isIsMainRule() || cri.isIsUserSelect() || cri.isIsaddnewbreak()) {
                return CodingRuleFactory.getLocalInstance(ctx).getBatchNumberNoBreak(bizObject, (IObjectValue)((CodingRuleInfo)codingRuleInfo), custom, count);
            }
            return CodingRuleFactory.getLocalInstance(ctx).getBatchNumber(bizObject, (CodingRuleInfo)codingRuleInfo, custom, count);
        }
        throw this.throwNotExistRuleException(ctx, bizObject);
    }

    static class InnerJTATransaction
    implements Synchronization {
        Context ctx;
        IObjectValue caller;
        String org;
        String bindingproperty;
        String customString;
        String number;
        ParmCodingRule cusPro;
        String[] numbers;
        boolean isBatch;
        RecycleCollection recycleCollection;
        private Logger logger = Logger.getLogger(InnerJTATransaction.class);

        public InnerJTATransaction(Context ctx, IObjectValue caller, String org, String number) {
            this(ctx, caller, org, null, null, number, null);
        }

        public InnerJTATransaction(Context ctx, IObjectValue caller, String org, String customString, String number) {
            this(ctx, caller, org, null, customString, number, null);
        }

        public InnerJTATransaction(Context ctx, IObjectValue caller, String org, String bindingproperty, String customString, String number) {
            this(ctx, caller, org, bindingproperty, customString, number, null);
        }

        public InnerJTATransaction(Context ctx, IObjectValue caller, String org, String bindingproperty, String customString, String number, ParmCodingRule cusPro) {
            this.ctx = ctx;
            this.caller = caller;
            this.org = org;
            this.bindingproperty = bindingproperty;
            this.customString = customString;
            this.number = number;
            this.cusPro = cusPro;
            this.isBatch = false;
        }

        public InnerJTATransaction(Context ctx, IObjectValue bizObject, String org, String[] numbers) {
            this.ctx = ctx;
            this.caller = bizObject;
            this.org = org;
            this.numbers = numbers;
            this.isBatch = true;
        }

        public InnerJTATransaction(Context ctx, IObjectValue caller, String org, String[] number, String customString) {
            this(ctx, caller, org, number);
            this.customString = customString;
        }

        public InnerJTATransaction(Context ctx, IObjectValue caller, String org, String[] number, String customString, String bindingproperty) {
            this(ctx, caller, org, number, customString);
            this.bindingproperty = bindingproperty;
        }

        public InnerJTATransaction(Context ctx, RecycleCollection recycleCollection, String org, String customString, String bindingproperty, ParmCodingRule cusPro) {
            this(ctx, null, org, bindingproperty, customString, null, cusPro);
            this.recycleCollection = recycleCollection;
            this.isBatch = true;
        }

        public void beforeCompletion() {
        }

        public void afterCompletion(int status) {
            if (status == 3) {
                this.logger.error((Object)"\u8c03\u7528\u7f16\u7801\u89c4\u5219\u5916\u56f4\u4e8b\u52a1\u6210\u529f\uff01");
            } else if (status == 4) {
                try {
                    boolean result = false;
                    this.logger.error((Object)("\u83b7\u53d6\u7f16\u7801\u89c4\u5219\u4e8b\u52a1\u56de\u6eda\uff0cnumber:" + this.number));
                    ICodingRuleManager iCodingRule = CodingRuleManagerFactory.getLocalInstance(this.ctx);
                    this.logger.error((Object)("\u5f00\u59cb\u56de\u6536\u7f16\u7801:" + this.number));
                    if (this.isBatch) {
                        if (this.recycleCollection != null) {
                            iCodingRule.recycleBatchNumber(this.recycleCollection, this.org, this.customString, this.bindingproperty, this.cusPro);
                        } else {
                            iCodingRule.recycleBatchNumber(this.caller, this.org, this.numbers, this.customString, this.bindingproperty);
                        }
                        result = true;
                    } else {
                        result = iCodingRule.recycleNumberReqNew(this.caller, this.org, this.bindingproperty, this.customString, this.number, this.cusPro);
                    }
                    this.logger.error((Object)("\u56de\u6536\u7f16\u7801\u662f\u5426\u6210\u529f\uff1a" + result));
                }
                catch (Exception e) {
                    this.logger.error((Object)"\u56de\u6536\u7f16\u7801 rollback _getNumber", (Throwable)e);
                }
            }
        }
    }
}

